/**
 * @file    Wdg_Mld_Types.h
 * @version V2.0.0
 *
 * @brief   YUNTU Wdg_Mld module interface
 * @details API implementation for Wdg_Mld driver
 *
 * @addtogroup WDG_MLD_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : WDG, EWDG
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef WDG_MLD_TYPES_H
#define WDG_MLD_TYPES_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                      INCLUDE FILES
==================================================================================================*/
#include "Wdg_Mld_Cfg.h"
#if (WDG_LLD_ENABLE == STD_ON)
#include "Wdg_Lld_Types.h"
#endif
#if (EWDG_LLD_ENABLE == STD_ON)
#include "Ewdg_Lld_Types.h"
#endif

/*==================================================================================================
 *                               SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define WDG_MLD_TYPES_VENDOR_ID             (180)
#define WDG_MLD_TYPES_MODULE_ID             (102)
#define WDG_MLD_TYPES_AR_REL_MAJOR_VER      (4)
#define WDG_MLD_TYPES_AR_REL_MINOR_VER      (4)
#define WDG_MLD_TYPES_AR_REL_REVISION_VER   (0)
#define WDG_MLD_TYPES_SW_MAJOR_VER          (2)
#define WDG_MLD_TYPES_SW_MINOR_VER          (0)
#define WDG_MLD_TYPES_SW_PATCH_VER          (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/
/* Check if Wdg_Mld_Types.h and Wdg_Mld_Cfg.h are of the same vendor */
#if (WDG_MLD_TYPES_VENDOR_ID != WDG_MLD_CFG_VENDOR_ID)
#error "Wdg_Mld_Types.h and Wdg_Mld_Cfg.h have different vendor ids"
#endif

/* Check if Wdg_Mld_Types.h and Wdg_Mld_Cfg.h are of the same Autosar version */
#if ((WDG_MLD_TYPES_AR_REL_MAJOR_VER != WDG_MLD_CFG_AR_REL_MAJOR_VER) || \
     (WDG_MLD_TYPES_AR_REL_MINOR_VER != WDG_MLD_CFG_AR_REL_MINOR_VER) || \
     (WDG_MLD_TYPES_AR_REL_REVISION_VER != WDG_MLD_CFG_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of Wdg_Mld_Types.h and Wdg_Mld_Cfg.h are different"
#endif

/* Check if Wdg_Mld_Types.h and Wdg_Mld_Cfg.h are of the same software version */
#if ((WDG_MLD_TYPES_SW_MAJOR_VER != WDG_MLD_CFG_SW_MAJOR_VER) || \
     (WDG_MLD_TYPES_SW_MINOR_VER != WDG_MLD_CFG_SW_MINOR_VER) || \
     (WDG_MLD_TYPES_SW_PATCH_VER != WDG_MLD_CFG_SW_PATCH_VER))
#error "Software Version Numbers of Wdg_Mld_Types.h and Wdg_Mld_Cfg.h are different"
#endif

#if (WDG_LLD_ENABLE == STD_ON)
/* Check if Wdg_Mld_Types.h and Wdg_Lld_Types.h are of the same vendor */
#if (WDG_MLD_TYPES_VENDOR_ID != WDG_LLD_TYPES_VENDOR_ID)
#error "Wdg_Mld_Types.h and Wdg_Lld_Types.h have different vendor ids"
#endif

/* Check if Wdg_Mld_Types.h and Wdg_Lld_Types.h are of the same Autosar version */
#if ((WDG_MLD_TYPES_AR_REL_MAJOR_VER != WDG_LLD_TYPES_AR_REL_MAJOR_VER) || \
     (WDG_MLD_TYPES_AR_REL_MINOR_VER != WDG_LLD_TYPES_AR_REL_MINOR_VER) || \
     (WDG_MLD_TYPES_AR_REL_REVISION_VER != WDG_LLD_TYPES_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of Wdg_Mld_Types.h and Wdg_Lld_Types.h are different"
#endif

/* Check if Wdg_Mld_Types.h and Wdg_Lld_Types.h are of the same software version */
#if ((WDG_MLD_TYPES_SW_MAJOR_VER != WDG_LLD_TYPES_SW_MAJOR_VER) || \
     (WDG_MLD_TYPES_SW_MINOR_VER != WDG_LLD_TYPES_SW_MINOR_VER) || \
     (WDG_MLD_TYPES_SW_PATCH_VER != WDG_LLD_TYPES_SW_PATCH_VER))
#error "Software Version Numbers of Wdg_Mld_Types.h and Wdg_Lld_Types.h are different"
#endif
#endif

#if (EWDG_LLD_ENABLE == STD_ON)
/* Check if Wdg_Mld_Types.h and Ewdg_Lld_Types.h are of the same vendor */
#if (WDG_MLD_TYPES_VENDOR_ID != EWDG_LLD_TYPES_VENDOR_ID)
#error "Wdg_Mld_Types.h and Ewdg_Lld_Types.h have different vendor ids"
#endif

/* Check if Wdg_Mld_Types.h and Ewdg_Lld_Types.h are of the same Autosar version */
#if ((WDG_MLD_TYPES_AR_REL_MAJOR_VER != EWDG_LLD_TYPES_AR_REL_MAJOR_VER) || \
     (WDG_MLD_TYPES_AR_REL_MINOR_VER != EWDG_LLD_TYPES_AR_REL_MINOR_VER) || \
     (WDG_MLD_TYPES_AR_REL_REVISION_VER != EWDG_LLD_TYPES_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of Wdg_Mld_Types.h and Ewdg_Lld_Types.h are different"
#endif

/* Check if Wdg_Mld_Types.h and Ewdg_Lld_Types.h are of the same software version */
#if ((WDG_MLD_TYPES_SW_MAJOR_VER != EWDG_LLD_TYPES_SW_MAJOR_VER) || \
     (WDG_MLD_TYPES_SW_MINOR_VER != EWDG_LLD_TYPES_SW_MINOR_VER) || \
     (WDG_MLD_TYPES_SW_PATCH_VER != EWDG_LLD_TYPES_SW_PATCH_VER))
#error "Software Version Numbers of Wdg_Mld_Types.h and Ewdg_Lld_Types.h are different"
#endif
#endif

/*==================================================================================================
 *                                          ENUMS
==================================================================================================*/
/**
 * @brief Wdg_Mld_InstType.
 */
typedef enum
{
    WDG_MLD_INST0    = 0x00U,   /**< Wdg Mld Instance 0 */
    WDG_MLD_INST1    = 0x01U,   /**< Wdg Mld Instance 1 */
    WDG_MLD_INST_CNT = 0x02U    /**< Wdg Mld Instance Count */
} Wdg_Mld_InstType;

/**
 * @brief   Wdg_Mld_IpType.
 */
typedef enum
{
    WDG_MLD_IP_WDG   = 0x00U,   /**< Wdg Mld IP WDG */
    WDG_MLD_IP_EWDG  = 0x01U,   /**< Wdg Mld IP EWDG */
    WDG_MLD_IP_CNT   = 0x02U,   /**< Wdg Mld IP Count */
    WDG_MLD_IP_UNINT = 0xFFU    /**< Wdg Mld IP Uninitialized */
} Wdg_Mld_IpType;

/*==================================================================================================
 *                                STRUCTURES AND OTHER TYPEDEFS
==================================================================================================*/
/**
 * @brief   Wdg_Mld configuration structure.
 */
typedef struct
{
    Wdg_Mld_IpType WdgMldIp;          /**< Wdg IP type */
#if (WDG_LLD_ENABLE == STD_ON)
    const Wdg_Lld_ConfigType *WdgConfig;    /**< WDG configuration */
#endif
#if (EWDG_LLD_ENABLE == STD_ON)
    const Ewdg_Lld_ConfigType *EwdgConfig;  /**< EWDG configuration */
#endif
} Wdg_Mld_ConfigType;

#ifdef __cplusplus
}
#endif

#endif /* WDG_MLD_TYPES_H */

/** @} */
