/**
 * @file    Wdg_Lld_Reg.h
 * @version V2.0.0
 *
 * @brief   YUNTU Wdg_Lld module interface
 * @details API implementation for Wdg_Lld driver
 *
 * @addtogroup WDG_LLD_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : WDG
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef WDG_LLD_REG_H
#define WDG_LLD_REG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                      INCLUDE FILES
==================================================================================================*/
#if defined(UNIT_TEST)
#include "fakeWdg.h"
#else
#include "pSIP_Wdg.h"
#endif

#if defined(CPU_YTM32B1ME0)
#include "YTM32B1ME0_features.h"
#elif defined(CPU_YTM32B1MD1)
#include "YTM32B1MD1_features.h"
#else
#error "Wrong MCU part number or no MCU part number selected!"
#endif

/*==================================================================================================
 *                               SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define WDG_LLD_REG_VENDOR_ID           (180)
#define WDG_LLD_REG_MODULE_ID           (102)
#define WDG_LLD_REG_AR_REL_MAJOR_VER    (4)
#define WDG_LLD_REG_AR_REL_MINOR_VER    (4)
#define WDG_LLD_REG_AR_REL_REVISION_VER (0)
#define WDG_LLD_REG_SW_MAJOR_VER        (2)
#define WDG_LLD_REG_SW_MINOR_VER        (0)
#define WDG_LLD_REG_SW_PATCH_VER        (0)

#ifdef __cplusplus
}
#endif

#endif /* WDG_LLD_REG_H */

/** @} */
