/**
 * @file    Wdg.h
 * @version V2.0.0
 *
 * @brief   AUTOSAR Wdg module interface
 * @details API implementation for Wdg driver
 *
 * @addtogroup WDG_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : WDG, EWDG
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef WDG_H
#define WDG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define WDG_VENDOR_ID           (180)
#define WDG_MODULE_ID           (102)
#define WDG_AR_REL_MAJOR_VER    (4)
#define WDG_AR_REL_MINOR_VER    (4)
#define WDG_AR_REL_REVISION_VER (0)
#define WDG_SW_MAJOR_VER        (2)
#define WDG_SW_MINOR_VER        (0)
#define WDG_SW_PATCH_VER        (0)

#ifdef __cplusplus
}
#endif

#endif /* WDG_H */

/** @} */
