/**
 * @file    Ewdg_Lld_Types.h
 * @version V2.0.0
 *
 * @brief   YUNTU Ewdg_Lld module interface
 * @details API implementation for Ewdg_Lld driver
 *
 * @addtogroup EWDG_LLD_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : EWDG
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef EWDG_LLD_TYPES_H
#define EWDG_LLD_TYPES_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                      INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"

/*==================================================================================================
 *                               SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define EWDG_LLD_TYPES_VENDOR_ID            (180)
#define EWDG_LLD_TYPES_MODULE_ID            (102)
#define EWDG_LLD_TYPES_AR_REL_MAJOR_VER     (4)
#define EWDG_LLD_TYPES_AR_REL_MINOR_VER     (4)
#define EWDG_LLD_TYPES_AR_REL_REVISION_VER  (0)
#define EWDG_LLD_TYPES_SW_MAJOR_VER         (2)
#define EWDG_LLD_TYPES_SW_MINOR_VER         (0)
#define EWDG_LLD_TYPES_SW_PATCH_VER         (0)

/*==================================================================================================
 *                                          ENUMS
==================================================================================================*/
/**
 * @brief   EWDG clock sources.
 */
typedef enum
{
    EWDG_LLD_CLKSRC_SIRC  = 0x00U,  /**< SIRC clock */
#if defined(CPU_YTM32B1ME0)
    EWDG_LLD_CLKSRC_SXOSC = 0x01U   /**< SXOSC clock */
#endif
} Ewdg_Lld_ClkSrcType;

/**
 * @brief   EWDG input pin configuration.
 */
typedef enum
{
    EWDG_LLD_IN_ASSERT_DISABLED      = 0x00U,   /**< Input pin disabled. */
    EWDG_LLD_IN_ASSERT_ON_LOGIC_ZERO = 0x01U,   /**< Input pin asserts EWDG when on logic 0. */
    EWDG_LLD_IN_ASSERT_ON_LOGIC_ONE  = 0x02U    /**< Input pin asserts EWDG when on logic 1. */
} Ewdg_Lld_In_AssertLogicType;

/*==================================================================================================
 *                                STRUCTURES AND OTHER TYPEDEFS
==================================================================================================*/
/**
 * @brief   EWDG callback type.
 */
typedef void (*Ewdg_Lld_CallbackType)(void);

/**
 * @brief   EWDG configuration structure..
 */
typedef struct
{
    boolean InterruptEnable;                    /**< Enable interrupt. */
    Ewdg_Lld_In_AssertLogicType AssertLogic;    /**< Input pin configuration. */
    Ewdg_Lld_ClkSrcType ClockSelect;            /**< Select clock source. */
    uint8 Prescaler;                            /**< Prescaler value. */
    uint8 CompareLow;                           /**< Compare low value. */
    uint8 CompareHigh;                          /**< Compare high value. */
    Ewdg_Lld_CallbackType EwdgCallback;         /**< Callback function. */
} Ewdg_Lld_ConfigType;

#ifdef __cplusplus
}
#endif

#endif /* EWDG_LLD_TYPES_H */

/** @} */
