/**
 * @file    Ewdg_Lld.h
 * @version V2.0.0
 *
 * @brief   YUNTU Ewdg_Lld module interface
 * @details API implementation for Ewdg_Lld driver
 *
 * @addtogroup EWDG_LLD_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : EWDG
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef EWDG_LLD_H
#define EWDG_LLD_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                          INCLUDE FILES
==================================================================================================*/
#include "Ewdg_Lld_Types.h"
#include "Ewdg_Lld_Cfg.h"

/*==================================================================================================
 *                                SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define EWDG_LLD_VENDOR_ID              (180)
#define EWDG_LLD_MODULE_ID              (102)
#define EWDG_LLD_AR_REL_MAJOR_VER       (4)
#define EWDG_LLD_AR_REL_MINOR_VER       (4)
#define EWDG_LLD_AR_REL_REVISION_VER    (0)
#define EWDG_LLD_SW_MAJOR_VER           (2)
#define EWDG_LLD_SW_MINOR_VER           (0)
#define EWDG_LLD_SW_PATCH_VER           (0)

/*==================================================================================================
 *                                       FILE VERSION CHECKS
==================================================================================================*/
/* Check if Ewdg_Lld.h and Ewdg_Lld_Types.h are of the same vendor */
#if (EWDG_LLD_VENDOR_ID != EWDG_LLD_TYPES_VENDOR_ID)
#error "Ewdg_Lld.h and Ewdg_Lld_Types.h have different vendor ids"
#endif

/* Check if Ewdg_Lld.h and Ewdg_Lld_Types.h are of the same Autosar version */
#if ((EWDG_LLD_AR_REL_MAJOR_VER != EWDG_LLD_TYPES_AR_REL_MAJOR_VER) || \
     (EWDG_LLD_AR_REL_MINOR_VER != EWDG_LLD_TYPES_AR_REL_MINOR_VER) || \
     (EWDG_LLD_AR_REL_REVISION_VER != EWDG_LLD_TYPES_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of Ewdg_Lld.h and Ewdg_Lld_Types.h are different"
#endif

/* Check if Ewdg_Lld.h and Ewdg_Lld_Types.h are of the same software version */
#if ((EWDG_LLD_SW_MAJOR_VER != EWDG_LLD_TYPES_SW_MAJOR_VER) || \
     (EWDG_LLD_SW_MINOR_VER != EWDG_LLD_TYPES_SW_MINOR_VER) || \
     (EWDG_LLD_SW_PATCH_VER != EWDG_LLD_TYPES_SW_PATCH_VER))
#error "Software Version Numbers of Ewdg_Lld.h and Ewdg_Lld_Types.h are different"
#endif

/* Check if Ewdg_Lld.c and Ewdg_Lld_Cfg.h are of the same vendor */
#if (EWDG_LLD_VENDOR_ID != EWDG_LLD_CFG_VENDOR_ID)
#error "Ewdg_Lld.c and Ewdg_Lld_Cfg.h have different vendor ids"
#endif

/* Check if Ewdg_Lld.c and Ewdg_Lld_Cfg.h are of the same Autosar version */
#if ((EWDG_LLD_AR_REL_MAJOR_VER != EWDG_LLD_CFG_AR_REL_MAJOR_VER) || \
     (EWDG_LLD_AR_REL_MINOR_VER != EWDG_LLD_CFG_AR_REL_MINOR_VER) || \
     (EWDG_LLD_AR_REL_REVISION_VER != EWDG_LLD_CFG_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of Ewdg_Lld.c and Ewdg_Lld_Cfg.h are different"
#endif

/* Check if Ewdg_Lld.c and Ewdg_Lld_Cfg.h are of the same software version */
#if ((EWDG_LLD_SW_MAJOR_VER != EWDG_LLD_CFG_SW_MAJOR_VER) || \
     (EWDG_LLD_SW_MINOR_VER != EWDG_LLD_CFG_SW_MINOR_VER) || \
     (EWDG_LLD_SW_PATCH_VER != EWDG_LLD_CFG_SW_PATCH_VER))
#error "Software Version Numbers of Ewdg_Lld.c and Ewdg_Lld_Cfg.h are different"
#endif

#if (EWDG_LLD_ENABLE == STD_ON)
/*==================================================================================================
 *                                      FUNCTION PROTOTYPES
==================================================================================================*/
#if (EWDG_LLD_RUN_ON_ROM == STD_ON)
#define WDG_START_SEC_CODE
#else
#define WDG_START_SEC_RAMCODE
#endif
#include "Wdg_MemMap.h"

/**
 * @brief       This function initializes the EWDG hardware.
 * @param[in]   Instance EWDG hardware instance
 * @param[in]   EwdgConfig EWDG hardware configuration
 * @return      Std_ReturnType
 * @retval      E_OK EWDG hardware initialization success
 * @retval      E_NOT_OK EWDG hardware initialization failed
 */
WDG_FUNC Std_ReturnType Ewdg_Lld_Init(uint8 Instance, const Ewdg_Lld_ConfigType *const EwdgConfig);

/**
 * @brief       This function refreshes the EWDG counter
 * @param[in]   Instance EWDG instance
 * @return      void
 */
WDG_FUNC void Ewdg_Lld_Service(uint8 Instance);

/**
 * @brief       EWDG instance interrupt handler.
 * @details     This function handles the different EWDG instances interrupt.
 * @param[in]   Instance EWDG hardware instance
 * @return      void
 */
WDG_FUNC void Ewdg_Lld_IrqHandler(uint8 Instance);

#if (EWDG_LLD_RUN_ON_ROM == STD_ON)
#define WDG_STOP_SEC_CODE
#else
#define WDG_STOP_SEC_RAMCODE
#endif
#include "Wdg_MemMap.h"

#endif /* #if (EWDG_LLD_ENABLE == STD_ON) */

#ifdef __cplusplus
}
#endif

#endif /* EWDG_LLD_H */

/** @} */
