/**
* @file    SchM_Icu.c
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : SchM_Icu
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

/**
*   @file    SchM_Icu.c
*
*   @addtogroup SCHM_ICU_MODULE
*   @{
*/

#ifdef __cplusplus
extern "C"
{
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"
#include "OsIf.h"
#include "SchM_Icu.h"
#include "Icu_Cfg.h"
/*==================================================================================================
                                      SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define SCHM_ICU_VENDOR_ID_C                    (180)
#define SCHM_ICU_AR_REL_MAJOR_VER_C              (4)
#define SCHM_ICU_AR_REL_MINOR_VER_C              (4)
#define SCHM_ICU_AR_REL_REVISION_VER_C           (0)
#define SCHM_ICU_SW_MAJOR_VER_C                  (2)
#define SCHM_ICU_SW_MINOR_VER_C                  (0)
#define SCHM_ICU_SW_PATCH_VER_C                  (0)
/*==================================================================================================
                                            FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and SCHM_ICU header file are of the same vendor */
#if (SCHM_ICU_VENDOR_ID_C != SCHM_ICU_VENDOR_ID)
#error "SchM_Icu.c and SchM_Icu.h have different vendor ids"
#endif

/* Check if source file and SCHM_ICU header file are of the same Autosar version */
#if (( SCHM_ICU_AR_REL_MAJOR_VER_C != SCHM_ICU_AR_REL_MAJOR_VER) || \
      ( SCHM_ICU_AR_REL_MINOR_VER_C != SCHM_ICU_AR_REL_MINOR_VER) || \
      ( SCHM_ICU_AR_REL_REVISION_VER_C != SCHM_ICU_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of SchM_Icu.c and SchM_Icu.h are different"
#endif

/* Check if source file and SCHM_ICU header file are of the same Software version */
#if (( SCHM_ICU_SW_MAJOR_VER_C != SCHM_ICU_SW_MAJOR_VER) || \
      ( SCHM_ICU_SW_MINOR_VER_C != SCHM_ICU_SW_MINOR_VER) || \
      ( SCHM_ICU_SW_PATCH_VER_C != SCHM_ICU_SW_PATCH_VER))
#error "Software Version Numbers of SchM_Icu.c and SchM_Icu.h are different"
#endif

/*==================================================================================================
                                                GLOBAL VARIABLES
==================================================================================================*/
/*==================================================================================================
*                                       LOCAL CONSTANTS
==================================================================================================*/
#ifdef MCAL_PLATFORM_ARM
#if (MCAL_PLATFORM_ARM == MCAL_ARM_AARCH64)
#define ISR_STATE_MASK     ((uint32)0x000000C0UL)   /**< @brief DAIF bit I and F */
#elif  (MCAL_PLATFORM_ARM == MCAL_ARM_RARCH)
#define ISR_STATE_MASK     ((uint32)0x00000080UL)   /**< @brief CPSR bit I */
#else
#if ((defined MCAL_ENABLE_USER_MODE_SUPPORT)&&(!defined MCAL_PLATFORM_ARM_M0PLUS))
#define ISR_STATE_MASK     ((uint32)0x000000FFUL)   /**< @brief BASEPRI[7:0] mask */
#else
#define ISR_STATE_MASK     ((uint32)0x00000001UL)   /**< @brief PRIMASK bit 0 */
#endif
#endif
#endif
/*==================================================================================================
*                                       LOCAL MACROS
==================================================================================================*/
#ifdef MCAL_PLATFORM_ARM
#if (MCAL_PLATFORM_ARM == MCAL_ARM_AARCH64)
#define ISR_ON(msr)            (((uint32)(msr) & (uint32)(ISR_STATE_MASK)) != (uint32)(ISR_STATE_MASK))
#elif  (MCAL_PLATFORM_ARM == MCAL_ARM_RARCH)
#define ISR_ON(msr)            (((uint32)(msr) & (uint32)(ISR_STATE_MASK)) != (uint32)(ISR_STATE_MASK))
#else
#define ISR_ON(msr)            (((uint32)(msr) & (uint32)(ISR_STATE_MASK)) == (uint32)0)
#endif
#endif

/*==================================================================================================
*                                       LOCAL VARIABLES
==================================================================================================*/
#define RTE_START_SEC_VAR_CLEARED_32_NO_CACHEABLE
#include "Rte_MemMap.h"
RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_00;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_00;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_01;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_01;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_02;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_02;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_03;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_03;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_04;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_04;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_05;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_05;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_06;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_06;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_07;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_07;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_08;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_08;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_09;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_09;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_10;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_10;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_11;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_11;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_12;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_12;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_13;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_13;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_14;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_14;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_15;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_15;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_16;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_16;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_17;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_17;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_18;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_18;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_19;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_19;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_20;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_20;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_21;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_21;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_22;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_22;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_23;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_23;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_24;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_24;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_25;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_25;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_26;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_26;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_27;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_27;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_28;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_28;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_29;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_29;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_30;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_30;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_31;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_31;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_32;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_32;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_33;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_33;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_34;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_34;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_35;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_35;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_36;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_36;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_37;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_37;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_38;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_38;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_39;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_39;

RTE_VAR static volatile uint32 msr_ICU_EXCLUSIVE_AREA_40;
RTE_VAR static volatile uint32 reentry_guard_ICU_EXCLUSIVE_AREA_40;

#define RTE_STOP_SEC_VAR_CLEARED_32_NO_CACHEABLE
#include "Rte_MemMap.h"
/*==================================================================================================
                                                LOCAL FUNCTIONS
==================================================================================================*/
#define RTE_START_SEC_CODE
#include "Rte_MemMap.h"
#ifdef __GNU_C_YTM32B1MXX
/**
* @brief   This function returns the MSR register value (32 bits).
* @details This function returns the MSR register value (32 bits).
*
* @param[in]     void        No input parameters
* @return        uint32 msr  This function returns the MSR register value (32 bits).
*
* @pre  None
* @post None
*
*/
RTE_FUNC uint32 Icu_schm_read_msr(void)
{
    register uint32 reg_tmp;
#if (MCAL_PLATFORM_ARM == MCAL_ARM_AARCH64)
    __asm volatile(" mrs %x0, DAIF " : "=r"(reg_tmp));
#elif  (MCAL_PLATFORM_ARM == MCAL_ARM_RARCH)
    __asm volatile(" mrs %0, CPSR " : "=r"(reg_tmp));
#else
#if ((defined MCAL_ENABLE_USER_MODE_SUPPORT)&&(!defined MCAL_PLATFORM_ARM_M0PLUS))
    __asm volatile(" mrs %0, basepri " : "=r"(reg_tmp));
#else
    __asm volatile(" mrs %0, primask " : "=r"(reg_tmp));
#endif
#endif
    return (uint32)reg_tmp;
}
#endif   /* __GNU_C_YTM32B1MXX*/
/*================================================================================================*/

#ifdef __ARM_C6_C_YTM32B1MXX
/**
* @brief   This function returns the MSR register value (32 bits).
* @details This function returns the MSR register value (32 bits).
*
* @param[in]     void        No input parameters
* @return        uint32 msr  This function returns the MSR register value (32 bits).
*
* @pre  None
* @post None
*
*/
RTE_FUNC uint32 Icu_schm_read_msr(void)
{
    register uint32 reg_tmp;
#if (MCAL_PLATFORM_ARM == MCAL_ARM_AARCH64)
    __asm volatile(" mrs %x0, DAIF " : "=r"(reg_tmp));
#elif  (MCAL_PLATFORM_ARM == MCAL_ARM_RARCH)
    __asm volatile(" mrs %0, CPSR " : "=r"(reg_tmp));
#else
#if ((defined MCAL_ENABLE_USER_MODE_SUPPORT)&&(!defined MCAL_PLATFORM_ARM_M0PLUS))
    __asm volatile(" mrs %0, basepri " : "=r"(reg_tmp));
#else
    __asm volatile(" mrs %0, primask " : "=r"(reg_tmp));
#endif
#endif
    return (uint32)reg_tmp;
}
#endif   /* __ARM_C6_C_YTM32B1MXX */

#ifdef __IAR_C_YTM32B1MXX
/**
* @brief   This function returns the MSR register value (32 bits).
* @details This function returns the MSR register value (32 bits).
*
* @param[in]     void        No input parameters
* @return        uint32 msr  This function returns the MSR register value (32 bits).
*
* @pre  None
* @post None
*
*/
RTE_FUNC uint32 Icu_schm_read_msr(void)
{
    register uint32 reg_tmp;

#if ((defined MCAL_ENABLE_USER_MODE_SUPPORT)&&(!defined MCAL_PLATFORM_ARM_M0PLUS))
    __asm volatile(" mrs %0, basepri " : "=r"(reg_tmp));
#else
    __asm volatile(" mrs %0, primask " : "=r"(reg_tmp));
#endif

    return (uint32)reg_tmp;
}
#endif   /* __IAR_C_YTM32B1MXX */

#define RTE_STOP_SEC_CODE
#include "Rte_MemMap.h"

/*==================================================================================================
                                                GLOBAL FUNCTIONS
==================================================================================================*/

#define RTE_START_SEC_CODE
#include "Rte_MemMap.h"

#if(STD_ON == ICU_SCHM_SUPPORT)

RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_00(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_00)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_00 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_00 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_00)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_00++;
}

RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_00(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_00--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_00)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_00))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**************************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_01(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_01)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_01 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_01 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_01)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_01++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_01(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_01--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_01)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_01))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/***************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_02(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_02)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_02 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_02 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_02)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_02++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_02(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_02--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_02)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_02))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_03(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_03)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_03 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_03 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_03)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_03++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_03(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_03--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_03)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_03))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_04(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_04)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_04 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_04 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_04)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_04++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_04(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_04--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_04)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_04))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_05(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_05)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_05 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_05 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_05)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_05++;
}

RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_05(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_05--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_05)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_05))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_06(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_06)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_06 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_06 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_06)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_06++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_06(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_06--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_06)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_06))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_07(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_07)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_07 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_07 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_07)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_07++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_07(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_07--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_07)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_07))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_08(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_08)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_08 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_08 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_08)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_08++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_08(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_08--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_08)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_08))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_09(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_09)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_09 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_09 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_09)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_09++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_09(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_09--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_09)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_09))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_10(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_10)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_10 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_10 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_10)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_10++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_10(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_10--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_10)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_10))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_11(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_11)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_11 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_11 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_11)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_11++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_11(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_11--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_11)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_11))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_12(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_12)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_12 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_12 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_12)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_12++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_12(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_12--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_12)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_12))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_13(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_13)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_13 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_13 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_13)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_13++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_13(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_13--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_13)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_13))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_14(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_14)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_14 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_14 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_14)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_14++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_14(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_14--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_14)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_14))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_15(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_15)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_15 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_15 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_15)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_15++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_15(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_15--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_15)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_15))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_16(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_16)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_16 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_16 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_16)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_16++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_16(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_16--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_16)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_16))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_17(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_17)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_17 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_17 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_17)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_17++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_17(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_17--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_17)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_17))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_18(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_18)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_18 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_18 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_18)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_18++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_18(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_18--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_18)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_18))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_19(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_19)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_19 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_19 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_19)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_19++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_19(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_19--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_19)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_19))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_20(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_20)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_20 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_20 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_20)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_20++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_20(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_20--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_20)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_20))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_21(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_21)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_21 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_21 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_21)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_21++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_21(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_21--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_21)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_21))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_22(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_22)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_22 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_22 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_22)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_22++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_22(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_22--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_22)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_22))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_23(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_23)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_23 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_23 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_23)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif

        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_23++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_23(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_23--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_23)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_23))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_24(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_24)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_24 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_24 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_24)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_24++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_24(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_24--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_24)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_24))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_25(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_25)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_25 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_25 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_25)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_25++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_25(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_25--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_25)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_25))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_26(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_26)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_26 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_26 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_26)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_26++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_26(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_26--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_26)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_26))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_27(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_27)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_27 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_27 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_27)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_27++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_27(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_27--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_27)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_27))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_28(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_28)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_28 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_28 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_28)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_28++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_28(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_28--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_28)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_28))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_29(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_29)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_29 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_29 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_29)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_29++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_29(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_29--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_29)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_29))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_30(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_30)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_30 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_30 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_30)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_30++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_30(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_30--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_30)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_30))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_31(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_31)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_31 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_31 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_31)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_31++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_31(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_31--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_31)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_31))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_32(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_32)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_32 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_32 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_32)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_32++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_32(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_32--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_32)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_32))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_33(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_33)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_33 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_33 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_33)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_33++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_33(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_33--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_33)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_33))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_34(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_34)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_34 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_34 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_34)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_34++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_34(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_34--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_34)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_34))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_35(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_35)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_35 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_35 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_35)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_35++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_35(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_35--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_35)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_35))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_36(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_36)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_36 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_36 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_36)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_36++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_36(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_36--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_36)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_36))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_37(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_37)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_37 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_37 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_37)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_37++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_37(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_37--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_37)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_37))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_38(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_38)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_38 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_38 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_38)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_38++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_38(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_38--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_38)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_38))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_39(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_39)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_39 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_39 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_39)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_39++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_39(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_39--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_39)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_39))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_40(void)
{
    if (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_40)
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_ICU_EXCLUSIVE_AREA_40 = OsIf_Trusted_Call_Return(Icu_schm_read_msr);
#else
        msr_ICU_EXCLUSIVE_AREA_40 = Icu_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_ICU_EXCLUSIVE_AREA_40)) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_ICU_EXCLUSIVE_AREA_40++;
}
RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_40(void)
{
    reentry_guard_ICU_EXCLUSIVE_AREA_40--;
    if ((ISR_ON(msr_ICU_EXCLUSIVE_AREA_40)) && (0UL == reentry_guard_ICU_EXCLUSIVE_AREA_40))       /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}
/**********************************************************************************/
#else
        /* If SchM is not used, define empty functions */
        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_00(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_00(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_01(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_01(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_02(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_02(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_03(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_03(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_04(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_04(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_05(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_05(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_06(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_06(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_07(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_07(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_08(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_08(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_09(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_09(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_10(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_10(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_11(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_11(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_12(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_12(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_13(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_13(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_14(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_14(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_15(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_15(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_16(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_16(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_17(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_17(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_18(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_18(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_19(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_19(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_20(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_20(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_21(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_21(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_22(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_22(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_23(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_23(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_24(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_24(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_25(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_25(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_26(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_26(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_27(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_27(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_28(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_28(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_29(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_29(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_30(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_30(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_31(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_31(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_32(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_32(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_33(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_33(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_34(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_34(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_35(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_35(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_36(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_36(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_37(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_37(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_38(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_38(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_39(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_39(void)  {}

        RTE_FUNC void SchM_Enter_Icu_ICU_EXCLUSIVE_AREA_40(void) {}
        RTE_FUNC void SchM_Exit_Icu_ICU_EXCLUSIVE_AREA_40(void)  {}

#endif /* STD_ON == ICU_SCHM_SUPPORT */

#define RTE_STOP_SEC_CODE
#include "Rte_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */

/* End of file SchM_Icu.c */
