/**
 * @file    SchM_Gpt.h
 * @version V2.0.0
 *
 * @brief   AUTOSAR SchM_Gpt module interface
 * @details API implementation for GPT driver
 *
 * @addtogroup SCHM_GPT_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : Lptmr, Ptmr, Tmr, Rtc
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *   
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
 *                                          INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"
#include "Platform_Cfg.h"
#include "OsIf.h"
#include "SchM_Gpt.h"
#include "Gpt_Cfg.h"

/*==================================================================================================
 *                               SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define SCHM_GPT_VENDOR_ID_C                    (180)
#define SCHM_GPT_AR_RELEASE_MAJOR_VERSION_C     (4)
#define SCHM_GPT_AR_RELEASE_MINOR_VERSION_C     (4)
#define SCHM_GPT_AR_RELEASE_REVISION_VERSION_C  (0)
#define SCHM_GPT_SW_MAJOR_VERSION_C             (2)
#define SCHM_GPT_SW_MINOR_VERSION_C             (0)
#define SCHM_GPT_SW_PATCH_VERSION_C             (0)

/*==================================================================================================
 *                                       LOCAL CONSTANTS
==================================================================================================*/
#ifdef MCAL_PLATFORM_ARM
    #if (MCAL_PLATFORM_ARM == MCAL_ARM_AARCH64)
        #define ISR_STATE_MASK     ((uint32)0x000000C0UL)   /**< @brief DAIF bit I and F */
    #elif  (MCAL_PLATFORM_ARM == MCAL_ARM_RARCH)
        #define ISR_STATE_MASK     ((uint32)0x00000080UL)   /**< @brief CPSR bit I */
    #else
        #if ((defined MCAL_ENABLE_USER_MODE_SUPPORT)&&(!defined MCAL_PLATFORM_ARM_M0PLUS))
            #define ISR_STATE_MASK     ((uint32)0x000000FFUL)   /**< @brief BASEPRI[7:0] mask */
        #else
            #define ISR_STATE_MASK     ((uint32)0x00000001UL)   /**< @brief PRIMASK bit 0 */
        #endif
    #endif
#endif
/*==================================================================================================
 *                                       LOCAL MACROS
==================================================================================================*/
#ifdef MCAL_PLATFORM_ARM
    #if (MCAL_PLATFORM_ARM == MCAL_ARM_AARCH64)
        #define ISR_ON(msr)            (((uint32)(msr) & (uint32)(ISR_STATE_MASK)) != (uint32)(ISR_STATE_MASK))
    #elif  (MCAL_PLATFORM_ARM == MCAL_ARM_RARCH)
        #define ISR_ON(msr)            (((uint32)(msr) & (uint32)(ISR_STATE_MASK)) != (uint32)(ISR_STATE_MASK))
    #else
        #define ISR_ON(msr)            (((uint32)(msr) & (uint32)(ISR_STATE_MASK)) == (uint32)0)
    #endif
#endif

/*==================================================================================================
 *                                       LOCAL VARIABLES
==================================================================================================*/
#define RTE_START_SEC_VAR_CLEARED_32_NO_CACHEABLE
#include "Rte_MemMap.h"
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_00[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_00[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_01[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_01[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_02[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_02[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_03[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_03[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_04[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_04[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_05[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_05[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_06[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_06[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_07[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_07[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_08[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_08[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_09[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_09[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_10[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_10[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_11[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_11[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_12[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_12[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_13[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_13[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_14[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_14[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_15[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_15[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_16[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_16[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_17[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_17[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_18[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_18[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_19[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_19[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_20[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_20[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_21[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_21[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_22[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_22[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_23[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_23[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_24[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_24[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_25[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_25[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_26[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_26[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_27[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_27[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_28[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_28[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_29[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_29[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_30[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_30[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 msr_GPT_EXCLUSIVE_AREA_31[NUMBER_OF_CORES];
RTE_VAR static volatile uint32 reentry_guard_GPT_EXCLUSIVE_AREA_31[NUMBER_OF_CORES];
#define RTE_STOP_SEC_VAR_CLEARED_32_NO_CACHEABLE
#include "Rte_MemMap.h"

/*==================================================================================================
 *                                       LOCAL FUNCTIONS
==================================================================================================*/
#define RTE_START_SEC_CODE
#include "Rte_MemMap.h"

/*================================================================================================*/
#ifdef __GNU_C_YTM32B1MXX
/** 
* @brief    This function returns the MSR register value (32 bits).    
* @return   uint32 This function returns the MSR register value (32 bits). 
*/
RTE_FUNC uint32 Gpt_schm_read_msr(void)
{
    register uint32 RegTmp;
    #if (MCAL_PLATFORM_ARM == MCAL_ARM_AARCH64)
        __asm volatile( " mrs %x0, DAIF " : "=r" (RegTmp) );
    #elif  (MCAL_PLATFORM_ARM == MCAL_ARM_RARCH)
        __asm volatile( " mrs %0, CPSR " : "=r" (RegTmp) );
    #else
        #if ((defined MCAL_ENABLE_USER_MODE_SUPPORT)&&(!defined MCAL_PLATFORM_ARM_M0PLUS))
        __asm volatile( " mrs %0, basepri " : "=r" (RegTmp) );
        #else
        __asm volatile( " mrs %0, primask " : "=r" (RegTmp) );
        #endif
    #endif
    return (uint32)RegTmp;
}
#endif /* __GNU_C_YTM32B1MXX */
/*================================================================================================*/

#ifdef __ARM_C6_C_YTM32B1MXX
/** 
* @brief    This function returns the MSR register value (32 bits). 
* @return   uint32 This function returns the MSR register value (32 bits). 
*/
RTE_FUNC uint32 Gpt_schm_read_msr(void)
{
    register uint32 RegTmp;
    #if (MCAL_PLATFORM_ARM == MCAL_ARM_AARCH64)
        __asm volatile( " mrs %x0, DAIF " : "=r" (RegTmp) );
    #elif  (MCAL_PLATFORM_ARM == MCAL_ARM_RARCH)
        __asm volatile( " mrs %0, CPSR " : "=r" (RegTmp) );
    #else
        #if ((defined MCAL_ENABLE_USER_MODE_SUPPORT)&&(!defined MCAL_PLATFORM_ARM_M0PLUS))
        __asm volatile( " mrs %0, basepri " : "=r" (RegTmp) );
        #else
        __asm volatile( " mrs %0, primask " : "=r" (RegTmp) );
        #endif
    #endif
    return (uint32)RegTmp;
}
#endif /* __ARM_C6_C_YTM32B1MXX */

#ifdef __IAR_C_YTM32B1MXX
/** 
* @brief    This function returns the MSR register value (32 bits).    
* @return   uint32 This function returns the MSR register value (32 bits). 
*/
RTE_FUNC uint32 Gpt_schm_read_msr(void)
{
    register uint32 RegTmp;

#if ((defined MCAL_ENABLE_USER_MODE_SUPPORT)&&(!defined MCAL_PLATFORM_ARM_M0PLUS))
   __asm volatile( " mrs %0, basepri " : "=r" (RegTmp) );
#else
   __asm volatile( " mrs %0, primask " : "=r" (RegTmp) );
#endif

    return (uint32)RegTmp;
}
#endif /* __IAR_C_YTM32B1MXX */

#define RTE_STOP_SEC_CODE
#include "Rte_MemMap.h"

/*==================================================================================================
*                                        GLOBAL FUNCTIONS
==================================================================================================*/
#define RTE_START_SEC_CODE
#include "Rte_MemMap.h"

#if (STD_ON == GPT_SCHM_SUPPORT)

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_00(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_00[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_00[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_00[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_00[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_00[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_00(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_00[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_00[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_00[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_01(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_01[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_01[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_01[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_01[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_01[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_01(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_01[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_01[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_01[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_02(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_02[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_02[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_02[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_02[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_02[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_02(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_02[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_02[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_02[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_03(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_03[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_03[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_03[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_03[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_03[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_03(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_03[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_03[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_03[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_04(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_04[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_04[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_04[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_04[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_04[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_04(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_04[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_04[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_04[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_05(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_05[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_05[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_05[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_05[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_05[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_05(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_05[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_05[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_05[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_06(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_06[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_06[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_06[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_06[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_06[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_06(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_06[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_06[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_06[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_07(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_07[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_07[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_07[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_07[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_07[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_07(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_07[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_07[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_07[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_08(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_08[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_08[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_08[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_08[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_08[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_08(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_08[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_08[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_08[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_09(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_09[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_09[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_09[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_09[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_09[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_09(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_09[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_09[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_09[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_10(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_10[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_10[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_10[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_10[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_10[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_10(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_10[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_10[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_10[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_11(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_11[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_11[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_11[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_11[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_11[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_11(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_11[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_11[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_11[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_12(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_12[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_12[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_12[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_12[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_12[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_12(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_12[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_12[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_12[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_13(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_13[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_13[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_13[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_13[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_13[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_13(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_13[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_13[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_13[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_14(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_14[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_14[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_14[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_14[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_14[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_14(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_14[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_14[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_14[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_15(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_15[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_15[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_15[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_15[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_15[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_15(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_15[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_15[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_15[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_16(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_16[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_16[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_16[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_16[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_16[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_16(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_16[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_16[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_16[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_17(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_17[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_17[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_17[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_17[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_17[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_17(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_17[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_17[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_17[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_18(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_18[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_18[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_18[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_18[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_18[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_18(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_18[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_18[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_18[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_19(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_19[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_19[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_19[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_19[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_19[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_19(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_19[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_19[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_19[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_20(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_20[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_20[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_20[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_20[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_20[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_20(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_20[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_20[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_20[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_21(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_21[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_21[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_21[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_21[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_21[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_21(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_21[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_21[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_21[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_22(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_22[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_22[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_22[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_22[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_22[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_22(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_22[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_22[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_22[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_23(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_23[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_23[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_23[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_23[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_23[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_23(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_23[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_23[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_23[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_24(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_24[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_24[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_24[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_24[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_24[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_24(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_24[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_24[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_24[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_25(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_25[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_25[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_25[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_25[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_25[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_25(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_25[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_25[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_25[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_26(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_26[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_26[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_26[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_26[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_26[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_26(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_26[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_26[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_26[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_27(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_27[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_27[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_27[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_27[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_27[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_27(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_27[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_27[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_27[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_28(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_28[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_28[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_28[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_28[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_28[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_28(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_28[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_28[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_28[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_29(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_29[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_29[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_29[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_29[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_29[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_29(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_29[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_29[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_29[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_30(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_30[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_30[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_30[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_30[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_30[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_30(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_30[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_30[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_30[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

RTE_FUNC void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_31(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    if(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_31[CoreId])
    {
#if (defined MCAL_ENABLE_USER_MODE_SUPPORT)
        msr_GPT_EXCLUSIVE_AREA_31[CoreId] = OsIf_Trusted_Call_Return(Gpt_schm_read_msr);
#else
        msr_GPT_EXCLUSIVE_AREA_31[CoreId] = Gpt_schm_read_msr();  /*read MSR (to store interrupts state)*/
#endif /* MCAL_ENABLE_USER_MODE_SUPPORT */
        if (ISR_ON(msr_GPT_EXCLUSIVE_AREA_31[CoreId])) /*if MSR[EE] = 0, skip calling Suspend/Resume AllInterrupts*/
        {
            OsIf_SuspendAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
            __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
        }
    }
    reentry_guard_GPT_EXCLUSIVE_AREA_31[CoreId]++;
}

RTE_FUNC void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_31(void)
{
    uint32 CoreId = (uint32)OsIf_GetCoreID();

    reentry_guard_GPT_EXCLUSIVE_AREA_31[CoreId]--;
    if ((ISR_ON(msr_GPT_EXCLUSIVE_AREA_31[CoreId]))&&(0UL == reentry_guard_GPT_EXCLUSIVE_AREA_31[CoreId]))         /*if interrupts were enabled*/
    {
        OsIf_ResumeAllInterrupts();
#ifdef __ARM_C6_C_YTM32B1MXX
        __ASM(" nop ");/* Compiler fix - forces the CSPID instruction to be generated with -02, -Ospace are selected*/
#endif
    }
}

#else

/* If SchM is not used, define empty functions */
RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_00(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_00(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_01(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_01(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_02(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_02(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_03(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_03(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_04(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_04(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_05(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_05(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_06(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_06(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_07(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_07(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_08(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_08(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_09(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_09(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_10(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_10(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_11(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_11(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_12(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_12(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_13(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_13(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_14(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_14(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_15(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_15(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_16(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_16(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_17(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_17(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_18(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_18(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_19(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_19(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_20(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_20(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_21(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_21(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_22(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_22(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_23(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_23(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_24(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_24(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_25(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_25(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_26(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_26(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_27(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_27(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_28(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_28(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_29(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_29(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_30(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_30(void)  {}

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_31(void) {}
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_31(void)  {}
#endif /* #if (STD_ON == GPT_SCHM_SUPPORT) */

#define RTE_STOP_SEC_CODE
#include "Rte_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */