/*
* @file    SchM_CddI2c.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : SchM_CddI2c
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef SCHM_CDDI2C_H
#define SCHM_CDDI2C_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES                                          
==================================================================================================*/
/*==================================================================================================
                                      HHEADER FILE VERSION INFORMATION                                
==================================================================================================*/
#define SCHM_CDDI2C_VENDOR_ID             		 (180)
#define SCHM_CDDI2C_AR_REL_MAJOR_VER              (4)
#define SCHM_CDDI2C_AR_REL_MINOR_VER              (4)
#define SCHM_CDDI2C_AR_REL_REVISION_VER           (0)
#define SCHM_CDDI2C_SW_MAJOR_VER                  (2)
#define SCHM_CDDI2C_SW_MINOR_VER                  (0)
#define SCHM_CDDI2C_SW_PATCH_VER                  (0)
/*==================================================================================================
                                                DEFINES AND MACROS                                       
==================================================================================================*/

/* Number of cores id */
#ifndef NUMBER_OF_CORES
#define NUMBER_OF_CORES         (uint8)(1U)
#endif /* NUMBER_OF_CORES */

/*==================================================================================================
                                                EXTERNAL CONSTANTS                                        
==================================================================================================*/
/*==================================================================================================
                                                ENUMS                                        
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES                                           
==================================================================================================*/

extern void SchM_Enter_CddI2c_CDDI2C_EXCLUSIVE_AREA_00(void);
extern void SchM_Exit_CddI2c_CDDI2C_EXCLUSIVE_AREA_00(void);

extern void SchM_Enter_CddI2c_CDDI2C_EXCLUSIVE_AREA_01(void);
extern void SchM_Exit_CddI2c_CDDI2C_EXCLUSIVE_AREA_01(void);

extern void SchM_Enter_CddI2c_CDDI2C_EXCLUSIVE_AREA_02(void);
extern void SchM_Exit_CddI2c_CDDI2C_EXCLUSIVE_AREA_02(void);

extern void SchM_Enter_CddI2c_CDDI2C_EXCLUSIVE_AREA_03(void);
extern void SchM_Exit_CddI2c_CDDI2C_EXCLUSIVE_AREA_03(void);

extern void SchM_Enter_CddI2c_CDDI2C_EXCLUSIVE_AREA_04(void);
extern void SchM_Exit_CddI2c_CDDI2C_EXCLUSIVE_AREA_04(void);

extern void SchM_Enter_CddI2c_CDDI2C_EXCLUSIVE_AREA_05(void);
extern void SchM_Exit_CddI2c_CDDI2C_EXCLUSIVE_AREA_05(void);

extern void SchM_Enter_CddI2c_CDDI2C_EXCLUSIVE_AREA_06(void);
extern void SchM_Exit_CddI2c_CDDI2C_EXCLUSIVE_AREA_06(void);

extern void SchM_Enter_CddI2c_CDDI2C_EXCLUSIVE_AREA_07(void);
extern void SchM_Exit_CddI2c_CDDI2C_EXCLUSIVE_AREA_07(void);

extern void SchM_Enter_CddI2c_CDDI2C_EXCLUSIVE_AREA_08(void);
extern void SchM_Exit_CddI2c_CDDI2C_EXCLUSIVE_AREA_08(void);

extern void SchM_Enter_CddI2c_CDDI2C_EXCLUSIVE_AREA_09(void);
extern void SchM_Exit_CddI2c_CDDI2C_EXCLUSIVE_AREA_09(void);

extern void SchM_Enter_CddI2c_CDDI2C_EXCLUSIVE_AREA_10(void);
extern void SchM_Exit_CddI2c_CDDI2C_EXCLUSIVE_AREA_10(void);

extern void SchM_Enter_CddI2c_CDDI2C_EXCLUSIVE_AREA_11(void);
extern void SchM_Exit_CddI2c_CDDI2C_EXCLUSIVE_AREA_11(void);

#ifdef __cplusplus
}
#endif

#endif /* End of file SchM_CddI2c.h */
