/*
* @file    Port_Lld_Reg.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : Port_Lld_Reg
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef PORT_LLD_REG_H
#define PORT_LLD_REG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#if defined(CPU_YTM32B1ME0) || defined(CPU_YTM32B1MD1)
#include "pSIP_Pctrl.h"
#include "pSIP_Gpio.h"
#endif

#if defined(UNIT_TEST)
#include "inc/fakePctrl.h"
#include "inc/fakeGpio.h"
#endif

/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define PORT_LLD_REG_VENDOR_ID             		(180)
#define PORT_LLD_REG_AR_REL_MAJOR_VER              (4)
#define PORT_LLD_REG_AR_REL_MINOR_VER              (4)
#define PORT_LLD_REG_AR_REL_REVISION_VER           (0)
#define PORT_LLD_REG_SW_MAJOR_VER                  (2)
#define PORT_LLD_REG_SW_MINOR_VER                  (0)
#define PORT_LLD_REG_SW_PATCH_VER                  (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
#ifdef __cplusplus
}
#endif

#endif /* End of file Port_Lld_Reg.h */
