/**
*   @file    ComStack_Types.h
*   @version
*
*   @brief   ComStack type define
*
*   @addtogroup GENERAL
*   @{
*/
/*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   Autosar Conf.Variant :
*   SW Version           : V2.0.0
*
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/
/*==================================================================================================
==================================================================================================*/

#ifndef COMSTACK_TYPES_H
#define COMSTACK_TYPES_H

/*=================================================================================================
*                                        INCLUDE FILES
=================================================================================================*/
#include "Std_Types.h"
#include "Compiler.h"
#include "Platform_Types.h"

/*==================================================================================================
*                                       DEFINES AND MACROS
==================================================================================================*/
typedef uint8        PduIdType;             /* uint8, uint16                 */
typedef uint16       PduLengthType;         /* uint8, uint16, uint32         */
/**
 * @brief       Data length of a LIN Frame.
 * @details     This type is used to specify the number of SDU data bytes to copy.
 * @implements  Lin_FrameDlType_typedef
 */
typedef uint8 Lin_FrameDlType;

/**
 * @brief       The LIN identifier (0..0x3F) with its parity bits.
 * @details     Represents all valid protected Identifier used by Lin_SendHeader().
 * @implements  Lin_FramePidType_typedef
 */
typedef uint8 Lin_FramePidType;

typedef enum {
    LIN_ENHANCED_CS                          = 0, /**<    */
    LIN_CLASSIC_CS                           = 1, /**<    */
} Lin_FrameCsModelType;

typedef enum {
    LIN_MASTER_RESPONSE,    /**< @brief Response is generated from this (master) node.*/
    LIN_SLAVE_RESPONSE,     /**< @brief Response is generated from a remote slave node.*/
    LIN_SLAVE_TO_SLAVE      /**< @brief Response is generated from one slave to another slave.*/
    /**< @brief For the master the response will be anonymous,
     * it does not have to receive the response.*/
} Lin_FrameResponseType;

typedef struct
{
    uint8            *SduDataPtr;   /**< Pointer of SDU data buffer */
    uint8            *MetaDataPtr;  /**< Pointer of Meta data buffer */
    PduLengthType    SduLength;     /**< Length of SDU data buffer */
} PduInfoType;

/**
 * @brief       The LIN identifier (0..0x3F) with its parity bits.
 * @details     This Type is used to provide PID, checksum model, data length and SDU
 *              pointer from the LIN Interface to the LIN driver.
 * @implements  Lin_PduType_struct
 */
typedef struct
{
    Lin_FramePidType      Pid;     /*!< LIN frame identifier.*/
    Lin_FrameCsModelType  Cs;      /*!< Checksum model type.*/
    Lin_FrameResponseType Drc;     /*!< Response type.*/
    Lin_FrameDlType       Dl;      /*!< Data length.*/
    uint8*                SduPtr;  /*!< Pointer to Sdu.*/
} Lin_PduType;

typedef uint8        PNCHandleType;

typedef enum
{
    TP_STMIN,
    TP_BS,
    TP_BC
} TPParameterType;

typedef enum
{
    BUFREQ_OK,
    BUFREQ_E_NOT_OK,
    BUFREQ_E_BUSY,
    BUFREQ_E_OVFL
} BufReq_ReturnType;

typedef enum
{
    TP_DATACONF,
    TP_DATARETRY,
    TP_CONFPENDING
} TpDataStateType;

typedef struct
{
    TpDataStateType     TpDataState;    /**< TP data state */
    PduLengthType       TxTpDataCnt;    /**< Tx TP data count */
} RetryInfoType;

typedef uint8       NetworkHandleType;
typedef uint8       IcomConfigIdType;

typedef enum
{
    ICOM_SWITCH_E_OK,
    ICOM_SWITCH_E_FAILED
} IcomSwitch_ErrorType;

#endif /* COMSTACK_TYPES_H */
/** @} */
