/**
* @file    Mcu_Lld_Irq.c
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : Mcu_Lld_Irq
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifdef __cplusplus
extern "C"
{
#endif

/*==================================================================================================
                                              INCLUDE FILES                                          
==================================================================================================*/
#include "Mcal.h"
#include "Mcu.h"
#include "Mcu_Lld.h"
/*==================================================================================================
                                      SOURCE FILE VERSION INFORMATION                                
==================================================================================================*/
#define MCU_LLD_IRQ_VENDOR_ID_C                     (180)
#define MCU_LLD_IRQ_AR_REL_MAJOR_VER_C              (4)
#define MCU_LLD_IRQ_AR_REL_MINOR_VER_C              (4)
#define MCU_LLD_IRQ_AR_REL_REVISION_VER_C           (0)
#define MCU_LLD_IRQ_SW_MAJOR_VER_C                  (2)
#define MCU_LLD_IRQ_SW_MINOR_VER_C                  (0)
#define MCU_LLD_IRQ_SW_PATCH_VER_C                  (0)
/*==================================================================================================
                                            FILE VERSION CHECKS                                      
==================================================================================================*/
/* Check if source file and MCU_LLD_IRQ header file are of the same vendor */
#if (MCU_LLD_IRQ_VENDOR_ID_C != MCU_LLD_VENDOR_ID)
#error "Mcu_Lld_Irq.c and Mcu_Lld_Irq.h have different vendor ids"
#endif

/* Check if source file and MCU_LLD_IRQ header file are of the same Autosar version */
#if (( MCU_LLD_IRQ_AR_REL_MAJOR_VER_C != MCU_LLD_AR_REL_MAJOR_VER) || \
      ( MCU_LLD_IRQ_AR_REL_MINOR_VER_C != MCU_LLD_AR_REL_MINOR_VER) || \
      ( MCU_LLD_IRQ_AR_REL_REVISION_VER_C != MCU_LLD_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of Mcu_Lld_Irq.c and Mcu_Lld_Irq.h are different"
#endif

/* Check if source file and MCU_LLD_IRQ header file are of the same Software version */
#if (( MCU_LLD_IRQ_SW_MAJOR_VER_C != MCU_LLD_SW_MAJOR_VER) || \
      ( MCU_LLD_IRQ_SW_MINOR_VER_C != MCU_LLD_SW_MINOR_VER) || \
      ( MCU_LLD_IRQ_SW_PATCH_VER_C != MCU_LLD_SW_PATCH_VER))
#error "Software Version Numbers of Mcu_Lld_Irq.c and Mcu_Lld_Irq.h are different"
#endif



/*==================================================================================================
                                                GLOBAL VARIABLES                                       
==================================================================================================*/

#define MCU_START_SEC_CODE
#include "Mcu_MemMap.h"

#ifdef MCU_LLD_PCU_ISR_USED
MCU_FUNC void PCU_IRQHandler(void);
#endif

#ifdef MCU_LLD_SCU_ISR_USED
MCU_FUNC void SCU_IRQHandler(void);
#endif
/*==================================================================================================
                                                LOCAL VARIABLES                                        
==================================================================================================*/

#ifdef MCU_LLD_PCU_ISR_USED
MCU_FUNC void PCU_IRQHandler(void) {
    Mcu_Lld_Pcu_ChannelIrqProcess();
}
#endif

#ifdef MCU_LLD_SCU_ISR_USED
MCU_FUNC void SCU_IRQHandler(void) {
    Mcu_Lld_Cmu_ChannelIrqProcess();
}
#endif
/*==================================================================================================
                                                LOCAL CONSTANTS                                        
==================================================================================================*/
/*==================================================================================================
                                                LOCAL MACROS                                           
==================================================================================================*/
/*==================================================================================================
                                                LOCAL FUNCTIONS                                        
==================================================================================================*/
/*==================================================================================================
                                                GLOBAL FUNCTIONS                                       
==================================================================================================*/

#define MCU_STOP_SEC_CODE
#include "Mcu_MemMap.h"

#ifdef __cplusplus
}
#endif

/* End of file Mcu_Lld_Irq.c */
