/**
* @file    Mcu_Lld_Reg.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : Mcu_Lld_Reg
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef MCU_LLD_REG_H
#define MCU_LLD_REG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES                                          
==================================================================================================*/

#if defined(CPU_YTM32B1ME0) || defined(CPU_YTM32B1MD1)
#include "core_CM33_scb.h"
#include "pSIP_Scu.h"
#include "pSIP_Rcu.h"
#include "pSIP_Ipc.h"
#include "pSIP_Pcu.h"
#include "pSIP_Efm.h"
#endif

#if defined(UNIT_TEST)
#include "inc/fakeCM33Scb.h"
#include "inc/fakeScu.h"
#include "inc/fakeRcu.h"
#include "inc/fakeIpc.h"
#include "inc/fakePcu.h"
#include "inc/fakeEfm.h"
#endif
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION                                
==================================================================================================*/
#define MCU_LLD_REG_VENDOR_ID             		(180)
#define MCU_LLD_REG_AR_REL_MAJOR_VER              (4)
#define MCU_LLD_REG_AR_REL_MINOR_VER              (4)
#define MCU_LLD_REG_AR_REL_REVISION_VER           (0)
#define MCU_LLD_REG_SW_MAJOR_VER                  (2)
#define MCU_LLD_REG_SW_MINOR_VER                  (0)
#define MCU_LLD_REG_SW_PATCH_VER                  (0)
/*==================================================================================================
                                                DEFINES AND MACROS                                       
==================================================================================================*/
/*==================================================================================================
                                                EXTERNAL CONSTANTS                                        
==================================================================================================*/
/*==================================================================================================
                                                ENUMS                                        
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES                                           
==================================================================================================*/
#ifdef __cplusplus
}
#endif

#endif /* End of file Mcu_Lld_Reg.h */
