/**
* @file    Icu_Cmp_Irq.c
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : Icu_Cmp_Irq
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifdef __cplusplus
extern "C"
{
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "Icu_Cmp_Irq.h"
#include "Icu_Lld_Reg.h"
#include "Icu.h"
/*==================================================================================================
                                      SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define ICU_CMP_IRQ_VENDOR_ID_C                     (180)
#define ICU_CMP_IRQ_AR_REL_MAJOR_VER_C              (4)
#define ICU_CMP_IRQ_AR_REL_MINOR_VER_C              (4)
#define ICU_CMP_IRQ_AR_REL_REVISION_VER_C           (0)
#define ICU_CMP_IRQ_SW_MAJOR_VER_C                  (2)
#define ICU_CMP_IRQ_SW_MINOR_VER_C                  (0)
#define ICU_CMP_IRQ_SW_PATCH_VER_C                  (0)
/*==================================================================================================
                                            FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and ICU_CMP_IRQ header file are of the same vendor */
#if (ICU_CMP_IRQ_VENDOR_ID_C != ICU_CMP_IRQ_VENDOR_ID)
#error "Icu_Cmp_Irq.c and Icu_Cmp_Irq.h have different vendor ids"
#endif

/* Check if source file and ICU_CMP_IRQ header file are of the same Autosar version */
#if (( ICU_CMP_IRQ_AR_REL_MAJOR_VER_C != ICU_CMP_IRQ_AR_REL_MAJOR_VER) || \
      ( ICU_CMP_IRQ_AR_REL_MINOR_VER_C != ICU_CMP_IRQ_AR_REL_MINOR_VER) || \
      ( ICU_CMP_IRQ_AR_REL_REVISION_VER_C != ICU_CMP_IRQ_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of Icu_Cmp_Irq.c and Icu_Cmp_Irq.h are different"
#endif

/* Check if source file and ICU_CMP_IRQ header file are of the same Software version */
#if (( ICU_CMP_IRQ_SW_MAJOR_VER_C != ICU_CMP_IRQ_SW_MAJOR_VER) || \
      ( ICU_CMP_IRQ_SW_MINOR_VER_C != ICU_CMP_IRQ_SW_MINOR_VER) || \
      ( ICU_CMP_IRQ_SW_PATCH_VER_C != ICU_CMP_IRQ_SW_PATCH_VER))
#error "Software Version Numbers of Icu_Cmp_Irq.c and Icu_Cmp_Irq.h are different"
#endif

/*==================================================================================================
                                                GLOBAL VARIABLES
==================================================================================================*/
/*==================================================================================================
                                                LOCAL VARIABLES
==================================================================================================*/
/*==================================================================================================
                                                LOCAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                LOCAL MACROS
==================================================================================================*/
/*==================================================================================================
                                                LOCAL FUNCTIONS
==================================================================================================*/
/*==================================================================================================
                                                GLOBAL FUNCTIONS
==================================================================================================*/
void Icu_Cmp_IrqHandler(void);
ICU_ACMP_ISR(ACMP0_IRQHandler);

#define ICU_START_SEC_CODE
#include "Icu_MemMap.h"
ICU_FUNC ICU_ACMP_ISR(ACMP0_IRQHandler)
{
    Icu_Cmp_IrqHandler();
}
ICU_FUNC void Icu_Cmp_IrqHandler(void)
{
    volatile ACMP_Type *BaseAddr;

    uint32 ChannelCount;
    if (Icu_gConfigPtr != NULL_PTR)
    {
        Icu_ChannelConfigType const * IcuCmpChannelConfig = Icu_gConfigPtr->ChannelConfigPtr;
        ChannelCount = Icu_gConfigPtr->IcuChannelCount;
        for (uint32 ChannelIndex = 0; ChannelIndex < ChannelCount; ++ChannelIndex)
        {
            if (IcuCmpChannelConfig->IcuHwIp == ICU_LPCMP)
            {
                break;
            }
            ++IcuCmpChannelConfig;
        }
        BaseAddr = AcmpBase[IcuCmpChannelConfig->IcuHwIpInstance];
    }
    else
    {
        BaseAddr = AcmpBase[0];   /*default Instance 0*/
    }
    BaseAddr->CONT &= ~ACMP_CONT_EN_MASK;
    BaseAddr->CONT |= ACMP_CONT_EN(FALSE);   /*Disable ACMP Continuous mode*/

    if ((NULL_PTR != IcuCmpNotification->EdgeNotificationPtr) && (TRUE == IcuCmpNotification->IsNotificationEnable))
    {
        IcuCmpNotification->EdgeNotificationPtr();
    }
    BaseAddr->STS |= (uint32)ACMP_STS_CH_FLAG_MASK;
    BaseAddr->STS |= ((uint32)0U << ACMP_STS_CH_OUT_SHIFT) & ACMP_STS_CH_OUT_MASK;

    BaseAddr->CTRL |= ACMP_CTRL_EN_MASK;   /* Enable the ACMP */
    BaseAddr->CONT &= ~ACMP_CONT_EN_MASK;
    BaseAddr->CONT |= ACMP_CONT_EN(TRUE);   /*Enable ACMP Continuous mode again*/
}

#define ICU_STOP_SEC_CODE
#include "Icu_MemMap.h"

#ifdef __cplusplus
}
#endif

/* End of file Icu_Cmp_Irq.c */
