/*
* @file    Icu_Lld_Cmp.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : Icu_Lld_Cmp
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef ICU_LLD_CMP_H
#define ICU_LLD_CMP_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES                                          
==================================================================================================*/
#include "Std_Types.h"
#include "Icu.h"
#include "Icu_Lld_Reg.h"
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION                                
==================================================================================================*/
#define ICU_LLD_CMP_VENDOR_ID             		  (180)
#define ICU_LLD_CMP_AR_REL_MAJOR_VER              (4)
#define ICU_LLD_CMP_AR_REL_MINOR_VER              (4)
#define ICU_LLD_CMP_AR_REL_REVISION_VER           (0)
#define ICU_LLD_CMP_SW_MAJOR_VER                  (2)
#define ICU_LLD_CMP_SW_MINOR_VER                  (0)
#define ICU_LLD_CMP_SW_PATCH_VER                  (0)
/*==================================================================================================
                                                DEFINES AND MACROS                                       
==================================================================================================*/
#define ACMP_CONTINUOUS_MODE_CHANNELS_MASK  0xFF00U
#define ACMP_CONTINUOUS_MODE_CHANNELS_SHIFT 8U
#define ACMP_STS_CH_OUT_MASK                0xFF000000U
#define ACMP_STS_CH_OUT_SHIFT               24U
#define ACMP_STS_CH_FLAG_MASK               0x00FF0000U
#define ACMP_STS_CH_FLAG_SHIFT              16U
/*==================================================================================================
                                                EXTERNAL CONSTANTS                                        
==================================================================================================*/

/*==================================================================================================
                                                ENUMS                                        
==================================================================================================*/
typedef void (*IcuCmpNotificationType)(void);
typedef struct
{
    IcuCmpNotificationType EdgeNotificationPtr;  /*!< ICU_Port notification function */
    boolean IsNotificationEnable;               /*!< ICU_Port notification enable flag */
} IcuCmpEdgeDetectType;
/*==================================================================================================
                                                FUNCTION PROTOTYPES                                           
==================================================================================================*/
extern volatile ACMP_Type *const AcmpBase[ACMP_INSTANCE_COUNT];
extern IcuCmpEdgeDetectType IcuCmpNotification[ICU_CMP_MAX];
/**
 * @brief            This function initializes the channel.
 * @details 
 * @return           void
 * 
 */
void Icu_Lld_Cmp_Init(void);
/**
 * @brief            This function deinitialize the channel.
 * @details
 * @return           void
 *
 */
void Icu_Lld_Cmp_DeInit(void);
/**
 * @brief            This function initializes the channel.
 * @details
 * @param[in]        Channel - The channel
 * @return           void
 *
 */
void Icu_Lld_Cmp_EnableNotification(uint8 Channel);

/**
 * @brief            This function deinitialize the channel.
 * @details
 * @param[in]        Channel - The channel
 * @return           void
 *
 */
void Icu_Lld_Cmp_DisableNotification(uint8 Channel);

/**
 * @brief            This function sets the activation condition.
 * @details
 * @param[in]        ChannelIndex - The channel index.
 * @param[in]        Activation - The activation condition.
 * @return           void
 *
 */
void Icu_Lld_Cmp_SetActivationCondition(uint8 ChannelIndex, Icu_ActivationType Activation);

/**
 * @brief            This function sets the sleep mode.
 * @details
 * @param[in]        ConfigPtr - The channel configuration.
 * @return           void
 *
 */
void Icu_Lld_Cmp_SetSleepMode(const Icu_ChannelConfigType *ConfigPtr);

/**
 * @brief            This function sets the normal mode.
 * @details
 * @param[in]        ConfigPtr - The channel configuration.
 * @return           void
 *
 */
void Icu_Lld_Cmp_SetNormalMode(const Icu_ChannelConfigType *ConfigPtr);


/**
 * @brief            This function enable Edge Detection.
 * @details
 * @param[in]        ChannelIndex - The channel index.
 * @return           void
 *
 */
void Icu_Lld_Cmp_EnableEdgeDetection(uint16 ChannelIndex);

/**
 * @brief            This function disable Edge Detection.
 * @details
 * @param[in]        ChannelIndex - The channel index.
 * @return           void
 *
 */
void Icu_Lld_Cmp_DisableEdgeDetection(uint16 ChannelIndex);
#ifdef __cplusplus
}
#endif

#endif /* End of file Icu_Lld_Cmp.h */
