/**
 * @file    Icu_Base.h
 * @version
 *
 * @brief   AUTOSAR Port module interface
 * @details API implementation for Icu driver
 *
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : Etmr
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *   
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/
/*==================================================================================================
==================================================================================================*/
#ifndef ICU_BASE_H
#define ICU_BASE_H

/*=================================================================================================
 *                                        INCLUDE FILES
=================================================================================================*/
#include "Std_Types.h"
/*==================================================================================================
 *                                   FILE VERSION INFORMATION
==================================================================================================*/
#define ICU_BASE_VENDOR_ID (0xB4)
#define ICU_BASE_AR_REL_MAJOR_VER (4)
#define ICU_BASE_AR_REL_MINOR_VER (4)
#define ICU_BASE_AR_REL_REVISION_VER (0)
#define ICU_BASE_SW_MAJOR_VER (2)
#define ICU_BASE_SW_MINOR_VER (0)
#define ICU_BASE_SW_PATCH_VER (0)
/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/

/*==================================================================================================
 *                                       DEFINES AND MACROS
==================================================================================================*/
#define ICU_INSTANCE_ID_MASK (0xFF00U)  /**< @brief Mask for ICU instance ID */
#define ICU_CHANNEL_ID_MASK (0x00FFU)   /**< @brief Mask for ICU channel ID */

#define ICU_MAX_CHANNELS (6*8)
/**
* @brief Wakeup feature is currently enabled
*/
#define ICU_CHANNEL_STATE_WKUP                  (1U)

/**
* @brief The current channel status - IDLE / ACTIVE
*/
#define ICU_CHANNEL_STATE_IDLE                  (1U<<1)

/**
* @brief Notification is enabled
*/
#define ICU_CHANNEL_STATE_NOTIFICATION          (1U<<2)

/**
* @brief The current channel state
*/
#define ICU_CHANNEL_STATE_RUNNING               (1U<<3)

/**
* @brief Overflow flag
*/
#define ICU_CHANNEL_STATE_OVERFLOW              (1U<<4)

/**
* @brief Wakeup source
*/
#define ICU_CHANNEL_IS_WAKEUP_SOURCE            (1U<<7)
/*==================================================================================================
 *                                             ENUMS
==================================================================================================*/
typedef enum
{
    ICU_ACTIVE = 0U, /**<    */
    ICU_IDLE = 1U,   /**<    */
} Icu_InputStateType;

typedef enum
{
    ICU_MODE_SIGNAL_EDGE_DETECT = 0U, /**<    */
    ICU_MODE_SIGNAL_MEASUREMENT = 1U, /**<    */
    ICU_MODE_TIMESTAMP = 2U,          /**<    */
    ICU_MODE_EDGE_COUNTER = 3U,       /**<    */
} Icu_MeasurementModeType;

typedef uint8   Icu_ChannelStateType;   /**< ICU Channel state type. */

/*==================================================================================================
 *                                          VARIATES
==================================================================================================*/

#endif