/**
 * @file    Gpt_Lld_Lptmr_Reg.h
 * @version V2.0.0
 *
 * @brief   AUTOSAR Gpt module interface
 * @details API implementation for Gpt driver
 *
 * @addtogroup GPT_LLD_LPTMR_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : Lptmr
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef GPT_LLD_LPTMR_REG_H
#define GPT_LLD_LPTMR_REG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                      INCLUDE FILES
==================================================================================================*/
#if defined(CPU_YTM32B1ME0) || defined(CPU_YTM32B1MD1)
#include "pSIP_Lptmr.h"
#include "pSIP_Wku.h"
#elif defined(TESSY) && defined(UNIT_TEST)
#include "fakeLptmr.h"
#include "fakeWku.h"
#endif

/*==================================================================================================
 *                               SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define GPT_LLD_LPTMR_REG_VENDOR_ID             (180)
#define GPT_LLD_LPTMR_REG_MODULE_ID             (100)
#define GPT_LLD_LPTMR_REG_AR_REL_MAJOR_VER      (4)
#define GPT_LLD_LPTMR_REG_AR_REL_MINOR_VER      (4)
#define GPT_LLD_LPTMR_REG_AR_REL_REVISION_VER   (0)
#define GPT_LLD_LPTMR_REG_SW_MAJOR_VER          (2)
#define GPT_LLD_LPTMR_REG_SW_MINOR_VER          (0)
#define GPT_LLD_LPTMR_REG_SW_PATCH_VER          (0)

#ifdef __cplusplus
}
#endif

#endif /* GPT_LLD_LPTMR_REG_H */

/** @} */
