/**
 * @file    Crypto_keyManage.c
 * @version
 *
 * @brief   AUTOSAR Csm module interface
 * @details API implementation for CSM driver
 *
 * @addtogroup CSM_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4 MCAL
 *   Platform             : ARM
 *   Peripheral           : Csm
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/
/*==================================================================================================
==================================================================================================*/

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
*                                          INCLUDE FILES
* 1) system and project includes
* 2) needed interfaces from external units
* 3) internal and external interfaces from this unit
==================================================================================================*/
#include "Std_Types.h"
#include "Crypto_Ip_Types.h"
#include "Crypto_Lld_Reg.h"
#include "Crypto_KeyManage.h"
#include "Crypto_Cfg.h"
#include "OsIf.h"
/*==================================================================================================
*                                 SOURCE FILE VERSION INFORMATION
==================================================================================================*/


/*==================================================================================================
*                                       FILE VERSION CHECKS
==================================================================================================*/


/*==================================================================================================
*                           LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
==================================================================================================*/

/*==================================================================================================
*                                          LOCAL MACROS
==================================================================================================*/
#define LENGTH_OF_KEYSLOT        (32U)
/*==================================================================================================
*                                         LOCAL CONSTANTS
==================================================================================================*/


/*==================================================================================================
*                                         LOCAL VARIABLES
==================================================================================================*/

/*==================================================================================================
*                                        GLOBAL CONSTANTS
==================================================================================================*/

/*==================================================================================================
*                                        GLOBAL VARIABLES
==================================================================================================*/

/*==================================================================================================
*                                    LOCAL FUNCTION PROTOTYPES
==================================================================================================*/

#define CRYPTO_START_SEC_CODE
#include "Crypto_MemMap.h"

/*FUNCTION**********************************************************************
 *
 * Function Name : Crypto_KeyManage_LoadAESKey
 * Description   : Load AES key for HCU
 *
 * Implements    : Crypto_KeyManage_LoadAESKey
 *END**************************************************************************/

CRYPTO_FUNC Std_ReturnType Crypto_KeyManage_LoadAESKey(uint32 Address)
{
    uint8 TempKey[16];
    Std_ReturnType TempStdRet = E_NOT_OK;
    /*Waiting for idle*/
    do {
        Fls_MainFunction();
    } while (Fls_GetStatus() != MEMIF_IDLE);
    /*Load key schm protect ??*/
    TempStdRet = Fls_Read(Address, TempKey, LENGTH_OF_KEYSLOT);
    if(E_OK == TempStdRet)
    {
        do
        {
            Fls_MainFunction();
        } while (Fls_GetStatus()!= MEMIF_IDLE);

        if(Fls_GetJobResult()== MEMIF_JOB_OK)
        {
            TempStdRet = E_OK;
        }
        else
        {
            TempStdRet = E_NOT_OK;
        }
    }
    return TempStdRet;
}

#define CRYPTO_STOP_SEC_CODE
#include "Crypto_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */

