/**
 * @file    TRNG_LId.h
 * @version
 *
 * @brief   AUTOSAR Crypto module interface
 * @details API implementation for Crypto random driver
 *
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4 MCAL
 *   Platform             : ARM
 *   Peripheral           : Crypto TRNG
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/
/*==================================================================================================
==================================================================================================*/


#ifndef TRNG_Lld_H
#define TRNG_Lld_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
*                                          INCLUDE FILES
* 1) system and project includes
* 2) needed interfaces from external units
* 3) internal and external interfaces from this unit
==================================================================================================*/
#include "Std_Types.h"
#include "TRNG_Ip_Types.h"
#include "pSIP_Trng.h"
#include "Crypto_KeyManage.h"

/*==================================================================================================
*                                            CONSTANTS
==================================================================================================*/

/*==================================================================================================
*                                       DEFINES AND MACROS
==================================================================================================*/
/*TRNG*/
#define TRNG_INST              0
#define TRNG_ENTROPY_DELAY     0x0A00


/*==================================================================================================
*                                              ENUMS
==================================================================================================*/

/*==================================================================================================
*                                  STRUCTURES AND OTHER TYPEDEFS
==================================================================================================*/

/*==================================================================================================
*                                  GLOBAL VARIABLE DECLARATIONS
==================================================================================================*/

/*==================================================================================================
*                                       FUNCTION PROTOTYPES
==================================================================================================*/
extern void Trng_Lld_Init(uint32 Instance, uint32 EntroyDelay);
extern void Trng_Lld_Get_Ent(uint32 Instance,uint8* EntValuePtr,uint32 Length);
extern status_t Trng_Lld_GetStatus(uint32 Instance);



#ifdef __cplusplus
}
#endif

#endif /* CRYPTO_IPW_H */


