/*
* @file    Crypto_Lld_Reg.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : CRYPTO_Lld_Reg
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef CRYPTO_LLD_REG_H
#define CRYPTO_LLD_REG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#if defined(CPU_YTM32B1ME0)
#include "pSIP_Hcu.h"
#include "pSIP_Efm.h"
#include "pSIP_Trng.h"
#include "YTM32B1ME0_features.h"
#elif defined(CPU_YTM32B1MD1)
#include "pSIP_Hcu.h"
#include "pSIP_Efm.h"
#include "pSIP_Trng.h"
#include "YTM32B1MD1_features.h"
#endif

#if defined(UNIT_TEST)
#include "inc/fakeHcu.h"
#include "inc/fakeEfm.h"
#include "inc/fakeTrng.h"
#include "YTM32B1ME0_features.h"

#define HCU_NVR_ADDR           0x10000000
#define HCU_HWKEY_SZIE         32
#endif
/*==================================================================================================
                                      HHEADER FILE VERSION INFORMATION
==================================================================================================*/
#define CRYPTO_LLD_REG_VENDOR_ID                     (180)
#define CRYPTO_LLD_REG_AR_REL_MAJOR_VER              (4)
#define CRYPTO_LLD_REG_AR_REL_MINOR_VER              (4)
#define CRYPTO_LLD_REG_AR_REL_REVISION_VER           (0)
#define CRYPTO_LLD_REG_SW_MAJOR_VER                  (2)
#define CRYPTO_LLD_REG_SW_MINOR_VER                  (0)
#define CRYPTO_LLD_REG_SW_PATCH_VER                  (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
#ifdef __cplusplus
}
#endif

#endif /* End of file CRYPTO_Lld_Reg.h */
