/**
 * @file    Crypto_Lld.h
 * @version
 *
 * @brief   AUTOSAR Crypto module interface
 * @details API implementation for CRYPTO driver
 *
 * @addtogroup CRYPTO_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4 MCAL
 *   Platform             : ARM
 *   Peripheral           : Csm
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V2.0.0
 *
 *   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/
/*==================================================================================================
==================================================================================================*/


#ifndef CRYPTO_Lld_H
#define CRYPTO_Lld_H

/**
*   @file
*
*   @internal
*   @addtogroup CRYPTO
*   @{
*/

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
*                                          INCLUDE FILES
* 1) system and project includes
* 2) needed interfaces from external units
* 3) internal and external interfaces from this unit
==================================================================================================*/
#include "Std_Types.h"
#include "Crypto_Ip_Types.h"
/*==================================================================================================
*                                            CONSTANTS
==================================================================================================*/

/*==================================================================================================
*                                       DEFINES AND MACROS
==================================================================================================*/



/*==================================================================================================
*                                              ENUMS
==================================================================================================*/

/*==================================================================================================
*                                  STRUCTURES AND OTHER TYPEDEFS
==================================================================================================*/


/*==================================================================================================
*                                  GLOBAL VARIABLE DECLARATIONS
==================================================================================================*/

/*==================================================================================================
*                                       FUNCTION PROTOTYPES
==================================================================================================*/
/*declare funtion here*/
boolean Crypto_Lld_HCU_GetStatusFlag(hcu_status_flag_t StatusFlag);
void Crypto_Lld_HCU_ClearStatusFlag(hcu_status_flag_t StatusFlag);
#if(CRYPTO_METHOD_INTERRUPT == CRYPTO_ASYNJOB_METHOD_SUPPORT)
void Crypto_Lld_HCU_SetDefaultInterrupt(boolean Enable);
#endif
void Crypto_Lld_HCU_ResetFifo(void);
void Crypto_Lld_HCU_ClearCR(void);
void Crypto_Lld_HCU_DRV_CfgSwapping(hcu_swapping_t Cfg);
void Crypto_Lld_HCU_SetEngineAlgorithm(hcu_engine_sel_t Engine, hcu_alg_aes_mode_t Algorithm, hcu_mode_sel_t Encrypt);
void Crypto_Lld_HCU_SetUserKey(uint32 const* KeyArray, uint32 KeyLength);
void Crypto_Lld_HCU_SetIV(const uint8 *Iv);
void Crypto_Lld_HCU_SetCV(const uint8 *Cv);
void Crypto_Lld_HCU_SetKeySize( uint32 LengthOfBits);
void Crypto_Lld_HCU_SetMsgLength(uint32 MsgLen, uint32 AddMsgLen);
void Crypto_Lld_HCU_SetMacLength(uint32 Length);
void Crypto_Lld_HCU_SetMsgType(hcu_msg_type_t Type);
void Crypto_Lld_HCU_SetMsgTotalLength(uint32 MsgTotalLen);
void Crypto_Lld_HCU_SetFIFOWaterMark(uint8 In, uint8 Out);
void Crypto_Lld_HCU_StartEngine(void);
boolean Crypto_Lld_HCU_IsDone(void);
boolean Crypto_Lld_HCU_IsInputFifoEmpty(void);
boolean Crypto_Lld_HCU_IsOutputFifoFull(void);
void Crypto_Lld_HCU_WriteInputFifo(const uint8 *Data, uint32 Length);
void Crypto_Lld_HCU_ReadOutputFifo(uint8 *Data, uint8 Length);
void Crypto_Lld_HCU_SetInputMac(const uint8 *MacVerif,uint32 Length);
void Crypto_Lld_HCU_ReadAESMAC(uint8 *Data, uint8 Length);
void Crypto_Lld_HCU_SetInputDMA(boolean Enable);
void Crypto_Lld_HCU_SetOutputDMA(boolean Enable);
void Crypto_Lld_HCU_SetSHAVerification(boolean Enable);
void Crypto_Lld_HCU_ClearInputMac(void);
#ifdef __cplusplus
}
#endif

/** @} */

#endif /* CRYPTO_IPW_H */


