/**
*   @file    CddUart.c
*   @version
*   @brief   AUTOSAR CddUart module interface
*   @details API implementation for CddUart driver
*/
/*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : uart
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   Autosar Conf.Variant :
*   SW Version           : V2.0.0
*
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifdef __cplusplus
extern "C"
{
#endif

/*==================================================================================================
*                                        INCLUDE FILES
* 1) system and project includes
* 2) needed interfaces from external units
* 3) internal and external interfaces from this unit
==================================================================================================*/
#include "CddUart_Lld_LinFlexD.h"
/*==================================================================================================
*                                       LOCAL MACROS
==================================================================================================*/
#define CddUart_ISR(IsrName) void IsrName(void)
/*==================================================================================================
                                       LOCAL CONSTANTS
==================================================================================================*/

/*==================================================================================================
                                       LOCAL VARIABLES
==================================================================================================*/
#define CDDUART_START_SEC_CODE
#include "CddUart_MemMap.h"
/*==================================================================================================
*                                    LOCAL FUNCTION PROTOTYPES
==================================================================================================*/
#ifdef CDDUART_LINFLEXD_0_USED
CddUart_ISR(LINFlexD0_IRQHandler);
#endif
#ifdef CDDUART_LINFLEXD_1_USED
CddUart_ISR(LINFlexD1_IRQHandler);
#endif
#ifdef CDDUART_LINFLEXD_2_USED
CddUart_ISR(LINFlexD2_IRQHandler);
#endif
#ifdef CDDUART_LINFLEXD_3_USED
CddUart_ISR(LINFlexD3_IRQHandler);
#endif
#ifdef CDDUART_LINFLEXD_4_USED
CddUart_ISR(LINFlexD4_IRQHandler);
#endif
#ifdef CDDUART_LINFLEXD_5_USED
CddUart_ISR(LINFlexD5_IRQHandler);
#endif
/*==================================================================================================
*                                    LOCAL FUNCTION
==================================================================================================*/
#ifdef CDDUART_LINFLEXD_0_USED
CDDUART_FUNC CddUart_ISR(LINFlexD0_IRQHandler)
{
    LinFlexD_IRQHandler(0U);
}
#endif
#ifdef CDDUART_LINFLEXD_1_USED
CDDUART_FUNC CddUart_ISR(LINFlexD1_IRQHandler)
{
    LinFlexD_IRQHandler(1U);
}
#endif
#ifdef CDDUART_LINFLEXD_2_USED
CDDUART_FUNC CddUart_ISR(LINFlexD2_IRQHandler)
{
    LinFlexD_IRQHandler(2U);
}
#endif
#ifdef CDDUART_LINFLEXD_3_USED
CDDUART_FUNC CddUart_ISR(LINFlexD3_IRQHandler)
{
    LinFlexD_IRQHandler(3U);
}
#endif
#ifdef CDDUART_LINFLEXD_4_USED
CDDUART_FUNC CddUart_ISR(LINFlexD4_IRQHandler)
{
    LinFlexD_IRQHandler(4U);
}
#endif
#ifdef CDDUART_LINFLEXD_5_USED
CDDUART_FUNC CddUart_ISR(LINFlexD4_IRQHandler)
{
    LinFlexD_IRQHandler(5U);
}
#endif

#define CDDUART_STOP_SEC_CODE
#include "CddUart_MemMap.h"

#ifdef __cplusplus
}
#endif