/*
* @file    CddI2c_Lld_Reg.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : CddI2c_Lld_Reg
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef CDDI2C_LLD_REG_H
#define CDDI2C_LLD_REG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#if defined(CPU_YTM32B1ME0) || defined(CPU_YTM32B1MD1)
#include "pSIP_I2c.h"
#elif defined(UNIT_TEST)
#include "inc/fakeI2c.h"
#endif

#if defined(CPU_YTM32B1ME0) || defined(UNIT_TEST)
#include "YTM32B1ME0_features.h"
#elif defined(CPU_YTM32B1MD1)
#include "YTM32B1MD1_features.h"
#else
#error "Wrong MCU part number or no MCU part number selected!"
#endif

/*==================================================================================================
                                      HHEADER FILE VERSION INFORMATION
==================================================================================================*/
#define CDDI2C_LLD_REG_VENDOR_ID                     (180)
#define CDDI2C_LLD_REG_AR_REL_MAJOR_VER              (4)
#define CDDI2C_LLD_REG_AR_REL_MINOR_VER              (4)
#define CDDI2C_LLD_REG_AR_REL_REVISION_VER           (0)
#define CDDI2C_LLD_REG_SW_MAJOR_VER                  (2)
#define CDDI2C_LLD_REG_SW_MINOR_VER                  (0)
#define CDDI2C_LLD_REG_SW_PATCH_VER                  (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
#ifdef __cplusplus
}
#endif

#endif /* End of file CddI2c_Lld_Reg.h */
