


/**
 * @class CrcModel
 */
declare class CrcModel {
    /**
     * @example 
    //define different CRC model
    new CrcModel(8, "CRC8", 0x07, 0x00, 0x00, false, false),
    new CrcModel(8, "CRC8_SAE_J1850", 0x1D, 0xFF, 0xFF, false, false),
    new CrcModel(8, "CRC8_SAE_J1850_ZERO", 0x1D, 0x00, 0x00, false, false),
    new CrcModel(8, "CRC8_8H2F", 0x2F, 0xFF, 0xFF, false, false),
    new CrcModel(8, "CRC8_CDMA2000", 0x9B, 0xFF, 0x00, false, false),
    new CrcModel(8, "CRC8_DARC", 0x39, 0x00, 0x00, true, true),
    new CrcModel(8, "CRC8_DVB_S2", 0xD5, 0x00, 0x00, false, false),
    new CrcModel(8, "CRC8_EBU", 0x1D, 0xFF, 0x00, true, true),
    new CrcModel(8, "CRC8_ICODE", 0x1D, 0xFD, 0x00, false, false),
    new CrcModel(8, "CRC8_ITU", 0x07, 0x00, 0x55, false, false),
    new CrcModel(8, "CRC8_MAXIM", 0x31, 0x00, 0x00, true, true),
    new CrcModel(8, "CRC8_ROHC", 0x07, 0xFF, 0x00, true, true),
    new CrcModel(8, "CRC8_WCDMA", 0x9B, 0x00, 0x00, true, true),
    new CrcModel(16, "CRC16_CCIT_ZERO", 0x1021, 0x0000, 0x0000, false, false),
    new CrcModel(16, "CRC16_ARC", 0x8005, 0x0000, 0x0000, true, true),
    new CrcModel(16, "CRC16_AUG_CCITT", 0x1021, 0x1D0F, 0x0000, false, false),
    new CrcModel(16, "CRC16_BUYPASS", 0x8005, 0x0000, 0x0000, false, false),
    new CrcModel(16, "CRC16_CCITT_FALSE", 0x1021, 0xFFFF, 0x0000, false, false),
    new CrcModel(16, "CRC16_CDMA2000", 0xC867, 0xFFFF, 0x0000, false, false),
    new CrcModel(16, "CRC16_DDS_110", 0x8005, 0x800D, 0x0000, false, false),
    new CrcModel(16, "CRC16_DECT_R", 0x0589, 0x0000, 0x0001, false, false),
    new CrcModel(16, "CRC16_DECT_X", 0x0589, 0x0000, 0x0000, false, false),
    new CrcModel(16, "CRC16_DNP", 0x3D65, 0x0000, 0xFFFF, true, true),
    new CrcModel(16, "CRC16_EN_13757", 0x3D65, 0x0000, 0xFFFF, false, false),
    new CrcModel(16, "CRC16_GENIBUS", 0x1021, 0xFFFF, 0xFFFF, false, false),
    new CrcModel(16, "CRC16_MAXIM", 0x8005, 0x0000, 0xFFFF, true, true),
    new CrcModel(16, "CRC16_MCRF4XX", 0x1021, 0xFFFF, 0x0000, true, true),
    new CrcModel(16, "CRC16_RIELLO", 0x1021, 0xB2AA, 0x0000, true, true),
    new CrcModel(16, "CRC16_T10_DIF", 0x8BB7, 0x0000, 0x0000, false, false),
    new CrcModel(16, "CRC16_TELEDISK", 0xA097, 0x0000, 0x0000, false, false),
    new CrcModel(16, "CRC16_TMS37157", 0x1021, 0x89EC, 0x0000, true, true),
    new CrcModel(16, "CRC16_USB", 0x8005, 0xFFFF, 0xFFFF, true, true),
    new CrcModel(16, "CRC16_A", 0x1021, 0xC6C6, 0x0000, true, true),
    new CrcModel(16, "CRC16_KERMIT", 0x1021, 0x0000, 0x0000, true, true),
    new CrcModel(16, "CRC16_MODBUS", 0x8005, 0xFFFF, 0x0000, true, true),
    new CrcModel(16, "CRC16_X_25", 0x1021, 0xFFFF, 0xFFFF, true, true),
    new CrcModel(16, "CRC16_XMODEM", 0x1021, 0x0000, 0x0000, false, false),
    new CrcModel(32, "CRC32", 0x04C11DB7, 0xFFFFFFFF, 0xFFFFFFFF, true, true),
    new CrcModel(32, "CRC32_BZIP2", 0x04C11DB7, 0xFFFFFFFF, 0xFFFFFFFF, false, false),
    new CrcModel(32, "CRC32_C", 0x1EDC6F41, 0xFFFFFFFF, 0xFFFFFFFF, true, true),
    new CrcModel(32, "CRC32_D", 0xA833982B, 0xFFFFFFFF, 0xFFFFFFFF, true, true),
    new CrcModel(32, "CRC32_MPEG2", 0x04C11DB7, 0xFFFFFFFF, 0x00000000, false, false),
    new CrcModel(32, "CRC32_POSIX", 0x04C11DB7, 0x00000000, 0xFFFFFFFF, false, false),
    new CrcModel(32, "CRC32_Q", 0x814141AB, 0x00000000, 0x00000000, false, false),
    new CrcModel(32, "CRC32_JAMCRC", 0x04C11DB7, 0xFFFFFFFF, 0x00000000, true, true),
    new CrcModel(32, "CRC32_XFER", 0x000000AF, 0x00000000, 0x00000000, false, false),    
    new CrcModel(64, "CRC64_ECMA_182", "0x42f0e1eba9ea3693", "0x0000000000000000", "0x0000000000000000", false, false),
    new CrcModel(64, "CRC64_GO_ISO", "0x000000000000001B", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF", true, true),
    new CrcModel(64, "CRC64_WE", "0x42f0e1eba9ea3693", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF", false, false),
    new CrcModel(64, "CRC64_XZ", "0x42f0e1eba9ea3693", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF", true, true)
     */
    constructor(width: number, name: string, polynomial: number|string, initialValue: number|string, finalXorValue: number|string, reflectIn: boolean, reflectOut: boolean);
}
export {CrcModel};

/**
 * @remarks 
 * new CrcModel(8, "CRC8", 0x07, 0x00, 0x00, false, false)
 */
export function CRC8(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(8, "CRC8_SAE_J1850", 0x1D, 0xFF, 0xFF, false, false)
 */
export function CRC8_SAE_J1850(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(8, "CRC8_SAE_J1850_ZERO", 0x1D, 0x00, 0x00, false, false)
 */
export function CRC8_SAE_J1850_ZERO(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(8, "CRC8_8H2F", 0x2F, 0xFF, 0xFF, false, false)
 */
export function CRC8_8H2F(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(8, "CRC8_CDMA2000", 0x9B, 0xFF, 0x00, false, false)
 */
export function CRC8_CDMA2000(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(8, "CRC8_DARC", 0x39, 0x00, 0x00, true, true)
 */
export function CRC8_DARC(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(8, "CRC8_DVB_S2", 0xD5, 0x00, 0x00, false, false)
 */
export function CRC8_DVB_S2(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(8, "CRC8_EBU", 0x1D, 0xFF, 0x00, true, true)
 */
export function CRC8_EBU(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(8, "CRC8_ICODE", 0x1D, 0xFD, 0x00, false, false)
 */
export function CRC8_ICODE(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(8, "CRC8_ITU", 0x07, 0x00, 0x55, false, false)
 */
export function CRC8_ITU(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(8, "CRC8_MAXIM", 0x31, 0x00, 0x00, true, true)
 */

export function CRC8_MAXIM(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(8, "CRC8_ROHC", 0x07, 0xFF, 0x00, true, true)
 */
export function CRC8_ROHC(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(8, "CRC8_WCDMA", 0x9B, 0x00, 0x00, true, true)
 */
export function CRC8_WCDMA(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_CCIT_ZERO", 0x1021, 0x0000, 0x0000, false, false)
 */
export function CRC16_CCIT_ZERO(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_ARC", 0x8005, 0x0000, 0x0000, true, true)
 */
export function CRC16_ARC(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_AUG_CCITT", 0x1021, 0x1D0F, 0x0000, false, false)
 */
export function CRC16_AUG_CCITT(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_BUYPASS", 0x8005, 0x0000, 0x0000, false, false)
 */
export function CRC16_BUYPASS(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_CCITT_FALSE", 0x1021, 0xFFFF, 0x0000, false, false)
 */
export function CRC16_CCITT_FALSE(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_CDMA2000", 0xC867, 0xFFFF, 0x0000, false, false)
 */
export function CRC16_CDMA2000(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_DDS_110", 0x8005, 0x800D, 0x0000, false, false)
 */
export function CRC16_DDS_110(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_DECT_R", 0x0589, 0x0000, 0x0001, false, false)
 */
export function CRC16_DECT_R(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_DECT_X", 0x0589, 0x0000, 0x0000, false, false)
 */
export function CRC16_DECT_X(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_DNP", 0x3D65, 0x0000, 0xFFFF, true, true)
 */
export function CRC16_DNP(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_EN_13757", 0x3D65, 0x0000, 0xFFFF, false, false)
 */
export function CRC16_EN_13757(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_GENIBUS", 0x1021, 0xFFFF, 0xFFFF, false, false)
 */
export function CRC16_GENIBUS(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_MAXIM", 0x8005, 0x0000, 0xFFFF, true, true)
 */
export function CRC16_MAXIM(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_MCRF4XX", 0x1021, 0xFFFF, 0x0000, true, true)
 */
export function CRC16_MCRF4XX(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_RIELLO", 0x1021, 0xB2AA, 0x0000, true, true)
 */
export function CRC16_RIELLO(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_T10_DIF", 0x8BB7, 0x0000, 0x0000, false, false)
 */
export function CRC16_T10_DIF(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_TELEDISK", 0xA097, 0x0000, 0x0000, false, false)
 */
export function CRC16_TELEDISK(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_TMS37157", 0x1021, 0x89EC, 0x0000, true, true)
 */
export function CRC16_TMS37157(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_USB", 0x8005, 0xFFFF, 0xFFFF, true, true)
 */
export function CRC16_USB(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_A", 0x1021, 0xC6C6, 0x0000, true, true)
 */
export function CRC16_A(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_KERMIT", 0x1021, 0x0000, 0x0000, true, true)
 */
export function CRC16_KERMIT(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_MODBUS", 0x8005, 0xFFFF, 0x0000, true, true)
 */
export function CRC16_MODBUS(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_X_25", 0x1021, 0xFFFF, 0xFFFF, true, true)
 */
export function CRC16_X_25(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(16, "CRC16_XMODEM", 0x1021, 0x0000, 0x0000, false, false)
 */
export function CRC16_XMODEM(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(32, "CRC32", 0x04C11DB7, 0xFFFFFFFF, 0xFFFFFFFF, true, true)
 */
export function CRC32(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(32, "CRC32_BZIP2", 0x04C11DB7, 0xFFFFFFFF, 0xFFFFFFFF, false, false)
 */
export function CRC32_BZIP2(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(32, "CRC32_C", 0x1EDC6F41, 0xFFFFFFFF, 0xFFFFFFFF, true, true)
 */
export function CRC32_C(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(32, "CRC32_D", 0xA833982B, 0xFFFFFFFF, 0xFFFFFFFF, true, true)
 */
export function CRC32_D(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(32, "CRC32_MPEG2", 0x04C11DB7, 0xFFFFFFFF, 0x00000000, false, false)
 */
export function CRC32_MPEG2(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(32, "CRC32_POSIX", 0x04C11DB7, 0x00000000, 0xFFFFFFFF, false, false)
 */
export function CRC32_POSIX(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(32, "CRC32_Q", 0x814141AB, 0x00000000, 0x00000000, false, false)
 */
export function CRC32_Q(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(32, "CRC32_JAMCRC", 0x04C11DB7, 0xFFFFFFFF, 0x00000000, true, true)
 */
export function CRC32_JAMCRC(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(32, "CRC32_XFER", 0x000000AF, 0x00000000, 0x00000000, false, false)
 */
export function CRC32_XFER(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(64, "CRC64_ECMA_182", "0x42f0e1eba9ea3693", "0x0000000000000000", "0x0000000000000000", false, false)
 */
export function CRC64_ECMA_182(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(64, "CRC64_GO_ISO", "0x000000000000001B", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF", true, true)
 */
export function CRC64_GO_ISO(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(64, "CRC64_WE", "0x42f0e1eba9ea3693", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF", false, false)
 */
export function CRC64_WE(data:Buffer):Buffer
/**
 * @remarks
 * new CrcModel(64, "CRC64_XZ", "0x42f0e1eba9ea3693", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF", true, true)
 */
export function CRC64_XZ(data:Buffer):Buffer



/**
 * Custom CRC calculation with self define model
 * @param data Buffer to calculate CRC
 * @param model CrcModel self defined CRC model
 * @returns Buffer of CRC result
 * 
 * @example
 *
 * ```ts
 * import {CRC_CUSTOM, CrcModel} from 'YT'
 * 
 * UDS.Init(()=>{
 *     const data = Buffer.from([0x01, 0x02, 0x03, 0x04]);
 *     const module = new CrcModel(16, "MyCrcName", 0x1021, 0x0000, 0x0000, false, false)
 *     const res = CRC_CUSTOM(data, module)
 *     console.log(res)
 * })
 * ```
 */
export function CRC_CUSTOM(data:Buffer, model:CrcModel):Buffer



