/// <reference types="node" />
/// <reference types="node" />

declare const serviceList: readonly [
        "Can.DiagnosticSessionControlProgrammingSession",
        "Can.DiagnosticSessionControlExtendedSession",
        "Can.ECUResetSoftware",
        "Can.ReadMemoryByAddress35",
        "Can.EraseFlashA",
        "Can.RoutineControlCrcCheck",
        "Can.RoutineControlFlashDriverCrcCheck",
        "Can.RoutineControlFlashDriverDownloaded",
        "Can.BootSwap",
        "Can.EraseFlashDriverRam",
        "Can.writeAppInfo",
        "Can.RequestDownloadFileA",
        "Can.RequestDownloadFlashDriver",
        "Can.SecurityAccessRequestSeed",
        "Can.SecurityAccessSendKey",
        "Can.RequestUploadFile",
        "Can.RequestUploadFlashDriver",
];
declare const allServicesSend: readonly [
        "Can.DiagnosticSessionControlProgrammingSession.send",
        "Can.DiagnosticSessionControlExtendedSession.send",
        "Can.ECUResetSoftware.send",
        "Can.ReadMemoryByAddress35.send",
        "Can.EraseFlashA.send",
        "Can.RoutineControlCrcCheck.send",
        "Can.RoutineControlFlashDriverCrcCheck.send",
        "Can.RoutineControlFlashDriverDownloaded.send",
        "Can.BootSwap.send",
        "Can.EraseFlashDriverRam.send",
        "Can.writeAppInfo.send",
        "Can.RequestDownloadFileA.send",
        "Can.RequestDownloadFlashDriver.send",
        "Can.SecurityAccessRequestSeed.send",
        "Can.SecurityAccessSendKey.send",
        "Can.RequestUploadFile.send",
        "Can.RequestUploadFlashDriver.send",
];
declare const allServicesPreSend: readonly [
        "Can.DiagnosticSessionControlProgrammingSession.preSend",
        "Can.DiagnosticSessionControlExtendedSession.preSend",
        "Can.ECUResetSoftware.preSend",
        "Can.ReadMemoryByAddress35.preSend",
        "Can.EraseFlashA.preSend",
        "Can.RoutineControlCrcCheck.preSend",
        "Can.RoutineControlFlashDriverCrcCheck.preSend",
        "Can.RoutineControlFlashDriverDownloaded.preSend",
        "Can.BootSwap.preSend",
        "Can.EraseFlashDriverRam.preSend",
        "Can.writeAppInfo.preSend",
        "Can.RequestDownloadFileA.preSend",
        "Can.RequestDownloadFlashDriver.preSend",
        "Can.SecurityAccessRequestSeed.preSend",
        "Can.SecurityAccessSendKey.preSend",
        "Can.RequestUploadFile.preSend",
        "Can.RequestUploadFlashDriver.preSend",
];
declare const allServicesRecv: readonly [
        "Can.DiagnosticSessionControlProgrammingSession.recv",
        "Can.DiagnosticSessionControlExtendedSession.recv",
        "Can.ECUResetSoftware.recv",
        "Can.ReadMemoryByAddress35.recv",
        "Can.EraseFlashA.recv",
        "Can.RoutineControlCrcCheck.recv",
        "Can.RoutineControlFlashDriverCrcCheck.recv",
        "Can.RoutineControlFlashDriverDownloaded.recv",
        "Can.BootSwap.recv",
        "Can.EraseFlashDriverRam.recv",
        "Can.writeAppInfo.recv",
        "Can.RequestDownloadFileA.recv",
        "Can.RequestDownloadFlashDriver.recv",
        "Can.SecurityAccessRequestSeed.recv",
        "Can.SecurityAccessSendKey.recv",
        "Can.RequestUploadFile.recv",
        "Can.RequestUploadFlashDriver.recv",
];
interface Jobs {
    "Can.DownloadFile": (param1:string,) => DiagRequest[]|Promise<DiagRequest[]>;
    "Can.DownloadFlashDriver": () => DiagRequest[]|Promise<DiagRequest[]>;
    "Can.UploadFile": () => DiagRequest[]|Promise<DiagRequest[]>;
    "Can.UploadFlashDriver": () => DiagRequest[]|Promise<DiagRequest[]>;
}
export type ServiceName = (typeof serviceList)[number];
export type ServiceNameSend = (typeof allServicesSend)[number];
export type ServiceNameRecv = (typeof allServicesRecv)[number];
export type ServiceNamePreSend = (typeof allServicesPreSend)[number];
export type JobName = keyof Jobs;
type EventMapSend = {
    [key in ServiceNameSend]: DiagRequest;
};
type EventMapPreSend = {
    [key in ServiceNamePreSend]: DiagRequest;
};
type EventMapRecv = {
    [key in ServiceNameRecv]: DiagResponse;
};
type EventMap = EventMapSend & EventMapRecv & EventMapPreSend;
export type ServiceEvent = {
    'send': DiagRequest;
    'preSend': DiagRequest;
    'recv': DiagResponse;
};
declare class Service {
    
    private params;
    private isRequest;
    private data?;
    
    /**
     * Subscribe to an event. When the event occurs, the listener function will be invoked.
     *
     * The valid event name should be:
     * - `'send'`: will be happen before the msg is send
     * - `'preSend'`: will be happen after the msg is send
     * - `'recv'`: will be happen when the response msg is recv
     *
     * @param event The event to be listened.
     * @param listener the function when event
     *
     * @example
     *
     * ```ts
     * UDS.Init(async ()=>{
     *     // add param arrayParam in YCT.
     *     const testService = new DiagRequest('Can.testService')
     *     testService.On('send', ()=>{
     *         console.log('send event happened.')
     *     })
     *
     *     testService.On('preSend', ()=>{
     *         console.log('preSend event happened.')
     *     })
     *
     *     testService.On('recv', ()=>{
     *         console.log('recv event happened.')
     *     })
     * })
     * ```
     */
    On<T extends keyof ServiceEvent>(event: T, listener: (data: ServiceEvent[T]) => void | Promise<void>): void;
    /**
     * Unsubscribe from an event.
     *
     * @param event - The event type.
     * @param listener - The function to unsubscribe.
     *
     * @example
     *
     * ```ts
     * UDS.Init(async () => {
     *     // Add param arrayParam in YCT.
     *     const testService = new DiagRequest('Can.testService');
     *     testService.On('send', () => {
     *         console.log('send event happened.');
     *     });
     *
     *     testService.On('preSend', preSendFunc);
     *
     *     // The following code will not work
     *     testService.Off('send', () => {
     *         console.log('send event happened.');
     *     });
     *     // The following code is better
     *     testService.Off('preSend', preSendFunc);
     * });
     * ```
     *
     * > **Note**: To unsubscribe from an event, you must provide a non-anonymous function.
     */
    Off<T extends keyof ServiceEvent>(event: T, listener: (data: ServiceEvent[T]) => void | Promise<void>): void;
    private asyncEmit;
    /**
     * This function will return the service name
     *
     * @example
     *
     * ```ts
     * UDS.Init(()=>{
     *     const testService = new DiagRequest('Can.testService');
     *     console.log('ServiceName:', testService.getServiceName())
     * })
     * ```
     */
    getServiceName(): string;
    /**
     * This function will return the service describe setting in YCT.
     * @returns service describe.
     *
     * @example
     *
     * ```ts
     * UDS.Init(()=>{
     *     const testService = new DiagRequest('Can.testService');
     *     console.log('Desc:', testService.getServiceDesc())
     * })
     * ```
     */
    getServiceDesc(): string | undefined;
    /**
     * This function will return the value of the provided parameter.
     * @param paramName param name
     * @returns param value
     *
     * @example
     *
     * ```ts
     * UDS.Init(()=>{
     *     const testService = new DiagRequest('Can.testService');
     *     console.log('SERVICE-ID Buffer:', testService.diagGetParameter('SERVICE-ID'))
     * })
     * ```
     */
    diagGetParameter(paramName: string): string | number;
    /**
     * This function will return the `Buffer` of the provided parameter.
     * @param paramName param name
     * @returns `Buffer` value of provided parameter.
     *
     * @example
     *
     * ```ts
     * UDS.Init(()=>{
     *     const testService = new DiagRequest('Can.testService');
     *     console.log('SERVICE-ID:', testService.diagGetParameterRaw('SERVICE-ID'))
     * })
     * ```
     */
    diagGetParameterRaw(paramName: string): Buffer;
    /**
     * This function will return the bit size of the provided parameter.
     * @param paramName param name
     * @returns param bit size
     *
     * @example
     *
     * ```ts
     * UDS.Init(()=>{
     *     const testService = new DiagRequest('Can.testService');
     *     console.log('SERVICE-ID Size:', testService.diagGetParameterSize('SERVICE-ID'))
     * })
     */
    diagGetParameterSize(paramName: string): number;
    /**
     * This function returns the names of all parameters associated with the given diag.
     *
     * @returns {string[]} An array of strings storing the names of all parameters.
     *
     * @example
     *
     * UDS.Init(()=>{
     *     const testService = new DiagRequest('Can.testService');
     *     console.log('parameter names:', testService.diagGetParameterNames())
     * })
     */
    diagGetParameterNames(): string[];
    /**
     * This function will change the parameter's bit size.
     * @param paramName parameter name
     * @param bitLen new bit size of the provided parameter.
     *
     * @example
     *
     * > It is only advisable to specify the size of num and array parameters.
     *
     * ```ts
     * UDS.Init(async ()=>{
     *     const testService = new DiagRequest('Can.testService')
     *
     *     // array parameter
     *     console.log('arrayParam bit size:', testService.diagGetParameterSize('arrayParam'))
     *     await testService.diagSetParameterSize('arrayParam', 64)
     *     console.log('arrayParam bit size:', testService.diagGetParameterSize('arrayParam'))
     *
     *     // num parameter
     *     console.log('numParam bit size:', testService.diagGetParameterSize('numParam'))
     *     await testService.diagSetParameterSize('numParam', 16)
     *     console.log('numParam bit size:', testService.diagGetParameterSize('numParam'))
     *
     *     console.log('ascii bit size:', testService.diagGetParameterSize('asciiParam'))
     *     await testService.diagSetParameterSize('asciiParam', 16)
     *     console.log('ascii bit size:', testService.diagGetParameterSize('asciiParam'))
     * })
     * ```
     *
     */
    diagSetParameterSize(paramName: string, bitLen: number): Promise<void>;
    /**
     * This function will change the provided parameter's value.
     * @param paramName parameter's name need to be changed.
     * @param value new value of the provided parameter.
     *
     * @example
     *
     * > Add relative param in YT Config Tool.
     *
     * 1. **array parameter**
     *
     *     ```ts
     *     UDS.Init(async ()=>{
     *         // add param arrayParam in YCT.
     *         const testService = new DiagRequest('Can.testService')
     *
     *         console.log('arrayParam:', testService.diagGetParameter('arrayParam'))
     *         await testService.diagSetParameter('arrayParam', '12 34 56 78')
     *         console.log('arrayParam:', testService.diagGetParameter('arrayParam'))
     *     })
     *     ```
     *
     * 2. **num parameter**
     *
     *     ```ts
     *     UDS.Init(async ()=>{
     *         // add param arrayParam in YCT.
     *         const testService = new DiagRequest('Can.testService')
     *
     *         // 8 bit number
     *         console.log('8 bits num:', testService.diagGetParameter('numParam'))
     *         await testService.diagSetParameter('numParam', '12')
     *         console.log('set parameter with str:', testService.diagGetParameter('numParam'))
     *         await testService.diagSetParameter('numParam', 99)
     *         console.log('set parameter with number:', testService.diagGetParameter('numParam'))
     *
     *         // 16 bit number
     *         console.log('8 bits num:', testService.diagGetParameterRaw('numParam'))
     *         await testService.diagSetParameterSize('numParam', 16)
     *         console.log('change size to 16 bits:', testService.diagGetParameterRaw('numParam'))
     *         await testService.diagSetParameter('numParam', '257')
     *         console.log('set parameter with str', testService.diagGetParameterRaw('numParam'))
     *         await testService.diagSetParameter('numParam', 65534)
     *         console.log('set parameter with number', testService.diagGetParameterRaw('numParam'))
     *     })
     *     ```
     * 3. **ascii parameter**
     *
     *     > The ascii parameter formats the input value into a string. It is advisable to avoid using numbers as input.
     *
     *     ```ts
     *     UDS.Init(async ()=>{
     *         // add param arrayParam in YCT.
     *         const testService = new DiagRequest('Can.testService')
     *
     *         // 8 bit number
     *         console.log('8 bits num:', testService.diagGetParameterRaw('asciiParam'))
     *         await testService.diagSetParameter('asciiParam', 'A')
     *         console.log('set parameter with str:', testService.diagGetParameterRaw('asciiParam'))
     *
     *         // 16 bit number
     *         console.log('8 bits num:', testService.diagGetParameterRaw('asciiParam'))
     *         await testService.diagSetParameterSize('asciiParam', 16)
     *         console.log('change size to 16 bits:', testService.diagGetParameterRaw('asciiParam'))
     *         await testService.diagSetParameter('asciiParam', 'AB')
     *         console.log('set parameter with str', testService.diagGetParameterRaw('asciiParam'))
     *     })
     *     ```
     * 4. **unicode parameter**
     *
     *     ```ts
     *     UDS.Init(async ()=>{
     *         // add param arrayParam in YCT.
     *         const testService = new DiagRequest('Can.testService')
     *
     *         // 8 bit number
     *         console.log('24 bits num:', testService.diagGetParameter('unicodeParam'))
     *         await testService.diagSetParameter('unicodeParam', '❤')
     *         console.log('set parameter with str:', testService.diagGetParameter('unicodeParam'))
     *
     *         // 16 bit number
     *         console.log('48 bits num:', testService.diagGetParameter('unicodeParam'))
     *         await testService.diagSetParameterSize('unicodeParam', 48)
     *         console.log('change size to 16 bits:', testService.diagGetParameter('unicodeParam'))
     *         await testService.diagSetParameter('unicodeParam', '❤️')
     *         console.log('set parameter with str', testService.diagGetParameter('unicodeParam'))
     *     })
     *     ```
     *
     * 5. **float parameter**
     *
     *     ```ts
     *     UDS.Init(async ()=>{
     *         // add param arrayParam in YCT.
     *         const testService = new DiagRequest('Can.testService')
     *
     *         // 8 bit number
     *         console.log('32 bits num:', testService.diagGetParameter('floatParam'))
     *         await testService.diagSetParameter('floatParam', 0.12345)
     *         console.log('set parameter with float:', testService.diagGetParameter('floatParam'))
     *     })
     *     ```
     */
    diagSetParameter(paramName: string, value: string | number): Promise<void>;
    /**
     * This function will change the provided parameter's value with provided `Buffer` value.
     *
     * @param paramName parameter's name need to be changed.
     * @param {Buffer} value new `Buffer` value of the provided parameter.
     *
     * @example
     *
     * > Add relative param in YT Config Tool.
     *
     * This function modifies the value of a parameter using a Buffer. The Buffer's value will be transferred at the TP layer.
     * You can generate a Buffer using the following methods:
     *
     * ```ts
     * const newValue1 = Buffer.from([0x12, 0x34, 0x56, 0x78]);
     *
     * const newValue2 = Buffer.alloc(4);
     * newValue2.writeUInt8(0x01, 0);
     * newValue2.writeUInt8(0x02, 1);
     * newValue2.writeUInt8(0x03, 2);
     * newValue2.writeUInt8(0x04, 3);
     *
     * const newValue3 = Buffer.from('11223344', 'hex');
     * ```
     *
     * To modify an array parameter, you can use the following example:
     *
     * ```ts
     * UDS.Init(async () => {
     *     // Add param arrayParam in YCT.
     *     const testService = new DiagRequest('Can.testService');
     *
     *     console.log('arrayParam:', testService.diagGetParameter('arrayParam'));
     *     const newValue1 = Buffer.from([0x12, 0x34, 0x56, 0x78]);
     *
     *     await testService.diagSetParameterRaw('arrayParam', newValue1);
     *     console.log('arrayParam:', testService.diagGetParameter('arrayParam'));
     * });
     * ```
     *
     * > For more examples on changing different parameter types, please refer to the {@link diagSetParameter | `diagSetParameter`} function.
     *
     */
    diagSetParameterRaw(paramName: string, value: Buffer): Promise<void>;
    private applyBuffer;
    /**
     * This function modifies all values of a service.
     *
     * @param data - The new data's buffer value.
     *
     * @example
     *
     * This function is typically used by a job to modify all data of a service. The following code demonstrates how to generate a new service and set its raw data:
     *
     * ```ts
     * UDS.Register('Can.testJob', async (v) => {
     *     // Add param arrayParam in YCT.
     *     const testService = new DiagRequest();
     *     const newData = Buffer.from([0x10, 0x01, 0x00, 0x01, 0x02]);
     *     await testService.diagSetRaw(newData);
     *     return [testService];
     * });
     * ```
     *
     * > - Ensure that the job `Can.testJob` is already configured in YCT.
     * > - The return type of a job should be a array.
     *
     * You can also modify the raw data of an existing service with the following code:
     *
     * ```ts
     * UDS.Init(async () => {
     *     // Add param arrayParam in YCT.
     *     const testService = new DiagRequest();
     *     const newData = Buffer.from([0x10, 0x02]);
     *     await testService.diagSetRaw(newData);
     * });
     * ```
     *
     *
     * > - Ensure that the service `Can.testService` is already configured in YCT.
     * > - The new raw data size should be equal to the old raw data size.
     */
    diagSetRaw(data: Buffer): Promise<void>;
    /**
     * This function will return a raw data of one service.
     * @returns raw data of one service.
     *
     * @example
     *
     * ```ts
     * UDS.Init(async ()=>{
     *     // add param arrayParam in YCT.
     *     const testService = new DiagRequest('Can.testService')
     *     console.log('get raw data:', testService.diagGetRaw())
     * })
     * ```
     */
    diagGetRaw(): Buffer;
}
/**
 * @category UDS
 */
export declare class DiagJob extends Service {
    constructor(jobName: keyof Jobs);
}
export declare class DiagResponse extends Service {
    private rxBuffer?;
    /**
     * When the service receives the returned data, a DiagResponse will be automatically created.
     *
     * @example
     *
     * Normally, users do not need to care about the constructor of `DiagResponse`. In some cases, you may need to retrieve the previous response result. For example, consider the following example:
     * - **service1**: DiagnosticSessionControl
     *
     * - **service2**: SecurityAccess request seed
     *
     * - **service3**: SecurityAccess send key
     *
     *
     * Where service1 is used to set the session, service2 is used to get the seed, and service3 is used to send the key. There are several ways to implement this:
     *
     * 1. Implementing via Job:
     *     ```ts
     *     UDS.Register('Can.testJob', async (v) => {
     *         // DiagnosticSessionControl
     *         const service1 = new DiagRequest()
     *         await service1.diagSetRaw(Buffer.from([0x10, 0x02]))
     *         // SecurityAccess
     *         const service2 = new DiagRequest()
     *         await service2.diagSetRaw(Buffer.from([0x27, 0x01]))
     *         // other service
     *         const service3 = new DiagRequest()
     *         service3.On('preSend', async () => {
     *             console.log(123, service2.getServiceName())
     *             const response2 = new DiagResponse(service2.getServiceName() as any)
     *             console.log('response raw data', response2.diagGetRaw())
     *         })
     *         return [service1, service2, service3]
     *     })
     *     ```
     *
     * 2. Implementing via service:
     *
     *     ```ts
     *     UDS.On('Can.service3.preSend', ()=>{
     *         const service2 = new DiagResponse('Can.service2');
     *         console.log(service2.diagGetRaw());
     *     })
     *     ```
     *
     * 3. Implementing by storing to a local variable:
     *
     *     ```ts
     *     let localVal:Buffer
     *     UDS.On('Can.service2.recv', (v)=>{
     *         localVal = v.diagGetRaw();
     *     })
     *
     *     UDS.On('Can.service3.preSend', ()=>{
     *         console.log(localVal);
     *     })
     *     ```
     *
     */
    constructor(serviceName?: ServiceName, rxData?: Buffer);
    /** @hidden */
    static fromDiagRequest(req: DiagRequest): DiagResponse;
    /** @hidden */
    readonly(): boolean;
    /**
     * This function will return whether the response is a positive response or not.
     * @returns bool
     *
     * @example
     *
     * ```ts
     * UDS.On('Can.testService.recv', (v)=>{
     *     console.log('response is positive:', v.diagIsPositiveResponse())
     * })
     * ```
     *
     */
    diagIsPositiveResponse(): boolean;
    /**
     * This function will return the response code of one response.
     *
     * > **NOTE**: Positive response does not have response code.
     *
     * @returns response code.
     *
     * @example
     *
     * // here testService2 is a RequestDownload(0x34) service
     * UDS.On('Can.testService2.recv', (v)=>{
     *     console.log('response code', v.diagGetResponseCode())
     * })
     *
     */
    diagGetResponseCode(): number;
}
export declare class DiagRequest extends Service {
    /**
     * @param {string} serviceName
     *
     * > serviceName's type '' is the string configured by YCT.
     *
     * The parameter serviceName is optional:
     * - if a serviceName is given, the serviceName should be one of the string setting in YCT
     * - if a serviceName is not provided, this function will return a new service object.
     *
     * @example
     *
     * 1. get a service object already exist
     *     ```ts
     *     UDS.Init(async ()=>{
     *         // add param arrayParam in YCT.
     *         const testService = new DiagRequest('Can.testService')
     *         testService.On('send', ()=>{
     *             console.log('send event happened.')
     *         })
     *     }
     *     ```
     *
     * 2. create a new object
     *     ```ts
     *     UDS.Register('Can.testJob', async (v) => {
     *         // Add param arrayParam in YCT.
     *         const testService = new DiagRequest();
     *         const newData = Buffer.from([0x10, 0x01, 0x00, 0x01, 0x02]);
     *         await testService.diagSetRaw(newData);
     *         return [testService];
     *     });
     *     ```
     */
    constructor(serviceName?: ServiceName);
}
export declare class UDSClass {
    private isMain;
    private event;
    private funcMap;
    /**
     * Register a handler function for a job.
     * @param jobs
     * Job name, valid format is \<tester name\>.\<job name\>
     * @param func
     * Handler function for the job
     *
     * @example
     *
     * ```ts
     * UDS.Register('Can.testJob', async (v) => {
     *     // Add param arrayParam in YCT.
     *     const testService = new DiagRequest();
     *     const newData = Buffer.from([0x10, 0x01, 0x00, 0x01, 0x02]);
     *     await testService.diagSetRaw(newData);
     *     return [testService];
     * });
     * ```
     */
    Register(jobs: JobName, func: Jobs[keyof Jobs]): void;
    private workerOn;
    /**
     * Subscribe to an event, invoking the registered function when the event is emitted.
     * @param eventName
     * Service name, formatted as \<tester name\>.\<service name\>.\<send|preSend|recv\>
     *
     * @param listener
     * Function to be called when the event is emitted
     *
     * @example
     *
     * > The `UDS` is a UDSClass type and has already been created by YCT.
     *
     * 1. *send functions*
     *
     *     ```ts
     *     UDS.On('Can.testService.send', async (req) => {
     *        // The req is a `DiagRequest`
     *        console.log(req.getServiceName(), ': send');
     *     });
     *     ```
     * 2. *preSend function*
     *
     *     ```ts
     *     UDS.On('Can.testService.preSend', async (req) => {
     *        // The req is a `DiagRequest`
     *        console.log(req.getServiceName(), ':preSend');
     *     });
     *     ```
     *
     * 3. *recv function*
     *
     *     ```ts
     *     UDS.On('Can.testService.recv', async (req) => {
     *        // The req is a `DiagResponse`
     *        console.log(req.getServiceName(), ':recv');
     *     });
     *     ```
     *
     */
    On<Name extends keyof EventMap>(eventName: Name, listener: (eventData: EventMap[Name]) => void | Promise<void>): void;
    /**
     * Unsubscribe from an event.
     *
     * > Only non-anonymous functions can be unsubscribed.
     *
     * @param eventName
     * Service name, formatted as \<tester name\>.\<service name\>.\<send|preSend|recv\>
     *
     * @param listener
     * Function to be unsubscribed
     *
     * @example
     *
     * ```ts
     * UDS.On('Can.testService.send', ()=>{
     *     console.log('this function will not be Off')
     * })
     *
     * UDS.Off('Can.testService.send', ()=>{
     *     console.log('this function will not be Off')
     * })
     *
     * // This function will be successfully unsubscribed
     * const preSendFunc = function() {
     *     console.log('123')
     * }
     *
     * UDS.On('Can.testService.preSend', preSendFunc)
     *
     * UDS.Off('Can.testService.preSend', preSendFunc)
     * ```
     *
     */
    Off<Name extends keyof EventMap>(eventName: Name, listener: (eventData: EventMap[Name]) => void | Promise<void>): void;
    private start;
    private evnetDone;
    constructor();
    /**
     * Register a function, this function will be invoked when UDSClass is initialized.
     * @param fc Non-async or async function
     *
     * @example
     *
     * - Perform actions following UDS initialization using a normal function.
     *     ```ts
     *     UDS.Init(()=>{
     *       console.log('Hello UDS!')
     *     })
     *     ```
     *
     * - Perform actions following UDS initialization using an async function.
     *     ```ts
     *     UDS.Init(async ()=>{
     *       const file=await fs.readFile(path.join(process.env.PROJECT_ROOT as any,'uds_pc_tool.yct'))
     *       let length=file.length
     *       console.log('Hello UDS file! file length is', length)
     *     })
     *     ```
     *
     * - The last registered function will override the previous ones.
     *     ```ts
     *     // The following code will be ignored
     *     UDS.Init(async ()=>{
     *         console.log('1')
     *     })
     *
     *     // The following code will take effect
     *     UDS.Init(async ()=>{
     *         console.log('2')
     *     })
     *     ```
     */
    Init(fc: () => void | Promise<void>): void;
}
/**
 * Global instance of UDSClass, providing access to UDS functionality throughout the application.
 * Use this instance to interact with UDS features and services.
 *
 * @category UDS
 * @type {UDSClass}
 *
 * @example
 * 1. *Init function*
 *     - Perform actions following UDS initialization using a normal function.
 *         ```ts
 *         UDS.Init(()=>{
 *           console.log('Hello UDS!')
 *         })
 *         ```
 *
 *     - Perform actions following UDS initialization using an async function.
 *         ```ts
 *         UDS.Init(async ()=>{
 *           const file=await fs.readFile(path.join(process.env.PROJECT_ROOT as any,'uds_pc_tool.yct'))
 *           let length=file.length
 *           console.log('Hello UDS file! file length is', length)
 *         })
 *         ```
 *
 * 2. *send functions*
 *     > * This function will be called after the message has been sent.
 *     > * Please replace `Can.DiagRequest.send` with your own service item name. The format is `<tester name>.<service item name>.send`
 *
 *     ```ts
 *     UDS.On('Can.DiagRequest.send', async (req) => {
 *        // The req is a `DiagRequest`
 *        console.log(req.getServiceName(), ': send');
 *     });
 *     ```
 * 3. *preSend function*
 *     > * This function will be called before the message is sent.
 *     > * Please replace `Can.DiagRequest.preSend` with your own service item name. The format is `<tester name>.<service item name>.preSend`
 *
 *     ```ts
 *     UDS.On('Can.DiagRequest.preSend', async (req) => {
 *        // The req is a `DiagRequest`
 *        console.log(req.getServiceName(), ':preSend');
 *     });
 *     ```
 *
 * 4. *recv function*
 *     > * This function will be called after the response message has been received.
 *     > * Please replace `Can.DiagRequest.recv` with your own service item name. The format is `<tester name>.<service item name>.recv`
 *
 *     ```ts
 *     UDS.On('Can.DiagRequest.recv', async (req) => {
 *        // The req is a `DiagResponse`
 *        console.log(req.getServiceName(), ':recv');
 *     });
 *     ```
 *
 * 5. **More**
 *     > For more details, please refer to {@link UDSClass | `UDSClass`} class.
 */
export declare const UDS: UDSClass;
export {};
