cmake_minimum_required(VERSION 3.16)



set(sources
    ${PROJ_DIR}/rtos/freertos/croutine.c
    ${PROJ_DIR}/rtos/freertos/event_groups.c
    ${PROJ_DIR}/rtos/freertos/list.c
    ${PROJ_DIR}/rtos/freertos/queue.c
    ${PROJ_DIR}/rtos/freertos/stream_buffer.c
    ${PROJ_DIR}/rtos/freertos/tasks.c
    ${PROJ_DIR}/rtos/freertos/timers.c
    ${PROJ_DIR}/rtos/freertos/portable/GCC/ARM_CM7/r0p1/port.c
    ${PROJ_DIR}/rtos/freertos/portable/MemMang/heap_4.c
)
set(includes
    ${PROJ_DIR}/rtos/freertos/include
    ${PROJ_DIR}/rtos/freertos/portable/GCC/ARM_CM7/r0p1
)
set(priIncludes
)

add_library(FREERTOS STATIC ${sources})

target_include_directories(FREERTOS PUBLIC ${includes})


target_include_directories(FREERTOS PRIVATE ${priIncludes})
configcore(FREERTOS ${CMAKE_SOURCE_DIR})

target_compile_definitions(FREERTOS PUBLIC
    YTM32B1HA0
    CPU_YTM32B1HA0
)
target_compile_options(FREERTOS PUBLIC
    -fdiagnostics-color=always
)



target_link_libraries(FREERTOS
    GENERATED_CONFIG_TARGET
)
