
#ifndef CAN_HAL_H_
#define CAN_HAL_H_
#include "cantp_types.h"
/**
 * @brief The fellowing typedef is use for cantp_hal's callback.
 */
typedef void (*cantp_hal_tx_confirmation_type)(pdu_id_type txPduId,  cantp_return_type result);
typedef void (*cantp_hal_rx_indication_type)(pdu_id_type rxPduId, const pdu_info_type_t* pduInfoPtr);

/**
 * @brief CanTp_Hal layer's main function.
 *
 * @details This function checks whether the mailbox configured by cantp is available. If the mailbox
 *          is in an idle state, it will re-enable the mailbox.
 */
void CanTp_Hal_Mainfunction();

/**
 * @brief This function will use FLEX_CAN's API to init hardware with configured setting.
 *
 */
cantp_return_type CanTp_Hal_Init();

/**
 * @brief This function will use FLEX_CAN's API to transmit one msg to bus.
 *
 * @param[in] pduId which pduId to be transmit.
 * @param[in] pduInfoPtr Pointer point to the pdu info.
 * @return cantp_hal_tx_res_type transmit result.
 */
cantp_hal_tx_res_type CanTp_Hal_Transmit(cantp_u8 pduId, const pdu_info_type_t* pduInfoPtr);

/**
 * @brief This function will return actual transmit len in bus of the given len.
 *
 * @param[in] len Length of data that needs to be transmitted.
 * @return cantp_u8 The actual length of data that was transmitted on the bus.
 */
cantp_u8 CanTp_Hal_GetTxLength(cantp_u8 len);

/**
 * @brief This function calculates the minimum length of a Standard Frame (SF) for a given CAN data
 *        length (CAN_DL).
 *
 * @param rxLen The data length received.
 * @return The minimum length of the given CAN_DL.
 */
cantp_u8 CanTp_Hal_GetRxMinLength(cantp_u8 rxLen);

/**
 * @brief Return the MB's status of given sduId.
 * 
 * @param sduId Sdu identifier.
 * @return cantp_hal_tx_res_type Result.
 */
cantp_hal_tx_res_type CanTp_Hal_GetMBStatus(pdu_id_type sduId);

#endif /* CAN_HAL_H_ */
