#ifndef CANTP_H_
#define CANTP_H_
#include "cantp_types.h"

/* The following function is not implemented and will be completed in the future */
cantp_return_type CanTp_Core_Transmit(pdu_id_type txPduId, const pdu_info_type_t* pduInfoPtr);
cantp_return_type CanTp_Core_CancelTransmit(pdu_id_type txPduId);
cantp_return_type CanTp_Core_CancelReceive(pdu_id_type rxPduId);
cantp_return_type CanTp_Core_ChangeParameter(pdu_id_type id, tp_parameter_type parameter, cantp_u16 value);
cantp_return_type CanTp_Core_ReadParameter(pdu_id_type id, tp_parameter_type parameter, cantp_u16* value);

/**
 * @brief Main function of cantp_core
 *
 */
void CanTp_Core_MainFunction(void);

/**
 * @brief This function will init the cantp_core's global variables.
 *
 * @param[in] configPtr Pointer point to a configuration of cantp.
 */
void CanTp_Core_Init(const cantp_config_t* configPtr);

/**
 * @brief Callback function of cantp_core layer, will be called by cantp_hal layer.
 *
 * @param[in] rxPduId Received pdu id.
 * @param[in] pduInfoPtr Pointer point to a pdu struct.
 */
void CanTp_Core_RxIndication(pdu_id_type rxPduId, const pdu_info_type_t* pduInfoPtr);

/**
 * @brief Callback function of cantp_core layer, will be called by cantp_hal layer.
 *
 * @param[in] txPduId Transmit pdu id.
 * @param[in] result Result of last transmit.
 */
void CanTp_Core_TxConfirmation(pdu_id_type txPduId, cantp_return_type result);

/**
 * @brief This function will decrease all counter of cantp_core layer.
 *
 */
void CanTp_Core_DecreaseCounter();

/**
 * @brief This function is used by cantp layer to transmit msg.
 *
 * @param[in] sduId Sdu id.
 */
void CanTp_Core_TxNode(sdu_id_type sduId);

#endif