/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 *
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 *
 * @file main.c
 * @brief
 *
 */

/* USER CODE END Header */
#include "sdk_project_config.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "fls_drv_bin.h"
#include "uds.h"
#include "string.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define LPTMRConf_Channel_0             (0U)
#define UDS_RC_BOOT_SWAP                (0xF002u)       /**< Routine Control BootSwap */
#define UDS_RC_ERASE_RAM                (0xF003u)       /**< Routine Control EraseRam */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
const uint32_t key[4] = {0x2b7e1516, 0x28aed2a6, 0xabf71588, 0x09cf4f3c};
uint32_t cnt0 = 0U;
uint32_t cnt1 = 0U;

static fls_drv_tbl_t * pfls_drv = (fls_drv_tbl_t *)0x20044000; /* flash driver bin address */
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
void lpTMR0_IRQHandler(void);
void InitTxData(void);
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */

    
    PRINTF("Build %s %s\n", __DATE__, __TIME__);
    CanTp_Init(&CanTp_Config);
    Uds_Init();
    INT_SYS_EnableIRQ(lpTMR0_IRQn);
    lpTMR_DRV_StartCounter(LPTMRConf_Channel_0);
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        CanTp_MainFunction();
        Uds_MainFunction();
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT);
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    FLEXCAN_DRV_Init(0,&flexcanInitConfig0_State,&flexcanInitConfig0);
    lpTMR_DRV_Init(0,&LPTMR_Config,false);
    TRNG_DRV_Init(TRNG_INST,TRNG_ENTROPY_DELAY);
    HCU_DRV_Init(&hcu_config0,&hcu_config0_State);
    HCU_DRV_LoadUserKey(key,KEY_SIZE_128_BITS);
    PCRC_DRV_Init(0,&pcrc_config0);
    UTILITY_PRINT_Init();
}

/* USER CODE BEGIN 4 */

void lpTMR0_IRQHandler(void)
{
    cnt0++;
    if(cnt0 == 1000)
    {
        cnt0 = 0;
        PRINTF("Hello! APP A is running! Count%d\r\n", cnt1);
        cnt1++;
    }
    CanTp_TimeService();
    Uds_TimeService(1);
    lpTMR_DRV_ClearCompareFlag(0);
}



void UDS_IP_BootSwap(uds_channel_t channel, uds_u8_t* data, uds_u16_t dataLength, void* param){
    uds_sid_t sid=data[0];
    uds_nrc_t nrc=UDS_NRC_GR;
    status_t status=STATUS_SUCCESS;
    uds_bool_t ok=uds_false;
    do{
        /* 1Byte sid, 1Byte subfuc, 2Byte routineIdentifier */
        if(dataLength<4){
            /* the length of the message is wrong */
            /* incorrectMessageLengthOrInvalidFormat */
            nrc=UDS_NRC_IMLOIF;
            break;
        }
        if(((data[2]<<8)|(data[3]))!=UDS_RC_BOOT_SWAP){
            nrc=UDS_NRC_IMLOIF;
            break;
        }
        /* boot swap */
        status=((FLASH_BootSwap_t)((uds_u32_t)(pfls_drv->bootSwap) + (uds_u32_t)pfls_drv))();
        if(status!=STATUS_SUCCESS){
            nrc=UDS_NRC_GPF;
            break;
        }

        uds_u8_t tmpData[3];
        /* subfunction */
        tmpData[0]=data[1];
        /* routineIdentifier */
        tmpData[1]=data[2];
        tmpData[2]=data[3];

        ok=uds_true;
        Uds_SendPositiveResponse(channel, sid, tmpData, 3);
    }while(0);

    if(ok==uds_false){
        Uds_SendNegativeResponse(channel, data[0], nrc, NULL, 0);
    }
}

static uds_s32_t eraseRam(uds_u32_t address, uds_u32_t dataLength){
    memset((void*)address, 0, dataLength);
    return dataLength;
}

void UDS_IP_RoutineControlEraseRamMemory(uds_channel_t channel, uds_u8_t* data, uds_u16_t dataLength, void* param){
    uds_nrc_t nrc=UDS_NRC_GR;
    uds_bool_t ok=uds_false;
    do{
        if(dataLength<12){
            /* the length of the message is wrong */
            nrc=UDS_NRC_IMLOIF;
            break;
        }
        if(((data[2]<<8)|(data[3]))!=UDS_RC_ERASE_RAM){
            nrc=UDS_NRC_IMLOIF;
            break;
        } 
        uds_u32_t addr=0;
        for(uds_u8_t i=0;i<4;i++){
            addr<<=8;
            addr+=data[4+i];
        }
        uds_u32_t size=0;
        for(uds_u8_t i=0;i<4;i++){
            size<<=8;
            size+=data[8+i];
        }
        uds_s32_t ret=eraseRam(addr,size);
        if(ret<0){
            /* GeneralProgrammingFailure. This NRC shall be returned if the server detects an error when performing a routine, which accesses server internal memory.*/
            nrc=UDS_NRC_GPF;
            break;
        }
        
        uds_sid_t sid=data[0];
        uds_u8_t tmpData[3];
        /* routineControlType */
        tmpData[0]=data[1];
        /* routineIdentifier */
        tmpData[1]=data[2];
        tmpData[2]=data[3];

        ok=uds_true;
        Uds_SendPositiveResponse(channel, sid, tmpData, 3);

    }while(0);

    if(ok==uds_false){
        Uds_SendNegativeResponse(channel, data[0], nrc, NULL, 0);
    }
}

/* USER CODE END 4 */
