# UDS OTA Demo 使用说明

## 概述

  * 本示例展示了如何通过UDS（Unified Diagnostic Services）协议，利用CAN总线实现OTA（Over-The-Air）固件更新功能。

  * 示例中，A面程序的主要功能是信息打印，B面程序是基于FreeRTOS的演示示例。

* OTA升级过程中使用了以下UDS服务：
  * 0x10 (Diagnostic Session Control)
  * 0x27 (Security Access)
  * 0x31 (Routine Control)
  * 0x34 (Request Download)
  * 0x36 (Transfer Data)
  * 0x37 (Request Transfer Exit)
  * 0x11 (ECU Reset)

---

## OTA 更新流程

1. 切换至进入扩展会话模式。(10 03)
2. 切换至编程会话模式。(10 02)
3. 请求安全访问种子以进行身份验证。(27 01)
4. 发送密钥以通过安全验证。(27 02)
5. 将Flash驱动程序加载到RAM中。(34、36、37)
6. 对Flash驱动程序进行CRC校验，确保其完整性。（31 01 F0 00）
7. 通知MCU Flash Driver已下载完成。（31 01 F0 01）
7. 清除目标Flash区域（PFLASH1）的现有数据。(31 01 FF 00)
8. 将新固件文件写入PFLASH1区域。(34、36、37)
9. CRC校验写入的固件文件，确保数据完整。(31 01 F0 00)
10. 触发Boot Swap操作，切换至新固件。(31 01 F0 02)
11. 清除RAM中的Flash驱动程序，释放资源。(31 01 F0 03)

---

## 工程结构

```
uds_can_ota_app_a/       # 应用程序A的代码
uds_can_ota_app_b/       # 应用程序B的代码
uds_pc_tool_write_a/     # UDS上位机工程A，用于下载应用程序A
uds_pc_tool_write_b/     # UDS上位机工具B，用于下载应用程序B
```

---

## 使用说明

* 使用Type-C线连接EVB板子和PC，并通过串口工具打开COM口，设置波特率为115200。
* 使用YCT打开demo工程(`uds_can_ota_app_a` 或 `uds_can_ota_app_a`)，编译后下载到EVB板子上。
* 将评估板通过USB-CAN适配器连接到PC。
* 打开上位机工程（`uds_pc_tool_write_a` 或 `uds_pc_tool_write_b`）。
* 按照OTA更新流程逐步操作，确保每一步成功完成后再进行下一步。
* 更新完成后，复位验证新固件是否正常运行。

---

## 硬件设置

- **评估板 (EVB)**: YTM32B1HA01-EVB-Q176-Rev.A  
- **USB-CAN适配器**: 支持以下设备：
  - PEAK  
  - Kvaser  
- **连接方式**: 本示例使用 **FLEX_CAN0** 通道（通过跳帽P10连接）进行UDS信息的收发。

---

## 软件设置

- **YCT版本**: 2.7.0  
- **SDK版本**: 1.3.1  
- **Middleware**:
  - **CAN Stack**: 0.8.0  
  - **UDS Stack**: 0.8.2  

---

## 注意事项

- **电源稳定性**：在OTA更新过程中，确保设备电源稳定，避免因断电导致更新失败或设备损坏。
- **流程严谨性**：按照流程操作，避免跳过步骤，以确保更新过程的安全性和可靠性。

---

## 支持与反馈

如在使用过程中遇到问题，或需要进一步的技术支持，请联系我们的技术支持团队。我们将竭诚为您提供帮助！

---
