# UDS OTA Demo User Manual

## Overview

  * This example demonstrates how to implement OTA (Over-The-Air) firmware updates using the UDS (Unified Diagnostic Services) protocol over the CAN bus.

  * In this example, the main function of the A-side program is information printing, while the B-side program is a demonstration example based on FreeRTOS.

* The following UDS services are used during the OTA upgrade process:
  * 0x10 (Diagnostic Session Control)
  * 0x27 (Security Access)
  * 0x31 (Routine Control)
  * 0x34 (Request Download)
  * 0x36 (Transfer Data)
  * 0x37 (Request Transfer Exit)
  * 0x11 (ECU Reset)

---

## OTA Update Process

1. Switch to extended session mode.
2. Switch to programming session mode.
3. Request a security access seed for authentication.
4. Send the key to pass the security verification.
5. Load the Flash driver into RAM.
6. Perform a CRC check on the Flash driver to ensure its integrity.
7. Clear the existing data in the target Flash area (PFLASH1).
8. Write the new firmware file to the PFLASH1 area.
9. Verify the written firmware file to ensure data integrity.
10. Trigger the Boot Swap operation to switch to the new firmware.
11. Clear the Flash driver from RAM to release resources.

---

## Project Structure

```
uds_can_ota_app_a/       # Code for Application A
uds_can_ota_app_b/       # Code for Application B
uds_pc_tool_write_a/     # UDS PC Tool Project A for downloading Application A
uds_pc_tool_write_b/     # UDS PC Tool Project B for downloading Application B
```

---

## Usage Instructions

* Connect the EVB board to the PC using a Type-C cable, and open the COM port through a serial port tool with a baud rate of 115200.
* Open the demo project (`uds_can_ota_app_a` or `uds_can_ota_app_a`) in YCT, compile it, and download it to the EVB board.
* Connect the evaluation board to the PC via a USB-CAN adapter.
* Open the PC tool project (`uds_pc_tool_write_a` or `uds_pc_tool_write_b`).
* Follow the OTA update process step by step, ensuring each step is successfully completed before proceeding to the next.
* After the update is complete, reset the system to verify that the new firmware is running correctly.

---

## Hardware Setup

- **Evaluation Board (EVB)**: YTM32B1HA01-EVB-Q176-Rev.A  
- **USB-CAN Adapter**: Supports the following devices:
  - PEAK  
  - Kvaser  
- **Connection Method**: This example uses the **FLEX_CAN0** channel (connected via jumper P10) for sending and receiving UDS messages.

---

## Software Setup

- **YCT Version**: 2.7.0  
- **SDK Version**: 1.3.1  
- **Middleware**:
  - **CAN Stack**: 0.8.0  
  - **UDS Stack**: 0.8.2  

---

## Notes

- **Power Stability**: Ensure stable power supply during the OTA update process to avoid update failure or device damage due to power interruption.
- **Process Rigor**: Strictly follow the process to avoid skipping any steps, ensuring the safety and reliability of the update process.

---

## Support and Feedback

If you encounter any issues during use or require further technical support, please contact our technical support team. We are committed to providing you with the best assistance!

---