/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file RamInit0.S
 * @brief 
 * 
 */

.syntax unified
.globl RamInit0
RamInit0:
_GET_POR:
    LDR     R1, =0x401FC000
    LDR     R4, [R1]
    LDR     R3, =0x1
/* R4 store POR result */
    ANDS    R4, R3
#define ITCMCR  (0xE000EF90)
#define DTCMCR  (0xE000EF94)

/* Enable ITCM and DTCM with ECC support */
_TCM_Enable:
    LDR     R11, =ITCMCR
    LDR     R0, [R11]
    ORR     R0, R0, #0x7
    STR     R0, [R11]
    LDR     R11, =DTCMCR
    LDR     R0, [R11]
    ORR     R0, R0, #0x7
    STR     R0, [R11]
_IVT_RAM_start:
/* 8bytes align */
    LDR     R1, =IVT_RAM_memory_start
    LDR     R2, =IVT_RAM_memory_end
    
    SUBS    R2, R2, R1
    SUBS    R2, #1
    BLE     _IVT_RAM_end

    LDR     R0, =0x5A5A5A5A
    LDR     R3, =0x5A5A5A5A
 _IVT_RAM_loop:
    STM     R1!, {R0,R3}
    SUBS    R2, #8
    BGE      _IVT_RAM_loop
 _IVT_RAM_end:
_CODE_RAM_start:
/* 8bytes align */
    LDR     R1, =CODE_RAM_memory_start
    LDR     R2, =CODE_RAM_memory_end
    
    SUBS    R2, R2, R1
    SUBS    R2, #1
    BLE     _CODE_RAM_end

    LDR     R0, =0x5A5A5A5A
    LDR     R3, =0x5A5A5A5A
 _CODE_RAM_loop:
    STM     R1!, {R0,R3}
    SUBS    R2, #8
    BGE      _CODE_RAM_loop
 _CODE_RAM_end:
_STACK_start:
/* 8bytes align */
    LDR     R1, =STACK_memory_start
    LDR     R2, =STACK_memory_end
    
    SUBS    R2, R2, R1
    SUBS    R2, #1
    BLE     _STACK_end

    LDR     R0, =0x5A5A5A5A
    LDR     R3, =0x5A5A5A5A
 _STACK_loop:
    STM     R1!, {R0,R3}
    SUBS    R2, #8
    BGE      _STACK_loop
 _STACK_end:
_RAM_start:
/* 8bytes align */
    LDR     R1, =RAM_memory_start
    LDR     R2, =RAM_memory_end
    
    SUBS    R2, R2, R1
    SUBS    R2, #1
    BLE     _RAM_end

    LDR     R0, =0x5A5A5A5A
    LDR     R3, =0x5A5A5A5A
 _RAM_loop:
    STM     R1!, {R0,R3}
    SUBS    R2, #8
    BGE      _RAM_loop
 _RAM_end:
   BX LR

