/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file main.c
 * @brief 
 * 
 */

/* USER CODE END Header */
#include "sdk_project_config.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "hcu_hw_access.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define HCU_NVR_START       (0x10000800)
#define HCU_NVR_SECTOR_SIZE (0x800)
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
/* HCU key used for secure boot */
const uint32_t keyNvr[48] = { 0x2b7e1516, 0x28aed2a6, 0xabf71588, 0x09cf4f3c, 0xffffffff, 0xffffffff, 0xffffffff,
                              0xffffffff, 0x03020100, 0x07060504, 0x0b0a0908, 0x0f0e0d0c, 0xffffffff, 0xffffffff,
                              0xffffffff, 0xffffffff, 0x33221100, 0x77665544, 0xbbaa9988, 0xffeeddcc, 0xffffffff,
                              0xffffffff, 0xffffffff, 0xffffffff, 0x76543210, 0xfedcba98, 0x01234567, 0x89abcdef,
                              0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xade12372, 0xfed23123, 0xaf231f41,
                              0xcdf21098, 0x2b7e1516, 0x0f0e0d0c, 0xffffffff, 0xffffffff, 0xaefc2334, 0x34fe2124,
                              0x213805fe, 0x23efb2c2, 0xfed23123, 0x77665544, 0xaefc2334, 0x89abcdef };
/* AES-ECB plain data */
const uint32_t plainText[16] = { 0x6bc1bee2, 0x2e409f96, 0xe93d7e11, 0x7393172a, 0xae2d8a57, 0x1e03ac9c,
                                 0x9eb76fac, 0x45af8e51, 0x30c81c46, 0xa35ce411, 0xe5fbc119, 0x1a0a52ef,
                                 0xf69f2445, 0xdf4f9b17, 0xad2b417b, 0xe66c3710 };
/* AES-ECB cipher data */
const uint32_t cipherText[16] = { 0xC48D5784, 0xF6BB1688, 0xA1F6AC18, 0xEEDAB413, 0x39CBB8F3, 0x7FAB8C25,
                                  0x3B1C1E50, 0x8C53E9D0, 0xDF273015, 0x3603F913, 0xD4298D27, 0xBB91F6FA,
                                  0xF95B31D0, 0x9053DFF1, 0x214A42EF, 0xF22A080D };
uint32_t sw_encrypt_result[16];
uint32_t hw_encrypt_result[16];


__attribute__((section(".retentionRam"))) uint8_t Retention_IVT[1024];
const uint8_t IVT_table[1024] = { 0x00, 0x00, 0x01, 0x20, 0xE5, 0x14, 0x00, 0x02, 0x6B, 0x2A, 0x00, 0x02, 0x6D, 0x2A, 0x00, 0x02,
  0x6F, 0x2A, 0x00, 0x02, 0x71, 0x2A, 0x00, 0x02, 0x73, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02,
  0x69, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02, 0x75, 0x2A, 0x00, 0x02,
  0x77, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02, 0x79, 0x2A, 0x00, 0x02, 0x49, 0x4E, 0x00, 0x02,
  0xFF, 0x3A, 0x00, 0x02, 0x09, 0x3B, 0x00, 0x02, 0x13, 0x3B, 0x00, 0x02, 0x1D, 0x3B, 0x00, 0x02,
  0x27, 0x3B, 0x00, 0x02, 0x31, 0x3B, 0x00, 0x02, 0x3B, 0x3B, 0x00, 0x02, 0x45, 0x3B, 0x00, 0x02,
  0x4F, 0x3B, 0x00, 0x02, 0x59, 0x3B, 0x00, 0x02, 0x63, 0x3B, 0x00, 0x02, 0x6D, 0x3B, 0x00, 0x02,
  0x77, 0x3B, 0x00, 0x02, 0x81, 0x3B, 0x00, 0x02, 0x8B, 0x3B, 0x00, 0x02, 0x95, 0x3B, 0x00, 0x02,
  0x9F, 0x3B, 0x00, 0x02, 0xA9, 0x3B, 0x00, 0x02, 0xB3, 0x3B, 0x00, 0x02, 0xBD, 0x3B, 0x00, 0x02,
  0xC7, 0x3B, 0x00, 0x02, 0xD1, 0x3B, 0x00, 0x02, 0xDB, 0x3B, 0x00, 0x02, 0xE5, 0x3B, 0x00, 0x02,
  0xEF, 0x3B, 0x00, 0x02, 0xF9, 0x3B, 0x00, 0x02, 0x03, 0x3C, 0x00, 0x02, 0x0D, 0x3C, 0x00, 0x02,
  0x17, 0x3C, 0x00, 0x02, 0x21, 0x3C, 0x00, 0x02, 0x2B, 0x3C, 0x00, 0x02, 0x35, 0x3C, 0x00, 0x02,
  0x3F, 0x3C, 0x00, 0x02, 0x7B, 0x2A, 0x00, 0x02, 0xAD, 0x4C, 0x00, 0x02, 0xC9, 0x4C, 0x00, 0x02,
  0x7D, 0x2A, 0x00, 0x02, 0x7F, 0x2A, 0x00, 0x02, 0x81, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02,
  0x83, 0x2A, 0x00, 0x02, 0x85, 0x2A, 0x00, 0x02, 0x87, 0x2A, 0x00, 0x02, 0x89, 0x2A, 0x00, 0x02,
  0x8B, 0x2A, 0x00, 0x02, 0x8D, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02, 0x8F, 0x2A, 0x00, 0x02,
  0x69, 0x2A, 0x00, 0x02, 0x91, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02, 0x93, 0x2A, 0x00, 0x02,
  0x69, 0x2A, 0x00, 0x02, 0x95, 0x2A, 0x00, 0x02, 0x97, 0x2A, 0x00, 0x02, 0x99, 0x2A, 0x00, 0x02,
  0x9B, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02, 0x9D, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02,
  0x9F, 0x2A, 0x00, 0x02, 0xA1, 0x2A, 0x00, 0x02, 0xA3, 0x2A, 0x00, 0x02, 0xA5, 0x2A, 0x00, 0x02,
  0xA7, 0x2A, 0x00, 0x02, 0xA9, 0x2A, 0x00, 0x02, 0xAB, 0x2A, 0x00, 0x02, 0xAD, 0x2A, 0x00, 0x02,
  0xAF, 0x2A, 0x00, 0x02, 0xB1, 0x2A, 0x00, 0x02, 0xB3, 0x2A, 0x00, 0x02, 0xB5, 0x2A, 0x00, 0x02,
  0xB7, 0x2A, 0x00, 0x02, 0xB9, 0x2A, 0x00, 0x02, 0xBB, 0x2A, 0x00, 0x02, 0xBD, 0x2A, 0x00, 0x02,
  0xBF, 0x2A, 0x00, 0x02, 0xC1, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02,
  0x69, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02, 0xC3, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02,
  0xC5, 0x2A, 0x00, 0x02, 0xC7, 0x2A, 0x00, 0x02, 0xC9, 0x2A, 0x00, 0x02, 0xCB, 0x2A, 0x00, 0x02,
  0xCD, 0x2A, 0x00, 0x02, 0xCF, 0x2A, 0x00, 0x02, 0xD1, 0x2A, 0x00, 0x02, 0xD3, 0x2A, 0x00, 0x02,
  0xD5, 0x2A, 0x00, 0x02, 0xD7, 0x2A, 0x00, 0x02, 0xD9, 0x2A, 0x00, 0x02, 0xDB, 0x2A, 0x00, 0x02,
  0xDD, 0x2A, 0x00, 0x02, 0xDF, 0x2A, 0x00, 0x02, 0xE1, 0x2A, 0x00, 0x02, 0xE3, 0x2A, 0x00, 0x02,
  0xE5, 0x2A, 0x00, 0x02, 0xE7, 0x2A, 0x00, 0x02, 0xE9, 0x2A, 0x00, 0x02, 0xEB, 0x2A, 0x00, 0x02,
  0xED, 0x2A, 0x00, 0x02, 0xEF, 0x2A, 0x00, 0x02, 0xF1, 0x2A, 0x00, 0x02, 0xF3, 0x2A, 0x00, 0x02,
  0xF5, 0x2A, 0x00, 0x02, 0xF7, 0x2A, 0x00, 0x02, 0xF9, 0x2A, 0x00, 0x02, 0xFB, 0x2A, 0x00, 0x02,
  0xFD, 0x2A, 0x00, 0x02, 0xFF, 0x2A, 0x00, 0x02, 0x01, 0x2B, 0x00, 0x02, 0x03, 0x2B, 0x00, 0x02,
  0x05, 0x2B, 0x00, 0x02, 0x07, 0x2B, 0x00, 0x02, 0x09, 0x2B, 0x00, 0x02, 0x0B, 0x2B, 0x00, 0x02,
  0x0D, 0x2B, 0x00, 0x02, 0x0F, 0x2B, 0x00, 0x02, 0x11, 0x2B, 0x00, 0x02, 0x13, 0x2B, 0x00, 0x02,
  0x15, 0x2B, 0x00, 0x02, 0x17, 0x2B, 0x00, 0x02, 0x19, 0x2B, 0x00, 0x02, 0x1B, 0x2B, 0x00, 0x02,
  0x1D, 0x2B, 0x00, 0x02, 0x1F, 0x2B, 0x00, 0x02, 0x21, 0x2B, 0x00, 0x02, 0x23, 0x2B, 0x00, 0x02,
  0x25, 0x2B, 0x00, 0x02, 0x27, 0x2B, 0x00, 0x02, 0x29, 0x2B, 0x00, 0x02, 0x2B, 0x2B, 0x00, 0x02,
  0x2D, 0x2B, 0x00, 0x02, 0x2F, 0x2B, 0x00, 0x02, 0x31, 0x2B, 0x00, 0x02, 0x33, 0x2B, 0x00, 0x02,
  0x35, 0x2B, 0x00, 0x02, 0x37, 0x2B, 0x00, 0x02, 0x39, 0x2B, 0x00, 0x02, 0x3B, 0x2B, 0x00, 0x02,
  0x3D, 0x2B, 0x00, 0x02, 0x3F, 0x2B, 0x00, 0x02, 0x41, 0x2B, 0x00, 0x02, 0x43, 0x2B, 0x00, 0x02,
  0x45, 0x2B, 0x00, 0x02, 0x47, 0x2B, 0x00, 0x02, 0x49, 0x2B, 0x00, 0x02, 0x4B, 0x2B, 0x00, 0x02,
  0x4D, 0x2B, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02,
  0x69, 0x2A, 0x00, 0x02, 0x4F, 0x2B, 0x00, 0x02, 0x51, 0x2B, 0x00, 0x02, 0x53, 0x2B, 0x00, 0x02,
  0x55, 0x2B, 0x00, 0x02, 0x57, 0x2B, 0x00, 0x02, 0x9D, 0x4A, 0x00, 0x02, 0x59, 0x2B, 0x00, 0x02,
  0x5B, 0x2B, 0x00, 0x02, 0x5D, 0x2B, 0x00, 0x02, 0x5F, 0x2B, 0x00, 0x02, 0x61, 0x2B, 0x00, 0x02,
  0x63, 0x2B, 0x00, 0x02, 0x65, 0x2B, 0x00, 0x02, 0x67, 0x2B, 0x00, 0x02, 0x69, 0x2B, 0x00, 0x02,
  0x6B, 0x2B, 0x00, 0x02, 0x6D, 0x2B, 0x00, 0x02, 0x6F, 0x2B, 0x00, 0x02, 0x71, 0x2B, 0x00, 0x02,
  0x73, 0x2B, 0x00, 0x02, 0x75, 0x2B, 0x00, 0x02, 0x77, 0x2B, 0x00, 0x02, 0x79, 0x2B, 0x00, 0x02,
  0x7B, 0x2B, 0x00, 0x02, 0x7D, 0x2B, 0x00, 0x02, 0x7F, 0x2B, 0x00, 0x02, 0x81, 0x2B, 0x00, 0x02,
  0x83, 0x2B, 0x00, 0x02, 0x85, 0x2B, 0x00, 0x02, 0x87, 0x2B, 0x00, 0x02, 0x89, 0x2B, 0x00, 0x02,
  0x8B, 0x2B, 0x00, 0x02, 0x8D, 0x2B, 0x00, 0x02, 0x8F, 0x2B, 0x00, 0x02, 0x91, 0x2B, 0x00, 0x02,
  0x93, 0x2B, 0x00, 0x02, 0x95, 0x2B, 0x00, 0x02, 0x97, 0x2B, 0x00, 0x02, 0x99, 0x2B, 0x00, 0x02,
  0x9B, 0x2B, 0x00, 0x02, 0x9D, 0x2B, 0x00, 0x02, 0x9F, 0x2B, 0x00, 0x02, 0xA1, 0x2B, 0x00, 0x02,
  0x69, 0x2A, 0x00, 0x02, 0xA3, 0x2B, 0x00, 0x02, 0xA5, 0x2B, 0x00, 0x02, 0xA7, 0x2B, 0x00, 0x02,
  0xA9, 0x2B, 0x00, 0x02, 0xAB, 0x2B, 0x00, 0x02, 0xAD, 0x2B, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02,
  0xAF, 0x2B, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02, 0xB1, 0x2B, 0x00, 0x02, 0xB3, 0x2B, 0x00, 0x02,
  0xB5, 0x2B, 0x00, 0x02, 0xB7, 0x2B, 0x00, 0x02, 0xB9, 0x2B, 0x00, 0x02, 0xBB, 0x2B, 0x00, 0x02,
  0x69, 0x2A, 0x00, 0x02, 0x69, 0x2A, 0x00, 0x02, 0xBD, 0x2B, 0x00, 0x02, 0xBF, 0x2B, 0x00, 0x02,
  0xC1, 0x2B, 0x00, 0x02, 0xC3, 0x2B, 0x00, 0x02, 0xC5, 0x2B, 0x00, 0x02, 0xC7, 0x2B, 0x00, 0x02,
  0xC9, 0x2B, 0x00, 0x02, 0xCB, 0x2B, 0x00, 0x02, 0xCD, 0x2B, 0x00, 0x02, 0xCF, 0x2B, 0x00, 0x02,
  0xD1, 0x2B, 0x00, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
/* Program HCU key */
static status_t Program_HcuKey(const void *key, uint32_t length)
{
    status_t status = STATUS_SUCCESS;
    /* Erase HCU NVR, user should be careful of it */
    EFM->CUS_KEY = 0x4dff32;
    status |= FLASH_DRV_EraseSector(0, HCU_NVR_START, HCU_NVR_SECTOR_SIZE);
    /* Program HCU key */
    status |= FLASH_DRV_Program(0, HCU_NVR_START, length, key);
    return status;
}

/* Check HCU key load success */
static status_t Check_HcuKeyLoad(void)
{
    status_t status = STATUS_SUCCESS;

    /* Load hardware key */
    INT_SYS_DisableIRQGlobal();
    status |= FLASH_DRV_LoadAESKey(0, HCU_NVR_START);
    INT_SYS_EnableIRQGlobal();
    HCU_SetKeySize(KEY_SIZE_128_BITS);
    /* HCU ECB encrypt with hardware key */
    status |= HCU_DRV_EncryptECB(plainText, 64, hw_encrypt_result);

    /* Load software key */
    status |= HCU_DRV_LoadUserKey(keyNvr, KEY_SIZE_128_BITS);
    /* Start AES-ECB software encrypt */
    status |= HCU_DRV_EncryptECB(plainText, 64, sw_encrypt_result);
    /* Check result */
    for (uint32_t i = 0; i < 16; i++)
    {
        if (sw_encrypt_result[i] != cipherText[i])
        {
            PRINTF("Software key mismatch!\n");
            return STATUS_ERROR;
        }
        if (hw_encrypt_result[i] != cipherText[i])
        {
            PRINTF("Hardware key mismatch!\n");
            return STATUS_ERROR;
        }
    }
    PRINTF("HCU key load success!\n");
    return status;
}

/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    status_t status = STATUS_SUCCESS;
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    PRINTF("Secure boot prepare demo!\n");
    Program_HcuKey(keyNvr, sizeof(keyNvr));
    Check_HcuKeyLoad();
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        if (status != STATUS_SUCCESS)
        {
            break;
        }
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT);
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    FLASH_DRV_Init(0,&flash_config0,&flash_config0_State);
    UTILITY_PRINT_Init();
    HCU_DRV_Init(&hcu_config0,&hcu_config0_State);
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
