/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file secure_boot_config.c
 * @brief 
 * 
 */



#include "secure_boot_config.h"

/* 
 * add the CAMC result array definition of sections as below with "SB_CMAC_SEG" to place it into 
 * section ".sb_cmac" allocated in linker file 
 */
#if defined (__ICCARM__)
__root const uint8_t cmac0[16] SB_CMAC_SEG = {0};
__root const uint8_t cmac1[16] SB_CMAC_SEG = {0};
__root const uint8_t cmac2[16] SB_CMAC_SEG = {0};
__root const uint8_t cmac3[16] SB_CMAC_SEG = {0};
__root const uint8_t cmac4[16] SB_CMAC_SEG = {0};
#else
const uint8_t cmac0[16] SB_CMAC_SEG = {0};
const uint8_t cmac1[16] SB_CMAC_SEG = {0};
const uint8_t cmac2[16] SB_CMAC_SEG = {0};
const uint8_t cmac3[16] SB_CMAC_SEG = {0};
const uint8_t cmac4[16] SB_CMAC_SEG = {0};
#endif

/* add the secure boot section config structure definitions as below with "SB_CONFIG_SECTION_SEG" 
 * to place it into section ".sb_config_section" allocated in linker file 
 */
#if defined (__ICCARM__)
__root const secure_boot_section_config_t secure_boot_section_config0 SB_CONFIG_SECTION_SEG = {
#else
const secure_boot_section_config_t secure_boot_section_config0 SB_CONFIG_SECTION_SEG = {
#endif
    .secure_boot_marker = SECURE_BOOT_SECTION_MARKER,
    .aes_key_size       = KEY_LEN_128_BITS,
    .key_slot           = 1,
    .start_addr         = 0x02000800,
    .length             = 0x200,
    .cmac_addr          = (uint32_t)&cmac0[0],
};
#if defined (__ICCARM__)
__root const secure_boot_section_config_t secure_boot_section_config1 SB_CONFIG_SECTION_SEG = {
#else
const secure_boot_section_config_t secure_boot_section_config1 SB_CONFIG_SECTION_SEG = {
#endif
    .secure_boot_marker = SECURE_BOOT_SECTION_MARKER,
    .aes_key_size       = KEY_LEN_128_BITS,
    .key_slot           = 2,
    .start_addr         = 0x02000800,
    .length             = 0x200,
    .cmac_addr          = (uint32_t)&cmac1[0],
};
#if defined (__ICCARM__)
__root const secure_boot_section_config_t secure_boot_section_config2 SB_CONFIG_SECTION_SEG = {
#else
const secure_boot_section_config_t secure_boot_section_config2 SB_CONFIG_SECTION_SEG = {
#endif
    .secure_boot_marker = SECURE_BOOT_SECTION_MARKER,
    .aes_key_size       = KEY_LEN_128_BITS,
    .key_slot           = 3,
    .start_addr         = 0x02000800,
    .length             = 0x200,
    .cmac_addr          = (uint32_t)&cmac2[0],
};
#if defined (__ICCARM__)
__root const secure_boot_section_config_t secure_boot_section_config3 SB_CONFIG_SECTION_SEG = {
#else
const secure_boot_section_config_t secure_boot_section_config3 SB_CONFIG_SECTION_SEG = {
#endif
    .secure_boot_marker = SECURE_BOOT_SECTION_MARKER,
    .aes_key_size       = KEY_LEN_192_BITS,
    .key_slot           = 4,
    .start_addr         = 0x02000800,
    .length             = 0x200,
    .cmac_addr          = (uint32_t)&cmac3[0],
};
#if defined (__ICCARM__)
__root const secure_boot_section_config_t secure_boot_section_config4 SB_CONFIG_SECTION_SEG = {
#else
const secure_boot_section_config_t secure_boot_section_config4 SB_CONFIG_SECTION_SEG = {
#endif
    .secure_boot_marker = SECURE_BOOT_SECTION_MARKER,
    .aes_key_size       = KEY_LEN_256_BITS,
    .key_slot           = 5,
    .start_addr         = 0x02000800,
    .length             = 0x200,
    .cmac_addr          = (uint32_t)&cmac4[0],
};

/* add the secure boot group config structure definitions as below with "SB_CONFIG_GROUP_SEG" 
 * to place it into section ".sb_group_section" allocated in linker file 
 */
#if defined (__ICCARM__)
__root const secure_boot_group_config_t secure_boot_group SB_CONFIG_SECTION_SEG = {
#else
const secure_boot_group_config_t secure_boot_group SB_CONFIG_SECTION_SEG = {
#endif
    .secure_boot_group_marker = SECURE_BOOT_GROUP_MARKER,
    .secure_boot_section_num  = 5,
    .encrypt                  = true,
    .aes_key_size             = KEY_LEN_128_BITS,
    .key_slot                 = 0,
    .section_config_addr[0]   = (uint32_t)&secure_boot_section_config0, 
    .section_config_addr[1]   = (uint32_t)&secure_boot_section_config1, 
    .section_config_addr[2]   = (uint32_t)&secure_boot_section_config2, 
    .section_config_addr[3]   = (uint32_t)&secure_boot_section_config3, 
    .section_config_addr[4]   = (uint32_t)&secure_boot_section_config4, 
};

/* BVT Header section
 * include configuration refer to BVT_t
 */
#define BOOT_CONFIG_WORD  (BVT_BCW_CPDIVS_SET(0) | \
                           ROM_BOOT_SCST_EN_BIT |\
                           APP_WDG_EN |\
                           BOOT_SEQ_EN |\
                           BOOT_SEQ_STRICT |\
                           CM7_0_M_EN)

/* BVT Header configuration */
#if defined (__ICCARM__)
__root const bvt_header_config_t bvt_header BVT_HEADER_SEG = {
#else
const bvt_header_config_t bvt_header BVT_HEADER_SEG = {
#endif
    .bvt_marker            = BVT_VALID_MARK,
    .boot_config_word      = BOOT_CONFIG_WORD,
    .sbt_config_group_addr = (uint32_t)&secure_boot_group,
    .cm7_0_main_app_addr   = 0x02000800,
    .app_wdg_timeout       = 300000,
};
