/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file main.c
 * @brief 
 * 
 */

/* USER CODE END Header */
#include "sdk_project_config.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "hcu_hw_access.h"


#include <stdio.h>
#include <string.h>
#include <stdint.h>
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define HCU_NVR_START       (0x10000800)
#define HCU_NVR_SECTOR_SIZE (0x800)

#define EN_FAST_WAKEUP        0
#define FLASH_IVT_ADDR        0x2000800

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
/* HCU key used for secure boot */
const uint32_t keyNvr[48] = { 0x2b7e1516, 0x28aed2a6, 0xabf71588, 0x09cf4f3c, 0xffffffff, 0xffffffff, 0xffffffff,
                              0xffffffff, 0x03020100, 0x07060504, 0x0b0a0908, 0x0f0e0d0c, 0xffffffff, 0xffffffff,
                              0xffffffff, 0xffffffff, 0x33221100, 0x77665544, 0xbbaa9988, 0xffeeddcc, 0xffffffff,
                              0xffffffff, 0xffffffff, 0xffffffff, 0x76543210, 0xfedcba98, 0x01234567, 0x89abcdef,
                              0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xade12372, 0xfed23123, 0xaf231f41,
                              0xcdf21098, 0x2b7e1516, 0x0f0e0d0c, 0xffffffff, 0xffffffff, 0xaefc2334, 0x34fe2124,
                              0x213805fe, 0x23efb2c2, 0xfed23123, 0x77665544, 0xaefc2334, 0x89abcdef };
/* AES-ECB plain data */
const uint32_t plainText[16] = { 0x6bc1bee2, 0x2e409f96, 0xe93d7e11, 0x7393172a, 0xae2d8a57, 0x1e03ac9c,
                                 0x9eb76fac, 0x45af8e51, 0x30c81c46, 0xa35ce411, 0xe5fbc119, 0x1a0a52ef,
                                 0xf69f2445, 0xdf4f9b17, 0xad2b417b, 0xe66c3710 };
/* AES-ECB cipher data */
const uint32_t cipherText[16] = { 0xC48D5784, 0xF6BB1688, 0xA1F6AC18, 0xEEDAB413, 0x39CBB8F3, 0x7FAB8C25,
                                  0x3B1C1E50, 0x8C53E9D0, 0xDF273015, 0x3603F913, 0xD4298D27, 0xBB91F6FA,
                                  0xF95B31D0, 0x9053DFF1, 0x214A42EF, 0xF22A080D };
uint32_t sw_encrypt_result[16];
uint32_t hw_encrypt_result[16];


__attribute__((section(".retentionRam"))) uint8_t Retention_IVT[1024];
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* Check HCU key load success */
static status_t Check_HcuKeyLoad(void)
{
    status_t status = STATUS_SUCCESS;

    /* Load hardware key */
    INT_SYS_DisableIRQGlobal();
    status |= FLASH_DRV_LoadAESKey(0, HCU_NVR_START);
    INT_SYS_EnableIRQGlobal();
    HCU_SetKeySize(KEY_SIZE_128_BITS);
    /* HCU ECB encrypt with hardware key */
    status |= HCU_DRV_EncryptECB(plainText, 64, hw_encrypt_result);

    /* Load software key */
    status |= HCU_DRV_LoadUserKey(keyNvr, KEY_SIZE_128_BITS);
    /* Start AES-ECB software encrypt */
    status |= HCU_DRV_EncryptECB(plainText, 64, sw_encrypt_result);
    /* Check result */
    for (uint32_t i = 0; i < 16; i++)
    {
        if (sw_encrypt_result[i] != cipherText[i])
        {
            PRINTF("Software key mismatch!\n");
            return STATUS_ERROR;
        }
        if (hw_encrypt_result[i] != cipherText[i])
        {
            PRINTF("Hardware key mismatch!\n");
            return STATUS_ERROR;
        }
    }
    PRINTF("HCU key load success!\n");
    return status;
}

/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    status_t status = STATUS_SUCCESS;
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    //clear POR flag
    RCU->RSSR |= RCU_RSSR_POR_LVD_MASK;
    
    PRINTF("Secure boot prepare demo!\n");
    Check_HcuKeyLoad();

#if EN_FAST_WAKEUP
    /* Set fast wakeup tag at REGFILE->DR[0] */
    REGFILE->DR[0] = 0x5A5B6E6F;
    /* Set address of IVT table at REGFILE->DR[1], must be retention RAM area, and must be 1K algined */
    REGFILE->DR[1] = 0x20020000;
    /* Copy IVT table to the address which is set at REGFILE->DR[1] */
    const uint8_t* pflash_ivt_src = (const uint8_t*)FLASH_IVT_ADDR;
    memcpy(Retention_IVT, pflash_ivt_src, 1024);
#endif

    PINS_DRV_SetPins(GPIOB, 1 << 12);                     
    SystemSoftwareReset();
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    uint32_t counter = 0;
    while (1)
    {
        if (status != STATUS_SUCCESS)
        {
            break;
        }
        PRINTF("Current counter is %d\n", counter++);
        OSIF_TimeDelay(1000);
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT);
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    FLASH_DRV_Init(0,&flash_config0,&flash_config0_State);
    UTILITY_PRINT_Init();
    HCU_DRV_Init(&hcu_config0,&hcu_config0_State);
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
