/*
* @file    Performance_Measure.h
*==================================================================================================
*   Platform             : ARM Cortex-M
*   Dependencies         : Cortex-M SysTick Timer and a MCU GPIO pin(optional) as well as UART instance
                           (optional for measured time print output to a terminal/console via UART)
*   Description          : This file contains the header file of the performance measurement module.
*   Author               : Enwei Hu(YTMicro. AE Team)
*   Notes                : The SysTick timer is a 24bit timer, and clocked by the Cortex-M CPU core clock
                           the max counter value is 2^24-1 = 16,777,216.
*                          so set the load value to 16,000,000 by default. in order to measure a time interval
*                          with the timer overflow, a SysTick timer interrupt handler is needed to to record the
*                          overflow times. if the SysTick timer is used for other purpose, such as timer tick of 
*                          a RTOS, the SysTick timer interrupt handler should be modified to avoid the conflict.
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef CRYPTO_EXAMPLE_H
#define CRYPTO_EXAMPLE_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES                                          
==================================================================================================*/

#include "sdk_project_config.h"

/*==================================================================================================
                                                DEFINES AND MACROS                                       
==================================================================================================*/


/*==================================================================================================
                                                ENUMS                                        
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES                                           
==================================================================================================*/
void MBEDTLS_Alg_test(void);

#ifdef __cplusplus
}
#endif

#endif /* End of file Performance_Measure.h */
