#include "../CryptoHAL/inc/crypto_hal.h"
#include "crypto_examples.h"
#include "printf.h"
#include <stddef.h>
#include <stdint.h>
#include "Performance_Measure.h"

#define MEASURE_TEST 1

#define DEBUG_PRINT 1

uint8_t key[32] = {0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6, 0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c, \
                   0x2b, 0x7e, 0x15, 0x16, 0x28, 0xae, 0xd2, 0xa6, 0xab, 0xf7, 0x15, 0x88, 0x09, 0xcf, 0x4f, 0x3c
                  };
uint8_t iv[16] = {0x00, 0x01, 0x02};
uint8_t plainText[16] = {0x32, 0x43, 0xf6, 0xa8, 0x88, 0x5a, 0x30, 0x8d, 0x31, 0x31, 0x98, 0xa2, 0xe0, 0x37, 0x07, 0x34};
uint8_t cipherText[16] = {0};
__attribute__((section(".text")))
const uint8_t publicKey_2048_Pem[] = {0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x50, 0x55, 0x42, 0x4c, 0x49,
                                      0x43, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x42, 0x49,
                                      0x6a, 0x41, 0x4e, 0x42, 0x67, 0x6b, 0x71, 0x68, 0x6b, 0x69, 0x47, 0x39, 0x77, 0x30, 0x42, 0x41,
                                      0x51, 0x45, 0x46, 0x41, 0x41, 0x4f, 0x43, 0x41, 0x51, 0x38, 0x41, 0x4d, 0x49, 0x49, 0x42, 0x43,
                                      0x67, 0x4b, 0x43, 0x41, 0x51, 0x45, 0x41, 0x74, 0x32, 0x6b, 0x50, 0x2f, 0x45, 0x45, 0x58, 0x54,
                                      0x34, 0x34, 0x56, 0x35, 0x69, 0x55, 0x68, 0x34, 0x44, 0x4f, 0x75, 0x0a, 0x43, 0x72, 0x6c, 0x4d,
                                      0x6f, 0x70, 0x55, 0x65, 0x33, 0x44, 0x62, 0x45, 0x69, 0x74, 0x6f, 0x2b, 0x30, 0x4e, 0x50, 0x78,
                                      0x38, 0x54, 0x4a, 0x2f, 0x56, 0x57, 0x74, 0x57, 0x31, 0x33, 0x55, 0x62, 0x47, 0x32, 0x32, 0x75,
                                      0x41, 0x58, 0x32, 0x6c, 0x64, 0x34, 0x45, 0x59, 0x4a, 0x71, 0x6b, 0x58, 0x44, 0x49, 0x62, 0x46,
                                      0x75, 0x79, 0x43, 0x49, 0x59, 0x36, 0x6b, 0x31, 0x72, 0x31, 0x31, 0x63, 0x0a, 0x4e, 0x6d, 0x4a,
                                      0x37, 0x50, 0x51, 0x4f, 0x68, 0x74, 0x68, 0x71, 0x56, 0x6a, 0x51, 0x42, 0x43, 0x32, 0x69, 0x73,
                                      0x38, 0x2f, 0x35, 0x2b, 0x2f, 0x74, 0x77, 0x4d, 0x6c, 0x2b, 0x6a, 0x68, 0x53, 0x2f, 0x42, 0x38,
                                      0x53, 0x47, 0x68, 0x61, 0x2f, 0x2f, 0x74, 0x56, 0x78, 0x43, 0x7a, 0x34, 0x39, 0x30, 0x42, 0x56,
                                      0x51, 0x48, 0x73, 0x61, 0x65, 0x39, 0x4d, 0x56, 0x47, 0x47, 0x71, 0x36, 0x39, 0x0a, 0x52, 0x78,
                                      0x35, 0x41, 0x2b, 0x44, 0x6a, 0x46, 0x63, 0x6f, 0x4f, 0x31, 0x7a, 0x54, 0x70, 0x76, 0x48, 0x31,
                                      0x74, 0x41, 0x77, 0x73, 0x4f, 0x59, 0x78, 0x62, 0x6b, 0x47, 0x74, 0x30, 0x52, 0x42, 0x65, 0x66,
                                      0x56, 0x33, 0x57, 0x5a, 0x64, 0x45, 0x41, 0x62, 0x39, 0x76, 0x57, 0x4f, 0x39, 0x57, 0x75, 0x6a,
                                      0x57, 0x6a, 0x6e, 0x61, 0x31, 0x79, 0x41, 0x46, 0x43, 0x66, 0x70, 0x62, 0x41, 0x50, 0x0a, 0x4f,
                                      0x4c, 0x34, 0x67, 0x66, 0x67, 0x6c, 0x66, 0x39, 0x6a, 0x73, 0x34, 0x61, 0x70, 0x4e, 0x50, 0x79,
                                      0x33, 0x64, 0x42, 0x41, 0x39, 0x48, 0x38, 0x6e, 0x70, 0x56, 0x6c, 0x6c, 0x2f, 0x74, 0x58, 0x4b,
                                      0x67, 0x42, 0x77, 0x41, 0x63, 0x43, 0x45, 0x36, 0x79, 0x42, 0x2f, 0x66, 0x51, 0x6e, 0x74, 0x6c,
                                      0x47, 0x64, 0x4f, 0x35, 0x78, 0x6b, 0x59, 0x5a, 0x70, 0x59, 0x6e, 0x65, 0x50, 0x6f, 0x49, 0x0a,
                                      0x6d, 0x2f, 0x68, 0x44, 0x45, 0x54, 0x30, 0x45, 0x6c, 0x62, 0x4f, 0x37, 0x71, 0x45, 0x2f, 0x79,
                                      0x50, 0x69, 0x50, 0x77, 0x35, 0x65, 0x79, 0x6a, 0x61, 0x36, 0x52, 0x34, 0x61, 0x41, 0x33, 0x41,
                                      0x70, 0x39, 0x73, 0x4e, 0x67, 0x62, 0x2f, 0x35, 0x37, 0x79, 0x67, 0x78, 0x44, 0x76, 0x79, 0x79,
                                      0x6f, 0x6d, 0x4e, 0x4c, 0x75, 0x68, 0x6e, 0x74, 0x4b, 0x46, 0x79, 0x41, 0x47, 0x69, 0x6d, 0x56,
                                      0x0a, 0x47, 0x77, 0x49, 0x44, 0x41, 0x51, 0x41, 0x42, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45,
                                      0x4e, 0x44, 0x20, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d,
                                      0x2d, 0x2d, 0x0a, 0x00
                                     };
__attribute__((section(".text")))
const uint8_t privateKey_2048_Pem[] = {0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x52, 0x53, 0x41, 0x20, 0x50,
                                       0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a,
                                       0x4d, 0x49, 0x49, 0x45, 0x70, 0x41, 0x49, 0x42, 0x41, 0x41, 0x4b, 0x43, 0x41, 0x51, 0x45, 0x41,
                                       0x74, 0x32, 0x6b, 0x50, 0x2f, 0x45, 0x45, 0x58, 0x54, 0x34, 0x34, 0x56, 0x35, 0x69, 0x55, 0x68,
                                       0x34, 0x44, 0x4f, 0x75, 0x43, 0x72, 0x6c, 0x4d, 0x6f, 0x70, 0x55, 0x65, 0x33, 0x44, 0x62, 0x45,
                                       0x69, 0x74, 0x6f, 0x2b, 0x30, 0x4e, 0x50, 0x78, 0x38, 0x54, 0x4a, 0x2f, 0x56, 0x57, 0x74, 0x57,
                                       0x0a, 0x31, 0x33, 0x55, 0x62, 0x47, 0x32, 0x32, 0x75, 0x41, 0x58, 0x32, 0x6c, 0x64, 0x34, 0x45,
                                       0x59, 0x4a, 0x71, 0x6b, 0x58, 0x44, 0x49, 0x62, 0x46, 0x75, 0x79, 0x43, 0x49, 0x59, 0x36, 0x6b,
                                       0x31, 0x72, 0x31, 0x31, 0x63, 0x4e, 0x6d, 0x4a, 0x37, 0x50, 0x51, 0x4f, 0x68, 0x74, 0x68, 0x71,
                                       0x56, 0x6a, 0x51, 0x42, 0x43, 0x32, 0x69, 0x73, 0x38, 0x2f, 0x35, 0x2b, 0x2f, 0x74, 0x77, 0x4d,
                                       0x6c, 0x0a, 0x2b, 0x6a, 0x68, 0x53, 0x2f, 0x42, 0x38, 0x53, 0x47, 0x68, 0x61, 0x2f, 0x2f, 0x74,
                                       0x56, 0x78, 0x43, 0x7a, 0x34, 0x39, 0x30, 0x42, 0x56, 0x51, 0x48, 0x73, 0x61, 0x65, 0x39, 0x4d,
                                       0x56, 0x47, 0x47, 0x71, 0x36, 0x39, 0x52, 0x78, 0x35, 0x41, 0x2b, 0x44, 0x6a, 0x46, 0x63, 0x6f,
                                       0x4f, 0x31, 0x7a, 0x54, 0x70, 0x76, 0x48, 0x31, 0x74, 0x41, 0x77, 0x73, 0x4f, 0x59, 0x78, 0x62,
                                       0x6b, 0x47, 0x0a, 0x74, 0x30, 0x52, 0x42, 0x65, 0x66, 0x56, 0x33, 0x57, 0x5a, 0x64, 0x45, 0x41,
                                       0x62, 0x39, 0x76, 0x57, 0x4f, 0x39, 0x57, 0x75, 0x6a, 0x57, 0x6a, 0x6e, 0x61, 0x31, 0x79, 0x41,
                                       0x46, 0x43, 0x66, 0x70, 0x62, 0x41, 0x50, 0x4f, 0x4c, 0x34, 0x67, 0x66, 0x67, 0x6c, 0x66, 0x39,
                                       0x6a, 0x73, 0x34, 0x61, 0x70, 0x4e, 0x50, 0x79, 0x33, 0x64, 0x42, 0x41, 0x39, 0x48, 0x38, 0x6e,
                                       0x70, 0x56, 0x6c, 0x0a, 0x6c, 0x2f, 0x74, 0x58, 0x4b, 0x67, 0x42, 0x77, 0x41, 0x63, 0x43, 0x45,
                                       0x36, 0x79, 0x42, 0x2f, 0x66, 0x51, 0x6e, 0x74, 0x6c, 0x47, 0x64, 0x4f, 0x35, 0x78, 0x6b, 0x59,
                                       0x5a, 0x70, 0x59, 0x6e, 0x65, 0x50, 0x6f, 0x49, 0x6d, 0x2f, 0x68, 0x44, 0x45, 0x54, 0x30, 0x45,
                                       0x6c, 0x62, 0x4f, 0x37, 0x71, 0x45, 0x2f, 0x79, 0x50, 0x69, 0x50, 0x77, 0x35, 0x65, 0x79, 0x6a,
                                       0x61, 0x36, 0x52, 0x34, 0x0a, 0x61, 0x41, 0x33, 0x41, 0x70, 0x39, 0x73, 0x4e, 0x67, 0x62, 0x2f,
                                       0x35, 0x37, 0x79, 0x67, 0x78, 0x44, 0x76, 0x79, 0x79, 0x6f, 0x6d, 0x4e, 0x4c, 0x75, 0x68, 0x6e,
                                       0x74, 0x4b, 0x46, 0x79, 0x41, 0x47, 0x69, 0x6d, 0x56, 0x47, 0x77, 0x49, 0x44, 0x41, 0x51, 0x41,
                                       0x42, 0x41, 0x6f, 0x49, 0x42, 0x41, 0x46, 0x58, 0x47, 0x43, 0x35, 0x54, 0x44, 0x2b, 0x42, 0x76,
                                       0x62, 0x62, 0x67, 0x42, 0x67, 0x0a, 0x6b, 0x7a, 0x51, 0x66, 0x31, 0x78, 0x2f, 0x71, 0x77, 0x70,
                                       0x30, 0x79, 0x4d, 0x65, 0x6c, 0x34, 0x72, 0x33, 0x66, 0x6b, 0x55, 0x77, 0x59, 0x6b, 0x61, 0x48,
                                       0x79, 0x4e, 0x53, 0x69, 0x46, 0x76, 0x66, 0x6f, 0x42, 0x71, 0x6f, 0x73, 0x2b, 0x7a, 0x2f, 0x6e,
                                       0x46, 0x79, 0x43, 0x6b, 0x55, 0x57, 0x47, 0x57, 0x35, 0x54, 0x47, 0x35, 0x56, 0x66, 0x48, 0x65,
                                       0x2f, 0x43, 0x61, 0x69, 0x5a, 0x35, 0x0a, 0x68, 0x73, 0x4c, 0x4a, 0x58, 0x59, 0x75, 0x4e, 0x69,
                                       0x4f, 0x62, 0x69, 0x34, 0x4f, 0x69, 0x69, 0x44, 0x42, 0x69, 0x52, 0x36, 0x37, 0x48, 0x4f, 0x45,
                                       0x4d, 0x76, 0x58, 0x4d, 0x4c, 0x68, 0x73, 0x2f, 0x34, 0x44, 0x43, 0x67, 0x49, 0x53, 0x71, 0x48,
                                       0x7a, 0x51, 0x57, 0x4f, 0x5a, 0x6e, 0x36, 0x78, 0x64, 0x41, 0x6c, 0x50, 0x70, 0x45, 0x6d, 0x74,
                                       0x6e, 0x35, 0x2b, 0x45, 0x75, 0x36, 0x54, 0x0a, 0x70, 0x35, 0x4a, 0x6f, 0x37, 0x39, 0x6e, 0x6e,
                                       0x6d, 0x79, 0x69, 0x36, 0x6e, 0x42, 0x52, 0x4f, 0x35, 0x6d, 0x48, 0x68, 0x46, 0x77, 0x44, 0x4b,
                                       0x45, 0x30, 0x4a, 0x42, 0x6d, 0x2b, 0x67, 0x73, 0x2b, 0x46, 0x4f, 0x53, 0x66, 0x4d, 0x6a, 0x36,
                                       0x6b, 0x7a, 0x79, 0x43, 0x56, 0x6b, 0x69, 0x4d, 0x5a, 0x49, 0x30, 0x4b, 0x55, 0x68, 0x4c, 0x55,
                                       0x69, 0x35, 0x68, 0x4d, 0x47, 0x78, 0x59, 0x6b, 0x0a, 0x39, 0x59, 0x67, 0x36, 0x7a, 0x46, 0x55,
                                       0x52, 0x72, 0x68, 0x79, 0x4b, 0x32, 0x69, 0x48, 0x5a, 0x56, 0x5a, 0x39, 0x70, 0x39, 0x53, 0x76,
                                       0x48, 0x48, 0x6e, 0x6f, 0x36, 0x42, 0x6e, 0x53, 0x44, 0x42, 0x4e, 0x77, 0x47, 0x4e, 0x74, 0x6a,
                                       0x63, 0x49, 0x54, 0x4c, 0x43, 0x6b, 0x58, 0x39, 0x58, 0x6c, 0x4b, 0x51, 0x77, 0x6a, 0x35, 0x50,
                                       0x49, 0x4d, 0x50, 0x31, 0x50, 0x45, 0x69, 0x66, 0x4e, 0x0a, 0x4c, 0x45, 0x2b, 0x75, 0x52, 0x41,
                                       0x50, 0x64, 0x59, 0x61, 0x51, 0x66, 0x62, 0x69, 0x5a, 0x4d, 0x61, 0x51, 0x6e, 0x6b, 0x48, 0x31,
                                       0x58, 0x30, 0x2f, 0x71, 0x5a, 0x58, 0x65, 0x2b, 0x54, 0x48, 0x79, 0x43, 0x73, 0x53, 0x56, 0x63,
                                       0x31, 0x2f, 0x4f, 0x43, 0x54, 0x48, 0x68, 0x59, 0x6c, 0x79, 0x67, 0x56, 0x6e, 0x69, 0x53, 0x44,
                                       0x2f, 0x49, 0x47, 0x34, 0x43, 0x55, 0x69, 0x36, 0x4f, 0x7a, 0x0a, 0x52, 0x51, 0x53, 0x43, 0x69,
                                       0x42, 0x45, 0x43, 0x67, 0x59, 0x45, 0x41, 0x2f, 0x62, 0x61, 0x71, 0x4c, 0x76, 0x79, 0x71, 0x4b,
                                       0x77, 0x61, 0x33, 0x54, 0x75, 0x6f, 0x71, 0x48, 0x50, 0x4c, 0x6c, 0x48, 0x41, 0x79, 0x79, 0x74,
                                       0x43, 0x57, 0x2b, 0x52, 0x30, 0x55, 0x47, 0x4a, 0x41, 0x56, 0x55, 0x41, 0x6c, 0x39, 0x54, 0x32,
                                       0x58, 0x30, 0x50, 0x68, 0x43, 0x45, 0x41, 0x5a, 0x77, 0x48, 0x59, 0x0a, 0x55, 0x63, 0x73, 0x6c,
                                       0x77, 0x6d, 0x79, 0x75, 0x75, 0x4a, 0x55, 0x48, 0x77, 0x7a, 0x52, 0x56, 0x42, 0x44, 0x70, 0x37,
                                       0x57, 0x6c, 0x7a, 0x6b, 0x6f, 0x32, 0x56, 0x65, 0x37, 0x2b, 0x4d, 0x63, 0x64, 0x69, 0x34, 0x47,
                                       0x4b, 0x33, 0x63, 0x61, 0x6f, 0x65, 0x70, 0x59, 0x58, 0x78, 0x4a, 0x7a, 0x4d, 0x73, 0x4e, 0x66,
                                       0x47, 0x46, 0x31, 0x43, 0x63, 0x6d, 0x51, 0x42, 0x79, 0x31, 0x44, 0x64, 0x0a, 0x59, 0x44, 0x74,
                                       0x69, 0x6f, 0x45, 0x4e, 0x45, 0x43, 0x4f, 0x5a, 0x53, 0x4e, 0x51, 0x6a, 0x57, 0x61, 0x6e, 0x2b,
                                       0x41, 0x53, 0x42, 0x43, 0x54, 0x51, 0x39, 0x31, 0x55, 0x44, 0x37, 0x76, 0x44, 0x44, 0x4d, 0x65,
                                       0x37, 0x6c, 0x58, 0x38, 0x67, 0x4b, 0x53, 0x39, 0x34, 0x39, 0x32, 0x5a, 0x4d, 0x4e, 0x4a, 0x42,
                                       0x30, 0x2b, 0x55, 0x4d, 0x43, 0x67, 0x59, 0x45, 0x41, 0x75, 0x52, 0x41, 0x30, 0x0a, 0x44, 0x4b,
                                       0x76, 0x34, 0x4f, 0x69, 0x2f, 0x74, 0x42, 0x75, 0x67, 0x31, 0x68, 0x70, 0x61, 0x4e, 0x63, 0x45,
                                       0x4c, 0x5a, 0x66, 0x51, 0x49, 0x75, 0x62, 0x41, 0x52, 0x6c, 0x42, 0x66, 0x48, 0x33, 0x4c, 0x66,
                                       0x4d, 0x46, 0x37, 0x6b, 0x6b, 0x6f, 0x73, 0x51, 0x4a, 0x67, 0x4e, 0x63, 0x77, 0x35, 0x45, 0x30,
                                       0x55, 0x4d, 0x4c, 0x42, 0x73, 0x69, 0x42, 0x56, 0x35, 0x66, 0x63, 0x44, 0x37, 0x68, 0x0a, 0x63,
                                       0x4f, 0x38, 0x6e, 0x45, 0x79, 0x4b, 0x79, 0x77, 0x59, 0x6c, 0x44, 0x6b, 0x61, 0x68, 0x59, 0x45,
                                       0x47, 0x54, 0x44, 0x5a, 0x52, 0x41, 0x74, 0x38, 0x4a, 0x39, 0x76, 0x79, 0x48, 0x4b, 0x77, 0x45,
                                       0x48, 0x33, 0x53, 0x54, 0x57, 0x4a, 0x57, 0x32, 0x59, 0x73, 0x41, 0x61, 0x7a, 0x70, 0x78, 0x4a,
                                       0x54, 0x6b, 0x44, 0x6d, 0x45, 0x5a, 0x75, 0x43, 0x62, 0x74, 0x67, 0x74, 0x6d, 0x5a, 0x7a, 0x0a,
                                       0x43, 0x54, 0x74, 0x75, 0x67, 0x43, 0x4b, 0x41, 0x67, 0x33, 0x41, 0x34, 0x61, 0x4f, 0x73, 0x38,
                                       0x66, 0x62, 0x6b, 0x32, 0x59, 0x30, 0x37, 0x47, 0x79, 0x57, 0x34, 0x4a, 0x69, 0x71, 0x49, 0x6f,
                                       0x52, 0x79, 0x45, 0x71, 0x36, 0x30, 0x6b, 0x43, 0x67, 0x59, 0x45, 0x41, 0x6e, 0x6b, 0x4a, 0x44,
                                       0x42, 0x65, 0x77, 0x31, 0x65, 0x59, 0x46, 0x47, 0x39, 0x73, 0x4b, 0x36, 0x59, 0x6a, 0x52, 0x68,
                                       0x0a, 0x46, 0x59, 0x34, 0x57, 0x4b, 0x71, 0x6b, 0x67, 0x64, 0x2f, 0x52, 0x6d, 0x55, 0x44, 0x48,
                                       0x43, 0x70, 0x58, 0x67, 0x78, 0x4a, 0x59, 0x6b, 0x4e, 0x46, 0x4b, 0x35, 0x42, 0x51, 0x66, 0x2b,
                                       0x30, 0x6e, 0x39, 0x44, 0x49, 0x54, 0x4f, 0x37, 0x65, 0x54, 0x65, 0x55, 0x6f, 0x59, 0x6d, 0x74,
                                       0x53, 0x58, 0x4d, 0x44, 0x65, 0x45, 0x51, 0x2f, 0x41, 0x7a, 0x75, 0x74, 0x38, 0x76, 0x4d, 0x59,
                                       0x2b, 0x0a, 0x43, 0x72, 0x6e, 0x4b, 0x76, 0x33, 0x49, 0x62, 0x2b, 0x73, 0x50, 0x6a, 0x4f, 0x2b,
                                       0x71, 0x57, 0x55, 0x53, 0x50, 0x74, 0x50, 0x5a, 0x56, 0x75, 0x7a, 0x55, 0x76, 0x30, 0x6b, 0x6f,
                                       0x35, 0x75, 0x69, 0x49, 0x69, 0x43, 0x6a, 0x4e, 0x56, 0x6f, 0x71, 0x75, 0x53, 0x41, 0x67, 0x76,
                                       0x52, 0x77, 0x53, 0x78, 0x34, 0x64, 0x4e, 0x74, 0x61, 0x67, 0x42, 0x63, 0x55, 0x5a, 0x6d, 0x6e,
                                       0x62, 0x55, 0x0a, 0x78, 0x44, 0x51, 0x53, 0x6e, 0x72, 0x34, 0x64, 0x6f, 0x5a, 0x4d, 0x72, 0x4d,
                                       0x61, 0x64, 0x75, 0x41, 0x5a, 0x76, 0x61, 0x57, 0x32, 0x45, 0x43, 0x67, 0x59, 0x41, 0x53, 0x41,
                                       0x48, 0x42, 0x2f, 0x74, 0x77, 0x36, 0x37, 0x59, 0x6b, 0x51, 0x56, 0x51, 0x75, 0x74, 0x4a, 0x2f,
                                       0x30, 0x55, 0x63, 0x34, 0x58, 0x50, 0x55, 0x68, 0x43, 0x7a, 0x4e, 0x31, 0x78, 0x4f, 0x59, 0x6f,
                                       0x33, 0x50, 0x65, 0x0a, 0x35, 0x56, 0x2f, 0x7a, 0x55, 0x4f, 0x79, 0x44, 0x59, 0x32, 0x37, 0x47,
                                       0x62, 0x4f, 0x6f, 0x30, 0x5a, 0x4b, 0x67, 0x4e, 0x64, 0x6b, 0x6f, 0x31, 0x36, 0x58, 0x73, 0x78,
                                       0x4b, 0x50, 0x79, 0x33, 0x42, 0x70, 0x78, 0x76, 0x63, 0x52, 0x57, 0x67, 0x57, 0x2b, 0x44, 0x56,
                                       0x76, 0x32, 0x46, 0x70, 0x6e, 0x74, 0x4f, 0x65, 0x39, 0x68, 0x62, 0x78, 0x37, 0x43, 0x42, 0x73,
                                       0x69, 0x44, 0x4e, 0x32, 0x0a, 0x4e, 0x7a, 0x63, 0x49, 0x7a, 0x67, 0x4d, 0x53, 0x77, 0x45, 0x47,
                                       0x33, 0x4c, 0x49, 0x55, 0x72, 0x45, 0x4d, 0x4f, 0x33, 0x77, 0x55, 0x6f, 0x63, 0x36, 0x6a, 0x77,
                                       0x37, 0x49, 0x66, 0x59, 0x59, 0x74, 0x4d, 0x35, 0x48, 0x36, 0x70, 0x4e, 0x44, 0x74, 0x64, 0x76,
                                       0x57, 0x34, 0x4f, 0x4d, 0x4f, 0x65, 0x38, 0x43, 0x39, 0x6f, 0x6b, 0x45, 0x57, 0x41, 0x50, 0x30,
                                       0x75, 0x6e, 0x68, 0x31, 0x36, 0x0a, 0x35, 0x64, 0x41, 0x4e, 0x2b, 0x51, 0x4b, 0x42, 0x67, 0x51,
                                       0x44, 0x37, 0x4c, 0x35, 0x70, 0x38, 0x31, 0x44, 0x42, 0x73, 0x4c, 0x54, 0x59, 0x4f, 0x42, 0x7a,
                                       0x6f, 0x68, 0x75, 0x43, 0x57, 0x55, 0x6b, 0x32, 0x43, 0x2f, 0x54, 0x36, 0x44, 0x55, 0x47, 0x59,
                                       0x38, 0x4b, 0x42, 0x62, 0x75, 0x64, 0x31, 0x50, 0x6b, 0x5a, 0x6b, 0x6e, 0x66, 0x5a, 0x61, 0x68,
                                       0x44, 0x53, 0x53, 0x36, 0x55, 0x6b, 0x0a, 0x55, 0x54, 0x73, 0x6a, 0x67, 0x31, 0x62, 0x64, 0x77,
                                       0x4c, 0x50, 0x68, 0x53, 0x6d, 0x5a, 0x7a, 0x4e, 0x64, 0x59, 0x31, 0x38, 0x64, 0x37, 0x52, 0x51,
                                       0x4f, 0x7a, 0x4b, 0x48, 0x6f, 0x69, 0x31, 0x6c, 0x76, 0x55, 0x69, 0x43, 0x77, 0x50, 0x71, 0x63,
                                       0x2f, 0x4b, 0x65, 0x39, 0x74, 0x6c, 0x7a, 0x53, 0x73, 0x6e, 0x6c, 0x50, 0x52, 0x70, 0x37, 0x79,
                                       0x56, 0x35, 0x58, 0x39, 0x51, 0x73, 0x50, 0x0a, 0x52, 0x49, 0x50, 0x73, 0x32, 0x69, 0x2f, 0x57,
                                       0x46, 0x72, 0x66, 0x65, 0x62, 0x72, 0x4c, 0x56, 0x74, 0x74, 0x76, 0x4a, 0x7a, 0x46, 0x34, 0x59,
                                       0x69, 0x74, 0x4b, 0x4e, 0x42, 0x4d, 0x57, 0x48, 0x46, 0x50, 0x79, 0x70, 0x30, 0x43, 0x75, 0x6c,
                                       0x70, 0x62, 0x64, 0x58, 0x72, 0x72, 0x33, 0x52, 0x58, 0x6e, 0x62, 0x7a, 0x53, 0x51, 0x3d, 0x3d,
                                       0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45, 0x4e, 0x44, 0x20, 0x52, 0x53, 0x41, 0x20, 0x50, 0x52,
                                       0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x00
                                      };
__attribute__((section(".text")))
const uint8_t publicKey_3072_Pem[] = {0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x50, 0x55, 0x42, 0x4c, 0x49,
                                      0x43, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x42, 0x6f,
                                      0x6a, 0x41, 0x4e, 0x42, 0x67, 0x6b, 0x71, 0x68, 0x6b, 0x69, 0x47, 0x39, 0x77, 0x30, 0x42, 0x41,
                                      0x51, 0x45, 0x46, 0x41, 0x41, 0x4f, 0x43, 0x41, 0x59, 0x38, 0x41, 0x4d, 0x49, 0x49, 0x42, 0x69,
                                      0x67, 0x4b, 0x43, 0x41, 0x59, 0x45, 0x41, 0x78, 0x4c, 0x6a, 0x4c, 0x32, 0x4e, 0x6b, 0x50, 0x6c,
                                      0x6b, 0x42, 0x6b, 0x69, 0x51, 0x69, 0x4c, 0x37, 0x6c, 0x4c, 0x43, 0x0a, 0x52, 0x35, 0x39, 0x33,
                                      0x7a, 0x37, 0x59, 0x70, 0x50, 0x4e, 0x79, 0x6e, 0x46, 0x4d, 0x6e, 0x74, 0x54, 0x59, 0x36, 0x71,
                                      0x46, 0x58, 0x66, 0x56, 0x6e, 0x53, 0x42, 0x4c, 0x67, 0x38, 0x6c, 0x71, 0x78, 0x30, 0x53, 0x75,
                                      0x67, 0x79, 0x47, 0x73, 0x33, 0x61, 0x74, 0x6d, 0x77, 0x4d, 0x78, 0x47, 0x59, 0x47, 0x65, 0x42,
                                      0x37, 0x31, 0x34, 0x70, 0x74, 0x70, 0x69, 0x72, 0x71, 0x6b, 0x6f, 0x44, 0x0a, 0x65, 0x2f, 0x41,
                                      0x47, 0x52, 0x47, 0x78, 0x35, 0x68, 0x51, 0x36, 0x56, 0x7a, 0x55, 0x46, 0x49, 0x49, 0x71, 0x65,
                                      0x2f, 0x49, 0x44, 0x56, 0x4a, 0x4b, 0x61, 0x31, 0x6b, 0x43, 0x4c, 0x59, 0x57, 0x2b, 0x55, 0x55,
                                      0x76, 0x51, 0x6a, 0x4b, 0x6e, 0x54, 0x64, 0x4f, 0x54, 0x32, 0x54, 0x38, 0x2b, 0x61, 0x73, 0x31,
                                      0x6a, 0x71, 0x31, 0x48, 0x4d, 0x6b, 0x54, 0x64, 0x56, 0x53, 0x49, 0x41, 0x54, 0x0a, 0x56, 0x45,
                                      0x57, 0x54, 0x33, 0x4e, 0x57, 0x4e, 0x2b, 0x54, 0x47, 0x67, 0x61, 0x4a, 0x54, 0x4e, 0x30, 0x78,
                                      0x66, 0x55, 0x6e, 0x6a, 0x30, 0x63, 0x2b, 0x63, 0x67, 0x48, 0x47, 0x61, 0x43, 0x2b, 0x6c, 0x58,
                                      0x4f, 0x69, 0x4c, 0x2b, 0x31, 0x52, 0x31, 0x67, 0x30, 0x65, 0x6e, 0x35, 0x4d, 0x63, 0x35, 0x51,
                                      0x52, 0x59, 0x31, 0x70, 0x6a, 0x63, 0x37, 0x39, 0x66, 0x6d, 0x6d, 0x69, 0x77, 0x75, 0x0a, 0x74,
                                      0x58, 0x31, 0x69, 0x30, 0x34, 0x6b, 0x43, 0x39, 0x65, 0x56, 0x43, 0x43, 0x32, 0x50, 0x54, 0x59,
                                      0x41, 0x39, 0x6f, 0x32, 0x6e, 0x6f, 0x35, 0x45, 0x38, 0x45, 0x4f, 0x74, 0x50, 0x6f, 0x54, 0x52,
                                      0x64, 0x48, 0x36, 0x31, 0x74, 0x75, 0x63, 0x79, 0x66, 0x6b, 0x67, 0x50, 0x41, 0x61, 0x61, 0x43,
                                      0x62, 0x62, 0x6b, 0x75, 0x65, 0x46, 0x58, 0x77, 0x53, 0x4b, 0x50, 0x75, 0x68, 0x64, 0x33, 0x0a,
                                      0x71, 0x4c, 0x48, 0x77, 0x67, 0x68, 0x4d, 0x71, 0x71, 0x64, 0x58, 0x53, 0x75, 0x61, 0x73, 0x51,
                                      0x42, 0x6a, 0x62, 0x61, 0x73, 0x74, 0x69, 0x4a, 0x63, 0x38, 0x4b, 0x5a, 0x44, 0x57, 0x79, 0x79,
                                      0x54, 0x48, 0x37, 0x46, 0x53, 0x49, 0x57, 0x50, 0x56, 0x45, 0x37, 0x6b, 0x61, 0x66, 0x73, 0x6f,
                                      0x31, 0x4f, 0x37, 0x50, 0x53, 0x75, 0x6a, 0x39, 0x7a, 0x4b, 0x4b, 0x47, 0x67, 0x52, 0x53, 0x4e,
                                      0x0a, 0x6a, 0x4c, 0x47, 0x6e, 0x74, 0x79, 0x7a, 0x61, 0x50, 0x4d, 0x6c, 0x2b, 0x44, 0x59, 0x6b,
                                      0x6f, 0x42, 0x44, 0x39, 0x72, 0x4a, 0x34, 0x53, 0x43, 0x59, 0x38, 0x5a, 0x2f, 0x47, 0x4c, 0x51,
                                      0x74, 0x6e, 0x35, 0x67, 0x30, 0x6c, 0x52, 0x6b, 0x53, 0x47, 0x58, 0x62, 0x63, 0x39, 0x44, 0x48,
                                      0x67, 0x32, 0x62, 0x64, 0x4f, 0x65, 0x32, 0x4f, 0x2b, 0x37, 0x75, 0x69, 0x35, 0x42, 0x6c, 0x74,
                                      0x31, 0x0a, 0x55, 0x72, 0x6d, 0x65, 0x52, 0x32, 0x58, 0x56, 0x79, 0x76, 0x51, 0x67, 0x43, 0x69,
                                      0x71, 0x44, 0x55, 0x34, 0x6a, 0x7a, 0x64, 0x34, 0x41, 0x46, 0x39, 0x6a, 0x63, 0x62, 0x75, 0x6c,
                                      0x36, 0x45, 0x53, 0x57, 0x56, 0x54, 0x64, 0x71, 0x6c, 0x77, 0x54, 0x62, 0x41, 0x48, 0x69, 0x64,
                                      0x5a, 0x4c, 0x30, 0x78, 0x6c, 0x44, 0x5a, 0x53, 0x76, 0x48, 0x7a, 0x71, 0x70, 0x4c, 0x31, 0x35,
                                      0x73, 0x42, 0x0a, 0x48, 0x47, 0x69, 0x58, 0x42, 0x4d, 0x44, 0x77, 0x58, 0x4d, 0x51, 0x30, 0x6c,
                                      0x6b, 0x45, 0x38, 0x56, 0x70, 0x61, 0x58, 0x58, 0x4b, 0x41, 0x65, 0x68, 0x48, 0x76, 0x53, 0x6c,
                                      0x36, 0x56, 0x38, 0x31, 0x5a, 0x50, 0x48, 0x78, 0x77, 0x57, 0x46, 0x48, 0x55, 0x4a, 0x6a, 0x41,
                                      0x67, 0x4d, 0x42, 0x41, 0x41, 0x45, 0x3d, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45, 0x4e, 0x44,
                                      0x20, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
                                      0x0a, 0x00
                                     };
__attribute__((section(".text")))
const uint8_t privateKey_3072_Pem[] = {0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x52, 0x53, 0x41, 0x20, 0x50,
                                       0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a,
                                       0x4d, 0x49, 0x49, 0x47, 0x35, 0x41, 0x49, 0x42, 0x41, 0x41, 0x4b, 0x43, 0x41, 0x59, 0x45, 0x41,
                                       0x78, 0x4c, 0x6a, 0x4c, 0x32, 0x4e, 0x6b, 0x50, 0x6c, 0x6b, 0x42, 0x6b, 0x69, 0x51, 0x69, 0x4c,
                                       0x37, 0x6c, 0x4c, 0x43, 0x52, 0x35, 0x39, 0x33, 0x7a, 0x37, 0x59, 0x70, 0x50, 0x4e, 0x79, 0x6e,
                                       0x46, 0x4d, 0x6e, 0x74, 0x54, 0x59, 0x36, 0x71, 0x46, 0x58, 0x66, 0x56, 0x6e, 0x53, 0x42, 0x4c,
                                       0x0a, 0x67, 0x38, 0x6c, 0x71, 0x78, 0x30, 0x53, 0x75, 0x67, 0x79, 0x47, 0x73, 0x33, 0x61, 0x74,
                                       0x6d, 0x77, 0x4d, 0x78, 0x47, 0x59, 0x47, 0x65, 0x42, 0x37, 0x31, 0x34, 0x70, 0x74, 0x70, 0x69,
                                       0x72, 0x71, 0x6b, 0x6f, 0x44, 0x65, 0x2f, 0x41, 0x47, 0x52, 0x47, 0x78, 0x35, 0x68, 0x51, 0x36,
                                       0x56, 0x7a, 0x55, 0x46, 0x49, 0x49, 0x71, 0x65, 0x2f, 0x49, 0x44, 0x56, 0x4a, 0x4b, 0x61, 0x31,
                                       0x6b, 0x0a, 0x43, 0x4c, 0x59, 0x57, 0x2b, 0x55, 0x55, 0x76, 0x51, 0x6a, 0x4b, 0x6e, 0x54, 0x64,
                                       0x4f, 0x54, 0x32, 0x54, 0x38, 0x2b, 0x61, 0x73, 0x31, 0x6a, 0x71, 0x31, 0x48, 0x4d, 0x6b, 0x54,
                                       0x64, 0x56, 0x53, 0x49, 0x41, 0x54, 0x56, 0x45, 0x57, 0x54, 0x33, 0x4e, 0x57, 0x4e, 0x2b, 0x54,
                                       0x47, 0x67, 0x61, 0x4a, 0x54, 0x4e, 0x30, 0x78, 0x66, 0x55, 0x6e, 0x6a, 0x30, 0x63, 0x2b, 0x63,
                                       0x67, 0x48, 0x0a, 0x47, 0x61, 0x43, 0x2b, 0x6c, 0x58, 0x4f, 0x69, 0x4c, 0x2b, 0x31, 0x52, 0x31,
                                       0x67, 0x30, 0x65, 0x6e, 0x35, 0x4d, 0x63, 0x35, 0x51, 0x52, 0x59, 0x31, 0x70, 0x6a, 0x63, 0x37,
                                       0x39, 0x66, 0x6d, 0x6d, 0x69, 0x77, 0x75, 0x74, 0x58, 0x31, 0x69, 0x30, 0x34, 0x6b, 0x43, 0x39,
                                       0x65, 0x56, 0x43, 0x43, 0x32, 0x50, 0x54, 0x59, 0x41, 0x39, 0x6f, 0x32, 0x6e, 0x6f, 0x35, 0x45,
                                       0x38, 0x45, 0x4f, 0x0a, 0x74, 0x50, 0x6f, 0x54, 0x52, 0x64, 0x48, 0x36, 0x31, 0x74, 0x75, 0x63,
                                       0x79, 0x66, 0x6b, 0x67, 0x50, 0x41, 0x61, 0x61, 0x43, 0x62, 0x62, 0x6b, 0x75, 0x65, 0x46, 0x58,
                                       0x77, 0x53, 0x4b, 0x50, 0x75, 0x68, 0x64, 0x33, 0x71, 0x4c, 0x48, 0x77, 0x67, 0x68, 0x4d, 0x71,
                                       0x71, 0x64, 0x58, 0x53, 0x75, 0x61, 0x73, 0x51, 0x42, 0x6a, 0x62, 0x61, 0x73, 0x74, 0x69, 0x4a,
                                       0x63, 0x38, 0x4b, 0x5a, 0x0a, 0x44, 0x57, 0x79, 0x79, 0x54, 0x48, 0x37, 0x46, 0x53, 0x49, 0x57,
                                       0x50, 0x56, 0x45, 0x37, 0x6b, 0x61, 0x66, 0x73, 0x6f, 0x31, 0x4f, 0x37, 0x50, 0x53, 0x75, 0x6a,
                                       0x39, 0x7a, 0x4b, 0x4b, 0x47, 0x67, 0x52, 0x53, 0x4e, 0x6a, 0x4c, 0x47, 0x6e, 0x74, 0x79, 0x7a,
                                       0x61, 0x50, 0x4d, 0x6c, 0x2b, 0x44, 0x59, 0x6b, 0x6f, 0x42, 0x44, 0x39, 0x72, 0x4a, 0x34, 0x53,
                                       0x43, 0x59, 0x38, 0x5a, 0x2f, 0x0a, 0x47, 0x4c, 0x51, 0x74, 0x6e, 0x35, 0x67, 0x30, 0x6c, 0x52,
                                       0x6b, 0x53, 0x47, 0x58, 0x62, 0x63, 0x39, 0x44, 0x48, 0x67, 0x32, 0x62, 0x64, 0x4f, 0x65, 0x32,
                                       0x4f, 0x2b, 0x37, 0x75, 0x69, 0x35, 0x42, 0x6c, 0x74, 0x31, 0x55, 0x72, 0x6d, 0x65, 0x52, 0x32,
                                       0x58, 0x56, 0x79, 0x76, 0x51, 0x67, 0x43, 0x69, 0x71, 0x44, 0x55, 0x34, 0x6a, 0x7a, 0x64, 0x34,
                                       0x41, 0x46, 0x39, 0x6a, 0x63, 0x62, 0x0a, 0x75, 0x6c, 0x36, 0x45, 0x53, 0x57, 0x56, 0x54, 0x64,
                                       0x71, 0x6c, 0x77, 0x54, 0x62, 0x41, 0x48, 0x69, 0x64, 0x5a, 0x4c, 0x30, 0x78, 0x6c, 0x44, 0x5a,
                                       0x53, 0x76, 0x48, 0x7a, 0x71, 0x70, 0x4c, 0x31, 0x35, 0x73, 0x42, 0x48, 0x47, 0x69, 0x58, 0x42,
                                       0x4d, 0x44, 0x77, 0x58, 0x4d, 0x51, 0x30, 0x6c, 0x6b, 0x45, 0x38, 0x56, 0x70, 0x61, 0x58, 0x58,
                                       0x4b, 0x41, 0x65, 0x68, 0x48, 0x76, 0x53, 0x0a, 0x6c, 0x36, 0x56, 0x38, 0x31, 0x5a, 0x50, 0x48,
                                       0x78, 0x77, 0x57, 0x46, 0x48, 0x55, 0x4a, 0x6a, 0x41, 0x67, 0x4d, 0x42, 0x41, 0x41, 0x45, 0x43,
                                       0x67, 0x67, 0x47, 0x41, 0x44, 0x4d, 0x50, 0x43, 0x38, 0x6d, 0x69, 0x76, 0x51, 0x72, 0x77, 0x64,
                                       0x36, 0x65, 0x68, 0x6b, 0x6b, 0x41, 0x76, 0x4e, 0x73, 0x48, 0x45, 0x51, 0x43, 0x4b, 0x6e, 0x55,
                                       0x78, 0x69, 0x36, 0x35, 0x4a, 0x72, 0x65, 0x74, 0x0a, 0x6a, 0x72, 0x31, 0x46, 0x6d, 0x77, 0x77,
                                       0x43, 0x44, 0x2b, 0x61, 0x44, 0x44, 0x2b, 0x4f, 0x58, 0x61, 0x71, 0x4f, 0x78, 0x77, 0x53, 0x2b,
                                       0x44, 0x74, 0x49, 0x53, 0x46, 0x4c, 0x39, 0x68, 0x78, 0x62, 0x70, 0x72, 0x34, 0x79, 0x75, 0x76,
                                       0x73, 0x76, 0x2f, 0x7a, 0x72, 0x45, 0x71, 0x73, 0x6e, 0x79, 0x37, 0x68, 0x34, 0x35, 0x36, 0x4b,
                                       0x30, 0x52, 0x65, 0x5a, 0x36, 0x34, 0x4f, 0x30, 0x74, 0x0a, 0x2f, 0x5a, 0x57, 0x74, 0x36, 0x4b,
                                       0x79, 0x63, 0x65, 0x54, 0x68, 0x58, 0x68, 0x39, 0x73, 0x73, 0x35, 0x58, 0x4c, 0x51, 0x54, 0x4c,
                                       0x62, 0x56, 0x74, 0x55, 0x36, 0x58, 0x78, 0x74, 0x35, 0x38, 0x4d, 0x64, 0x6a, 0x75, 0x38, 0x54,
                                       0x52, 0x6e, 0x46, 0x6a, 0x73, 0x6c, 0x62, 0x51, 0x56, 0x6d, 0x65, 0x36, 0x37, 0x69, 0x46, 0x38,
                                       0x2f, 0x42, 0x6e, 0x52, 0x78, 0x54, 0x77, 0x4d, 0x56, 0x37, 0x0a, 0x44, 0x34, 0x6e, 0x35, 0x30,
                                       0x57, 0x53, 0x38, 0x78, 0x78, 0x5a, 0x73, 0x49, 0x34, 0x55, 0x54, 0x4b, 0x4d, 0x5a, 0x75, 0x6a,
                                       0x54, 0x61, 0x55, 0x65, 0x31, 0x4f, 0x78, 0x6d, 0x34, 0x41, 0x6a, 0x76, 0x56, 0x61, 0x4a, 0x58,
                                       0x79, 0x39, 0x66, 0x45, 0x71, 0x38, 0x4c, 0x4e, 0x78, 0x44, 0x4c, 0x33, 0x52, 0x6e, 0x73, 0x4f,
                                       0x6a, 0x61, 0x6e, 0x4f, 0x77, 0x5a, 0x72, 0x77, 0x53, 0x70, 0x79, 0x0a, 0x6b, 0x6b, 0x61, 0x64,
                                       0x73, 0x71, 0x4f, 0x41, 0x70, 0x5a, 0x2f, 0x2b, 0x30, 0x4d, 0x35, 0x7a, 0x52, 0x72, 0x49, 0x48,
                                       0x32, 0x54, 0x34, 0x35, 0x7a, 0x37, 0x38, 0x36, 0x38, 0x35, 0x70, 0x55, 0x69, 0x45, 0x57, 0x54,
                                       0x4f, 0x54, 0x59, 0x65, 0x49, 0x30, 0x45, 0x75, 0x35, 0x64, 0x49, 0x62, 0x4e, 0x49, 0x66, 0x54,
                                       0x56, 0x41, 0x73, 0x39, 0x53, 0x69, 0x32, 0x36, 0x73, 0x71, 0x71, 0x4d, 0x0a, 0x5a, 0x74, 0x6b,
                                       0x44, 0x36, 0x4c, 0x6f, 0x6b, 0x67, 0x36, 0x69, 0x58, 0x6e, 0x72, 0x36, 0x4d, 0x49, 0x38, 0x68,
                                       0x52, 0x71, 0x47, 0x33, 0x61, 0x4d, 0x67, 0x30, 0x76, 0x63, 0x65, 0x59, 0x65, 0x7a, 0x49, 0x33,
                                       0x49, 0x41, 0x35, 0x78, 0x37, 0x46, 0x30, 0x52, 0x68, 0x46, 0x42, 0x54, 0x35, 0x36, 0x38, 0x6b,
                                       0x38, 0x61, 0x51, 0x46, 0x38, 0x50, 0x54, 0x65, 0x72, 0x41, 0x72, 0x4c, 0x4f, 0x0a, 0x68, 0x36,
                                       0x42, 0x30, 0x57, 0x35, 0x65, 0x5a, 0x4d, 0x4a, 0x34, 0x4b, 0x43, 0x46, 0x36, 0x6b, 0x42, 0x4b,
                                       0x4e, 0x31, 0x67, 0x4f, 0x78, 0x38, 0x55, 0x36, 0x36, 0x7a, 0x78, 0x63, 0x69, 0x50, 0x69, 0x4a,
                                       0x58, 0x4f, 0x36, 0x58, 0x6d, 0x47, 0x4d, 0x68, 0x36, 0x2f, 0x5a, 0x35, 0x31, 0x2f, 0x66, 0x38,
                                       0x6f, 0x38, 0x2b, 0x2b, 0x48, 0x34, 0x58, 0x47, 0x7a, 0x53, 0x4c, 0x59, 0x6c, 0x6b, 0x0a, 0x2f,
                                       0x41, 0x2f, 0x74, 0x36, 0x59, 0x53, 0x49, 0x5a, 0x38, 0x6e, 0x61, 0x5a, 0x6b, 0x55, 0x58, 0x38,
                                       0x4c, 0x59, 0x37, 0x4a, 0x54, 0x37, 0x41, 0x41, 0x45, 0x77, 0x6a, 0x51, 0x76, 0x74, 0x4c, 0x47,
                                       0x2b, 0x71, 0x2b, 0x46, 0x30, 0x70, 0x4e, 0x70, 0x52, 0x74, 0x6d, 0x38, 0x79, 0x33, 0x35, 0x6d,
                                       0x66, 0x62, 0x74, 0x67, 0x61, 0x57, 0x42, 0x65, 0x30, 0x2f, 0x54, 0x56, 0x59, 0x6f, 0x63, 0x0a,
                                       0x7a, 0x58, 0x50, 0x79, 0x38, 0x33, 0x49, 0x2b, 0x69, 0x75, 0x55, 0x63, 0x61, 0x51, 0x63, 0x4c,
                                       0x6a, 0x2b, 0x6c, 0x78, 0x54, 0x4b, 0x6f, 0x57, 0x30, 0x78, 0x76, 0x70, 0x41, 0x6f, 0x48, 0x42,
                                       0x41, 0x4f, 0x4a, 0x4c, 0x48, 0x55, 0x50, 0x7a, 0x33, 0x65, 0x39, 0x73, 0x49, 0x37, 0x79, 0x46,
                                       0x50, 0x35, 0x4d, 0x31, 0x32, 0x55, 0x51, 0x51, 0x72, 0x4f, 0x6b, 0x6b, 0x38, 0x69, 0x57, 0x4d,
                                       0x0a, 0x4e, 0x4a, 0x2f, 0x2b, 0x4a, 0x33, 0x48, 0x75, 0x56, 0x61, 0x4a, 0x6a, 0x7a, 0x33, 0x67,
                                       0x62, 0x51, 0x58, 0x36, 0x53, 0x48, 0x55, 0x74, 0x6e, 0x49, 0x69, 0x51, 0x37, 0x63, 0x36, 0x70,
                                       0x4b, 0x65, 0x47, 0x32, 0x4d, 0x67, 0x46, 0x65, 0x5a, 0x6a, 0x79, 0x52, 0x48, 0x53, 0x31, 0x4d,
                                       0x59, 0x4a, 0x52, 0x54, 0x56, 0x74, 0x79, 0x53, 0x49, 0x33, 0x35, 0x55, 0x4d, 0x2b, 0x52, 0x7a,
                                       0x70, 0x0a, 0x5a, 0x5a, 0x73, 0x59, 0x55, 0x44, 0x68, 0x32, 0x59, 0x34, 0x49, 0x6f, 0x4f, 0x41,
                                       0x47, 0x56, 0x64, 0x54, 0x58, 0x42, 0x66, 0x48, 0x79, 0x6b, 0x59, 0x6b, 0x6c, 0x75, 0x4e, 0x39,
                                       0x68, 0x37, 0x58, 0x65, 0x53, 0x4b, 0x74, 0x6c, 0x47, 0x74, 0x44, 0x72, 0x34, 0x6b, 0x7a, 0x7a,
                                       0x61, 0x49, 0x50, 0x69, 0x58, 0x4b, 0x4a, 0x44, 0x31, 0x42, 0x6f, 0x35, 0x39, 0x49, 0x67, 0x46,
                                       0x6e, 0x31, 0x0a, 0x55, 0x72, 0x76, 0x72, 0x6f, 0x6d, 0x4c, 0x34, 0x4a, 0x62, 0x35, 0x54, 0x71,
                                       0x4a, 0x54, 0x32, 0x63, 0x7a, 0x6b, 0x42, 0x64, 0x45, 0x37, 0x75, 0x6c, 0x5a, 0x30, 0x6f, 0x68,
                                       0x47, 0x41, 0x59, 0x63, 0x63, 0x43, 0x77, 0x70, 0x33, 0x37, 0x4b, 0x63, 0x43, 0x55, 0x35, 0x33,
                                       0x36, 0x56, 0x49, 0x4a, 0x39, 0x51, 0x37, 0x57, 0x78, 0x78, 0x47, 0x4d, 0x64, 0x74, 0x79, 0x39,
                                       0x67, 0x66, 0x47, 0x0a, 0x65, 0x77, 0x66, 0x43, 0x4c, 0x6c, 0x67, 0x56, 0x6f, 0x32, 0x41, 0x78,
                                       0x4a, 0x61, 0x49, 0x72, 0x63, 0x66, 0x79, 0x52, 0x59, 0x52, 0x39, 0x68, 0x6f, 0x44, 0x68, 0x42,
                                       0x48, 0x43, 0x58, 0x70, 0x43, 0x77, 0x4b, 0x42, 0x77, 0x51, 0x44, 0x65, 0x69, 0x2b, 0x51, 0x6f,
                                       0x33, 0x39, 0x7a, 0x51, 0x64, 0x51, 0x2f, 0x51, 0x77, 0x31, 0x6d, 0x70, 0x79, 0x53, 0x56, 0x61,
                                       0x58, 0x53, 0x2b, 0x39, 0x0a, 0x51, 0x64, 0x46, 0x39, 0x56, 0x56, 0x56, 0x35, 0x74, 0x61, 0x49,
                                       0x6d, 0x30, 0x4a, 0x59, 0x4f, 0x59, 0x44, 0x35, 0x32, 0x2f, 0x79, 0x2f, 0x64, 0x74, 0x4b, 0x49,
                                       0x4d, 0x4f, 0x31, 0x62, 0x69, 0x4f, 0x44, 0x44, 0x72, 0x70, 0x47, 0x37, 0x75, 0x53, 0x41, 0x63,
                                       0x73, 0x61, 0x32, 0x5a, 0x71, 0x46, 0x66, 0x32, 0x39, 0x59, 0x7a, 0x72, 0x57, 0x53, 0x4d, 0x55,
                                       0x30, 0x4f, 0x6a, 0x70, 0x5a, 0x0a, 0x46, 0x2b, 0x4e, 0x65, 0x71, 0x32, 0x42, 0x30, 0x51, 0x66,
                                       0x35, 0x6a, 0x58, 0x70, 0x6a, 0x76, 0x66, 0x39, 0x4a, 0x55, 0x2f, 0x6e, 0x59, 0x78, 0x44, 0x41,
                                       0x4e, 0x44, 0x4d, 0x4e, 0x73, 0x49, 0x46, 0x2f, 0x72, 0x58, 0x69, 0x6d, 0x49, 0x71, 0x67, 0x78,
                                       0x34, 0x50, 0x72, 0x67, 0x32, 0x54, 0x59, 0x58, 0x4e, 0x6d, 0x46, 0x6b, 0x67, 0x36, 0x4c, 0x6c,
                                       0x64, 0x62, 0x66, 0x7a, 0x64, 0x37, 0x0a, 0x50, 0x51, 0x4f, 0x71, 0x69, 0x52, 0x4d, 0x74, 0x47,
                                       0x65, 0x6f, 0x6e, 0x4a, 0x46, 0x72, 0x6c, 0x4c, 0x73, 0x63, 0x43, 0x35, 0x31, 0x37, 0x58, 0x35,
                                       0x72, 0x6f, 0x56, 0x75, 0x56, 0x79, 0x43, 0x41, 0x6d, 0x57, 0x50, 0x49, 0x56, 0x47, 0x68, 0x33,
                                       0x51, 0x46, 0x62, 0x42, 0x33, 0x55, 0x76, 0x66, 0x4a, 0x54, 0x4b, 0x53, 0x33, 0x6a, 0x55, 0x63,
                                       0x38, 0x78, 0x70, 0x5a, 0x47, 0x42, 0x41, 0x0a, 0x4a, 0x6c, 0x51, 0x5a, 0x32, 0x7a, 0x69, 0x30,
                                       0x39, 0x35, 0x31, 0x4c, 0x79, 0x51, 0x53, 0x6a, 0x50, 0x46, 0x43, 0x4f, 0x69, 0x56, 0x35, 0x48,
                                       0x6e, 0x54, 0x56, 0x45, 0x35, 0x6b, 0x4b, 0x46, 0x55, 0x70, 0x4b, 0x63, 0x30, 0x77, 0x6b, 0x43,
                                       0x67, 0x63, 0x45, 0x41, 0x70, 0x35, 0x53, 0x43, 0x76, 0x72, 0x44, 0x5a, 0x47, 0x52, 0x59, 0x58,
                                       0x50, 0x4f, 0x50, 0x63, 0x6d, 0x64, 0x4c, 0x56, 0x0a, 0x36, 0x39, 0x38, 0x42, 0x66, 0x63, 0x4a,
                                       0x37, 0x68, 0x43, 0x7a, 0x5a, 0x52, 0x2b, 0x5a, 0x36, 0x4a, 0x5a, 0x67, 0x66, 0x57, 0x4a, 0x76,
                                       0x62, 0x70, 0x35, 0x46, 0x66, 0x70, 0x6a, 0x44, 0x6b, 0x65, 0x74, 0x4f, 0x4d, 0x61, 0x42, 0x4b,
                                       0x53, 0x37, 0x48, 0x67, 0x72, 0x79, 0x4d, 0x79, 0x30, 0x75, 0x71, 0x71, 0x67, 0x59, 0x33, 0x68,
                                       0x63, 0x6f, 0x74, 0x4f, 0x4e, 0x6d, 0x6d, 0x6c, 0x4f, 0x0a, 0x4d, 0x45, 0x4d, 0x67, 0x65, 0x41,
                                       0x76, 0x63, 0x61, 0x33, 0x6d, 0x34, 0x59, 0x65, 0x76, 0x57, 0x64, 0x49, 0x6e, 0x50, 0x31, 0x54,
                                       0x4b, 0x64, 0x6a, 0x79, 0x61, 0x30, 0x58, 0x7a, 0x50, 0x44, 0x55, 0x62, 0x61, 0x57, 0x68, 0x74,
                                       0x53, 0x56, 0x6a, 0x4c, 0x36, 0x48, 0x59, 0x4e, 0x6b, 0x4d, 0x66, 0x56, 0x33, 0x51, 0x50, 0x69,
                                       0x57, 0x61, 0x51, 0x6b, 0x4d, 0x51, 0x36, 0x77, 0x46, 0x51, 0x0a, 0x5a, 0x77, 0x43, 0x32, 0x41,
                                       0x42, 0x34, 0x37, 0x31, 0x75, 0x4b, 0x69, 0x2b, 0x30, 0x46, 0x62, 0x78, 0x7a, 0x6b, 0x48, 0x45,
                                       0x6e, 0x52, 0x33, 0x73, 0x71, 0x44, 0x7a, 0x34, 0x54, 0x4a, 0x66, 0x68, 0x4a, 0x69, 0x51, 0x75,
                                       0x59, 0x71, 0x6f, 0x78, 0x56, 0x55, 0x30, 0x34, 0x45, 0x4b, 0x79, 0x4e, 0x32, 0x59, 0x4a, 0x4f,
                                       0x4c, 0x67, 0x73, 0x46, 0x41, 0x56, 0x6b, 0x59, 0x58, 0x6e, 0x33, 0x0a, 0x56, 0x65, 0x2f, 0x78,
                                       0x75, 0x68, 0x62, 0x66, 0x64, 0x68, 0x43, 0x5a, 0x53, 0x62, 0x79, 0x57, 0x66, 0x32, 0x71, 0x2b,
                                       0x79, 0x31, 0x78, 0x36, 0x42, 0x79, 0x64, 0x76, 0x53, 0x57, 0x41, 0x4c, 0x38, 0x61, 0x5a, 0x6c,
                                       0x64, 0x57, 0x4e, 0x61, 0x53, 0x67, 0x54, 0x54, 0x41, 0x6f, 0x48, 0x42, 0x41, 0x4c, 0x41, 0x6f,
                                       0x51, 0x33, 0x34, 0x6e, 0x56, 0x58, 0x36, 0x63, 0x61, 0x74, 0x78, 0x78, 0x0a, 0x42, 0x58, 0x52,
                                       0x6b, 0x42, 0x2f, 0x45, 0x7a, 0x65, 0x69, 0x70, 0x78, 0x41, 0x77, 0x59, 0x57, 0x6d, 0x67, 0x59,
                                       0x78, 0x52, 0x42, 0x30, 0x39, 0x56, 0x73, 0x6f, 0x69, 0x58, 0x4d, 0x2b, 0x4d, 0x78, 0x37, 0x4c,
                                       0x53, 0x33, 0x4d, 0x4b, 0x5a, 0x35, 0x66, 0x68, 0x44, 0x53, 0x6c, 0x58, 0x38, 0x58, 0x75, 0x4b,
                                       0x32, 0x6d, 0x52, 0x63, 0x4d, 0x48, 0x4a, 0x45, 0x30, 0x76, 0x78, 0x6b, 0x2b, 0x0a, 0x68, 0x73,
                                       0x41, 0x2f, 0x38, 0x66, 0x6d, 0x5a, 0x62, 0x62, 0x35, 0x41, 0x4c, 0x6e, 0x59, 0x74, 0x61, 0x62,
                                       0x67, 0x63, 0x31, 0x4f, 0x53, 0x4c, 0x61, 0x4c, 0x75, 0x4c, 0x6a, 0x6b, 0x35, 0x41, 0x37, 0x67,
                                       0x56, 0x38, 0x34, 0x4d, 0x67, 0x36, 0x7a, 0x2b, 0x58, 0x6b, 0x4e, 0x57, 0x61, 0x50, 0x33, 0x34,
                                       0x79, 0x50, 0x4a, 0x53, 0x68, 0x38, 0x4f, 0x62, 0x72, 0x44, 0x6c, 0x4c, 0x6a, 0x6d, 0x0a, 0x51,
                                       0x6c, 0x33, 0x72, 0x65, 0x4c, 0x4b, 0x77, 0x54, 0x4a, 0x5a, 0x38, 0x67, 0x58, 0x35, 0x6e, 0x36,
                                       0x6f, 0x6e, 0x30, 0x7a, 0x57, 0x67, 0x57, 0x57, 0x75, 0x79, 0x32, 0x7a, 0x6b, 0x6a, 0x36, 0x4a,
                                       0x42, 0x54, 0x36, 0x53, 0x61, 0x6f, 0x51, 0x67, 0x36, 0x31, 0x56, 0x67, 0x46, 0x5a, 0x2f, 0x70,
                                       0x55, 0x4a, 0x65, 0x30, 0x6b, 0x66, 0x66, 0x36, 0x31, 0x36, 0x66, 0x57, 0x70, 0x65, 0x57, 0x0a,
                                       0x6a, 0x68, 0x70, 0x39, 0x58, 0x76, 0x79, 0x39, 0x75, 0x34, 0x4b, 0x4c, 0x31, 0x46, 0x35, 0x7a,
                                       0x4c, 0x4c, 0x76, 0x79, 0x6c, 0x4d, 0x76, 0x38, 0x58, 0x6e, 0x4e, 0x6e, 0x74, 0x73, 0x78, 0x63,
                                       0x36, 0x41, 0x66, 0x2f, 0x35, 0x4c, 0x36, 0x5a, 0x46, 0x57, 0x61, 0x37, 0x4b, 0x64, 0x71, 0x42,
                                       0x49, 0x51, 0x4b, 0x42, 0x77, 0x47, 0x6f, 0x49, 0x50, 0x2f, 0x69, 0x78, 0x2f, 0x6f, 0x61, 0x43,
                                       0x0a, 0x4b, 0x4b, 0x4b, 0x5a, 0x32, 0x77, 0x47, 0x35, 0x33, 0x64, 0x4d, 0x56, 0x41, 0x2f, 0x77,
                                       0x43, 0x52, 0x6c, 0x2b, 0x45, 0x51, 0x65, 0x46, 0x63, 0x2b, 0x39, 0x6d, 0x38, 0x53, 0x4f, 0x6c,
                                       0x58, 0x74, 0x51, 0x34, 0x71, 0x77, 0x62, 0x34, 0x48, 0x35, 0x79, 0x69, 0x76, 0x61, 0x38, 0x49,
                                       0x56, 0x76, 0x39, 0x46, 0x63, 0x71, 0x37, 0x71, 0x53, 0x6f, 0x79, 0x37, 0x71, 0x58, 0x67, 0x4c,
                                       0x6a, 0x0a, 0x35, 0x70, 0x34, 0x73, 0x69, 0x48, 0x71, 0x35, 0x65, 0x56, 0x52, 0x6b, 0x67, 0x34,
                                       0x76, 0x43, 0x33, 0x79, 0x75, 0x46, 0x41, 0x2b, 0x43, 0x75, 0x7a, 0x31, 0x71, 0x50, 0x4b, 0x5a,
                                       0x6b, 0x74, 0x56, 0x6d, 0x76, 0x5a, 0x69, 0x6d, 0x70, 0x65, 0x33, 0x39, 0x6d, 0x42, 0x62, 0x73,
                                       0x79, 0x33, 0x42, 0x54, 0x52, 0x47, 0x71, 0x50, 0x49, 0x55, 0x48, 0x59, 0x62, 0x43, 0x73, 0x6e,
                                       0x79, 0x65, 0x0a, 0x50, 0x4f, 0x53, 0x43, 0x44, 0x41, 0x79, 0x68, 0x33, 0x64, 0x59, 0x70, 0x77,
                                       0x74, 0x77, 0x30, 0x6c, 0x69, 0x6f, 0x31, 0x6e, 0x59, 0x2b, 0x33, 0x2b, 0x46, 0x51, 0x78, 0x67,
                                       0x4d, 0x56, 0x6d, 0x66, 0x71, 0x59, 0x37, 0x61, 0x72, 0x39, 0x6b, 0x53, 0x41, 0x56, 0x53, 0x54,
                                       0x73, 0x33, 0x65, 0x30, 0x71, 0x35, 0x69, 0x50, 0x36, 0x46, 0x2b, 0x6d, 0x2b, 0x4e, 0x4c, 0x75,
                                       0x46, 0x71, 0x43, 0x0a, 0x4c, 0x77, 0x42, 0x79, 0x4d, 0x67, 0x6a, 0x66, 0x76, 0x69, 0x31, 0x31,
                                       0x53, 0x2b, 0x62, 0x67, 0x4c, 0x52, 0x67, 0x59, 0x5a, 0x32, 0x6f, 0x7a, 0x50, 0x44, 0x4b, 0x76,
                                       0x35, 0x49, 0x68, 0x4f, 0x75, 0x50, 0x48, 0x44, 0x47, 0x70, 0x57, 0x2f, 0x46, 0x46, 0x7a, 0x51,
                                       0x6b, 0x4d, 0x73, 0x39, 0x4d, 0x63, 0x45, 0x72, 0x4f, 0x51, 0x3d, 0x3d, 0x0a, 0x2d, 0x2d, 0x2d,
                                       0x2d, 0x2d, 0x45, 0x4e, 0x44, 0x20, 0x52, 0x53, 0x41, 0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54,
                                       0x45, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x00
                                      };
__attribute__((section(".text")))
const uint8_t publicKey_4096_Pem[] = {0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x50, 0x55, 0x42, 0x4c, 0x49,
                                      0x43, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x4d, 0x49, 0x49, 0x43, 0x49,
                                      0x6a, 0x41, 0x4e, 0x42, 0x67, 0x6b, 0x71, 0x68, 0x6b, 0x69, 0x47, 0x39, 0x77, 0x30, 0x42, 0x41,
                                      0x51, 0x45, 0x46, 0x41, 0x41, 0x4f, 0x43, 0x41, 0x67, 0x38, 0x41, 0x4d, 0x49, 0x49, 0x43, 0x43,
                                      0x67, 0x4b, 0x43, 0x41, 0x67, 0x45, 0x41, 0x76, 0x36, 0x66, 0x52, 0x43, 0x4d, 0x73, 0x74, 0x4b,
                                      0x30, 0x58, 0x51, 0x75, 0x67, 0x43, 0x6b, 0x66, 0x6a, 0x57, 0x4c, 0x0a, 0x4a, 0x6d, 0x65, 0x74,
                                      0x71, 0x69, 0x6a, 0x56, 0x72, 0x74, 0x57, 0x71, 0x47, 0x48, 0x4a, 0x54, 0x2b, 0x62, 0x58, 0x4a,
                                      0x54, 0x43, 0x70, 0x42, 0x42, 0x74, 0x32, 0x75, 0x61, 0x4c, 0x2b, 0x64, 0x30, 0x74, 0x55, 0x6c,
                                      0x45, 0x47, 0x74, 0x6f, 0x30, 0x45, 0x32, 0x58, 0x55, 0x64, 0x74, 0x38, 0x44, 0x61, 0x62, 0x4c,
                                      0x59, 0x76, 0x41, 0x6e, 0x42, 0x35, 0x36, 0x38, 0x32, 0x61, 0x65, 0x64, 0x0a, 0x59, 0x43, 0x41,
                                      0x65, 0x53, 0x4f, 0x48, 0x6c, 0x50, 0x32, 0x33, 0x35, 0x33, 0x61, 0x54, 0x55, 0x65, 0x50, 0x43,
                                      0x37, 0x6a, 0x31, 0x68, 0x78, 0x6a, 0x66, 0x49, 0x4c, 0x61, 0x6f, 0x39, 0x52, 0x30, 0x31, 0x72,
                                      0x65, 0x34, 0x2b, 0x58, 0x73, 0x76, 0x73, 0x31, 0x61, 0x53, 0x43, 0x70, 0x2b, 0x2f, 0x79, 0x61,
                                      0x41, 0x7a, 0x6d, 0x4c, 0x68, 0x75, 0x61, 0x76, 0x6b, 0x35, 0x67, 0x73, 0x36, 0x0a, 0x70, 0x52,
                                      0x4d, 0x61, 0x47, 0x4b, 0x46, 0x44, 0x34, 0x49, 0x71, 0x4b, 0x5a, 0x59, 0x34, 0x4e, 0x53, 0x32,
                                      0x39, 0x78, 0x42, 0x44, 0x68, 0x7a, 0x32, 0x59, 0x2f, 0x35, 0x47, 0x64, 0x41, 0x59, 0x75, 0x73,
                                      0x42, 0x4f, 0x77, 0x75, 0x47, 0x4b, 0x33, 0x6d, 0x64, 0x53, 0x66, 0x4d, 0x41, 0x34, 0x57, 0x30,
                                      0x56, 0x53, 0x59, 0x50, 0x72, 0x79, 0x68, 0x4a, 0x6f, 0x4e, 0x35, 0x61, 0x43, 0x64, 0x0a, 0x37,
                                      0x62, 0x67, 0x58, 0x58, 0x44, 0x76, 0x54, 0x54, 0x5a, 0x67, 0x59, 0x57, 0x48, 0x5a, 0x59, 0x6f,
                                      0x63, 0x58, 0x71, 0x4e, 0x32, 0x70, 0x61, 0x69, 0x7a, 0x52, 0x78, 0x54, 0x63, 0x44, 0x42, 0x79,
                                      0x5a, 0x70, 0x30, 0x64, 0x72, 0x4c, 0x2f, 0x4c, 0x6e, 0x74, 0x73, 0x73, 0x36, 0x41, 0x46, 0x72,
                                      0x39, 0x39, 0x7a, 0x76, 0x34, 0x2b, 0x67, 0x71, 0x32, 0x6e, 0x61, 0x6d, 0x4e, 0x71, 0x5a, 0x0a,
                                      0x59, 0x73, 0x6b, 0x2f, 0x36, 0x37, 0x67, 0x74, 0x33, 0x2b, 0x2f, 0x79, 0x36, 0x44, 0x54, 0x53,
                                      0x6d, 0x49, 0x6f, 0x75, 0x4b, 0x63, 0x56, 0x58, 0x63, 0x48, 0x55, 0x34, 0x30, 0x41, 0x6f, 0x7a,
                                      0x6c, 0x33, 0x7a, 0x44, 0x48, 0x2b, 0x4a, 0x56, 0x46, 0x74, 0x38, 0x63, 0x63, 0x6d, 0x69, 0x36,
                                      0x64, 0x58, 0x63, 0x6c, 0x48, 0x49, 0x63, 0x73, 0x6c, 0x75, 0x2b, 0x71, 0x39, 0x78, 0x66, 0x34,
                                      0x0a, 0x2b, 0x2f, 0x6e, 0x46, 0x78, 0x59, 0x35, 0x67, 0x2f, 0x64, 0x50, 0x62, 0x68, 0x66, 0x57,
                                      0x30, 0x36, 0x65, 0x2b, 0x4b, 0x71, 0x78, 0x46, 0x76, 0x64, 0x30, 0x6a, 0x55, 0x48, 0x71, 0x39,
                                      0x65, 0x51, 0x44, 0x42, 0x48, 0x31, 0x55, 0x36, 0x6d, 0x51, 0x71, 0x2b, 0x35, 0x78, 0x73, 0x68,
                                      0x62, 0x71, 0x54, 0x36, 0x47, 0x49, 0x39, 0x68, 0x31, 0x33, 0x4b, 0x56, 0x6e, 0x54, 0x6f, 0x46,
                                      0x44, 0x0a, 0x35, 0x33, 0x36, 0x51, 0x56, 0x75, 0x32, 0x42, 0x2f, 0x33, 0x43, 0x4e, 0x6a, 0x30,
                                      0x63, 0x35, 0x58, 0x53, 0x62, 0x58, 0x63, 0x5a, 0x33, 0x4b, 0x33, 0x36, 0x77, 0x69, 0x33, 0x4e,
                                      0x4b, 0x7a, 0x71, 0x55, 0x79, 0x2b, 0x41, 0x48, 0x69, 0x56, 0x4f, 0x56, 0x48, 0x65, 0x78, 0x53,
                                      0x6f, 0x79, 0x50, 0x2b, 0x4d, 0x32, 0x77, 0x48, 0x78, 0x45, 0x33, 0x6f, 0x71, 0x4e, 0x66, 0x44,
                                      0x31, 0x43, 0x0a, 0x6d, 0x76, 0x7a, 0x6b, 0x68, 0x78, 0x41, 0x55, 0x35, 0x68, 0x6a, 0x50, 0x34,
                                      0x52, 0x35, 0x78, 0x63, 0x43, 0x6e, 0x71, 0x44, 0x79, 0x53, 0x74, 0x63, 0x48, 0x68, 0x76, 0x2f,
                                      0x38, 0x68, 0x72, 0x2f, 0x69, 0x4f, 0x65, 0x57, 0x6d, 0x58, 0x78, 0x58, 0x2f, 0x7a, 0x61, 0x2b,
                                      0x41, 0x48, 0x78, 0x41, 0x51, 0x4d, 0x46, 0x41, 0x7a, 0x43, 0x70, 0x4b, 0x42, 0x41, 0x4b, 0x73,
                                      0x71, 0x4a, 0x77, 0x0a, 0x42, 0x53, 0x77, 0x54, 0x74, 0x79, 0x4d, 0x47, 0x63, 0x75, 0x67, 0x7a,
                                      0x32, 0x38, 0x79, 0x53, 0x61, 0x7a, 0x41, 0x68, 0x7a, 0x51, 0x58, 0x45, 0x36, 0x38, 0x51, 0x4e,
                                      0x50, 0x73, 0x63, 0x45, 0x6e, 0x46, 0x2b, 0x6a, 0x62, 0x71, 0x79, 0x50, 0x43, 0x43, 0x55, 0x32,
                                      0x61, 0x66, 0x44, 0x6d, 0x6b, 0x2f, 0x68, 0x67, 0x53, 0x6c, 0x57, 0x54, 0x34, 0x64, 0x47, 0x61,
                                      0x6e, 0x5a, 0x37, 0x68, 0x0a, 0x73, 0x52, 0x4a, 0x4a, 0x63, 0x55, 0x4d, 0x76, 0x4e, 0x73, 0x55,
                                      0x6f, 0x79, 0x56, 0x38, 0x56, 0x31, 0x34, 0x33, 0x63, 0x45, 0x46, 0x2f, 0x73, 0x6a, 0x5a, 0x30,
                                      0x71, 0x77, 0x57, 0x6e, 0x42, 0x46, 0x4f, 0x53, 0x55, 0x6b, 0x2b, 0x73, 0x59, 0x48, 0x41, 0x31,
                                      0x2b, 0x69, 0x56, 0x37, 0x70, 0x4c, 0x72, 0x45, 0x53, 0x78, 0x4a, 0x58, 0x6c, 0x76, 0x47, 0x55,
                                      0x42, 0x4c, 0x6e, 0x46, 0x4c, 0x0a, 0x39, 0x63, 0x68, 0x77, 0x4c, 0x6b, 0x61, 0x4e, 0x2f, 0x38,
                                      0x75, 0x48, 0x6b, 0x72, 0x67, 0x5a, 0x50, 0x43, 0x39, 0x64, 0x4c, 0x67, 0x38, 0x43, 0x41, 0x77,
                                      0x45, 0x41, 0x41, 0x51, 0x3d, 0x3d, 0x0a, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x45, 0x4e, 0x44, 0x20,
                                      0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a,
                                      0x00
                                     };
__attribute__((section(".text")))
const uint8_t privateKey_4096_Pem[] = {0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x20, 0x52, 0x53, 0x41, 0x20, 0x50,
                                       0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a,
                                       0x4d, 0x49, 0x49, 0x4a, 0x4b, 0x51, 0x49, 0x42, 0x41, 0x41, 0x4b, 0x43, 0x41, 0x67, 0x45, 0x41,
                                       0x76, 0x36, 0x66, 0x52, 0x43, 0x4d, 0x73, 0x74, 0x4b, 0x30, 0x58, 0x51, 0x75, 0x67, 0x43, 0x6b,
                                       0x66, 0x6a, 0x57, 0x4c, 0x4a, 0x6d, 0x65, 0x74, 0x71, 0x69, 0x6a, 0x56, 0x72, 0x74, 0x57, 0x71,
                                       0x47, 0x48, 0x4a, 0x54, 0x2b, 0x62, 0x58, 0x4a, 0x54, 0x43, 0x70, 0x42, 0x42, 0x74, 0x32, 0x75,
                                       0x0a, 0x61, 0x4c, 0x2b, 0x64, 0x30, 0x74, 0x55, 0x6c, 0x45, 0x47, 0x74, 0x6f, 0x30, 0x45, 0x32,
                                       0x58, 0x55, 0x64, 0x74, 0x38, 0x44, 0x61, 0x62, 0x4c, 0x59, 0x76, 0x41, 0x6e, 0x42, 0x35, 0x36,
                                       0x38, 0x32, 0x61, 0x65, 0x64, 0x59, 0x43, 0x41, 0x65, 0x53, 0x4f, 0x48, 0x6c, 0x50, 0x32, 0x33,
                                       0x35, 0x33, 0x61, 0x54, 0x55, 0x65, 0x50, 0x43, 0x37, 0x6a, 0x31, 0x68, 0x78, 0x6a, 0x66, 0x49,
                                       0x4c, 0x0a, 0x61, 0x6f, 0x39, 0x52, 0x30, 0x31, 0x72, 0x65, 0x34, 0x2b, 0x58, 0x73, 0x76, 0x73,
                                       0x31, 0x61, 0x53, 0x43, 0x70, 0x2b, 0x2f, 0x79, 0x61, 0x41, 0x7a, 0x6d, 0x4c, 0x68, 0x75, 0x61,
                                       0x76, 0x6b, 0x35, 0x67, 0x73, 0x36, 0x70, 0x52, 0x4d, 0x61, 0x47, 0x4b, 0x46, 0x44, 0x34, 0x49,
                                       0x71, 0x4b, 0x5a, 0x59, 0x34, 0x4e, 0x53, 0x32, 0x39, 0x78, 0x42, 0x44, 0x68, 0x7a, 0x32, 0x59,
                                       0x2f, 0x35, 0x0a, 0x47, 0x64, 0x41, 0x59, 0x75, 0x73, 0x42, 0x4f, 0x77, 0x75, 0x47, 0x4b, 0x33,
                                       0x6d, 0x64, 0x53, 0x66, 0x4d, 0x41, 0x34, 0x57, 0x30, 0x56, 0x53, 0x59, 0x50, 0x72, 0x79, 0x68,
                                       0x4a, 0x6f, 0x4e, 0x35, 0x61, 0x43, 0x64, 0x37, 0x62, 0x67, 0x58, 0x58, 0x44, 0x76, 0x54, 0x54,
                                       0x5a, 0x67, 0x59, 0x57, 0x48, 0x5a, 0x59, 0x6f, 0x63, 0x58, 0x71, 0x4e, 0x32, 0x70, 0x61, 0x69,
                                       0x7a, 0x52, 0x78, 0x0a, 0x54, 0x63, 0x44, 0x42, 0x79, 0x5a, 0x70, 0x30, 0x64, 0x72, 0x4c, 0x2f,
                                       0x4c, 0x6e, 0x74, 0x73, 0x73, 0x36, 0x41, 0x46, 0x72, 0x39, 0x39, 0x7a, 0x76, 0x34, 0x2b, 0x67,
                                       0x71, 0x32, 0x6e, 0x61, 0x6d, 0x4e, 0x71, 0x5a, 0x59, 0x73, 0x6b, 0x2f, 0x36, 0x37, 0x67, 0x74,
                                       0x33, 0x2b, 0x2f, 0x79, 0x36, 0x44, 0x54, 0x53, 0x6d, 0x49, 0x6f, 0x75, 0x4b, 0x63, 0x56, 0x58,
                                       0x63, 0x48, 0x55, 0x34, 0x0a, 0x30, 0x41, 0x6f, 0x7a, 0x6c, 0x33, 0x7a, 0x44, 0x48, 0x2b, 0x4a,
                                       0x56, 0x46, 0x74, 0x38, 0x63, 0x63, 0x6d, 0x69, 0x36, 0x64, 0x58, 0x63, 0x6c, 0x48, 0x49, 0x63,
                                       0x73, 0x6c, 0x75, 0x2b, 0x71, 0x39, 0x78, 0x66, 0x34, 0x2b, 0x2f, 0x6e, 0x46, 0x78, 0x59, 0x35,
                                       0x67, 0x2f, 0x64, 0x50, 0x62, 0x68, 0x66, 0x57, 0x30, 0x36, 0x65, 0x2b, 0x4b, 0x71, 0x78, 0x46,
                                       0x76, 0x64, 0x30, 0x6a, 0x55, 0x0a, 0x48, 0x71, 0x39, 0x65, 0x51, 0x44, 0x42, 0x48, 0x31, 0x55,
                                       0x36, 0x6d, 0x51, 0x71, 0x2b, 0x35, 0x78, 0x73, 0x68, 0x62, 0x71, 0x54, 0x36, 0x47, 0x49, 0x39,
                                       0x68, 0x31, 0x33, 0x4b, 0x56, 0x6e, 0x54, 0x6f, 0x46, 0x44, 0x35, 0x33, 0x36, 0x51, 0x56, 0x75,
                                       0x32, 0x42, 0x2f, 0x33, 0x43, 0x4e, 0x6a, 0x30, 0x63, 0x35, 0x58, 0x53, 0x62, 0x58, 0x63, 0x5a,
                                       0x33, 0x4b, 0x33, 0x36, 0x77, 0x69, 0x0a, 0x33, 0x4e, 0x4b, 0x7a, 0x71, 0x55, 0x79, 0x2b, 0x41,
                                       0x48, 0x69, 0x56, 0x4f, 0x56, 0x48, 0x65, 0x78, 0x53, 0x6f, 0x79, 0x50, 0x2b, 0x4d, 0x32, 0x77,
                                       0x48, 0x78, 0x45, 0x33, 0x6f, 0x71, 0x4e, 0x66, 0x44, 0x31, 0x43, 0x6d, 0x76, 0x7a, 0x6b, 0x68,
                                       0x78, 0x41, 0x55, 0x35, 0x68, 0x6a, 0x50, 0x34, 0x52, 0x35, 0x78, 0x63, 0x43, 0x6e, 0x71, 0x44,
                                       0x79, 0x53, 0x74, 0x63, 0x48, 0x68, 0x76, 0x0a, 0x2f, 0x38, 0x68, 0x72, 0x2f, 0x69, 0x4f, 0x65,
                                       0x57, 0x6d, 0x58, 0x78, 0x58, 0x2f, 0x7a, 0x61, 0x2b, 0x41, 0x48, 0x78, 0x41, 0x51, 0x4d, 0x46,
                                       0x41, 0x7a, 0x43, 0x70, 0x4b, 0x42, 0x41, 0x4b, 0x73, 0x71, 0x4a, 0x77, 0x42, 0x53, 0x77, 0x54,
                                       0x74, 0x79, 0x4d, 0x47, 0x63, 0x75, 0x67, 0x7a, 0x32, 0x38, 0x79, 0x53, 0x61, 0x7a, 0x41, 0x68,
                                       0x7a, 0x51, 0x58, 0x45, 0x36, 0x38, 0x51, 0x4e, 0x0a, 0x50, 0x73, 0x63, 0x45, 0x6e, 0x46, 0x2b,
                                       0x6a, 0x62, 0x71, 0x79, 0x50, 0x43, 0x43, 0x55, 0x32, 0x61, 0x66, 0x44, 0x6d, 0x6b, 0x2f, 0x68,
                                       0x67, 0x53, 0x6c, 0x57, 0x54, 0x34, 0x64, 0x47, 0x61, 0x6e, 0x5a, 0x37, 0x68, 0x73, 0x52, 0x4a,
                                       0x4a, 0x63, 0x55, 0x4d, 0x76, 0x4e, 0x73, 0x55, 0x6f, 0x79, 0x56, 0x38, 0x56, 0x31, 0x34, 0x33,
                                       0x63, 0x45, 0x46, 0x2f, 0x73, 0x6a, 0x5a, 0x30, 0x71, 0x0a, 0x77, 0x57, 0x6e, 0x42, 0x46, 0x4f,
                                       0x53, 0x55, 0x6b, 0x2b, 0x73, 0x59, 0x48, 0x41, 0x31, 0x2b, 0x69, 0x56, 0x37, 0x70, 0x4c, 0x72,
                                       0x45, 0x53, 0x78, 0x4a, 0x58, 0x6c, 0x76, 0x47, 0x55, 0x42, 0x4c, 0x6e, 0x46, 0x4c, 0x39, 0x63,
                                       0x68, 0x77, 0x4c, 0x6b, 0x61, 0x4e, 0x2f, 0x38, 0x75, 0x48, 0x6b, 0x72, 0x67, 0x5a, 0x50, 0x43,
                                       0x39, 0x64, 0x4c, 0x67, 0x38, 0x43, 0x41, 0x77, 0x45, 0x41, 0x0a, 0x41, 0x51, 0x4b, 0x43, 0x41,
                                       0x67, 0x41, 0x45, 0x69, 0x65, 0x54, 0x5a, 0x59, 0x48, 0x5a, 0x68, 0x58, 0x2f, 0x58, 0x68, 0x63,
                                       0x63, 0x4a, 0x7a, 0x65, 0x72, 0x45, 0x67, 0x35, 0x37, 0x4f, 0x6c, 0x49, 0x2f, 0x4a, 0x72, 0x67,
                                       0x59, 0x50, 0x56, 0x73, 0x46, 0x39, 0x73, 0x75, 0x6e, 0x46, 0x5a, 0x37, 0x47, 0x59, 0x39, 0x30,
                                       0x32, 0x49, 0x64, 0x2b, 0x4f, 0x75, 0x7a, 0x34, 0x6e, 0x68, 0x4f, 0x0a, 0x4f, 0x7a, 0x7a, 0x77,
                                       0x4d, 0x65, 0x59, 0x7a, 0x65, 0x67, 0x38, 0x6d, 0x41, 0x35, 0x30, 0x74, 0x61, 0x71, 0x4b, 0x42,
                                       0x2b, 0x37, 0x42, 0x64, 0x4e, 0x79, 0x72, 0x79, 0x36, 0x38, 0x2f, 0x4c, 0x79, 0x67, 0x32, 0x7a,
                                       0x77, 0x74, 0x62, 0x33, 0x2b, 0x4c, 0x39, 0x50, 0x58, 0x65, 0x51, 0x54, 0x4d, 0x50, 0x54, 0x2f,
                                       0x64, 0x34, 0x76, 0x74, 0x71, 0x68, 0x63, 0x31, 0x2b, 0x69, 0x44, 0x74, 0x0a, 0x4a, 0x4c, 0x54,
                                       0x47, 0x6a, 0x2f, 0x5a, 0x6a, 0x58, 0x78, 0x35, 0x43, 0x7a, 0x4a, 0x61, 0x67, 0x54, 0x4a, 0x63,
                                       0x72, 0x33, 0x6e, 0x59, 0x39, 0x50, 0x47, 0x62, 0x58, 0x49, 0x65, 0x79, 0x73, 0x53, 0x4b, 0x56,
                                       0x69, 0x32, 0x2b, 0x55, 0x4c, 0x49, 0x71, 0x49, 0x4e, 0x39, 0x30, 0x57, 0x6c, 0x34, 0x2f, 0x42,
                                       0x61, 0x5a, 0x70, 0x35, 0x76, 0x6a, 0x67, 0x34, 0x48, 0x33, 0x69, 0x58, 0x2f, 0x0a, 0x56, 0x33,
                                       0x67, 0x43, 0x62, 0x45, 0x2f, 0x33, 0x78, 0x46, 0x57, 0x52, 0x55, 0x38, 0x4c, 0x76, 0x71, 0x51,
                                       0x47, 0x31, 0x51, 0x6a, 0x43, 0x79, 0x44, 0x32, 0x75, 0x75, 0x42, 0x58, 0x34, 0x49, 0x49, 0x53,
                                       0x4b, 0x50, 0x34, 0x39, 0x6f, 0x76, 0x76, 0x68, 0x32, 0x37, 0x4e, 0x77, 0x53, 0x6b, 0x36, 0x30,
                                       0x2f, 0x5a, 0x6e, 0x42, 0x52, 0x53, 0x30, 0x77, 0x33, 0x44, 0x79, 0x48, 0x53, 0x5a, 0x0a, 0x6d,
                                       0x77, 0x4f, 0x51, 0x42, 0x6a, 0x77, 0x38, 0x78, 0x4c, 0x31, 0x64, 0x76, 0x4e, 0x7a, 0x77, 0x33,
                                       0x47, 0x58, 0x68, 0x71, 0x56, 0x41, 0x54, 0x37, 0x70, 0x6c, 0x54, 0x54, 0x5a, 0x44, 0x46, 0x39,
                                       0x45, 0x61, 0x68, 0x31, 0x76, 0x7a, 0x5a, 0x6f, 0x75, 0x61, 0x5a, 0x31, 0x69, 0x76, 0x68, 0x73,
                                       0x56, 0x71, 0x77, 0x76, 0x78, 0x58, 0x70, 0x56, 0x31, 0x53, 0x42, 0x63, 0x65, 0x4c, 0x74, 0x0a,
                                       0x44, 0x6c, 0x38, 0x56, 0x65, 0x35, 0x4d, 0x67, 0x34, 0x6e, 0x6f, 0x48, 0x37, 0x68, 0x70, 0x69,
                                       0x34, 0x70, 0x43, 0x62, 0x77, 0x6e, 0x45, 0x36, 0x43, 0x4d, 0x64, 0x4d, 0x70, 0x63, 0x78, 0x66,
                                       0x35, 0x4d, 0x53, 0x66, 0x74, 0x6b, 0x31, 0x4f, 0x74, 0x4b, 0x49, 0x67, 0x57, 0x4c, 0x46, 0x46,
                                       0x47, 0x6e, 0x4d, 0x2f, 0x44, 0x62, 0x6f, 0x70, 0x76, 0x38, 0x6e, 0x73, 0x2f, 0x48, 0x58, 0x49,
                                       0x0a, 0x62, 0x70, 0x67, 0x75, 0x51, 0x70, 0x4b, 0x4d, 0x79, 0x6a, 0x42, 0x77, 0x6b, 0x75, 0x41,
                                       0x68, 0x32, 0x45, 0x45, 0x30, 0x6b, 0x6b, 0x64, 0x71, 0x50, 0x50, 0x38, 0x65, 0x4a, 0x4d, 0x77,
                                       0x57, 0x30, 0x59, 0x59, 0x49, 0x38, 0x6b, 0x51, 0x74, 0x49, 0x6d, 0x31, 0x4f, 0x78, 0x65, 0x31,
                                       0x6f, 0x6f, 0x61, 0x41, 0x30, 0x4e, 0x54, 0x64, 0x6f, 0x35, 0x67, 0x6c, 0x4f, 0x5a, 0x2f, 0x35,
                                       0x70, 0x0a, 0x62, 0x4a, 0x43, 0x6e, 0x45, 0x71, 0x34, 0x76, 0x54, 0x31, 0x70, 0x6f, 0x33, 0x54,
                                       0x2b, 0x79, 0x66, 0x43, 0x46, 0x49, 0x30, 0x33, 0x61, 0x47, 0x59, 0x6f, 0x44, 0x7a, 0x41, 0x67,
                                       0x50, 0x70, 0x56, 0x36, 0x34, 0x4c, 0x43, 0x31, 0x31, 0x77, 0x71, 0x4e, 0x6e, 0x44, 0x73, 0x4b,
                                       0x53, 0x50, 0x44, 0x30, 0x38, 0x7a, 0x61, 0x6b, 0x30, 0x57, 0x38, 0x71, 0x73, 0x75, 0x54, 0x46,
                                       0x74, 0x2b, 0x0a, 0x6e, 0x4b, 0x6d, 0x79, 0x53, 0x61, 0x2f, 0x35, 0x56, 0x50, 0x2f, 0x6e, 0x42,
                                       0x54, 0x6e, 0x48, 0x6b, 0x77, 0x37, 0x52, 0x30, 0x58, 0x32, 0x47, 0x4b, 0x4b, 0x69, 0x66, 0x32,
                                       0x6f, 0x74, 0x55, 0x73, 0x69, 0x38, 0x4d, 0x48, 0x56, 0x6c, 0x38, 0x47, 0x56, 0x37, 0x33, 0x62,
                                       0x78, 0x6d, 0x71, 0x66, 0x73, 0x6d, 0x61, 0x68, 0x4b, 0x6a, 0x74, 0x6d, 0x52, 0x45, 0x6c, 0x52,
                                       0x33, 0x71, 0x33, 0x0a, 0x49, 0x35, 0x64, 0x78, 0x73, 0x61, 0x78, 0x50, 0x64, 0x54, 0x76, 0x71,
                                       0x37, 0x4e, 0x58, 0x65, 0x75, 0x6d, 0x55, 0x39, 0x2b, 0x37, 0x39, 0x43, 0x69, 0x55, 0x57, 0x4c,
                                       0x57, 0x75, 0x45, 0x6f, 0x46, 0x46, 0x64, 0x4f, 0x47, 0x6a, 0x75, 0x6b, 0x2f, 0x68, 0x47, 0x68,
                                       0x6c, 0x52, 0x48, 0x6d, 0x58, 0x32, 0x56, 0x53, 0x6a, 0x6f, 0x75, 0x43, 0x46, 0x49, 0x4a, 0x6a,
                                       0x7a, 0x6e, 0x48, 0x4b, 0x0a, 0x6a, 0x4f, 0x57, 0x43, 0x55, 0x35, 0x39, 0x45, 0x6d, 0x4f, 0x6c,
                                       0x36, 0x62, 0x39, 0x59, 0x71, 0x76, 0x74, 0x50, 0x79, 0x55, 0x41, 0x7a, 0x37, 0x67, 0x49, 0x65,
                                       0x76, 0x38, 0x42, 0x7a, 0x5a, 0x54, 0x6d, 0x6a, 0x62, 0x56, 0x6f, 0x78, 0x4c, 0x55, 0x30, 0x47,
                                       0x34, 0x66, 0x43, 0x63, 0x35, 0x41, 0x51, 0x4b, 0x43, 0x41, 0x51, 0x45, 0x41, 0x36, 0x52, 0x66,
                                       0x54, 0x5a, 0x66, 0x63, 0x7a, 0x0a, 0x2f, 0x42, 0x4b, 0x59, 0x76, 0x62, 0x52, 0x32, 0x36, 0x69,
                                       0x48, 0x68, 0x5a, 0x73, 0x4b, 0x53, 0x43, 0x68, 0x63, 0x79, 0x57, 0x47, 0x55, 0x4c, 0x43, 0x76,
                                       0x55, 0x76, 0x46, 0x6a, 0x73, 0x2f, 0x74, 0x41, 0x4c, 0x45, 0x42, 0x44, 0x77, 0x6b, 0x6f, 0x57,
                                       0x77, 0x6e, 0x42, 0x44, 0x2f, 0x77, 0x6f, 0x67, 0x47, 0x69, 0x57, 0x53, 0x6b, 0x47, 0x5a, 0x69,
                                       0x73, 0x70, 0x52, 0x71, 0x63, 0x38, 0x0a, 0x74, 0x54, 0x71, 0x7a, 0x4a, 0x53, 0x38, 0x39, 0x6c,
                                       0x47, 0x44, 0x43, 0x41, 0x70, 0x30, 0x69, 0x59, 0x7a, 0x42, 0x48, 0x2b, 0x5a, 0x31, 0x55, 0x6e,
                                       0x7a, 0x71, 0x6f, 0x52, 0x4e, 0x76, 0x59, 0x2f, 0x54, 0x71, 0x79, 0x53, 0x72, 0x52, 0x6e, 0x74,
                                       0x48, 0x76, 0x56, 0x51, 0x77, 0x32, 0x6b, 0x38, 0x78, 0x68, 0x44, 0x37, 0x4f, 0x77, 0x6f, 0x4a,
                                       0x36, 0x4e, 0x50, 0x43, 0x34, 0x31, 0x79, 0x0a, 0x53, 0x52, 0x4f, 0x77, 0x63, 0x67, 0x41, 0x47,
                                       0x67, 0x6c, 0x37, 0x4a, 0x63, 0x6c, 0x63, 0x37, 0x61, 0x6d, 0x4d, 0x54, 0x71, 0x72, 0x4a, 0x5a,
                                       0x36, 0x38, 0x47, 0x53, 0x41, 0x77, 0x46, 0x47, 0x4b, 0x68, 0x53, 0x6e, 0x6c, 0x76, 0x4a, 0x64,
                                       0x4e, 0x6f, 0x6f, 0x5a, 0x4a, 0x70, 0x36, 0x58, 0x43, 0x43, 0x58, 0x4b, 0x49, 0x66, 0x35, 0x33,
                                       0x33, 0x61, 0x64, 0x63, 0x61, 0x6f, 0x50, 0x41, 0x0a, 0x78, 0x46, 0x6e, 0x71, 0x37, 0x46, 0x59,
                                       0x75, 0x71, 0x73, 0x63, 0x56, 0x65, 0x5a, 0x4b, 0x52, 0x6a, 0x6e, 0x44, 0x4c, 0x61, 0x79, 0x4d,
                                       0x71, 0x54, 0x6c, 0x43, 0x6c, 0x59, 0x7a, 0x58, 0x6f, 0x48, 0x67, 0x51, 0x61, 0x44, 0x70, 0x42,
                                       0x65, 0x50, 0x56, 0x50, 0x74, 0x51, 0x56, 0x31, 0x63, 0x70, 0x30, 0x2b, 0x65, 0x33, 0x79, 0x38,
                                       0x6a, 0x67, 0x5a, 0x50, 0x36, 0x66, 0x4c, 0x6d, 0x47, 0x0a, 0x56, 0x55, 0x51, 0x39, 0x4c, 0x45,
                                       0x70, 0x4b, 0x33, 0x6d, 0x74, 0x30, 0x52, 0x6d, 0x72, 0x32, 0x34, 0x48, 0x4c, 0x4a, 0x51, 0x55,
                                       0x55, 0x38, 0x66, 0x36, 0x56, 0x74, 0x46, 0x33, 0x68, 0x34, 0x50, 0x6c, 0x50, 0x74, 0x34, 0x34,
                                       0x4a, 0x73, 0x77, 0x42, 0x48, 0x57, 0x4d, 0x35, 0x2f, 0x46, 0x75, 0x69, 0x61, 0x63, 0x70, 0x37,
                                       0x4e, 0x55, 0x55, 0x5a, 0x31, 0x73, 0x49, 0x78, 0x7a, 0x53, 0x0a, 0x6f, 0x77, 0x59, 0x47, 0x46,
                                       0x74, 0x4e, 0x58, 0x6e, 0x39, 0x33, 0x43, 0x5a, 0x77, 0x4b, 0x43, 0x41, 0x51, 0x45, 0x41, 0x30,
                                       0x6e, 0x32, 0x41, 0x66, 0x42, 0x38, 0x6e, 0x44, 0x51, 0x39, 0x62, 0x76, 0x6e, 0x5a, 0x6b, 0x43,
                                       0x6d, 0x76, 0x4b, 0x58, 0x32, 0x61, 0x31, 0x6c, 0x45, 0x39, 0x37, 0x32, 0x6c, 0x4e, 0x34, 0x74,
                                       0x67, 0x56, 0x4f, 0x5a, 0x39, 0x4a, 0x31, 0x56, 0x56, 0x41, 0x77, 0x0a, 0x4b, 0x34, 0x49, 0x49,
                                       0x42, 0x6f, 0x31, 0x56, 0x4c, 0x58, 0x43, 0x42, 0x33, 0x78, 0x78, 0x5a, 0x6e, 0x56, 0x4d, 0x61,
                                       0x67, 0x75, 0x6e, 0x63, 0x4f, 0x79, 0x72, 0x5a, 0x48, 0x58, 0x4b, 0x67, 0x2b, 0x31, 0x35, 0x68,
                                       0x42, 0x4a, 0x50, 0x30, 0x59, 0x6b, 0x78, 0x79, 0x66, 0x6e, 0x51, 0x32, 0x51, 0x6b, 0x70, 0x68,
                                       0x71, 0x4d, 0x4a, 0x7a, 0x62, 0x42, 0x2b, 0x30, 0x50, 0x41, 0x56, 0x6c, 0x0a, 0x46, 0x2f, 0x4e,
                                       0x41, 0x66, 0x48, 0x35, 0x44, 0x41, 0x53, 0x76, 0x5a, 0x7a, 0x46, 0x6b, 0x30, 0x4c, 0x33, 0x55,
                                       0x31, 0x70, 0x4a, 0x75, 0x33, 0x62, 0x4f, 0x43, 0x38, 0x4b, 0x42, 0x46, 0x4d, 0x71, 0x72, 0x6b,
                                       0x39, 0x74, 0x67, 0x53, 0x35, 0x4c, 0x71, 0x6f, 0x32, 0x49, 0x48, 0x45, 0x42, 0x52, 0x50, 0x59,
                                       0x75, 0x32, 0x65, 0x42, 0x41, 0x63, 0x57, 0x63, 0x4a, 0x62, 0x68, 0x7a, 0x6f, 0x0a, 0x71, 0x33,
                                       0x4e, 0x72, 0x68, 0x37, 0x72, 0x49, 0x51, 0x47, 0x6a, 0x46, 0x77, 0x32, 0x4a, 0x54, 0x73, 0x43,
                                       0x5a, 0x41, 0x50, 0x32, 0x48, 0x73, 0x53, 0x51, 0x77, 0x32, 0x73, 0x58, 0x46, 0x30, 0x58, 0x52,
                                       0x63, 0x6e, 0x75, 0x66, 0x54, 0x59, 0x64, 0x6d, 0x67, 0x39, 0x64, 0x77, 0x57, 0x6c, 0x4c, 0x4a,
                                       0x55, 0x75, 0x71, 0x6d, 0x56, 0x39, 0x42, 0x35, 0x6f, 0x37, 0x6a, 0x68, 0x2b, 0x6d, 0x0a, 0x75,
                                       0x4e, 0x39, 0x72, 0x74, 0x61, 0x4f, 0x48, 0x51, 0x78, 0x41, 0x77, 0x6a, 0x47, 0x57, 0x72, 0x68,
                                       0x76, 0x45, 0x68, 0x53, 0x67, 0x62, 0x4b, 0x55, 0x6e, 0x41, 0x42, 0x2f, 0x33, 0x43, 0x4e, 0x50,
                                       0x45, 0x4a, 0x65, 0x74, 0x73, 0x68, 0x30, 0x54, 0x46, 0x78, 0x52, 0x65, 0x77, 0x37, 0x31, 0x68,
                                       0x42, 0x34, 0x61, 0x50, 0x47, 0x78, 0x5a, 0x4c, 0x2f, 0x77, 0x6a, 0x6e, 0x32, 0x58, 0x7a, 0x0a,
                                       0x33, 0x56, 0x35, 0x4a, 0x70, 0x46, 0x34, 0x79, 0x4c, 0x62, 0x53, 0x65, 0x36, 0x6b, 0x39, 0x74,
                                       0x50, 0x39, 0x56, 0x42, 0x4b, 0x74, 0x45, 0x30, 0x5a, 0x37, 0x51, 0x76, 0x35, 0x55, 0x53, 0x4b,
                                       0x45, 0x4a, 0x73, 0x4d, 0x66, 0x37, 0x58, 0x2b, 0x47, 0x51, 0x4b, 0x43, 0x41, 0x51, 0x41, 0x39,
                                       0x67, 0x48, 0x66, 0x61, 0x30, 0x35, 0x72, 0x33, 0x79, 0x38, 0x42, 0x5a, 0x62, 0x61, 0x42, 0x69,
                                       0x0a, 0x72, 0x6f, 0x58, 0x57, 0x6f, 0x30, 0x66, 0x39, 0x4f, 0x5a, 0x6d, 0x6a, 0x45, 0x53, 0x59,
                                       0x55, 0x77, 0x68, 0x53, 0x6d, 0x66, 0x51, 0x4f, 0x56, 0x37, 0x35, 0x54, 0x67, 0x75, 0x53, 0x33,
                                       0x42, 0x47, 0x64, 0x52, 0x42, 0x6e, 0x73, 0x31, 0x54, 0x4d, 0x62, 0x4d, 0x77, 0x61, 0x30, 0x36,
                                       0x77, 0x37, 0x6e, 0x70, 0x35, 0x6c, 0x65, 0x37, 0x43, 0x73, 0x72, 0x5a, 0x4a, 0x2f, 0x57, 0x6a,
                                       0x32, 0x0a, 0x47, 0x59, 0x47, 0x58, 0x52, 0x76, 0x61, 0x6e, 0x7a, 0x54, 0x6c, 0x77, 0x64, 0x7a,
                                       0x36, 0x34, 0x74, 0x4c, 0x56, 0x70, 0x56, 0x63, 0x69, 0x76, 0x4b, 0x43, 0x6d, 0x61, 0x35, 0x48,
                                       0x62, 0x6f, 0x66, 0x44, 0x51, 0x4d, 0x2b, 0x54, 0x43, 0x6f, 0x6f, 0x36, 0x4a, 0x6f, 0x68, 0x50,
                                       0x63, 0x6a, 0x58, 0x6b, 0x65, 0x67, 0x2b, 0x4c, 0x56, 0x4b, 0x36, 0x74, 0x4d, 0x48, 0x67, 0x56,
                                       0x49, 0x32, 0x0a, 0x57, 0x2b, 0x51, 0x7a, 0x4d, 0x79, 0x6b, 0x4f, 0x4c, 0x51, 0x34, 0x6e, 0x58,
                                       0x39, 0x2b, 0x79, 0x41, 0x4f, 0x55, 0x52, 0x76, 0x65, 0x68, 0x52, 0x65, 0x68, 0x6d, 0x75, 0x44,
                                       0x6b, 0x7a, 0x68, 0x38, 0x78, 0x59, 0x6e, 0x78, 0x6e, 0x68, 0x37, 0x51, 0x64, 0x31, 0x50, 0x6b,
                                       0x75, 0x44, 0x31, 0x72, 0x77, 0x38, 0x48, 0x57, 0x37, 0x51, 0x6c, 0x47, 0x73, 0x53, 0x4e, 0x6a,
                                       0x7a, 0x2f, 0x49, 0x0a, 0x39, 0x37, 0x61, 0x47, 0x32, 0x56, 0x46, 0x6d, 0x6b, 0x41, 0x52, 0x63,
                                       0x52, 0x47, 0x38, 0x4a, 0x4d, 0x75, 0x59, 0x77, 0x67, 0x79, 0x79, 0x33, 0x6e, 0x73, 0x56, 0x78,
                                       0x53, 0x6b, 0x35, 0x54, 0x53, 0x43, 0x32, 0x31, 0x72, 0x58, 0x69, 0x67, 0x2f, 0x4c, 0x55, 0x69,
                                       0x6c, 0x6b, 0x46, 0x38, 0x45, 0x78, 0x74, 0x6f, 0x68, 0x56, 0x73, 0x59, 0x62, 0x47, 0x54, 0x6e,
                                       0x70, 0x73, 0x4b, 0x53, 0x0a, 0x5a, 0x53, 0x2f, 0x4d, 0x31, 0x4c, 0x52, 0x48, 0x44, 0x49, 0x4a,
                                       0x6c, 0x6f, 0x6d, 0x73, 0x51, 0x45, 0x77, 0x6e, 0x78, 0x77, 0x32, 0x75, 0x57, 0x70, 0x6e, 0x61,
                                       0x43, 0x4c, 0x51, 0x75, 0x63, 0x73, 0x68, 0x67, 0x65, 0x6a, 0x75, 0x32, 0x51, 0x37, 0x46, 0x63,
                                       0x78, 0x4f, 0x48, 0x50, 0x72, 0x42, 0x4f, 0x70, 0x66, 0x61, 0x56, 0x39, 0x36, 0x66, 0x45, 0x42,
                                       0x6e, 0x44, 0x57, 0x52, 0x31, 0x0a, 0x58, 0x67, 0x48, 0x4a, 0x41, 0x6f, 0x49, 0x42, 0x41, 0x51,
                                       0x43, 0x6b, 0x53, 0x45, 0x75, 0x56, 0x6c, 0x49, 0x4c, 0x59, 0x45, 0x4a, 0x71, 0x63, 0x52, 0x71,
                                       0x37, 0x42, 0x36, 0x32, 0x73, 0x68, 0x6c, 0x6e, 0x6f, 0x31, 0x37, 0x4f, 0x74, 0x50, 0x64, 0x55,
                                       0x4b, 0x4c, 0x58, 0x67, 0x7a, 0x5a, 0x76, 0x30, 0x72, 0x51, 0x63, 0x53, 0x75, 0x48, 0x61, 0x59,
                                       0x39, 0x31, 0x2f, 0x61, 0x7a, 0x7a, 0x0a, 0x4d, 0x42, 0x4a, 0x4d, 0x33, 0x6b, 0x57, 0x62, 0x49,
                                       0x70, 0x64, 0x59, 0x67, 0x63, 0x6e, 0x66, 0x62, 0x41, 0x76, 0x55, 0x6a, 0x66, 0x6a, 0x53, 0x39,
                                       0x39, 0x42, 0x6b, 0x30, 0x45, 0x30, 0x32, 0x77, 0x30, 0x2f, 0x42, 0x48, 0x6c, 0x61, 0x53, 0x32,
                                       0x70, 0x62, 0x71, 0x4c, 0x67, 0x6f, 0x44, 0x34, 0x36, 0x4b, 0x36, 0x44, 0x63, 0x50, 0x66, 0x4d,
                                       0x33, 0x32, 0x72, 0x4c, 0x4b, 0x69, 0x44, 0x0a, 0x4b, 0x34, 0x52, 0x72, 0x6c, 0x31, 0x76, 0x42,
                                       0x68, 0x6f, 0x74, 0x39, 0x6c, 0x41, 0x4e, 0x50, 0x4f, 0x50, 0x2f, 0x68, 0x6a, 0x63, 0x37, 0x32,
                                       0x6d, 0x47, 0x6c, 0x76, 0x76, 0x4c, 0x51, 0x44, 0x6c, 0x64, 0x6c, 0x30, 0x37, 0x48, 0x33, 0x2f,
                                       0x49, 0x74, 0x31, 0x69, 0x4d, 0x30, 0x4a, 0x59, 0x77, 0x41, 0x42, 0x2b, 0x4c, 0x70, 0x58, 0x78,
                                       0x36, 0x72, 0x32, 0x4d, 0x53, 0x39, 0x32, 0x72, 0x0a, 0x56, 0x35, 0x71, 0x79, 0x61, 0x66, 0x58,
                                       0x44, 0x54, 0x37, 0x64, 0x70, 0x51, 0x4c, 0x59, 0x34, 0x4e, 0x51, 0x34, 0x69, 0x34, 0x39, 0x66,
                                       0x63, 0x4b, 0x41, 0x78, 0x62, 0x65, 0x4a, 0x76, 0x52, 0x6e, 0x6e, 0x34, 0x4b, 0x66, 0x52, 0x39,
                                       0x7a, 0x63, 0x6d, 0x50, 0x66, 0x6e, 0x69, 0x49, 0x39, 0x59, 0x73, 0x55, 0x45, 0x6f, 0x66, 0x4e,
                                       0x76, 0x36, 0x77, 0x43, 0x58, 0x33, 0x61, 0x2f, 0x65, 0x0a, 0x53, 0x61, 0x35, 0x36, 0x68, 0x59,
                                       0x65, 0x67, 0x5a, 0x47, 0x61, 0x45, 0x37, 0x6c, 0x50, 0x4f, 0x6a, 0x35, 0x6b, 0x66, 0x6b, 0x75,
                                       0x72, 0x49, 0x6b, 0x30, 0x78, 0x31, 0x41, 0x48, 0x4b, 0x30, 0x66, 0x6f, 0x45, 0x68, 0x75, 0x49,
                                       0x55, 0x71, 0x76, 0x6f, 0x76, 0x66, 0x69, 0x50, 0x6a, 0x37, 0x47, 0x4b, 0x46, 0x38, 0x38, 0x51,
                                       0x65, 0x71, 0x53, 0x4d, 0x4c, 0x56, 0x52, 0x4b, 0x65, 0x4a, 0x0a, 0x51, 0x4b, 0x57, 0x66, 0x58,
                                       0x71, 0x70, 0x33, 0x33, 0x61, 0x74, 0x6c, 0x44, 0x61, 0x38, 0x48, 0x47, 0x58, 0x30, 0x67, 0x52,
                                       0x61, 0x51, 0x30, 0x58, 0x61, 0x38, 0x64, 0x70, 0x68, 0x39, 0x52, 0x41, 0x6f, 0x49, 0x42, 0x41,
                                       0x51, 0x43, 0x7a, 0x6b, 0x70, 0x71, 0x70, 0x72, 0x62, 0x32, 0x4b, 0x38, 0x6c, 0x7a, 0x30, 0x64,
                                       0x41, 0x54, 0x49, 0x34, 0x41, 0x73, 0x72, 0x76, 0x78, 0x56, 0x4c, 0x0a, 0x71, 0x44, 0x34, 0x46,
                                       0x6c, 0x6f, 0x32, 0x46, 0x5a, 0x30, 0x6b, 0x31, 0x69, 0x76, 0x70, 0x49, 0x32, 0x42, 0x39, 0x45,
                                       0x4f, 0x54, 0x77, 0x55, 0x6d, 0x55, 0x5a, 0x2b, 0x46, 0x57, 0x38, 0x39, 0x72, 0x46, 0x74, 0x70,
                                       0x43, 0x6f, 0x30, 0x73, 0x55, 0x37, 0x43, 0x2f, 0x4d, 0x47, 0x5a, 0x76, 0x75, 0x72, 0x71, 0x4c,
                                       0x71, 0x52, 0x62, 0x67, 0x2b, 0x79, 0x6d, 0x64, 0x46, 0x55, 0x52, 0x34, 0x0a, 0x2b, 0x42, 0x41,
                                       0x6d, 0x6b, 0x72, 0x6d, 0x67, 0x32, 0x63, 0x73, 0x63, 0x53, 0x7a, 0x45, 0x45, 0x77, 0x79, 0x45,
                                       0x33, 0x30, 0x54, 0x52, 0x46, 0x41, 0x56, 0x41, 0x44, 0x53, 0x2b, 0x7a, 0x38, 0x4b, 0x68, 0x7a,
                                       0x50, 0x38, 0x30, 0x49, 0x79, 0x55, 0x76, 0x44, 0x34, 0x51, 0x65, 0x4a, 0x31, 0x6e, 0x71, 0x62,
                                       0x43, 0x71, 0x65, 0x6a, 0x55, 0x34, 0x6a, 0x50, 0x47, 0x30, 0x56, 0x49, 0x49, 0x0a, 0x2b, 0x67,
                                       0x53, 0x74, 0x6a, 0x75, 0x55, 0x34, 0x70, 0x39, 0x49, 0x2f, 0x68, 0x62, 0x6c, 0x4d, 0x70, 0x2f,
                                       0x34, 0x6e, 0x6b, 0x63, 0x33, 0x69, 0x52, 0x58, 0x78, 0x4f, 0x33, 0x4d, 0x49, 0x36, 0x47, 0x5a,
                                       0x39, 0x76, 0x76, 0x4d, 0x4d, 0x79, 0x57, 0x67, 0x36, 0x63, 0x6f, 0x2f, 0x2f, 0x56, 0x59, 0x51,
                                       0x6c, 0x6f, 0x63, 0x64, 0x52, 0x54, 0x74, 0x52, 0x7a, 0x37, 0x67, 0x31, 0x42, 0x65, 0x0a, 0x47,
                                       0x61, 0x62, 0x64, 0x45, 0x45, 0x4f, 0x43, 0x45, 0x77, 0x73, 0x2f, 0x57, 0x48, 0x79, 0x6d, 0x65,
                                       0x42, 0x2b, 0x31, 0x59, 0x4c, 0x36, 0x66, 0x69, 0x69, 0x4b, 0x31, 0x7a, 0x4e, 0x6e, 0x44, 0x5a,
                                       0x6c, 0x42, 0x59, 0x4e, 0x48, 0x42, 0x6f, 0x34, 0x58, 0x66, 0x43, 0x4b, 0x50, 0x4a, 0x65, 0x57,
                                       0x51, 0x2b, 0x49, 0x68, 0x41, 0x4a, 0x4c, 0x2b, 0x39, 0x44, 0x35, 0x38, 0x67, 0x4c, 0x2f, 0x0a,
                                       0x43, 0x6c, 0x4e, 0x38, 0x61, 0x48, 0x45, 0x50, 0x6f, 0x64, 0x69, 0x63, 0x48, 0x7a, 0x37, 0x72,
                                       0x46, 0x55, 0x45, 0x69, 0x33, 0x39, 0x6f, 0x79, 0x59, 0x6e, 0x56, 0x72, 0x6a, 0x66, 0x34, 0x4b,
                                       0x6d, 0x55, 0x49, 0x65, 0x71, 0x43, 0x77, 0x68, 0x4b, 0x33, 0x55, 0x66, 0x36, 0x55, 0x62, 0x51,
                                       0x54, 0x6d, 0x59, 0x4d, 0x67, 0x65, 0x65, 0x69, 0x74, 0x4e, 0x30, 0x70, 0x0a, 0x2d, 0x2d, 0x2d,
                                       0x2d, 0x2d, 0x45, 0x4e, 0x44, 0x20, 0x52, 0x53, 0x41, 0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54,
                                       0x45, 0x20, 0x4b, 0x45, 0x59, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x0a, 0x00
                                      };

uint8_t EccPublicKey[65];
uint8_t EccPrivateKey[32];

#define RSA_KEY_SIZE 4096
// #define KEY_GENERATION_ON

#if defined(KEY_GENERATION_ON)
uint8_t PublicKey[3500] = {0};
uint8_t PrivateKey[3500] = {0};
#endif

/*buffer compare function*/
int buffer_compare(uint8_t *buffer1, uint8_t *buffer2, uint32_t length)
{
    uint32_t i;
    for (i = 0; i < length; i++)
    {
        if (buffer1[i] != buffer2[i])
        {
            return -1;
        }
    }
    return 0;
}

#if MEASURE_TEST

#define TEST_COUNT    5
float test_first[3][TEST_COUNT];
float test_second[3][TEST_COUNT];

void clean_test_data(void)
{
    for (int i = 0; i < 3; i++)
    {
        for (int j = 0; j < TEST_COUNT; j++)
        {
            test_first[i][j] = 0.0;
            test_second[i][j] = 0.0;
        }
    }
}

#if defined(MBEDTLS_CIPHER_MODE_CBC)
void AES_Cbc_test(void)
{
    userKey_t keyUsed;
    retStatus_t ret;
    uint8_t output[32] = {0};
    float TotalTime = 0.0;

    keyUsed.pKey = &key[0];
    clean_test_data();
    for (uint8_t i = 0; i < 3; i++)
    {
        keyUsed.keySize = 128 + (i * 64);
        PRINTF("-----------------------------------------------------------------------------------\n\r");
        PRINTF("AES CBC Encrypt and Decrypt test with %dbits key\n\r", keyUsed.keySize);
        for (uint32_t j = 0 ; j < TEST_COUNT; j++)
        {
            MEAN_START("Crypto_HAL_AES_CBC_Encrypt");
            ret = Crypto_HAL_AES_CBC_Encrypt(keyUsed, plainText, cipherText, iv, sizeof(plainText));
            MEAN_END("Crypto_HAL_AES_CBC_Encrypt");
            test_first[i][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                while (1);
            }
            MEAN_START("Crypto_HAL_AES_CBC_Decrypt");
            ret = Crypto_HAL_AES_CBC_Decrypt(keyUsed, cipherText, output, iv, sizeof(plainText));
            MEAN_END("Crypto_HAL_AES_CBC_Decrypt");
            test_second[i][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                while (1);
            }
            while (buffer_compare(plainText, output, sizeof(plainText)) != 0);
        }
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_first[i][j];
        }
        PRINTF("Average encrypt time: %f\n\r", TotalTime / TEST_COUNT);

        TotalTime = 0.0;
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_second[i][j];
        }
        PRINTF("Average decrypt time: %f\n\r", TotalTime / TEST_COUNT);
    }
}
#endif

#if !defined(MBEDTLS_BLOCK_CIPHER_NO_DECRYPT)
void AES_Ecb_test(void)
{
    userKey_t keyUsed;
    retStatus_t ret;
    uint8_t output[32] = {0};
    float TotalTime = 0.0;
    keyUsed.pKey = &key[0];
    clean_test_data();

    for (uint8_t i = 0; i < 3; i++)
    {
        keyUsed.keySize = 128 + (i * 64);
        PRINTF("-----------------------------------------------------------------------------------\n\r");
        PRINTF("AES ECB Encrypt and Decrypt test with %dbits key\n\r", keyUsed.keySize);
        for (uint32_t j = 0 ; j < TEST_COUNT; j++)
        {
            MEAN_START("Crypto_HAL_AES_ECB_Encrypt");
            ret = Crypto_HAL_AES_ECB_Encrypt(keyUsed, plainText, cipherText, sizeof(plainText));
            MEAN_END("Crypto_HAL_AES_ECB_Encrypt");
            test_first[i][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                while (1);
            }
            MEAN_START("Crypto_HAL_AES_ECB_Decrypt");
            ret = Crypto_HAL_AES_ECB_Decrypt(keyUsed, cipherText, output, sizeof(plainText));
            MEAN_END("Crypto_HAL_AES_ECB_Decrypt");
            test_second[i][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                while (1);
            }
            while (buffer_compare(plainText, output, sizeof(plainText)) != 0);
        }
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_first[i][j];
        }
        PRINTF("Average encrypt time: %f\n\r", TotalTime / TEST_COUNT);

        TotalTime = 0.0;
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_second[i][j];
        }
        PRINTF("Average decrypt time: %f\n\r", TotalTime / TEST_COUNT);
    }
}
#endif

/*AEC CFB test*/
#if defined(MBEDTLS_CIPHER_MODE_CFB)
void AES_Cfb_test(void)
{
    userKey_t keyUsed;
    retStatus_t ret;
    uint8_t output[32] = {0};
    size_t ivOffset = 0;
    float TotalTime = 0.0;
    keyUsed.pKey = &key[0];
    clean_test_data();

    for (uint8_t i = 0; i < 3; i++)
    {
        keyUsed.keySize = 128 + (i * 64);
        PRINTF("-----------------------------------------------------------------------------------\n\r");
        PRINTF("AES CFB Encrypt and Decrypt test with %dbits key\n\r", keyUsed.keySize);
        for (uint32_t j = 0 ; j < TEST_COUNT; j++)
        {
            MEAN_START("Crypto_HAL_AES_CFB_Encrypt");
            ret = Crypto_HAL_AES_CFB_Encrypt(keyUsed, plainText, cipherText, &ivOffset, iv, sizeof(plainText));
            MEAN_END("Crypto_HAL_AES_CFB_Encrypt");
            test_first[i][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                while (1);
            }
            MEAN_START("Crypto_HAL_AES_CFB_Decrypt");
            ret = Crypto_HAL_AES_CFB_Decrypt(keyUsed, cipherText, output, &ivOffset, iv, sizeof(plainText));
            MEAN_END("Crypto_HAL_AES_CFB_Decrypt");
            test_second[i][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                while (1);
            }
            while (buffer_compare(plainText, output, sizeof(plainText)) != 0);
        }
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_first[i][j];
        }
        PRINTF("Average encrypt time: %f\n\r", TotalTime / TEST_COUNT);

        TotalTime = 0.0;
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_second[i][j];
        }
        PRINTF("Average decrypt time: %f\n\r", TotalTime / TEST_COUNT);
    }
}
#endif

#if defined(MBEDTLS_CIPHER_MODE_OFB)
/*AES OFB test*/
void AES_Ofb_test(void)
{
    userKey_t keyUsed;
    retStatus_t ret;
    uint8_t output[32] = {0};
    size_t ivOffset = 0;
    float TotalTime = 0.0;
    keyUsed.pKey = &key[0];
    clean_test_data();

    for (uint8_t i = 0; i < 3; i++)
    {
        keyUsed.keySize = 128 + (i * 64);
        PRINTF("-----------------------------------------------------------------------------------\n\r");
        PRINTF("AES OFB Encrypt and Decrypt test with %dbits key\n\r", keyUsed.keySize);
        for (uint32_t j = 0 ; j < TEST_COUNT; j++)
        {
            MEAN_START("Crypto_HAL_AES_OFB_Encrypt");
            ret = Crypto_HAL_AES_OFB_Encrypt(keyUsed, plainText, cipherText, &ivOffset, iv, sizeof(plainText));
            MEAN_END("Crypto_HAL_AES_OFB_Encrypt");
            test_first[i][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                while (1);
            }
            MEAN_START("Crypto_HAL_AES_OFB_Decrypt");
            ret = Crypto_HAL_AES_OFB_Decrypt(keyUsed, cipherText, output, &ivOffset, iv, sizeof(plainText));
            MEAN_END("Crypto_HAL_AES_OFB_Decrypt");
            test_second[i][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                while (1);
            }
            while (buffer_compare(plainText, output, sizeof(plainText)) != 0);
        }
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_first[i][j];
        }
        PRINTF("Average encrypt time: %f\n\r", TotalTime / TEST_COUNT);

        TotalTime = 0.0;
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_second[i][j];
        }
        PRINTF("Average decrypt time: %f\n\r", TotalTime / TEST_COUNT);
    }
}
#endif

/*AES CTR test*/
#if defined(MBEDTLS_CIPHER_MODE_CTR)
void AES_Ctr_test(void)
{
    userKey_t keyUsed;
    retStatus_t ret;
    uint8_t output[32] = {0};
    size_t count = 0;
    uint8_t none_counter[16] = {0};
    float TotalTime = 0.0;
    keyUsed.pKey = &key[0];
    clean_test_data();

    keyUsed.pKey = &key[0];
    for (uint8_t i = 0; i < 3; i++)
    {
        keyUsed.keySize = 128 + (i * 64);
        PRINTF("-----------------------------------------------------------------------------------\n\r");
        PRINTF("AES CTR Encrypt and Decrypt test with %dbits key\n\r", keyUsed.keySize);

        for (uint32_t j = 0 ; j < TEST_COUNT; j++)
        {
            count = 0;
            memset(none_counter, 0, 16);
            MEAN_START("Crypto_HAL_AES_CTR_Encrypt");
            ret = Crypto_HAL_AES_CTR_Encrypt(keyUsed, plainText, cipherText, &count, none_counter, sizeof(plainText));
            MEAN_END("Crypto_HAL_AES_CTR_Encrypt");
            test_first[i][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                while (1);
            }
            count = 0;
            memset(none_counter, 0, 16);
            MEAN_START("Crypto_HAL_AES_CTR_Decrypt");
            ret = Crypto_HAL_AES_CTR_Decrypt(keyUsed, cipherText, output, &count, none_counter, sizeof(plainText));
            MEAN_END("Crypto_HAL_AES_CTR_Decrypt");
            test_second[i][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                while (1);
            }
            while (buffer_compare(plainText, output, sizeof(plainText)) != 0);
        }
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_first[i][j];
        }
        PRINTF("Average encrypt time: %f\n\r", TotalTime / TEST_COUNT);
        TotalTime = 0;
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_second[i][j];
        }
        PRINTF("Average decrypt time: %f\n\r", TotalTime / TEST_COUNT);
    }
}
#endif

#if defined (MBEDTLS_CMAC_C)
void AES_Cmac_test(void)
{
    userKey_t keyUsed;
    retStatus_t ret;
    uint8_t macValue[16] = {0};
    float TotalTime = 0.0;
    keyUsed.pKey = &key[0];
    clean_test_data();

    for (uint8_t i = 0; i < 1; i++)
    {
        keyUsed.keySize = 128 + (i * 64);
        PRINTF("-----------------------------------------------------------------------------------\n\r");
        PRINTF("AES CMAC generate \n\r");

        for (uint32_t j = 0 ; j < TEST_COUNT; j++)
        {
            MEAN_START("Crypto_HAL_CMAC_Generate");
            ret = Crypto_HAL_CMAC_Generate(MBEDTLS_CIPHER_AES_128_ECB, keyUsed, plainText, sizeof(plainText), macValue);
            MEAN_END("Crypto_HAL_CMAC_Generate");
            test_first[i][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                while (1);
            }
            MEAN_START("Crypto_HAL_CMAC_Verify");
            ret = Crypto_HAL_CMAC_Verify(MBEDTLS_CIPHER_AES_128_ECB, keyUsed, plainText, sizeof(plainText), macValue);
            MEAN_END("Crypto_HAL_CMAC_Verify");
            test_second[i][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                while (1);
            }
        }
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_first[i][j];
        }
        PRINTF("Average CMAC_Generate time: %f\n\r", TotalTime / TEST_COUNT);
        TotalTime = 0.0;
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_second[i][j];
        }
        PRINTF("Average CMAC_Verify time: %f\n\r", TotalTime / TEST_COUNT);
    }
}
#endif

#if defined(MBEDTLS_MD_C)
void Crypto_HMAC_test(void)
{
    userKey_t keyUsed;
    retStatus_t ret;
    uint8_t hmacValue[32] = {0};

    float TotalTime = 0.0;
    keyUsed.pKey = &key[0];
    clean_test_data();

    keyUsed.keySize = 256;
    PRINTF("-----------------------------------------------------------------------------------\n\r");
    PRINTF("HMAC generate \n\r");

    for (uint32_t j = 0 ; j < TEST_COUNT; j++)
    {
        MEAN_START("Crypto_HAL_HMAC_Generate");
        ret = Crypto_HAL_HMAC_Generate(MBEDTLS_MD_SHA256, keyUsed, plainText, sizeof(plainText), hmacValue);
        MEAN_END("Crypto_HAL_HMAC_Generate");
        test_first[0][j] = MEAN_GET_ELAPSED_TIME();
        if (ret != ERC_NO_ERROR)
        {
            while (1);
        }
        MEAN_START("Crypto_HAL_HMAC_Verify");
        ret = Crypto_HAL_HMAC_Verify(MBEDTLS_MD_SHA256, keyUsed, plainText, sizeof(plainText), hmacValue);
        MEAN_END("Crypto_HAL_HMAC_Verify");
        test_second[0][j] = MEAN_GET_ELAPSED_TIME();
        if (ret != ERC_NO_ERROR)
        {
            while (1);
        }
    }
    for (int j = 0; j < TEST_COUNT; j++)
    {
        TotalTime += test_first[0][j];
    }
    PRINTF("Average HMAC_Generate time: %f\n\r", TotalTime / TEST_COUNT);
    TotalTime = 0.0;
    for (int j = 0; j < TEST_COUNT; j++)
    {
        TotalTime += test_second[0][j];
    }
    PRINTF("Average HMAC_Verify time: %f\n\r", TotalTime / TEST_COUNT);
}
#endif

#if defined(MBEDTLS_SHA256_C)
void Crypto_Hash_test(void)
{
    retStatus_t ret;
    uint8_t hashValue[32] = {0};
    float TotalTime = 0.0;
    clean_test_data();

    PRINTF("-----------------------------------------------------------------------------------\n\r");
    PRINTF("Hash generate \n\r");

    for (uint32_t j = 0 ; j < TEST_COUNT; j++)
    {
        MEAN_START("Crypto_HAL_Hash_Generate");
        ret = Crypto_HAL_Hash_Generate(MBEDTLS_MD_SHA256, key, sizeof(key), hashValue);
        MEAN_END("Crypto_HAL_Hash_Generate");
        test_first[0][j] = MEAN_GET_ELAPSED_TIME();
        if (ret != ERC_NO_ERROR)
        {
            while (1);
        }
        MEAN_START("Crypto_HAL_Hash_Verify");
        ret = Crypto_HAL_Hash_Verify(MBEDTLS_MD_SHA256, key, sizeof(key), hashValue);
        MEAN_END("Crypto_HAL_Hash_Verify");
        test_second[0][j] = MEAN_GET_ELAPSED_TIME();
        if (ret != ERC_NO_ERROR)
        {
            while (1);
        }
    }
    for (int j = 0; j < TEST_COUNT; j++)
    {
        TotalTime += test_first[0][j];
    }
    PRINTF("Average Hash_Generate time: %f\n\r", TotalTime / TEST_COUNT);
    TotalTime = 0.0;
    for (int j = 0; j < TEST_COUNT; j++)
    {
        TotalTime += test_second[0][j];
    }
    PRINTF("Average Hash_Verify time: %f\n\r", TotalTime / TEST_COUNT);
}
#endif

#if defined (MBEDTLS_RSA_C)
void Rsa_test(void)
{
    retStatus_t ret;
    uint8_t message[32] = "abcdefghijklmnopqrstuvwxyz123456";
    uint8_t cipherBuf[RSA_KEY_SIZE / 8] = {0};
    size_t  cipherLen = 0;
    uint8_t plainBuf[RSA_KEY_SIZE / 8] = {0};
    size_t  plainLen = 0;
    uint8_t sig[RSA_KEY_SIZE / 8] = {0};
    size_t sig_len = 0;
    const uint8_t *publickey;
    const uint8_t *privatekey;
    float TotalTime = 0.0;
    clean_test_data();
    uint32_t keySize = 0;

    /*generate key pair only once*/
#if defined (KEY_GENERATION_ON)
    for (int i = 0; i < 3500; i++)
    {
        PublicKey[i] = 0;
        PrivateKey[i] = 0;
    }
    ret = Crypto_HAL_RSA_GenerateKeyPair(MBEDTLS_PK_RSA, RSA_KEY_SIZE, 65537, PublicKey, PrivateKey);
    if (ret != ERC_NO_ERROR)
    {
        PRINTF("RSA key generation failed\n\r");
    }
    else
    {
        PRINTF("RSA key generation success\n\r");

        PRINTF("Public Key length: %d\n\r", strlen((const char *)PublicKey));
        for (int i = 0; i < strlen((const char *)PublicKey) + 1; i++)
        {
            PRINTF("0x%02x,", PublicKey[i]);
            if ((i + 1) % 16 == 0)
            {
                PRINTF("\n\r");
            }
        }
        PRINTF("\n\r");
        PRINTF("Private Key length: %d\n\r", strlen((const char *)PrivateKey));
        for (int i = 0; i < strlen((const char *)PrivateKey) + 1; i++)
        {
            PRINTF("0x%02x,", PrivateKey[i]);
            if ((i + 1) % 16 == 0)
            {
                PRINTF(" \n\r");
            }
        }
        PRINTF("\n\r");
    }
#endif

    PRINTF("-----------------------------------------------------------------------------------\n\r");
    PRINTF("RSA_test \n\r");
    for (uint8_t i = 0; i < 3; i++)
    {
        if (0 == i)
        {
            PRINTF("-----------------------------------------------------------------------------------\n\r");
            PRINTF("RSA 2048 bit key test\n\r");
            publickey = publicKey_2048_Pem;
            privatekey = privateKey_2048_Pem;
            keySize = 2048;
        }
        else if (1 == i)
        {
            PRINTF("-----------------------------------------------------------------------------------\n\r");
            PRINTF("RSA 3072 bit key test\n\r");
            publickey = publicKey_3072_Pem;
            privatekey = privateKey_3072_Pem;
            keySize = 3072;
        }
        else
        {
            PRINTF("-----------------------------------------------------------------------------------\n\r");
            PRINTF("RSA 4096 bit key test\n\r");
            publickey = publicKey_4096_Pem;
            privatekey = privateKey_4096_Pem;
            keySize = 4096;
        }
        for (uint32_t j = 0 ; j < TEST_COUNT; j++)
        {
            MEAN_START("Crypto_HAL_RSA_Sign");
            ret = Crypto_HAL_RSA_Sign(privatekey, MBEDTLS_MD_SHA256, message, sizeof(message), sig, sizeof(sig), &sig_len);
            MEAN_END("Crypto_HAL_RSA_Sign");
            test_first[0][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                PRINTF("RSA sign failed\n\r");
                while (1);
            }
            MEAN_START("Crypto_HAL_RSA_Verify");
            ret = Crypto_HAL_RSA_Verify(publickey, MBEDTLS_MD_SHA256, message, sizeof(message), sig, sig_len);
            MEAN_END("Crypto_HAL_RSA_Verify");
            test_second[0][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                PRINTF("RSA verify failed\n\r");
                while (1);
            }
        }
        TotalTime = 0.0;
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_first[0][j];
        }
        PRINTF("Average RSA_Sign time: %f\n\r", TotalTime / TEST_COUNT);
        TotalTime = 0.0;
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_second[0][j];
        }
        PRINTF("Average RSA_Verify time: %f\n\r", TotalTime / TEST_COUNT);

        clean_test_data();
        for (uint32_t j = 0 ; j < TEST_COUNT; j++)
        {
            MEAN_START("Crypto_HAL_RSA_Encrypt");
            ret = Crypto_HAL_RSA_Encrypt(publickey, message, sizeof(message), cipherBuf, &cipherLen, sizeof(cipherBuf));
            MEAN_END("Crypto_HAL_RSA_Encrypt");
            test_first[0][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                PRINTF("RSA encrypt failed\n\r");
                while (1);
            }
            MEAN_START("Crypto_HAL_RSA_Decrypt");
            ret = Crypto_HAL_RSA_Decrypt(privatekey, cipherBuf, cipherLen, plainBuf, &plainLen, sizeof(plainBuf));
            MEAN_END("Crypto_HAL_RSA_Decrypt");
            test_second[0][j] = MEAN_GET_ELAPSED_TIME();
            if (ret != ERC_NO_ERROR)
            {
                PRINTF("RSA decrypt failed\n\r");
                while (1);
            }
            /*buffer compare*/
            while (buffer_compare(message, plainBuf, plainLen) != 0);
        }
        TotalTime = 0.0;
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_first[0][j];
        }
        PRINTF("Average RSA_Encrypt time: %f\n\r", TotalTime / TEST_COUNT);
        TotalTime = 0.0;
        for (int j = 0; j < TEST_COUNT; j++)
        {
            TotalTime += test_second[0][j];
        }
        PRINTF("Average RSA_Decrypt time: %f\n\r", TotalTime / TEST_COUNT);
    }
}
#endif

#if defined(MBEDTLS_ECDSA_C)
void ECDSA_test()
{
    retStatus_t ret;
    uint8_t message[] = "Hello World!";
    uint8_t sig[132] = {0};
    size_t sig_len = 0;
    char *PrivateKey = "43eddf717b97cb45bebba36e904b983a16976d668995d56f9d5831697ee0c517";
    char *PublicKey = "043d5f9117b1c875853a2c0abfee8ee9b8222c3e6881e29da92cddbeadd7953b3b56e2a6b0002a994924d87a2700e8910bddd8eb7fb7b25d94322045ba7db68d82";

    float TotalTime = 0.0;
    clean_test_data();

    PRINTF("-----------------------------------------------------------------------------------\n\r");
    PRINTF("ECDSA key generation...\n\r");
    ret = Crypto_HAL_ECDSA_GenerateKeyPair(MBEDTLS_ECP_DP_SECP256R1, EccPublicKey, sizeof(EccPublicKey), EccPrivateKey, sizeof(EccPrivateKey));
    if (ret != ERC_NO_ERROR)
    {
        while (1);
    }
    else
    {
        PRINTF("ECDSA key generation success\n\r");
    }

    PRINTF("-----------------------------------------------------------------------------------\n\r");
    PRINTF("ECDSA_test \n\r");
    for (uint32_t j = 0 ; j < TEST_COUNT; j++)
    {
        MEAN_START("Crypto_HAL_ECDSA_Sign");
        ret = Crypto_HAL_ECDSA_Sign(PrivateKey, MBEDTLS_ECP_DP_SECP256R1, MBEDTLS_MD_SHA256, message, strlen((const char *)message), sig, sizeof(sig), &sig_len);
        MEAN_END("Crypto_HAL_RSA_Decrypt");
        test_first[0][j] = MEAN_GET_ELAPSED_TIME();
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("ECDSA sign failed\n\r");
            while (1);
        }

        MEAN_START("Crypto_HAL_ECDSA_Verify");
        ret = Crypto_HAL_ECDSA_Verify(PublicKey, MBEDTLS_ECP_DP_SECP256R1, MBEDTLS_MD_SHA256, message, strlen((const char *)message), sig, sig_len);
        MEAN_END("Crypto_HAL_ECDSA_Verify");
        test_second[0][j] = MEAN_GET_ELAPSED_TIME();
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("ECDSA verify failed\n\r");
            while (1);
        }
    }
    TotalTime = 0.0;
    for (uint32_t j = 0; j < TEST_COUNT; j++)
    {
        TotalTime += test_first[0][j];
    }
    PRINTF("Average ECDSA_Sign time: %f\n\r", TotalTime / TEST_COUNT);
    TotalTime = 0.0;
    for (uint32_t j = 0; j < TEST_COUNT; j++)
    {
        TotalTime += test_second[0][j];
    }
    PRINTF("Average ECDSA_Verify time: %f\n\r", TotalTime / TEST_COUNT);
}
#endif

#else

void AES_Cbc_test(void)
{
    userKey_t keyUsed;
    retStatus_t ret;
    uint8_t output[32] = {0};

    keyUsed.pKey = &key[0];
    for (uint8_t i = 0; i < 3; i++)
    {
        keyUsed.keySize = 128 + (i * 64);
        PRINTF("-----------------------------------------------------------------------------------\n\r");
        PRINTF("AES CBC Encrypt and Decrypt test with %dbits key\n\r", keyUsed.keySize);

        /*prinf plain text*/
        PRINTF("Plain Text:\n\r");
        for (int i = 0; i < sizeof(plainText); i++)
        {
            PRINTF("%02x ", plainText[i]);
        }
        PRINTF("\n\r");
        ret = Crypto_HAL_AES_CBC_Encrypt(keyUsed, plainText, cipherText, iv, sizeof(plainText));
#if DEBUG_PRINT
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("AES CBC Encrypt failed\n\r");
        }
        else
        {
            /*print cipher text*/
            PRINTF("AES CBC Encrypt success\n\r");
            PRINTF("Cipher Text:\n\r");
            for (int i = 0; i < sizeof(cipherText); i++)
            {
                PRINTF("%02x ", cipherText[i]);
            }
            PRINTF("\n\r");
        }
#endif
        ret = Crypto_HAL_AES_CBC_Decrypt(keyUsed, cipherText, output, iv, sizeof(plainText));
#if DEBUG_PRINT
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("AES CBC Decrypt failed\n\r");
        }
        else
        {
            PRINTF("AES CBC Decrypt success\n\r");
            /*print plain text*/
            PRINTF("Plain Text:\n\r");
            for (int i = 0; i < sizeof(plainText); i++)
            {
                PRINTF("%02x ", output[i]);
            }
            PRINTF("\n\r");
        }
#endif
        while (buffer_compare(plainText, output, sizeof(plainText)) != 0);
#if DEBUG_PRINT
        PRINTF("AES CBC Encrypt and Decrypt success\n\r");
#endif
    }
}

void AES_Ecb_test(void)
{
    userKey_t keyUsed;
    retStatus_t ret;
    uint8_t output[32] = {0};

    keyUsed.pKey = &key[0];
    for (uint8_t i = 0; i < 3; i++)
    {
        keyUsed.keySize = 128 + (i * 64);
        PRINTF("-----------------------------------------------------------------------------------\n\r");
        PRINTF("AES ECB Encrypt and Decrypt test with %dbits key\n\r", keyUsed.keySize);

        /*prinf plain text*/
        PRINTF("Plain Text:\n\r");
        for (int i = 0; i < sizeof(plainText); i++)
        {
            PRINTF("%02x ", plainText[i]);
        }
        PRINTF("\n\r");
        ret = Crypto_HAL_AES_ECB_Encrypt(keyUsed, plainText, cipherText, sizeof(plainText));
#if DEBUG_PRINT
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("AES ECB Encrypt failed\n\r");
        }
        else
        {
            /*print cipher text*/
            PRINTF("AES ECB Encrypt success\n\r");
            PRINTF("Cipher Text:\n\r");
            for (int i = 0; i < sizeof(cipherText); i++)
            {
                PRINTF("%02x ", cipherText[i]);
            }
            PRINTF("\n\r");
        }
#endif
        ret = Crypto_HAL_AES_ECB_Decrypt(keyUsed, cipherText, output, sizeof(plainText));
#if DEBUG_PRINT
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("AES ECB Decrypt failed\n\r");
        }
        else
        {
            PRINTF("AES ECB Decrypt success\n\r");
            /*print plain text*/
            PRINTF("Plain Text:\n\r");
            for (int i = 0; i < sizeof(plainText); i++)
            {
                PRINTF("%02x ", output[i]);
            }
            PRINTF("\n\r");
        }
#endif
        while (buffer_compare(plainText, output, sizeof(plainText)) != 0);
#if DEBUG_PRINT
        PRINTF("AES ECB Encrypt and Decrypt success\n\r");
#endif
    }
}

/*AEC CFB test*/
void AES_Cfb_test(void)
{
    userKey_t keyUsed;
    retStatus_t ret;
    uint8_t output[32] = {0};
    size_t ivOffset = 0;

    keyUsed.pKey = &key[0];
    for (uint8_t i = 0; i < 3; i++)
    {
        keyUsed.keySize = 128 + (i * 64);
        PRINTF("-----------------------------------------------------------------------------------\n\r");
        PRINTF("AES CFB Encrypt and Decrypt test with %dbits key\n\r", keyUsed.keySize);

        /*prinf plain text*/
        PRINTF("Plain Text:\n\r");
        for (int i = 0; i < sizeof(plainText); i++)
        {
            PRINTF("%02x ", plainText[i]);
        }
        PRINTF("\n\r");
        ret = Crypto_HAL_AES_CFB_Encrypt(keyUsed, plainText, cipherText, &ivOffset, iv, sizeof(plainText));
#if DEBUG_PRINT
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("AES CFB Encrypt failed\n\r");
        }
        else
        {
            /*print cipher text*/
            PRINTF("AES CFB Encrypt success\n\r");
            PRINTF("Cipher Text:\n\r");
            for (int i = 0; i < sizeof(cipherText); i++)
            {
                PRINTF("%02x ", cipherText[i]);
            }
            PRINTF("\n\r");
        }
#endif
        ret = Crypto_HAL_AES_CFB_Decrypt(keyUsed, cipherText, output, &ivOffset, iv, sizeof(plainText));
#if DEBUG_PRINT
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("AES CFB Decrypt failed\n\r");
        }
        else
        {
            PRINTF("AES CFB Decrypt success\n\r");
            /*print plain text*/
            PRINTF("Plain Text:\n\r");
            for (int i = 0; i < sizeof(plainText); i++)
            {
                PRINTF("%02x ", output[i]);
            }
            PRINTF("\n\r");
        }
#endif
        while (buffer_compare(plainText, output, sizeof(plainText)) != 0);
#if DEBUG_PRINT
        PRINTF("AES CFB Encrypt and Decrypt success\n\r");
#endif
    }
}

/*AES OFB test*/
void AES_Ofb_test(void)
{
    userKey_t keyUsed;
    retStatus_t ret;
    uint8_t output[32] = {0};
    size_t ivOffset = 0;

    keyUsed.pKey = &key[0];
    for (uint8_t i = 0; i < 3; i++)
    {
        keyUsed.keySize = 128 + (i * 64);
        PRINTF("-----------------------------------------------------------------------------------\n\r");
        PRINTF("AES OFB Encrypt and Decrypt test with %dbits key\n\r", keyUsed.keySize);

        /*prinf plain text*/
        PRINTF("Plain Text:\n\r");
        for (int i = 0; i < sizeof(plainText); i++)
        {
            PRINTF("%02x ", plainText[i]);
        }
        PRINTF("\n\r");
        ret = Crypto_HAL_AES_OFB_Encrypt(keyUsed, plainText, cipherText, &ivOffset, iv, sizeof(plainText));
#if DEBUG_PRINT
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("AES OFB Encrypt failed\n\r");
        }
        else
        {
            /*print cipher text*/
            PRINTF("AES OFB Encrypt success\n\r");
            PRINTF("Cipher Text:\n\r");
            for (int i = 0; i < sizeof(cipherText); i++)
            {
                PRINTF("%02x ", cipherText[i]);
            }
            PRINTF("\n\r");
        }
#endif
        ret = Crypto_HAL_AES_OFB_Decrypt(keyUsed, cipherText, output, &ivOffset, iv, sizeof(plainText));
#if DEBUG_PRINT
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("AES OFB Decrypt failed\n\r");
        }
        else
        {
            PRINTF("AES OFB Decrypt success\n\r");
            /*print plain text*/
            PRINTF("Plain Text:\n\r");
            for (int i = 0; i < sizeof(plainText); i++)
            {
                PRINTF("%02x ", output[i]);
            }
            PRINTF("\n\r");
        }
#endif
        while (buffer_compare(plainText, output, sizeof(plainText)) != 0);
#if DEBUG_PRINT
        PRINTF("AES OFB Encrypt and Decrypt success\n\r");
#endif
    }
}

/*AES CTR test*/
void AES_Ctr_test(void)
{
    userKey_t keyUsed;
    retStatus_t ret;
    uint8_t output[32] = {0};
    size_t count = 0;
    uint8_t none_counter[16] = {0};

    keyUsed.pKey = &key[0];
    for (uint8_t i = 0; i < 3; i++)
    {
        keyUsed.keySize = 128 + (i * 64);
        PRINTF("-----------------------------------------------------------------------------------\n\r");
        PRINTF("AES CTR Encrypt and Decrypt test with %dbits key\n\r", keyUsed.keySize);

        /*prinf plain text*/
        PRINTF("Plain Text:\n\r");
        for (int i = 0; i < sizeof(plainText); i++)
        {
            PRINTF("%02x ", plainText[i]);
        }
        PRINTF("\n\r");
        count = 0;
        memset(none_counter, 0, 16);
        ret = Crypto_HAL_AES_CTR_Encrypt(keyUsed, plainText, cipherText, &count, none_counter, sizeof(plainText));
#if DEBUG_PRINT
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("AES CTR Encrypt failed\n\r");
        }
        else
        {
            /*print cipher text*/
            PRINTF("AES CTR Encrypt success\n\r");
            PRINTF("Cipher Text:\n\r");
            for (int i = 0; i < sizeof(cipherText); i++)
            {
                PRINTF("%02x ", cipherText[i]);
            }
            PRINTF("\n\r");
        }
#endif
        count = 0;
        memset(none_counter, 0, 16);
        ret = Crypto_HAL_AES_CTR_Decrypt(keyUsed, cipherText, output, &count, none_counter, sizeof(plainText));
#if DEBUG_PRINT
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("AES CTR Decrypt failed\n\r");
        }
        else
        {
            PRINTF("AES CTR Decrypt success\n\r");
            /*print plain text*/
            PRINTF("Plain Text:\n\r");
            for (int i = 0; i < sizeof(plainText); i++)
            {
                PRINTF("%02x ", output[i]);
            }
            PRINTF("\n\r");
        }
#endif
        while (buffer_compare(plainText, output, sizeof(plainText)) != 0);
#if DEBUG_PRINT
        PRINTF("AES CTR Encrypt and Decrypt success\n\r");
#endif
    }
}

void AES_Cmac_test(void)
{
    userKey_t keyUsed;
    retStatus_t ret;
    uint8_t macValue[16] = {0};

    keyUsed.pKey = &key[0];
    for (uint8_t i = 0; i < 1; i++)
    {
        keyUsed.keySize = 128 + (i * 64);
        PRINTF("-----------------------------------------------------------------------------------\n\r");
        PRINTF("AES CMAC generate \n\r");

        ret = Crypto_HAL_CMAC_Generate(MBEDTLS_CIPHER_AES_128_ECB, keyUsed, plainText, sizeof(plainText), macValue);
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("AES CMAC generate failed\n\r");
        }
        else
        {
            PRINTF("AES CMAC generate success\n\r");
            PRINTF("Mac output:\n\r");
            for (int i = 0; i < sizeof(macValue); i++)
            {
                PRINTF("%02x ", macValue[i]);
            }
            PRINTF("\n\r");
        }

        PRINTF("-----------------------------------------------------------------------------------\n\r");
        PRINTF("AES CMAC verigy \n\r");
        ret = Crypto_HAL_CMAC_Verify(MBEDTLS_CIPHER_AES_128_ECB, keyUsed, plainText, sizeof(plainText), macValue);
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("AES CMAC verify failed\n\r");
        }
        else
        {
            PRINTF("AES CMAC verify success\n\r");
        }


    }
}

void Crypto_HMAC_test(void)
{
    userKey_t keyUsed;
    retStatus_t ret;
    uint8_t hmacValue[32] = {0};

    keyUsed.pKey = &key[0];

    keyUsed.keySize = 256;
    PRINTF("-----------------------------------------------------------------------------------\n\r");
    PRINTF("HMAC generate \n\r");

    ret = Crypto_HAL_HMAC_Generate(MBEDTLS_MD_SHA256, keyUsed, plainText, sizeof(plainText), hmacValue);
    if (ret != ERC_NO_ERROR)
    {
        PRINTF("HMAC generate failed\n\r");
    }
    else
    {
        PRINTF("HMAC generate success\n\r");
        PRINTF("Mac output:\n\r");
        for (int i = 0; i < sizeof(hmacValue); i++)
        {
            PRINTF("%02x ", hmacValue[i]);
        }
        PRINTF("\n\r");
    }

    PRINTF("-----------------------------------------------------------------------------------\n\r");
    PRINTF("HMAC verigy \n\r");
    ret = Crypto_HAL_HMAC_Verify(MBEDTLS_MD_SHA256, keyUsed, plainText, sizeof(plainText), hmacValue);
    if (ret != ERC_NO_ERROR)
    {
        PRINTF("HMAC verify failed\n\r");
    }
    else
    {
        PRINTF("HMAC verify success\n\r");
    }
}

void Crypto_Hash_test(void)
{
    retStatus_t ret;
    uint8_t hashValue[32] = {0};

    PRINTF("-----------------------------------------------------------------------------------\n\r");
    PRINTF("Hash generate \n\r");

    ret = Crypto_HAL_Hash_Generate(MBEDTLS_MD_SHA256, plainText, sizeof(plainText), hashValue);
    if (ret != ERC_NO_ERROR)
    {
        PRINTF("Hash generate failed\n\r");
    }
    else
    {
        PRINTF("Hash generate success\n\r");
        PRINTF("Hash output:\n\r");
        for (int i = 0; i < sizeof(hashValue); i++)
        {
            PRINTF("%02x ", hashValue[i]);
        }
        PRINTF("\n\r");
    }

    PRINTF("-----------------------------------------------------------------------------------\n\r");
    PRINTF("Hash verigy \n\r");
    ret = Crypto_HAL_Hash_Verify(MBEDTLS_MD_SHA256, plainText, sizeof(plainText), hashValue);
    if (ret != ERC_NO_ERROR)
    {
        PRINTF("Hash verify failed\n\r");
    }
    else
    {
        PRINTF("Hash verify success\n\r");
    }
}

void Rsa_test(void)
{
    retStatus_t ret;
    uint8_t message[RSA_KEY_SIZE / 8] = {0};
    uint8_t cipherBuf[RSA_KEY_SIZE / 8] = {0};
    size_t  cipherLen = 0;
    uint8_t plainBuf[RSA_KEY_SIZE / 8] = {0};
    size_t  plainLen = 0;
    uint8_t sig[RSA_KEY_SIZE / 8] = {0};
    size_t sig_len = 0;

    for (int j = 0; j < RSA_KEY_SIZE / 8; j++)
    {
        message[j] = j;
    }

    /*generate key pair only once*/
    if (rsaKeyGenFlag == 0)
    {
        for (int i = 0; i < 3500; i++)
        {
            PublicKey[i] = 0;
            PrivateKey[i] = 0;
        }
        ret = Crypto_HAL_RSA_GenerateKeyPair(MBEDTLS_PK_RSA, RSA_KEY_SIZE, 65537, PublicKey, PrivateKey);
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("RSA key generation failed\n\r");
        }
        else
        {
            PRINTF("RSA key generation success\n\r");

            PRINTF("Public Key:\n\r");
            for (int i = 0; i < strlen((const char *)PublicKey) + 1; i++)
            {
                PRINTF("%02x ", PublicKey[i]);
            }
            PRINTF("\n\r");
            PRINTF("Private Key:\n\r");
            for (int i = 0; i < strlen((const char *)PrivateKey) + 1; i++)
            {
                PRINTF("%02x ", PrivateKey[i]);
            }
            PRINTF("\n\r");
        }
        rsaKeyGenFlag = 1;
    }

    ret = Crypto_HAL_RSA_Sign(PrivateKey, MBEDTLS_MD_SHA256, message, sizeof(message), sig, sizeof(sig), &sig_len);
    if (ret != ERC_NO_ERROR)
    {
        PRINTF("RSA sign failed\n\r");
    }
    else
    {
        PRINTF("RSA sign success\n\r");
        PRINTF("Signature:\n\r");
        for (int i = 0; i < sig_len; i++)
        {
            PRINTF("%02x ", sig[i]);
        }
        PRINTF("\n\r");
        ret = Crypto_HAL_RSA_Verify(PublicKey, MBEDTLS_MD_SHA256, message, sizeof(message), sig, sig_len);
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("RSA verify failed\n\r");
        }
        else
        {
            PRINTF("RSA verify success\n\r");
        }
    }

    ret = Crypto_HAL_RSA_Encrypt(PublicKey, message, (RSA_KEY_SIZE / 8 - 11), cipherBuf, &cipherLen, sizeof(cipherBuf));
    if (ret != ERC_NO_ERROR)
    {
        PRINTF("RSA encrypt failed\n\r");
    }
    else
    {
        PRINTF("RSA encrypt success\n\r");
        PRINTF("Cipher Text:\n\r");
        for (int i = 0; i < cipherLen; i++)
        {
            PRINTF("%02x ", cipherBuf[i]);
        }
        PRINTF("\n\r");

        ret = Crypto_HAL_RSA_Decrypt(PrivateKey, cipherBuf, cipherLen, plainBuf, &plainLen, sizeof(plainBuf));
        if (ret != ERC_NO_ERROR)
        {
            PRINTF("RSA decrypt failed\n\r");
        }
        else
        {
            /*buffer compare*/
            if (buffer_compare(message, plainBuf, plainLen) != 0)
            {
                PRINTF("RSA decrypt failed\n\r");
            }
            else
            {
                PRINTF("RSA decrypt success\n\r");
                PRINTF("Plain Text:\n\r");
                for (int i = 0; i < plainLen; i++)
                {
                    PRINTF("%02x ", plainBuf[i]);
                }
                PRINTF("\n\r");
            }
        }
    }
}
#endif

void MBEDTLS_Alg_test(void)
{
#if defined(PERFORMANCE_FOR_RSA)
    Rsa_test();
#elif defined (PERFORMANCE_FOR_ECDSA)
    ECDSA_test();
#else
    Rsa_test();
    ECDSA_test();
    AES_Cbc_test();
    AES_Ecb_test();
    AES_Cfb_test();
    AES_Ofb_test();
    AES_Ctr_test();
    AES_Cmac_test();
    Crypto_HMAC_test();
    Crypto_Hash_test();
#endif
}