
/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file undefined
 * @brief 
 * 
 */

#include "Fls_Types.h"
/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define FLS_VENDOR_ID_PBCFG_C                      (180)
#define FLS_AR_RELEASE_MAJOR_VERSION_PBCFG_C       (4)
#define FLS_AR_RELEASE_MINOR_VERSION_PBCFG_C       (4)
#define FLS_AR_RELEASE_REVISION_VERSION_PBCFG_C    (0)
#define FLS_SW_MAJOR_VERSION_PBCFG_C               (1)
#define FLS_SW_MINOR_VERSION_PBCFG_C               (0)
#define FLS_SW_PATCH_VERSION_PBCFG_C               (0)

/*==================================================================================================
 *                                       Function Prototypes
==================================================================================================*/

#define FLS_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Fls_MemMap.h"
/*================================================================================================== */
FLS_CONST const Fls_SectorType Fls_SectorConfig[4] ={
    {
        .SectorId = FlsConf_FlsConfigSet_DFLASH_0,
        .SectorStartAddress = 0x0U,
        .SectorSize = 0x800U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x6000000U,
        .PhySectorSize = 0x400U,
        .AsyncAccess = TRUE,
        .SectorHwCh = FLS_CH_INTERN,
    },
    {
        .SectorId = FlsConf_FlsConfigSet_DFLASH_1,
        .SectorStartAddress = 0x800U,
        .SectorSize = 0x400U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x6000800U,
        .PhySectorSize = 0x400U,
        .AsyncAccess = TRUE,
        .SectorHwCh = FLS_CH_INTERN,
    },
    {
        .SectorId = FlsConf_FlsConfigSet_DFLASH_2,
        .SectorStartAddress = 0xc00U,
        .SectorSize = 0x400U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x603fc00U,
        .PhySectorSize = 0x400U,
        .AsyncAccess = TRUE,
        .SectorHwCh = FLS_CH_INTERN,
    },
    {
        .SectorId = FlsConf_FlsConfigSet_PFLASH_0,
        .SectorStartAddress = 0x1000U,
        .SectorSize = 0x800U,
        .PageSize = 0x20U,
        .SectorHwStartAddress = 0x21ff800U,
        .PhySectorSize = 0x800U,
        .AsyncAccess = FALSE,
        .SectorHwCh = FLS_CH_INTERN,
    },
};

FLS_CONST const Fls_SectorProtectType Fls_SectorProtectConfig[FLS_INTERNAL_BLOCK_NUM] ={
                                
    0x0U,
    0x0U,
    0x80000000U,
};


FLS_CONST const Fls_ConfigType Fls_Config = {
    .AcEraseFunPtr = NULL_PTR,
    .AcWriteFunPtr = NULL_PTR,
    .JobEndNotificationFunPtr = NULL_PTR,
    .JobErrorNotificationFunPtr = NULL_PTR,
    .DefaultMode = MEMIF_MODE_SLOW,
    .MaxReadFastMode = 10240U,
    .MaxReadNormalMode = 1024U,
    .MaxWriteFastMode = 256U,
    .MaxWriteNormalMode = 32U,
    .ConfiguredSectorNumber = 4U,
    .SectorList = Fls_SectorConfig,
    .SectorProtection = Fls_SectorProtectConfig,
};

#define FLS_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Fls_MemMap.h"

