/**
*   @file    pSIP_Pcrc.h
*   @version
*
*   @brief   AUTOSAR Pcrc register map
*   @details Register map for PCRC
*
*   @addtogroup ADC_MODULE
*   @{
*/
/*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : Adc
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   Autosar Conf.Variant :
*   SW Version           : V1.0.0
*
*   (c) Copyright 2020-2023 YTMicro Semiconductor, Inc.
*   All Rights Reserved.
==================================================================================================*/
/*==================================================================================================
==================================================================================================*/

#ifndef PSIP_PCRC_H
#define PSIP_PCRC_H

/*=================================================================================================
*                                        INCLUDE FILES
=================================================================================================*/

#include "Std_Types.h"

/*==================================================================================================
*                              PCRC REGISTER MAP
==================================================================================================*/

/**
 * @addtogroup PCRC_Peripheral_Access_Layer PCRC Peripheral Access Layer
 * @{
 */


/** PCRC - Size of Registers Arrays */

/* PCRC Register Layout Typedef */
typedef struct {
    uint32 CTRL;                               /**< Control Register, offset: 0x0000 */
    uint32 POLY;                               /**< Polynomial Register, offset: 0x0004 */
    uint32 INIT;                               /**< Initial Seed Register, offset: 0x0008 */
    union {
        uint32 IN32;                               /**< Data in 32 bits, offset: 0x000C */
        uint16 IN16;                               /**< Data in 16 bits, offset: 0x000C */
        uint8 IN8;                                /**< Data in 8 bits, offset: 0x000C */

    } DATA;
    uint32 RESULT;                             /**< Result Register, offset: 0x0010 */

} PCRC_Type, *PCRC_MemMapPtr;

/** Number of instances of the PCRC module. */
#define PCRC_INSTANCE_COUNT                        (1u)

/* PCRC base address */
#define PCRC_BASE_ADDR32                                  (0x40194000U)
#define PCRC                                              ((volatile PCRC_Type *)(PCRC_BASE_ADDR32))

/** Array initializer of PCRC peripheral base addresses */
#define PCRC_BASE_ADDRS                                    { PCRC_BASE_ADDR32 }
/** Array initializer of PCRC peripheral base pointers */
#define PCRC_BASE_PTRS                                     { PCRC }

#define PCRC_CTRL_OFFSET32                                 (0x0000U)                    /**< Offset for Control Register */
#define PCRC_POLY_OFFSET32                                 (0x0004U)                    /**< Offset for Polynomial Register */
#define PCRC_INIT_OFFSET32                                 (0x0008U)                    /**< Offset for Initial Seed Register */
#define PCRC_DATA_OFFSET32                                 (0x000CU)                    /**< Offset for DATA Register */
#define PCRC_DATA_IN32_OFFSET32                            (0x000CU)                    /**< Offset for Data in 32 bits */
#define PCRC_DATA_IN16_OFFSET16                            (0x000CU)                    /**< Offset for Data in 16 bits */
#define PCRC_DATA_IN8_OFFSET8                             (0x000CU)                    /**< Offset for Data in 8 bits */


#define PCRC_RESULT_OFFSET32                               (0x0010U)                    /**< Offset for Result Register */


/**
 * @addtogroup PCRC Register Mask
 * @{
 */
/* PCRC_CTRL Register */
#define PCRC_CTRL_INV_OUT_MASK                              (0x4000U)
#define PCRC_CTRL_INV_OUT_SHIFT                             (14U)
#define PCRC_CTRL_INV_OUT(x)                                (((uint32)(((uint32)(x)) << PCRC_CTRL_INV_OUT_SHIFT)) & PCRC_CTRL_INV_OUT_MASK)
#define PCRC_CTRL_SWAP_OUT_MASK                             (0x3800U)
#define PCRC_CTRL_SWAP_OUT_SHIFT                            (11U)
#define PCRC_CTRL_SWAP_OUT(x)                               (((uint32)(((uint32)(x)) << PCRC_CTRL_SWAP_OUT_SHIFT)) & PCRC_CTRL_SWAP_OUT_MASK)
#define PCRC_CTRL_SWAP_IN_MASK                              (0x700U)
#define PCRC_CTRL_SWAP_IN_SHIFT                             (8U)
#define PCRC_CTRL_SWAP_IN(x)                                (((uint32)(((uint32)(x)) << PCRC_CTRL_SWAP_IN_SHIFT)) & PCRC_CTRL_SWAP_IN_MASK)
#define PCRC_CTRL_MODE_MASK                                 (0x1FU)
#define PCRC_CTRL_MODE_SHIFT                                (0U)
#define PCRC_CTRL_MODE(x)                                   (((uint32)(((uint32)(x)) << PCRC_CTRL_MODE_SHIFT)) & PCRC_CTRL_MODE_MASK)
/* PCRC_POLY Register */
#define PCRC_POLY_POLY_MASK                                 (0xFFFFFFFFU)
#define PCRC_POLY_POLY_SHIFT                                (0U)
#define PCRC_POLY_POLY(x)                                   (((uint32)(((uint32)(x)) << PCRC_POLY_POLY_SHIFT)) & PCRC_POLY_POLY_MASK)
/* PCRC_INIT Register */
#define PCRC_INIT_SEED_MASK                                 (0xFFFFFFFFU)
#define PCRC_INIT_SEED_SHIFT                                (0U)
#define PCRC_INIT_SEED(x)                                   (((uint32)(((uint32)(x)) << PCRC_INIT_SEED_SHIFT)) & PCRC_INIT_SEED_MASK)
/* PCRC_DATA_IN32 Register */
#define PCRC_DATA_IN32_DATA_MASK                                 (0xFFFFFFFFU)
#define PCRC_DATA_IN32_DATA_SHIFT                                (0U)
#define PCRC_DATA_IN32_DATA(x)                                   (((uint32)(((uint32)(x)) << PCRC_DATA_IN32_DATA_SHIFT)) & PCRC_DATA_IN32_DATA_MASK)
/* PCRC_DATA_IN16 Register */
#define PCRC_DATA_IN16_DATA_MASK                                 (0xFFFFU)
#define PCRC_DATA_IN16_DATA_SHIFT                                (0U)
#define PCRC_DATA_IN16_DATA(x)                                   (((uint32)(((uint32)(x)) << PCRC_DATA_IN16_DATA_SHIFT)) & PCRC_DATA_IN16_DATA_MASK)
/* PCRC_DATA_IN8 Register */
#define PCRC_DATA_IN8_DATA_MASK                                  (0xFFU)
#define PCRC_DATA_IN8_DATA_SHIFT                                 (0U)
#define PCRC_DATA_IN8_DATA(x)                                    (((uint32)(((uint32)(x)) << PCRC_DATA_IN8_DATA_SHIFT)) & PCRC_DATA_IN8_DATA_MASK)

/* PCRC_RESULT Register */
#define PCRC_RESULT_RESULT_MASK                             (0xFFFFFFFFU)
#define PCRC_RESULT_RESULT_SHIFT                            (0U)
#define PCRC_RESULT_RESULT(x)                               (((uint32)(((uint32)(x)) << PCRC_RESULT_RESULT_SHIFT)) & PCRC_RESULT_RESULT_MASK)


/**
 * @}
 */ /* end of group PCRC_Register_Masks */


/**
 * @}
 */ /* end of group PCRC_Peripheral_Access_Layer */

#endif /* PSIP_PCRC_H */

