/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file Port_Cfg.h
 * @brief 
 * 
 */


#ifndef PORT_CFG_H
#define PORT_CFG_H

#ifdef __cplusplus
extern "C"{
#endif


/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PORT_VENDOR_ID_CFG                      (180)
#define PORT_AR_RELEASE_MAJOR_VERSION_CFG       (4)
#define PORT_AR_RELEASE_MINOR_VERSION_CFG       (4)
#define PORT_AR_RELEASE_REVISION_VERSION_CFG    (0)
#define PORT_SW_MAJOR_VERSION_CFG               (2)
#define PORT_SW_MINOR_VERSION_CFG               (3)
#define PORT_SW_PATCH_VERSION_CFG               (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/

/*==================================================================================================
 *                          LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
==================================================================================================*/


/*==================================================================================================
 *                                       LOCAL MACROS
==================================================================================================*/
// PortGeneral
/**
 * @brief Switches the development error detection and notification on or off.
 * @note Trace: ECUC_Port_00123
 *       range: STD_ON, STD_OFF
 */
#define PORT_DEV_ERROR_DETECT                       (STD_ON)

/**
 * @brief Pre-processor switch to enable / disable the use of the function Port_SetPinDirection().
 * @note Trace: ECUC_Port_00131
 *       range: STD_ON, STD_OFF
 */
#define PORT_SET_PIN_DIRECTION_API                   (STD_ON)

/**
 * @brief Pre-processor switch to enable / disable the use of the function Port_SetPinMode().
 * @note Trace: ECUC_Port_00132
 *       range: STD_ON, STD_OFF
 */
#define PORT_SET_PIN_MODE_API                        (STD_ON)

/**
 * @brief Pre-processor switch to enable / disable the API to read out the modules version information.
 * @note Trace: ECUC_Port_00133
 *       range: STD_ON, STD_OFF
 */
#define PORT_VERSION_INFO_API                       (STD_ON)
/**
 * @brief Pre-processor switch to use or not use the post-build config
 * @note range: STD_ON, STD_OFF      
 */
#define PORT_FIXED_PB_CONFIG (STD_OFF)


/**
 * @brief        Pre-compile PORT_HAS_DIGITAL_FILTER
 */
#define PORT_HAS_DIGITAL_FILTER (STD_ON)


/**
 * @brief        Pre-compile PORT_HAS_DIGITAL_FILTER
 */
#define PORT_HAS_SLEW_RATE (STD_ON)


/**
 * @brief        Pre-compile enable PORT_READBACK_ENABLE
 */
#define PORT_READBACK_ENABLE                        (STD_OFF)


#ifdef PORT_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if PORT_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif

/**
* @brief Support for SchM: sync/atomic operations, global interrupt disable/enable.
*        If this parameter has been configured to 'STD_ON', the MCAL driver code supports sync/atomic operations for key resource protection.
*        If it is enabled, all the SchM codes in MCAL Port driver codes will work and support sync/atomic operation with CPU global interrupt enable/disable for key resource protection. 
*        Disable it can reduce code size, but may cause potential risks when access to some critical resource!
*/
#define PORT_SCHM_SUPPORT  (STD_ON) 

/**
* @brief Port Pin symbolic names
* @details Get All Symbolic Names from configuration tool
*
*/

#define PortConf_PortPin_PortPin_PE10      ((Port_PinType)(((4)<<8)|10))
#define PortConf_PortPin_PortPin_U2RX      ((Port_PinType)(((0)<<8)|8))
#define PortConf_PortPin_PortPin_U2TX      ((Port_PinType)(((0)<<8)|9))
#define PortConf_PortPin_PortPin_PTB8      ((Port_PinType)(((1)<<8)|8))
#define PortConf_PortPin_PortPin_PTB9      ((Port_PinType)(((1)<<8)|9))
#define PortConf_PortPin_PortPin_PTB10     ((Port_PinType)(((1)<<8)|10))
#define PortConf_PortPin_PortPin_PTB4      ((Port_PinType)(((1)<<8)|4))
#define PortConf_PortPin_PortPin_PTB5      ((Port_PinType)(((1)<<8)|5))
#define PortConf_PortPin_PortPin_PTE8      ((Port_PinType)(((4)<<8)|8))
#define PortConf_PortPin_PortPin_PTB2      ((Port_PinType)(((1)<<8)|2))
#define PortConf_PortPin_PortPin_PTB3      ((Port_PinType)(((1)<<8)|3))
#define PortConf_PortPin_PortPin_CAN5PTD2   ((Port_PinType)(((3)<<8)|2))
#define PortConf_PortPin_PortPin_CAN5PTD3   ((Port_PinType)(((3)<<8)|3))
#define PortConf_PortPin_PortPin_CAN5PTD4   ((Port_PinType)(((3)<<8)|4))
#define PortConf_PortPin_PortPin_CAN0PTE4   ((Port_PinType)(((4)<<8)|4))
#define PortConf_PortPin_PortPin_CAN0PTE5   ((Port_PinType)(((4)<<8)|5))
#define PortConf_PortPin_PortPin_CAN0PTD5   ((Port_PinType)(((3)<<8)|5))
#define PortConf_PortPin_PortPin_CAN3PTC0   ((Port_PinType)(((2)<<8)|0))
#define PortConf_PortPin_PortPin_CAN3PTC1   ((Port_PinType)(((2)<<8)|1))
#define PortConf_PortPin_PortPin_CAN3PTD9   ((Port_PinType)(((3)<<8)|9))
#define PortConf_PortPin_PortPin_CAN2PTC16   ((Port_PinType)(((2)<<8)|16))
#define PortConf_PortPin_PortPin_CAN2PTC17   ((Port_PinType)(((2)<<8)|17))
#define PortConf_PortPin_PortPin_CAN2PTD8   ((Port_PinType)(((3)<<8)|8))
#define PortConf_PortPin_PortPin_SPI3SDI   ((Port_PinType)(((0)<<8)|11))
#define PortConf_PortPin_PortPin_SPI3SDO   ((Port_PinType)(((0)<<8)|10))
#define PortConf_PortPin_PortPin_SPI3SCK   ((Port_PinType)(((0)<<8)|12))
#define PortConf_PortPin_PortPin_SPI3CS    ((Port_PinType)(((0)<<8)|13))
#define PortConf_PortPin_PortPin_SPI3WP    ((Port_PinType)(((4)<<8)|1))
#define PortConf_PortPin_PortPin_SPI3HOLD   ((Port_PinType)(((4)<<8)|0))
#define PortConf_PortPin_PortPin_ADC0PTA0   ((Port_PinType)(((0)<<8)|0))
#define PortConf_PortPin_PortPin_ADC0PTA1   ((Port_PinType)(((0)<<8)|1))
#define PortConf_PortPin_PortPin_SPI1SDO   ((Port_PinType)(((0)<<8)|27))
#define PortConf_PortPin_PortPin_SPI1SDI   ((Port_PinType)(((0)<<8)|29))
#define PortConf_PortPin_PortPin_SPI1CS    ((Port_PinType)(((1)<<8)|18))
#define PortConf_PortPin_PortPin_SPI2SDO   ((Port_PinType)(((1)<<8)|27))
#define PortConf_PortPin_PortPin_SPI2SDI   ((Port_PinType)(((1)<<8)|28))
#define PortConf_PortPin_PortPin_SPI2CS    ((Port_PinType)(((4)<<8)|13))
#define PortConf_PortPin_PortPin_SPI1SCK   ((Port_PinType)(((0)<<8)|28))
#define PortConf_PortPin_PortPin_SPI2SCK   ((Port_PinType)(((4)<<8)|15))
#define PortConf_PortPin_PortPin_eTMR0CH1   ((Port_PinType)(((1)<<8)|13))
#define PortConf_PortPin_PortPin_Lin0TX    ((Port_PinType)(((1)<<8)|1))
#define PortConf_PortPin_PortPin_Lin0RX    ((Port_PinType)(((1)<<8)|0))
#define PortConf_PortPin_PortPin_Lin0Sl    ((Port_PinType)(((2)<<8)|10))
#define PortConf_PortPin_PortPinLin1RX     ((Port_PinType)(((2)<<8)|8))
#define PortConf_PortPin_PortPinLin1TX     ((Port_PinType)(((2)<<8)|9))
#define PortConf_PortPin_PortPin_Lin1Sl    ((Port_PinType)(((0)<<8)|7))
#define PortConf_PortPin_PortPin_I2C0SCL   ((Port_PinType)(((0)<<8)|3))
#define PortConf_PortPin_PortPin_I2C0SDA   ((Port_PinType)(((0)<<8)|2))
#define PortConf_PortPin_PortPin_I2C0WP    ((Port_PinType)(((1)<<8)|11))

#ifdef __cplusplus
}
#endif

#endif /* PORT_CFG_H */

/** @} */

