/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file Intm_Lld_Cfg.h
 * @brief 
 * 
 */


#ifndef INTM_LLD_CFG_H
#define INTM_LLD_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES                                          
==================================================================================================*/

#include "Intm_Lld_CfgDefines.h"

/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION                                
==================================================================================================*/
#define INTM_LLD_CFG_VENDOR_ID                      (180)
#define INTM_LLD_CFG_AR_RELEASE_MAJOR_VERSION       (4)
#define INTM_LLD_CFG_AR_RELEASE_MINOR_VERSION       (4)
#define INTM_LLD_CFG_AR_RELEASE_REVISION_VERSION    (0)
#define INTM_LLD_CFG_SW_MAJOR_VERSION               (2)
#define INTM_LLD_CFG_SW_MINOR_VERSION               (3)
#define INTM_LLD_CFG_SW_PATCH_VERSION               (0)
/*==================================================================================================
                                      FILE VERSION CHECKS
==================================================================================================*/
/* Check if current file and Intm_Lld_CfgDefines header file are of the same vendor */
#if (INTM_LLD_CFG_VENDOR_ID != INTM_LLD_CFG_DEFINES_VENDOR_ID)
    #error "Intm_Lld_Cfg.h and Intm_Lld_CfgDefines.h have different vendor ids"
#endif

/* Check if current file and Intm_Lld_CfgDefines header file are of the same Software version */
#if ((INTM_LLD_CFG_SW_MAJOR_VERSION != INTM_LLD_CFG_DEFINES_SW_MAJOR_VERSION) || \
     (INTM_LLD_CFG_SW_MINOR_VERSION != INTM_LLD_CFG_DEFINES_SW_MINOR_VERSION) || \
     (INTM_LLD_CFG_SW_PATCH_VERSION != INTM_LLD_CFG_DEFINES_SW_PATCH_VERSION) \
    )
    #error "Software Version Numbers of Intm_Lld_Cfg.h and Intm_Lld_CfgDefines.h are different"
#endif
/*==================================================================================================
                                                DEFINES AND MACROS                                       
==================================================================================================*/
/*==================================================================================================
                                                EXTERNAL CONSTANTS                                        
==================================================================================================*/
/*==================================================================================================
                                                ENUMS                                        
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES                                           
==================================================================================================*/


#ifdef __cplusplus
}
#endif

#endif /* End of file Intm_Lld_Cfg.h */

