/**
*   @file    CddUart_Lld_LinFlexDCfg.h
*   @version 
*   @brief   AUTOSAR CddUart module interface
*   @details API implementation for CddUart driver cfg.
*/
/*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : uart
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   Autosar Conf.Variant :
*   SW Version           : V2.3.0
*   
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd. 
*   All Rights Reserved.
==================================================================================================*/


#ifndef CDDUART_LLD_LINFLEXDCFG_H
#define CDDUART_LLD_LINFLEXDCFG_H

#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
                                         INCLUDE FILES
 1) system and project includes
 2) needed interfaces from external units
 3) internal and external interfaces from this unit
==================================================================================================*/
#include "CddUart_LinFlexD_Types.h"
/*==================================================================================================
*                               FILE VERSION INFORMATION
==================================================================================================*/
#define CDDUART_VENDOR_ID_LINFLEXDUART_CFG                      (180)
#define CDDUART_AR_RELEASE_MAJOR_VERSION_LINFLEXDUART_CFG       (4)
#define CDDUART_AR_RELEASE_MINOR_VERSION_LINFLEXDUART_CFG       (4)
#define CDDUART_AR_RELEASE_REVISION_VERSION_LINFLEXDUART_CFG    (0)
#define CDDUART_SW_MAJOR_VERSION_LINFLEXDUART_CFG               (2)
#define CDDUART_SW_MINOR_VERSION_LINFLEXDUART_CFG               (3)
#define CDDUART_SW_PATCH_VERSION_LINFLEXDUART_CFG               (0)
/*==================================================================================================
*                                            CONSTANTS
==================================================================================================*/

/*==================================================================================================
*                                       DEFINES AND MACROS
==================================================================================================*/
#if defined(CPU_YTM32B1ME0)
#define CDDUART_FLEXUART_INSTANCE_COUNT        (5U)
#elif defined(CPU_YTM32B1MD1)
#define CDDUART_FLEXUART_INSTANCE_COUNT        (3U)
#elif defined(CPU_YTM32B1HA0)
#define CDDUART_FLEXUART_INSTANCE_COUNT        (10U)
#endif
/* @brief Uart has feature DMA enable. */
#define CDDUART_DMA_USED                   (STD_OFF)
/*==================================================================================================
*                                              ENUMS
==================================================================================================*/

/*==================================================================================================
*                                  STRUCTURES AND OTHER TYPEDEFS
==================================================================================================*/


/*==================================================================================================
*                                  GLOBAL VARIABLE DECLARATIONS
==================================================================================================*/
extern const LinFlexd_UartUserConfigType CddUart_Ip_HwConfig_0;

#ifdef __cplusplus
}
#endif

#endif 

