/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file Can_PBcfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C"{
#endif

/**
 * @page misra_violations MISRA-C:2012 violations
 */

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Can.h"
#include "Can_Drv.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CAN_VENDOR_ID_PBCFG_C                      (180)
#define CAN_AR_RELEASE_MAJOR_VERSION_PBCFG_C       (4)
#define CAN_AR_RELEASE_MINOR_VERSION_PBCFG_C       (4)
#define CAN_AR_RELEASE_REVISION_VERSION_PBCFG_C    (0)
#define CAN_SW_MAJOR_VERSION_PBCFG_C               (2)
#define CAN_SW_MINOR_VERSION_PBCFG_C               (3)
#define CAN_SW_PATCH_VERSION_PBCFG_C               (0)

/*==================================================================================================
*                                         CALLBACKS
==================================================================================================*/

#if (CAN_RX_PROCESS_HAS_POLLING == STD_ON)
#define CAN_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Can_MemMap.h"
CAN_CONST const Can_MainFunction_RW Can_MainFunction_Read_CanMainFunctionRWPeriods_5ms = Can_MainFunction_Read_Period_0;
CAN_CONST const Can_MainFunction_RW Can_MainFunction_Read_CanMainFunctionRWPeriods_500ms = Can_MainFunction_Read_Period_1;
#define CAN_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Can_MemMap.h"/*memory map finish*/ 
#endif

#if (CAN_TX_PROCESS_HAS_POLLING == STD_ON)
#define CAN_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Can_MemMap.h"
CAN_CONST const Can_MainFunction_RW Can_MainFunction_Write_CanMainFunctionRWPeriods_5ms = Can_MainFunction_Write_Period_0;
CAN_CONST const Can_MainFunction_RW Can_MainFunction_Write_CanMainFunctionRWPeriods_500ms = Can_MainFunction_Write_Period_1;
#define CAN_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Can_MemMap.h"/*memory map finish*/
#endif

#define CAN_START_SEC_CODE
#include "Can_MemMap.h"
CAN_FUNC __attribute__((weak)) boolean CanReceiveCallOut(uint8 Hrh, Can_IdType CanId, uint8 CanDataLegth, const uint8* CanSduPtr ){(void)Hrh; (void)CanId; (void)CanDataLegth; (void)CanSduPtr; return TRUE;}
CAN_FUNC __attribute__((weak)) void CanTransmitCallOut(PduIdType TxPduId){(void)TxPduId;}

CAN_FUNC __attribute__((weak)) void CanBusoffCan5(void){}
CAN_FUNC __attribute__((weak)) void CanBusoff1(void){}


#define CAN_STOP_SEC_CODE
#include "Can_MemMap.h"
/*==================================================================================================
*                                         CONSTANTS
==================================================================================================*/
#define CAN_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Can_MemMap.h"
#if (CAN_ENHANCE_FIFO_USAGE == STD_ON)




#endif/*#if (CAN_ENHANCE_FIFO_USAGE == STD_ON)*/
#if (CAN_LEGACY_FIFO_USAGE == STD_ON)

CAN_CONST const uint32 Can_GlobalMaskFilterTable_1[1][42] =
{
    {
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
        0x0U,
    },
};

CAN_CONST const Can_GlbMaskFilterConfigType Can_GlobalMaskFltConfig_1[1] =
{
    {
        .MsgIdType      = MIXED,
        .GlobalMaskCode = 0x0U,
        .FilterCodePtr  = Can_GlobalMaskFilterTable_1[0],
    },
};

CAN_CONST const Can_IdvMaskFilterConfigType Can_IndividualMaskFltConfig_1[22] =
{
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
    {
        .MsgIdType  = MIXED,
        .FilterCode = 0x0U,
        .MaskCode   = 0x0U
    },
};


CAN_CONST const Can_LegacyRxFifoConfigType Can_LegacyRxFifoConfig_1 =
{
    .LegacyRxFifoFilterFormat     = CAN_LEGACY_RX_FIFO_FILTER_FORMAT_A,
    .LegacyRxFifoFilterTotalNum   = 64U,
    .LegacyRxFifoOccupyMailboxNum = 22U,
    .FilterNumWithIndividualMask  = 22U,
    .FilterNumWithGlobalMask      = 42U,
    .IndividualMaskFltConfigPtr   = Can_IndividualMaskFltConfig_1,
    .GlobalMaskFltConfigPtr       = Can_GlobalMaskFltConfig_1,
};


#endif/*#if (CAN_LEGACY_FIFO_USAGE == STD_ON)*/

#if (CAN_FD_USAGE == STD_ON)
#endif



CAN_CONST const Can_BdrConfigType CanControllerBaudrateConfig_0[1] = 
{
    {
        .CanBaudrateConfigID = 0U,
        .CanBaudrate         = 500U,
        .CanPreDiv           = 3U,
        .CanPropSeg          = 7U,
        .CanSeg1             = 5U,
        .CanSeg2             = 3U,
        .CanSyncJumpWidth    = 1U,
#if (CAN_FD_USAGE == STD_ON)
        .CanFdBdrConfig = NULL_PTR,
#endif
    },
};


CAN_CONST const Can_BdrConfigType CanControllerBaudrateConfig_1[1] = 
{
    {
        .CanBaudrateConfigID = 0U,
        .CanBaudrate         = 500U,
        .CanPreDiv           = 3U,
        .CanPropSeg          = 7U,
        .CanSeg1             = 5U,
        .CanSeg2             = 3U,
        .CanSyncJumpWidth    = 1U,
#if (CAN_FD_USAGE == STD_ON)
        .CanFdBdrConfig = NULL_PTR,
#endif
    },
};


CAN_CONST const Can_BdrConfigType CanControllerBaudrateConfig_2[1] = 
{
    {
        .CanBaudrateConfigID = 0U,
        .CanBaudrate         = 500U,
        .CanPreDiv           = 3U,
        .CanPropSeg          = 7U,
        .CanSeg1             = 5U,
        .CanSeg2             = 3U,
        .CanSyncJumpWidth    = 1U,
#if (CAN_FD_USAGE == STD_ON)
        .CanFdBdrConfig = NULL_PTR,
#endif
    },
};


CAN_CONST const Can_BdrConfigType CanControllerBaudrateConfig_3[1] = 
{
    {
        .CanBaudrateConfigID = 0U,
        .CanBaudrate         = 500U,
        .CanPreDiv           = 3U,
        .CanPropSeg          = 7U,
        .CanSeg1             = 5U,
        .CanSeg2             = 3U,
        .CanSyncJumpWidth    = 1U,
#if (CAN_FD_USAGE == STD_ON)
        .CanFdBdrConfig = NULL_PTR,
#endif
    },
};

CAN_CONST const Can_MbRegionConfigType MbRegionConfig_0[1] =
{
    {
        .MbPlSizeType     = CAN_PLSIZE_8_BYTES,
        .MbMsgBufferNum   = 32U,
        .PayloadSize      = 8U,
        .PayloadRamLength = 16U
    },
};
CAN_CONST const Can_MbRegionConfigType MbRegionConfig_1[2] =
{
    {
        .MbPlSizeType     = CAN_PLSIZE_8_BYTES,
        .MbMsgBufferNum   = 32U,
        .PayloadSize      = 8U,
        .PayloadRamLength = 16U
    },
    {
        .MbPlSizeType     = CAN_PLSIZE_8_BYTES,
        .MbMsgBufferNum   = 32U,
        .PayloadSize      = 8U,
        .PayloadRamLength = 16U
    },
};
CAN_CONST const Can_MbRegionConfigType MbRegionConfig_2[1] =
{
    {
        .MbPlSizeType     = CAN_PLSIZE_8_BYTES,
        .MbMsgBufferNum   = 32U,
        .PayloadSize      = 8U,
        .PayloadRamLength = 16U
    },
};
CAN_CONST const Can_MbRegionConfigType MbRegionConfig_3[2] =
{
    {
        .MbPlSizeType     = CAN_PLSIZE_8_BYTES,
        .MbMsgBufferNum   = 32U,
        .PayloadSize      = 8U,
        .PayloadRamLength = 16U
    },
    {
        .MbPlSizeType     = CAN_PLSIZE_8_BYTES,
        .MbMsgBufferNum   = 32U,
        .PayloadSize      = 8U,
        .PayloadRamLength = 16U
    },
};


CAN_CONST const Can_PayloadConfigType    Can_PayloadConfig_0 =
{
    .MbRegionNum     = (Can_HwObjRegionType)1U,
    .MbRegionConfig  = MbRegionConfig_0,
    .ChPayloadMaxNum = 32U,
    .RxFifoType      = CAN_RX_FIFO_NONE,
#if (CAN_ENHANCE_FIFO_USAGE == STD_ON)
    .EnhanceRxFifoConfigPtr = NULL_PTR, /*!< Point the rx fifo config */
#endif
#if (CAN_LEGACY_FIFO_USAGE == STD_ON)
    .LegacyRxFifoConfigPtr  = NULL_PTR,
#endif
};

CAN_CONST const Can_PayloadConfigType    Can_PayloadConfig_1 =
{
    .MbRegionNum     = (Can_HwObjRegionType)2U,
    .MbRegionConfig  = MbRegionConfig_1,
    .ChPayloadMaxNum = 64U,
    .RxFifoType      = CAN_RX_FIFO_LEGACY,
#if (CAN_ENHANCE_FIFO_USAGE == STD_ON)
    .EnhanceRxFifoConfigPtr = NULL_PTR, /*!< Point the rx fifo config */
#endif
#if (CAN_LEGACY_FIFO_USAGE == STD_ON)
    .LegacyRxFifoConfigPtr  = &Can_LegacyRxFifoConfig_1,
#endif
};

CAN_CONST const Can_PayloadConfigType    Can_PayloadConfig_2 =
{
    .MbRegionNum     = (Can_HwObjRegionType)1U,
    .MbRegionConfig  = MbRegionConfig_2,
    .ChPayloadMaxNum = 32U,
    .RxFifoType      = CAN_RX_FIFO_NONE,
#if (CAN_ENHANCE_FIFO_USAGE == STD_ON)
    .EnhanceRxFifoConfigPtr = NULL_PTR, /*!< Point the rx fifo config */
#endif
#if (CAN_LEGACY_FIFO_USAGE == STD_ON)
    .LegacyRxFifoConfigPtr  = NULL_PTR,
#endif
};

CAN_CONST const Can_PayloadConfigType    Can_PayloadConfig_3 =
{
    .MbRegionNum     = (Can_HwObjRegionType)2U,
    .MbRegionConfig  = MbRegionConfig_3,
    .ChPayloadMaxNum = 64U,
    .RxFifoType      = CAN_RX_FIFO_NONE,
#if (CAN_ENHANCE_FIFO_USAGE == STD_ON)
    .EnhanceRxFifoConfigPtr = NULL_PTR, /*!< Point the rx fifo config */
#endif
#if (CAN_LEGACY_FIFO_USAGE == STD_ON)
    .LegacyRxFifoConfigPtr  = NULL_PTR,
#endif
};

CAN_CONST const Can_FilterOfMbType Can_FilterConfig_1[1] =
{
    {
        .FilterCode = 0x101U,
        .MaskCode   = 0x7F8U,
    }
};
CAN_CONST const Can_FilterOfMbType Can_FilterConfig_2[1] =
{
    {
        .FilterCode = 0x10011001U,
        .MaskCode   = 0x0U,
    }
};
CAN_CONST const Can_FilterOfMbType Can_FilterConfig_3[1] =
{
    {
        .FilterCode = 0x100U,
        .MaskCode   = 0x0U,
    }
};



CAN_CONST const Can_HohConfigType Can_HohConfig[6] =
{
    {
        .CanObjId          = 0U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_0,
        .CanHwObjNum       = 15U,
        .ObjectType        = CAN_TRANSMIT,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (CAN_FD_USAGE == STD_ON)
        .CanFdPaddingValue = 0xccU,
#endif
#if (DEVELOPPING == STD_ON)
        .TrigTransEnable   = FALSE,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
        .CanHwFlagStartId  = 17,
        .CanHwObjStartId = 17
    },
    {
        .CanObjId          = 1U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_0,
        .CanHwObjNum       = 1U,
        .ObjectType        = CAN_RECEIVE,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
        .MsgIdType         = EXTENDED,
        .FilterConfig      = Can_FilterConfig_1,
        .CanHwFlagStartId  = 0,
        .CanHwObjStartId = 0
    },
    {
        .CanObjId          = 2U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_0,
        .CanHwObjNum       = 1U,
        .ObjectType        = CAN_RECEIVE,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
        .MsgIdType         = EXTENDED,
        .FilterConfig      = Can_FilterConfig_2,
        .CanHwFlagStartId  = 1,
        .CanHwObjStartId = 1
    },
    {
        .CanObjId          = 3U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_0,
        .CanHwObjNum       = 15U,
        .ObjectType        = CAN_RECEIVE,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
        .MsgIdType         = MIXED,
        .FilterConfig      = Can_FilterConfig_3,
        .CanHwFlagStartId  = 2,
        .CanHwObjStartId = 2
    },
    {
        .CanObjId          = 4U,
        .CanChannelId      = 1U,
        .CanHwObjRegionId  = CAN_RAM_REGION_1,
        .CanHwObjNum       = 32U,
        .ObjectType        = CAN_TRANSMIT,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (CAN_FD_USAGE == STD_ON)
        .CanFdPaddingValue = 0xccU,
#endif
#if (DEVELOPPING == STD_ON)
        .TrigTransEnable   = FALSE,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
        .CanHwFlagStartId  = 32,
        .CanHwObjStartId = 0
    },
    {
        .CanObjId          = 5U,
        .CanChannelId      = 1U,
        .CanHwObjRegionId  = CAN_RX_FIFO_LEGACY,
        .CanHwObjNum       = 22U,
        .ObjectType        = CAN_RECEIVE,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
        .CanHwFlagStartId  = 0,
        .CanHwObjStartId = 0
    },
};

#if (CAN_RX_PROCESS_HAS_POLLING == STD_ON)

CAN_CONST const Can_HohPolPeriodType CanHrhPolPeriodTable[2] =
{
    /* Polling Name: CanMainFunctionRWPeriods_5ms */
    {
        .CanPeriodId       = 0U,
        .CanHohNum         = 0U,
        .CanPolTablePtr    = NULL_PTR,
    },
    /* Polling Name: CanMainFunctionRWPeriods_500ms */
    {
        .CanPeriodId       = 1U,
        .CanHohNum         = 0U,
        .CanPolTablePtr    = NULL_PTR,
    },
};
#endif

#if (CAN_TX_PROCESS_HAS_POLLING == STD_ON)

CAN_CONST const Can_HohPolPeriodType CanHthPolPeriodTable[2] =
{
    /* Polling Name: CanMainFunctionRWPeriods_5ms */
    {
        .CanPeriodId       = 0U,
        .CanHohNum         = 0U,
        .CanPolTablePtr    = NULL_PTR,
    },
    /* Polling Name: CanMainFunctionRWPeriods_500ms */
    {
        .CanPeriodId       = 1U,
        .CanHohNum         = 0U,
        .CanPolTablePtr    = NULL_PTR,
    },
};
#endif


/**
 * @brief This map is used to translate the 'CAN hardware ID' to 'a logical ID'.
 */
CAN_CONST const uint8 Can_HwIdTable[8] = { 1U, 255U, 3U, 2U, 255U, 0U, 255U, 255U,  };

/**
 * @brief This map is used to convert a mailbox flag ID to the HOH ID and region for CanController_0.
 */
CAN_CONST const Can_MbFlagMatrixType Can_HwFlagMatrixConfig_0[32] =
{
    /* Flag id: 0 */
    {
        .CanHwObjId    = 0,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 1,
    },
    /* Flag id: 1 */
    {
        .CanHwObjId    = 1,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 2,
    },
    /* Flag id: 2 */
    {
        .CanHwObjId    = 2,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 3,
    },
    /* Flag id: 3 */
    {
        .CanHwObjId    = 3,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 3,
    },
    /* Flag id: 4 */
    {
        .CanHwObjId    = 4,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 3,
    },
    /* Flag id: 5 */
    {
        .CanHwObjId    = 5,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 3,
    },
    /* Flag id: 6 */
    {
        .CanHwObjId    = 6,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 3,
    },
    /* Flag id: 7 */
    {
        .CanHwObjId    = 7,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 3,
    },
    /* Flag id: 8 */
    {
        .CanHwObjId    = 8,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 3,
    },
    /* Flag id: 9 */
    {
        .CanHwObjId    = 9,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 3,
    },
    /* Flag id: 10 */
    {
        .CanHwObjId    = 10,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 3,
    },
    /* Flag id: 11 */
    {
        .CanHwObjId    = 11,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 3,
    },
    /* Flag id: 12 */
    {
        .CanHwObjId    = 12,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 3,
    },
    /* Flag id: 13 */
    {
        .CanHwObjId    = 13,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 3,
    },
    /* Flag id: 14 */
    {
        .CanHwObjId    = 14,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 3,
    },
    /* Flag id: 15 */
    {
        .CanHwObjId    = 15,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 3,
    },
    /* Flag id: 16 */
    {
        .CanHwObjId    = 16,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 3,
    },
    /* Flag id: 17 */
    {
        .CanHwObjId    = 17,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
    /* Flag id: 18 */
    {
        .CanHwObjId    = 18,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
    /* Flag id: 19 */
    {
        .CanHwObjId    = 19,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
    /* Flag id: 20 */
    {
        .CanHwObjId    = 20,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
    /* Flag id: 21 */
    {
        .CanHwObjId    = 21,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
    /* Flag id: 22 */
    {
        .CanHwObjId    = 22,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
    /* Flag id: 23 */
    {
        .CanHwObjId    = 23,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
    /* Flag id: 24 */
    {
        .CanHwObjId    = 24,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
    /* Flag id: 25 */
    {
        .CanHwObjId    = 25,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
    /* Flag id: 26 */
    {
        .CanHwObjId    = 26,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
    /* Flag id: 27 */
    {
        .CanHwObjId    = 27,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
    /* Flag id: 28 */
    {
        .CanHwObjId    = 28,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
    /* Flag id: 29 */
    {
        .CanHwObjId    = 29,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
    /* Flag id: 30 */
    {
        .CanHwObjId    = 30,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
    /* Flag id: 31 */
    {
        .CanHwObjId    = 31,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
};

/**
 * @brief This map is used to convert a mailbox flag ID to the HOH ID and region for CanController_1.
 */
CAN_CONST const Can_MbFlagMatrixType Can_HwFlagMatrixConfig_1[64] =
{
    /* Flag id: 0 */
    {
        .CanHwObjId    = 0,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 1 */
    {
        .CanHwObjId    = 1,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 2 */
    {
        .CanHwObjId    = 2,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 3 */
    {
        .CanHwObjId    = 3,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 4 */
    {
        .CanHwObjId    = 4,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 5 */
    {
        .CanHwObjId    = 5,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 6 */
    {
        .CanHwObjId    = 6,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 7 */
    {
        .CanHwObjId    = 7,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 8 */
    {
        .CanHwObjId    = 8,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 9 */
    {
        .CanHwObjId    = 9,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 10 */
    {
        .CanHwObjId    = 10,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 11 */
    {
        .CanHwObjId    = 11,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 12 */
    {
        .CanHwObjId    = 12,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 13 */
    {
        .CanHwObjId    = 13,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 14 */
    {
        .CanHwObjId    = 14,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 15 */
    {
        .CanHwObjId    = 15,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 16 */
    {
        .CanHwObjId    = 16,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 17 */
    {
        .CanHwObjId    = 17,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 18 */
    {
        .CanHwObjId    = 18,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 19 */
    {
        .CanHwObjId    = 19,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 20 */
    {
        .CanHwObjId    = 20,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 21 */
    {
        .CanHwObjId    = 21,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 5,
    },
    /* Flag id: 22 */
    {
        .CanHwObjId    = 22,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 23 */
    {
        .CanHwObjId    = 23,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 24 */
    {
        .CanHwObjId    = 24,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 25 */
    {
        .CanHwObjId    = 25,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 26 */
    {
        .CanHwObjId    = 26,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 27 */
    {
        .CanHwObjId    = 27,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 28 */
    {
        .CanHwObjId    = 28,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 29 */
    {
        .CanHwObjId    = 29,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 30 */
    {
        .CanHwObjId    = 30,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 31 */
    {
        .CanHwObjId    = 31,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 32 */
    {
        .CanHwObjId    = 0,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 33 */
    {
        .CanHwObjId    = 1,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 34 */
    {
        .CanHwObjId    = 2,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 35 */
    {
        .CanHwObjId    = 3,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 36 */
    {
        .CanHwObjId    = 4,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 37 */
    {
        .CanHwObjId    = 5,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 38 */
    {
        .CanHwObjId    = 6,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 39 */
    {
        .CanHwObjId    = 7,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 40 */
    {
        .CanHwObjId    = 8,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 41 */
    {
        .CanHwObjId    = 9,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 42 */
    {
        .CanHwObjId    = 10,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 43 */
    {
        .CanHwObjId    = 11,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 44 */
    {
        .CanHwObjId    = 12,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 45 */
    {
        .CanHwObjId    = 13,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 46 */
    {
        .CanHwObjId    = 14,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 47 */
    {
        .CanHwObjId    = 15,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 48 */
    {
        .CanHwObjId    = 16,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 49 */
    {
        .CanHwObjId    = 17,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 50 */
    {
        .CanHwObjId    = 18,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 51 */
    {
        .CanHwObjId    = 19,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 52 */
    {
        .CanHwObjId    = 20,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 53 */
    {
        .CanHwObjId    = 21,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 54 */
    {
        .CanHwObjId    = 22,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 55 */
    {
        .CanHwObjId    = 23,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 56 */
    {
        .CanHwObjId    = 24,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 57 */
    {
        .CanHwObjId    = 25,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 58 */
    {
        .CanHwObjId    = 26,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 59 */
    {
        .CanHwObjId    = 27,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 60 */
    {
        .CanHwObjId    = 28,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 61 */
    {
        .CanHwObjId    = 29,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 62 */
    {
        .CanHwObjId    = 30,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
    /* Flag id: 63 */
    {
        .CanHwObjId    = 31,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 4,
    },
};

/**
 * @brief This map is used to convert a mailbox flag ID to the HOH ID and region for CanController_2.
 */
CAN_CONST const Can_MbFlagMatrixType Can_HwFlagMatrixConfig_2[32] =
{
    /* Flag id: 0 */
    {
        .CanHwObjId    = 0,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 1 */
    {
        .CanHwObjId    = 1,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 2 */
    {
        .CanHwObjId    = 2,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 3 */
    {
        .CanHwObjId    = 3,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 4 */
    {
        .CanHwObjId    = 4,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 5 */
    {
        .CanHwObjId    = 5,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 6 */
    {
        .CanHwObjId    = 6,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 7 */
    {
        .CanHwObjId    = 7,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 8 */
    {
        .CanHwObjId    = 8,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 9 */
    {
        .CanHwObjId    = 9,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 10 */
    {
        .CanHwObjId    = 10,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 11 */
    {
        .CanHwObjId    = 11,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 12 */
    {
        .CanHwObjId    = 12,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 13 */
    {
        .CanHwObjId    = 13,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 14 */
    {
        .CanHwObjId    = 14,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 15 */
    {
        .CanHwObjId    = 15,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 16 */
    {
        .CanHwObjId    = 16,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 17 */
    {
        .CanHwObjId    = 17,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 18 */
    {
        .CanHwObjId    = 18,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 19 */
    {
        .CanHwObjId    = 19,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 20 */
    {
        .CanHwObjId    = 20,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 21 */
    {
        .CanHwObjId    = 21,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 22 */
    {
        .CanHwObjId    = 22,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 23 */
    {
        .CanHwObjId    = 23,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 24 */
    {
        .CanHwObjId    = 24,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 25 */
    {
        .CanHwObjId    = 25,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 26 */
    {
        .CanHwObjId    = 26,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 27 */
    {
        .CanHwObjId    = 27,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 28 */
    {
        .CanHwObjId    = 28,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 29 */
    {
        .CanHwObjId    = 29,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 30 */
    {
        .CanHwObjId    = 30,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 31 */
    {
        .CanHwObjId    = 31,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
};

/**
 * @brief This map is used to convert a mailbox flag ID to the HOH ID and region for CanController_3.
 */
CAN_CONST const Can_MbFlagMatrixType Can_HwFlagMatrixConfig_3[64] =
{
    /* Flag id: 0 */
    {
        .CanHwObjId    = 0,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 1 */
    {
        .CanHwObjId    = 1,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 2 */
    {
        .CanHwObjId    = 2,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 3 */
    {
        .CanHwObjId    = 3,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 4 */
    {
        .CanHwObjId    = 4,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 5 */
    {
        .CanHwObjId    = 5,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 6 */
    {
        .CanHwObjId    = 6,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 7 */
    {
        .CanHwObjId    = 7,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 8 */
    {
        .CanHwObjId    = 8,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 9 */
    {
        .CanHwObjId    = 9,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 10 */
    {
        .CanHwObjId    = 10,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 11 */
    {
        .CanHwObjId    = 11,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 12 */
    {
        .CanHwObjId    = 12,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 13 */
    {
        .CanHwObjId    = 13,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 14 */
    {
        .CanHwObjId    = 14,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 15 */
    {
        .CanHwObjId    = 15,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 16 */
    {
        .CanHwObjId    = 16,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 17 */
    {
        .CanHwObjId    = 17,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 18 */
    {
        .CanHwObjId    = 18,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 19 */
    {
        .CanHwObjId    = 19,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 20 */
    {
        .CanHwObjId    = 20,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 21 */
    {
        .CanHwObjId    = 21,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 22 */
    {
        .CanHwObjId    = 22,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 23 */
    {
        .CanHwObjId    = 23,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 24 */
    {
        .CanHwObjId    = 24,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 25 */
    {
        .CanHwObjId    = 25,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 26 */
    {
        .CanHwObjId    = 26,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 27 */
    {
        .CanHwObjId    = 27,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 28 */
    {
        .CanHwObjId    = 28,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 29 */
    {
        .CanHwObjId    = 29,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 30 */
    {
        .CanHwObjId    = 30,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 31 */
    {
        .CanHwObjId    = 31,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 32 */
    {
        .CanHwObjId    = 0,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 33 */
    {
        .CanHwObjId    = 1,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 34 */
    {
        .CanHwObjId    = 2,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 35 */
    {
        .CanHwObjId    = 3,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 36 */
    {
        .CanHwObjId    = 4,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 37 */
    {
        .CanHwObjId    = 5,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 38 */
    {
        .CanHwObjId    = 6,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 39 */
    {
        .CanHwObjId    = 7,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 40 */
    {
        .CanHwObjId    = 8,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 41 */
    {
        .CanHwObjId    = 9,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 42 */
    {
        .CanHwObjId    = 10,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 43 */
    {
        .CanHwObjId    = 11,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 44 */
    {
        .CanHwObjId    = 12,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 45 */
    {
        .CanHwObjId    = 13,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 46 */
    {
        .CanHwObjId    = 14,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 47 */
    {
        .CanHwObjId    = 15,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 48 */
    {
        .CanHwObjId    = 16,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 49 */
    {
        .CanHwObjId    = 17,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 50 */
    {
        .CanHwObjId    = 18,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 51 */
    {
        .CanHwObjId    = 19,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 52 */
    {
        .CanHwObjId    = 20,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 53 */
    {
        .CanHwObjId    = 21,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 54 */
    {
        .CanHwObjId    = 22,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 55 */
    {
        .CanHwObjId    = 23,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 56 */
    {
        .CanHwObjId    = 24,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 57 */
    {
        .CanHwObjId    = 25,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 58 */
    {
        .CanHwObjId    = 26,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 59 */
    {
        .CanHwObjId    = 27,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 60 */
    {
        .CanHwObjId    = 28,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 61 */
    {
        .CanHwObjId    = 29,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 62 */
    {
        .CanHwObjId    = 30,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 63 */
    {
        .CanHwObjId    = 31,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
};


/**
 * @brief This is callback enable list for CanController_0
 */
CAN_CONST const Can_CallbackEntranceType Can_CallbackEntrance_0 =
{
#if ((CAN_LEGACY_FIFO_USAGE == STD_ON) || (CAN_ENHANCE_FIFO_USAGE == STD_ON))
    .ReceiveFifoFullCallback      = NULL_PTR,
    .ReceiveFifoOverflowCallback  = NULL_PTR,
#endif
    .OverrunCallback              = NULL_PTR,
    .WarningCallback              = NULL_PTR,
    .BusoffCallback               = CanBusoffCan5,
    .ErrorCallback                = NULL_PTR,
    .ErrFastCallback              = NULL_PTR,
    .ErrNceCallback               = NULL_PTR,
    .ErrCeCallback                = NULL_PTR,
#if (CAN_WAKEUP_SUPPORT == STD_ON)
    .WakeupCallback               = NULL_PTR,
#endif
#if (CAN_ICOM_USAGE == STD_ON)
    .IcomCallback                 = NULL_PTR,
#endif
};

/**
 * @brief This is callback enable list for CanController_1
 */
CAN_CONST const Can_CallbackEntranceType Can_CallbackEntrance_1 =
{
#if ((CAN_LEGACY_FIFO_USAGE == STD_ON) || (CAN_ENHANCE_FIFO_USAGE == STD_ON))
    .ReceiveFifoFullCallback      = NULL_PTR,
    .ReceiveFifoOverflowCallback  = NULL_PTR,
#endif
    .OverrunCallback              = NULL_PTR,
    .WarningCallback              = NULL_PTR,
    .BusoffCallback               = CanBusoff1,
    .ErrorCallback                = NULL_PTR,
    .ErrFastCallback              = NULL_PTR,
    .ErrNceCallback               = NULL_PTR,
    .ErrCeCallback                = NULL_PTR,
#if (CAN_WAKEUP_SUPPORT == STD_ON)
    .WakeupCallback               = NULL_PTR,
#endif
#if (CAN_ICOM_USAGE == STD_ON)
    .IcomCallback                 = NULL_PTR,
#endif
};

/**
 * @brief This is callback enable list for CanController_2
 */
CAN_CONST const Can_CallbackEntranceType Can_CallbackEntrance_2 =
{
#if ((CAN_LEGACY_FIFO_USAGE == STD_ON) || (CAN_ENHANCE_FIFO_USAGE == STD_ON))
    .ReceiveFifoFullCallback      = NULL_PTR,
    .ReceiveFifoOverflowCallback  = NULL_PTR,
#endif
    .OverrunCallback              = NULL_PTR,
    .WarningCallback              = NULL_PTR,
    .BusoffCallback               = NULL_PTR,
    .ErrorCallback                = NULL_PTR,
    .ErrFastCallback              = NULL_PTR,
    .ErrNceCallback               = NULL_PTR,
    .ErrCeCallback                = NULL_PTR,
#if (CAN_WAKEUP_SUPPORT == STD_ON)
    .WakeupCallback               = NULL_PTR,
#endif
#if (CAN_ICOM_USAGE == STD_ON)
    .IcomCallback                 = NULL_PTR,
#endif
};

/**
 * @brief This is callback enable list for CanController_3
 */
CAN_CONST const Can_CallbackEntranceType Can_CallbackEntrance_3 =
{
#if ((CAN_LEGACY_FIFO_USAGE == STD_ON) || (CAN_ENHANCE_FIFO_USAGE == STD_ON))
    .ReceiveFifoFullCallback      = NULL_PTR,
    .ReceiveFifoOverflowCallback  = NULL_PTR,
#endif
    .OverrunCallback              = NULL_PTR,
    .WarningCallback              = NULL_PTR,
    .BusoffCallback               = NULL_PTR,
    .ErrorCallback                = NULL_PTR,
    .ErrFastCallback              = NULL_PTR,
    .ErrNceCallback               = NULL_PTR,
    .ErrCeCallback                = NULL_PTR,
#if (CAN_WAKEUP_SUPPORT == STD_ON)
    .WakeupCallback               = NULL_PTR,
#endif
#if (CAN_ICOM_USAGE == STD_ON)
    .IcomCallback                 = NULL_PTR,
#endif
};


CAN_CONST const Can_ChannelConfigType Can_ChannelConfig[4] =
{
    {
        .CanChannelId            = 0U,
        .CanHwChId               = FLEXCAN_5,
        .CanChActivation         = TRUE,
        .ChBaseAddr              = 0x4003E000U,
        .CanTrippleSamp          = FALSE,
        /* Do not need to take care of 'CanAutoBusoffRecovery' param, The driver ensures that
           when a Busoff occurs, the Can controller will always enter the STOPPED state and
           has complied with MCAL requirements */
        .CanAutoBusoffRecovery   = FALSE,
        .CanRxProcessing         = CAN_PROCESS_MIXED,
        .CanTxProcessing         = CAN_PROCESS_MIXED,
        .CanBusoffProcessing     = CAN_PROCESS_INTERRUPT,
#if (CAN_WAKEUP_SUPPORT == STD_ON)
        .CanWakeupProcessing     = CAN_PROCESS_INTERRUPT,
        .CanWakeupSupport        = FALSE,
        .EcuMWakeupSource        = (EcuM_WakeupSourceType)0,
#endif
#if (CAN_WAKEUP_FUNCTIONALITY_API == STD_ON)
        .CanWakeupFunctionalityAPI = TRUE,
#endif
#if (CAN_FD_USAGE == STD_ON)
        .FdUsage                 = FALSE,
        .IsoModeUsage            = TRUE,
#endif
#if (CAN_DMA_USAGE == STD_ON)
        .CanDmaUsage             = FALSE,
        .CanDmaChannel           = 255U,
#endif
        .CanTimeQuantaSource     = CAN_CLOCK_SOURCE_OSC,
        .ChBaudrateNum           = 1U,
        .DefaultBdrConfig        = &CanControllerBaudrateConfig_0[0],
        .BdrConfigPtr            = CanControllerBaudrateConfig_0,
        .PayloadConfigPtr        = &Can_PayloadConfig_0,
        .CanCallbackPtr          = &Can_CallbackEntrance_0,
        .CanFifoHrhId            = 255U,
        .CanHwFlagMatrixPtr      = Can_HwFlagMatrixConfig_0,
        .RamMbNum                = 32U,
        .RamIrmqEn               = TRUE,
#if (CAN_MEMECC_FEATURE == STD_ON)
        .RamEnhFifoEn            = FALSE,
        .RamHrTimeStmpEn         = TRUE,
        .RamEnhMbMemEn           = FALSE,
#endif
    },
    {
        .CanChannelId            = 1U,
        .CanHwChId               = FLEXCAN_0,
        .CanChActivation         = TRUE,
        .ChBaseAddr              = 0x40030000U,
        .CanTrippleSamp          = FALSE,
        /* Do not need to take care of 'CanAutoBusoffRecovery' param, The driver ensures that
           when a Busoff occurs, the Can controller will always enter the STOPPED state and
           has complied with MCAL requirements */
        .CanAutoBusoffRecovery   = FALSE,
        .CanRxProcessing         = CAN_PROCESS_MIXED,
        .CanTxProcessing         = CAN_PROCESS_MIXED,
        .CanBusoffProcessing     = CAN_PROCESS_INTERRUPT,
#if (CAN_WAKEUP_SUPPORT == STD_ON)
        .CanWakeupProcessing     = CAN_PROCESS_INTERRUPT,
        .CanWakeupSupport        = FALSE,
        .EcuMWakeupSource        = (EcuM_WakeupSourceType)0,
#endif
#if (CAN_WAKEUP_FUNCTIONALITY_API == STD_ON)
        .CanWakeupFunctionalityAPI = FALSE,
#endif
#if (CAN_FD_USAGE == STD_ON)
        .FdUsage                 = FALSE,
        .IsoModeUsage            = FALSE,
#endif
#if (CAN_DMA_USAGE == STD_ON)
        .CanDmaUsage             = TRUE,
        .CanDmaChannel           = 7U,
#endif
        .CanTimeQuantaSource     = CAN_CLOCK_SOURCE_OSC,
        .ChBaudrateNum           = 1U,
        .DefaultBdrConfig        = &CanControllerBaudrateConfig_1[0],
        .BdrConfigPtr            = CanControllerBaudrateConfig_1,
        .PayloadConfigPtr        = &Can_PayloadConfig_1,
        .CanCallbackPtr          = &Can_CallbackEntrance_1,
        .CanFifoHrhId            = 5U,
        .CanHwFlagMatrixPtr      = Can_HwFlagMatrixConfig_1,
        .RamMbNum                = 64U,
        .RamIrmqEn               = TRUE,
#if (CAN_MEMECC_FEATURE == STD_ON)
        .RamEnhFifoEn            = TRUE,
        .RamHrTimeStmpEn         = TRUE,
        .RamEnhMbMemEn           = FALSE,
#endif
    },
    {
        .CanChannelId            = 2U,
        .CanHwChId               = FLEXCAN_3,
        .CanChActivation         = TRUE,
        .ChBaseAddr              = 0x4003C000U,
        .CanTrippleSamp          = FALSE,
        /* Do not need to take care of 'CanAutoBusoffRecovery' param, The driver ensures that
           when a Busoff occurs, the Can controller will always enter the STOPPED state and
           has complied with MCAL requirements */
        .CanAutoBusoffRecovery   = FALSE,
        .CanRxProcessing         = CAN_PROCESS_MIXED,
        .CanTxProcessing         = CAN_PROCESS_MIXED,
        .CanBusoffProcessing     = CAN_PROCESS_INTERRUPT,
#if (CAN_WAKEUP_SUPPORT == STD_ON)
        .CanWakeupProcessing     = CAN_PROCESS_INTERRUPT,
        .CanWakeupSupport        = FALSE,
        .EcuMWakeupSource        = (EcuM_WakeupSourceType)0,
#endif
#if (CAN_WAKEUP_FUNCTIONALITY_API == STD_ON)
        .CanWakeupFunctionalityAPI = FALSE,
#endif
#if (CAN_FD_USAGE == STD_ON)
        .FdUsage                 = FALSE,
        .IsoModeUsage            = TRUE,
#endif
#if (CAN_DMA_USAGE == STD_ON)
        .CanDmaUsage             = FALSE,
        .CanDmaChannel           = 255U,
#endif
        .CanTimeQuantaSource     = CAN_CLOCK_SOURCE_OSC,
        .ChBaudrateNum           = 1U,
        .DefaultBdrConfig        = &CanControllerBaudrateConfig_2[0],
        .BdrConfigPtr            = CanControllerBaudrateConfig_2,
        .PayloadConfigPtr        = &Can_PayloadConfig_2,
        .CanCallbackPtr          = &Can_CallbackEntrance_2,
        .CanFifoHrhId            = 255U,
        .CanHwFlagMatrixPtr      = Can_HwFlagMatrixConfig_2,
        .RamMbNum                = 32U,
        .RamIrmqEn               = TRUE,
#if (CAN_MEMECC_FEATURE == STD_ON)
        .RamEnhFifoEn            = FALSE,
        .RamHrTimeStmpEn         = TRUE,
        .RamEnhMbMemEn           = FALSE,
#endif
    },
    {
        .CanChannelId            = 3U,
        .CanHwChId               = FLEXCAN_2,
        .CanChActivation         = TRUE,
        .ChBaseAddr              = 0x40038000U,
        .CanTrippleSamp          = FALSE,
        /* Do not need to take care of 'CanAutoBusoffRecovery' param, The driver ensures that
           when a Busoff occurs, the Can controller will always enter the STOPPED state and
           has complied with MCAL requirements */
        .CanAutoBusoffRecovery   = FALSE,
        .CanRxProcessing         = CAN_PROCESS_MIXED,
        .CanTxProcessing         = CAN_PROCESS_MIXED,
        .CanBusoffProcessing     = CAN_PROCESS_INTERRUPT,
#if (CAN_WAKEUP_SUPPORT == STD_ON)
        .CanWakeupProcessing     = CAN_PROCESS_INTERRUPT,
        .CanWakeupSupport        = FALSE,
        .EcuMWakeupSource        = (EcuM_WakeupSourceType)0,
#endif
#if (CAN_WAKEUP_FUNCTIONALITY_API == STD_ON)
        .CanWakeupFunctionalityAPI = FALSE,
#endif
#if (CAN_FD_USAGE == STD_ON)
        .FdUsage                 = FALSE,
        .IsoModeUsage            = TRUE,
#endif
#if (CAN_DMA_USAGE == STD_ON)
        .CanDmaUsage             = FALSE,
        .CanDmaChannel           = 255U,
#endif
        .CanTimeQuantaSource     = CAN_CLOCK_SOURCE_OSC,
        .ChBaudrateNum           = 1U,
        .DefaultBdrConfig        = &CanControllerBaudrateConfig_3[0],
        .BdrConfigPtr            = CanControllerBaudrateConfig_3,
        .PayloadConfigPtr        = &Can_PayloadConfig_3,
        .CanCallbackPtr          = &Can_CallbackEntrance_3,
        .CanFifoHrhId            = 255U,
        .CanHwFlagMatrixPtr      = Can_HwFlagMatrixConfig_3,
        .RamMbNum                = 64U,
        .RamIrmqEn               = TRUE,
#if (CAN_MEMECC_FEATURE == STD_ON)
        .RamEnhFifoEn            = TRUE,
        .RamHrTimeStmpEn         = TRUE,
        .RamEnhMbMemEn           = FALSE,
#endif
    },
};

/**
 * @brief CAN config
 */
CAN_CONST const Can_ConfigType Can_Config =
{
    .CanChannelNum        = 4U,
    .CanHohNum            = 6U,
    .CanChCfgPtr          = Can_ChannelConfig,
    .CanHohCfgPtr         = Can_HohConfig,
    .CanHwIdTable         = Can_HwIdTable,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) && (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
    .CanPolPeriodNum      = 2,
#endif
#if (CAN_RX_PROCESS_HAS_POLLING == STD_ON)
    .CanHrhPolPeriodPtr   = CanHrhPolPeriodTable,
#endif
#if (CAN_TX_PROCESS_HAS_POLLING == STD_ON)
    .CanHthPolPeriodPtr   = CanHthPolPeriodTable,
#endif
    .CanReceiveCallback   = CanReceiveCallOut,
    .CanTransmitCallback  = CanTransmitCallOut,
#if ((CAN_ENHANCE_FIFO_USAGE == STD_ON) || (CAN_LEGACY_FIFO_USAGE == STD_ON))
#if (CAN_FIFO_IDHIT_USAGE == STD_ON)
    .CanIdhitCallback     = NULL_PTR,
#endif
#endif
#if (CAN_ICOM_USAGE == STD_ON)
    .CanIcomNum           = 0U,
    .CanIcomCfgPtr        = NULL_PTR,
#endif
};

#define CAN_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Can_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */

