/* USER CODE BEGIN Header */
/* you can remove the copyright */
/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * @file main.c
 * @brief
 *
 */

/* USER CODE END Header */
#include "Mcal.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "App_debug.h"
#include "SEGGER_RTT.h"
#include "user_rtt_printf.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define PORTCONFLG 1
#define TIMECONTER 6000
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
// extern const CddDma_TransferConfigType *DmaChannelTransferConfigArray[];
// extern CddDma_TransferConfigType Mem2MemTransferConfig;

/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    Mcu_Init(&Mcu_Config);
    Mcu_InitClock(0);
#if (MCU_NO_PLL == STD_OFF)
    while (MCU_PLL_LOCKED != Mcu_GetPllStatus())
    {
        /* Wait for the configuration PLL lock  */
    }

    while (E_OK != Mcu_DistributePllClock())
    {
    }
#endif
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */

    for (uint8 i = 0; i < GPT_LOGIC_CHANNEL_NUM; i++)
    {
        /*1ms*/
        Gpt_StartTimer(i, TIMECONTER);
        /*enable*/
        Gpt_EnableNotification(i);
    }

    LOG_INIT();
    LOG("\r\n");
    LOGI("==================================================\r\n");
    LOG("============= SEGGER_RTT successfu ==============\r\n");
    LOGI("==================================================\r\n");
    CoolDome();
    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    Gpt_Init(&Gpt_Config);
    CddDma_Init(&CddDma_Config);
    Port_Init(&Port_Config);
    CddUart_Init(&CddUart_Config);
    Can_Init(&Can_Config);
    Platform_Init(NULL_PTR);
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
