/*
* @file    Rte_Dem_Type.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : Rte_Dem_Type
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.3.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef RTE_DEM_TYPE_H
#define RTE_DEM_TYPE_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES                                          
==================================================================================================*/
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION                                
==================================================================================================*/
#define RTE_DEM_TYPE_VENDOR_ID                      (180)
#define RTE_DEM_TYPE_AR_RELEASE_MAJOR_VERSION       (4)
#define RTE_DEM_TYPE_AR_RELEASE_MINOR_VERSION       (4)
#define RTE_DEM_TYPE_AR_RELEASE_REVISION_VERSION    (0)
#define RTE_DEM_TYPE_SW_MAJOR_VERSION               (2)
#define RTE_DEM_TYPE_SW_MINOR_VERSION               (3)
#define RTE_DEM_TYPE_SW_PATCH_VERSION               (0)
/*==================================================================================================
                                                DEFINES AND MACROS                                       
==================================================================================================*/

typedef uint16 Dem_EventIdType;                              /**< @brief dem event ID type */

typedef uint8 Dem_EventStatusType;                           /**< @brief dem event status type */


#define DEM_EVENT_STATUS_PASSED                 (Dem_EventStatusType)0x00U  /**< @brief dem event passed */
#define DEM_EVENT_STATUS_FAILED                 (Dem_EventStatusType)0x01U  /**< @brief dem event failed */
#define DEM_EVENT_STATUS_PREPASSED              (Dem_EventStatusType)0x02U  /**< @brief dem event pre-passed */
#define DEM_EVENT_STATUS_PREFAILED              (Dem_EventStatusType)0x03U  /**< @brief dem event pre-failed */
#define DEM_EVENT_STATUS_FDC_THRESHOLD_REACHED  (Dem_EventStatusType)0x04U  /**< @brief dem event pre-failed */
/*==================================================================================================
                                                EXTERNAL CONSTANTS                                        
==================================================================================================*/
/*==================================================================================================
                                                ENUMS                                        
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES                                           
==================================================================================================*/
#ifdef __cplusplus
}
#endif

#endif /* End of file Rte_Dem_Type.h */

