/**
*   @file    CddUart.c
*   @version
*   @brief   AUTOSAR CddUart module interface
*   @details API implementation for CddUart driver
*/
/*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : uart
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   Autosar Conf.Variant :
*   SW Version           : V2.3.0
*
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifdef __cplusplus
extern "C"
{
#endif

/*==================================================================================================
*                                        INCLUDE FILES
* 1) system and project includes
* 2) needed interfaces from external units
* 3) internal and external interfaces from this unit
==================================================================================================*/
#include "CddUart_Lld_LinFlexD.h"
#include "OsIf.h"
/*==================================================================================================
*                                       LOCAL MACROS
==================================================================================================*/

/*==================================================================================================
                                       LOCAL CONSTANTS
==================================================================================================*/

/*==================================================================================================
                                       LOCAL VARIABLES
==================================================================================================*/
#define CDDUART_START_SEC_CODE
#include "CddUart_MemMap.h"
/*==================================================================================================
*                                    LOCAL FUNCTION PROTOTYPES
==================================================================================================*/
#ifdef CDDUART_LINFLEXD_0_USED
CDDUART_FUNC ISR(LINFlexD0_IRQHandler);
#endif
#ifdef CDDUART_LINFLEXD_1_USED
CDDUART_FUNC ISR(LINFlexD1_IRQHandler);
#endif
#ifdef CDDUART_LINFLEXD_2_USED
CDDUART_FUNC ISR(LINFlexD2_IRQHandler);
#endif
#ifdef CDDUART_LINFLEXD_3_USED
CDDUART_FUNC ISR(LINFlexD3_IRQHandler);
#endif
#ifdef CDDUART_LINFLEXD_4_USED
CDDUART_FUNC ISR(LINFlexD4_IRQHandler);
#endif
#ifdef CDDUART_LINFLEXD_5_USED
CDDUART_FUNC ISR(LINFlexD5_IRQHandler);
#endif
#ifdef CDDUART_LINFLEXD_6_USED
CDDUART_FUNC ISR(LINFlexD6_IRQHandler);
#endif
#ifdef CDDUART_LINFLEXD_7_USED
CDDUART_FUNC ISR(LINFlexD7_IRQHandler);
#endif
#ifdef CDDUART_LINFLEXD_8_USED
CDDUART_FUNC ISR(LINFlexD8_IRQHandler);
#endif
#ifdef CDDUART_LINFLEXD_9_USED
CDDUART_FUNC ISR(LINFlexD9_IRQHandler);
#endif
/*==================================================================================================
*                                    LOCAL FUNCTION
==================================================================================================*/
#ifdef CDDUART_LINFLEXD_0_USED
CDDUART_FUNC ISR(LINFlexD0_IRQHandler)
{
    LinFlexD_Lld_IRQHandler(0U);
}
#endif
#ifdef CDDUART_LINFLEXD_1_USED
CDDUART_FUNC ISR(LINFlexD1_IRQHandler)
{
    LinFlexD_Lld_IRQHandler(1U);
}
#endif
#ifdef CDDUART_LINFLEXD_2_USED
CDDUART_FUNC ISR(LINFlexD2_IRQHandler)
{
    LinFlexD_Lld_IRQHandler(2U);
}
#endif
#ifdef CDDUART_LINFLEXD_3_USED
CDDUART_FUNC ISR(LINFlexD3_IRQHandler)
{
    LinFlexD_Lld_IRQHandler(3U);
}
#endif
#ifdef CDDUART_LINFLEXD_4_USED
CDDUART_FUNC ISR(LINFlexD4_IRQHandler)
{
    LinFlexD_Lld_IRQHandler(4U);
}
#endif
#ifdef CDDUART_LINFLEXD_5_USED
CDDUART_FUNC ISR(LINFlexD5_IRQHandler)
{
    LinFlexD_Lld_IRQHandler(5U);
}
#endif
#ifdef CDDUART_LINFLEXD_6_USED
CDDUART_FUNC ISR(LINFlexD6_IRQHandler)
{
    LinFlexD_Lld_IRQHandler(6U);
}
#endif
#ifdef CDDUART_LINFLEXD_7_USED
CDDUART_FUNC ISR(LINFlexD7_IRQHandler)
{
    LinFlexD_Lld_IRQHandler(7U);
}
#endif
#ifdef CDDUART_LINFLEXD_8_USED
CDDUART_FUNC ISR(LINFlexD8_IRQHandler)
{
    LinFlexD_Lld_IRQHandler(8U);
}
#endif
#ifdef CDDUART_LINFLEXD_9_USED
CDDUART_FUNC ISR(LINFlexD9_IRQHandler)
{
    LinFlexD_Lld_IRQHandler(9U);
}
#endif
#define CDDUART_STOP_SEC_CODE
#include "CddUart_MemMap.h"

#ifdef __cplusplus
}
#endif

