/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file clock_config.c
 * @brief 
 * 
 */

#include "stddef.h"
#include "clock_config.h"

/*! @brief peripheral clock PeripheralClockConfig */

peripheral_clock_config_t clock_config0PeripheralClockConfig[3] = {
    {
        .clkName = LINFlexD3_CLK,
        .clkGate = true,
        .clkSrc = CLK_SRC_FXOSC,
        .divider = DIV_BY_1,
    },
    {
        .clkName = lpTMR0_CLK,
        .clkGate = true,
        .clkSrc = CLK_SRC_FIRC,
        .divider = DIV_BY_8,
    },
    {
        .clkName = HCU_CLK,
        .clkGate = true,
        .clkSrc = CLK_SRC_DISABLED,
        .divider = DIV_BY_1,
    },
};

const scu_config_t clock_config0ScuConfig = {
    .sircDeepSleepEnable = true,
    .sircStandbyEnable = true,
    .sircPowerDownEnable = true,
    .fircEnable = true,
    .fircDeepSleepEnable = false,
    .sysClkSrc = SCU_SYSTEM_CLOCK_SRC_PLL,
    .fxoscConfig =
        {
            .enable = true,
            .bypassMode = false,
            .gainSelection = 5,
            .frequency = 24000000U,
        },
    .sxoscConfig = 
        {
            .enable = false,
            .gainSelection = 0,
            .bypassMode = false,
            .deepsleepEnable = false,
            .standbyEnable = false,
            .powerdownEnable = false,
            .frequency = 32768U,
        },
    .pllConfig =
        {
            .enable = true,
            .pllRefClock = SCU_PLL_REF_FXOSC_CLK,
            .pllFeedBackDiv = 50,
            .pllRefClkDiv = 3,
        },
    .sysDiv = SCU_SYS_CLK_DIV_BY_1,
    .fastBusDiv = SCU_SYS_CLK_DIV_BY_2,
    .slowBusDiv = SCU_SYS_CLK_DIV_BY_2,
    .flashDiv = SCU_SYS_CLK_DIV_BY_3,
    .flashPrs = 0,
    .clockOutConfig =
        {
            .enable = false,
            .divider = 1,
            .source = SCU_CLKOUT_SEL_PLL_CLK,
        },
};

/*! @brief User Configuration structure clock_config0ClockManager */
clock_manager_user_config_t clock_config0ClockManager = {
    .ipcConfig = {
        .count = 3,
        .peripheralClocks = clock_config0PeripheralClockConfig,
    },
    .scuConfigPtr = &clock_config0ScuConfig,
    .cmuConfigPtr = NULL,
};

/*! @brief Array of pointers to User configuration structures */
clock_manager_user_config_t const *g_clockManConfigsArr[] = {
    &clock_config0ClockManager,
};

/*! @brief Array of pointers to User defined Callbacks configuration structures */
/* The tool do not support generate Callbacks configuration. It's always empty. */
clock_manager_callback_user_config_t *g_clockManCallbacksArr[] = {(void *)0};
