/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file main.c
 * @brief 
 * 
 */

/* USER CODE END Header */
#include "sdk_project_config.h"
#include "hcu_hw_access.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define FLASH_INST (0U)
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
#define addr_nvr 0x10000800
#define nvr_size 0x800
uint8_t hash [16];
const uint32_t key1[4]={0x2b7e1516, 0x28aed2a6, 0xabf71588, 0x09cf4f3c};
const uint32_t plainText[4] = {0x6bc1bee2,0x2e409f96,0xe93d7e11,0x7393172a};
hcu_cmac_config_t cmacConfig =
{
.macPtr = hash,
.macLen = 16,
};
static status_t Program(const void *key,uint32_t len)
{
    status_t status = STATUS_SUCCESS;
	EFM->CUS_KEY = 0x4dff32;
	status |= FLASH_DRV_EraseSector(0, addr_nvr,nvr_size);
	status |= FLASH_DRV_Program(0, addr_nvr,len,key);
	return status;
}
int main(void)
{
    /* USER CODE BEGIN 1 */
    status_t status = STATUS_SUCCESS;
    uint32_t addr;
    uint32_t data[6 * 1024 / 4];
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    /* USER CODE END 2 */
	Program(key1,sizeof(key1));
	INT_SYS_DisableIRQGlobal();
	status |= FLASH_DRV_LoadAESKey(0,addr_nvr);
	INT_SYS_EnableIRQGlobal();
	HCU_SetKeySize(KEY_SIZE_128_BITS);
	status |= HCU_DRV_GenerateMAC(plainText, 16, MSG_ALL, &cmacConfig);
	
    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    return status;
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    CLOCK_SYS_Init(g_clockManConfigsArr,CLOCK_MANAGER_CONFIG_CNT,g_clockManCallbacksArr,CLOCK_MANAGER_CALLBACK_CNT);
    CLOCK_SYS_UpdateConfiguration(CLOCK_MANAGER_ACTIVE_INDEX,CLOCK_MANAGER_POLICY_AGREEMENT);
    PINS_DRV_Init(NUM_OF_CONFIGURED_PINS0,g_pin_mux_InitConfigArr0);
    FLASH_DRV_Init(0,&flash_config0,&flash_config0_State);	
    HCU_DRV_Init(&hcu_config0,&hcu_config0_State);
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
