/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file undefined
 * @brief 
 * 
 */
#ifndef CDDI2C_CFG_H
#define CDDI2C_CFG_H

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"
#include "CddI2c_PBcfg.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CDDI2C_VENDOR_ID_CFG                      (180)
#define CDDI2C_AR_RELEASE_MAJOR_VERSION_CFG       (4)
#define CDDI2C_AR_RELEASE_MINOR_VERSION_CFG       (4)
#define CDDI2C_AR_RELEASE_REVISION_VERSION_CFG    (0)
#define CDDI2C_SW_MAJOR_VERSION_CFG               (1)
#define CDDI2C_SW_MINOR_VERSION_CFG               (3)
#define CDDI2C_SW_PATCH_VERSION_CFG               (2)

/*==================================================================================================
*                                       LOCAL MACROS
==================================================================================================*/
/**
* @brief   Switches the Development Error Detection and Notification ON or OFF.
*/
#define CDDI2C_DEV_ERROR_DETECT            (STD_ON)

/**
* @brief   Total number of available hardware I2C channels.
*/
#define CDDI2C_HW_MAX_MODULES              (5U)   

/**
* @brief   Switches the version information read API ON or OFF.
*/
#define CDDI2C_VERSION_INFO_API            (STD_ON)

/**
 * @brief  Enable timeout feature of SyncModeTransfer or not 
*/
#define CDDI2C_SYNC_TRANSFER_TIMEOUT_EN    (STD_ON)

/**
* @brief            Dma support enable/disabled
*/
#define I2C_DMA_USED                       (STD_ON)

/**
* @brief Support for SchM: sync/atomic operations, global interrupt disable/enable.
*        If this parameter has been configured to 'STD_ON', the MCAL driver code supports sync/atomic operations for key resource protection.
*        If it is enabled, all the SchM codes in MCAL CddI2c driver codes will work and support sync/atomic operation with CPU global interrupt 
*        enable/disable for key resource protection. 
*        Disable it can reduce code size, but may cause potential risks when access to some critical resource!
*/
#define CDDI2C_SCHM_SUPPORT                (STD_ON) 

/**
* @brief Define precompile support.
* @details Define precompile support if VARIANT-PRE-COMPILE or VARIANT-LINK-TIME is selected and number of variant <=1.
*/
#define CDDI2C_PRECOMPILE_SUPPORT          (STD_OFF)

/**
* @brief    the value initialization un init for each hw channel.
*/
#define CDDI2C_CHN_INIT_STATUS {I2C_CHN_UNINIT,I2C_CHN_UNINIT,I2C_CHN_UNINIT,I2C_CHN_UNINIT,I2C_CHN_UNINIT}

/**
 * @brief   macro for I2C instance mode type.
 */
#define I2C_0_MASTER_MODE_ENABLED
#define I2C_1_MASTER_MODE_ENABLED
#define I2C_2_SLAVE_MODE_ENABLED

/**
 * @brief   I2c slave rx buff full event.
 */
#define I2C_EVENT_RX_BUFF_FULL_SLAVE       (0x00U)

/**
 * @brief   I2c slave tx buff empty event.
 */
#define I2C_EVENT_TX_BUFF_EMPTY_SLAVE      (0x01U)

/**
 * @brief   I2c slave tx request event.
 */
#define I2C_EVENT_TX_REQ_SLAVE             (0x02U)

/**
 * @brief   I2c slave rx request event.
 */
#define I2C_EVENT_RX_REQ_SLAVE             (0x03U)

/**
 * @brief   I2c slave stop transfer event.
 */
#define I2C_EVENT_STOP_SLAVE               (0x04U)

/**
 * @brief   I2c master end transfer event.
 */
#define I2C_EVENT_END_TRANSFER_MASTER      (0x0AU)


/**
 * @brief   I2c transmission error type detection classification is enable ON or OFF.
 */
#define CDDI2C_EVENT_ERROR_DETECT          (STD_OFF)

/**
 * @brief   I2c callback configured by the user for I2c events.
 */
#define I2C_MODULE_CALLBACK(u8Event, u8Channel) (I2c_Callback(u8Event, u8Channel))

extern void I2C_MODULE_CALLBACK(uint8 Event, uint8 Channel);



#ifdef CDDI2C_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if CDDI2C_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif

#endif /* CDDI2C_CFG_H */

