/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file CddDma_PBcfg.h
 * @brief 
 * 
 */


#ifndef CDDDMA_PB_CFG_H
#define CDDDMA_PB_CFG_H


/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"


/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CDDDMA_VENDOR_ID_PBCFG                      (180)
#define CDDDMA_AR_RELEASE_MAJOR_VERSION_PBCFG       (4)
#define CDDDMA_AR_RELEASE_MINOR_VERSION_PBCFG       (4)
#define CDDDMA_AR_RELEASE_REVISION_VERSION_PBCFG    (0)
#define CDDDMA_SW_MAJOR_VERSION_PBCFG               (1)
#define CDDDMA_SW_MINOR_VERSION_PBCFG               (3)
#define CDDDMA_SW_PATCH_VERSION_PBCFG               (2)

/*!
 * @brief Structure for the DMA hardware channel
 *
 * Defines the structure for the DMA hardware channel collections.
 */
typedef enum {
    DMA_IP_HW_CH_0           =  0U,     /*!< DMA IP HW channel 0 */
    DMA_IP_HW_CH_1           =  1U,     /*!< DMA IP HW channel 1 */
    DMA_IP_HW_CH_2           =  2U,     /*!< DMA IP HW channel 2 */
    DMA_IP_HW_CH_3           =  3U,     /*!< DMA IP HW channel 3 */
    DMA_IP_HW_CH_4           =  4U,     /*!< DMA IP HW channel 4 */
    DMA_IP_HW_CH_5           =  5U,     /*!< DMA IP HW channel 5 */
    DMA_IP_HW_CH_6           =  6U,     /*!< DMA IP HW channel 6 */
    DMA_IP_HW_CH_7           =  7U,     /*!< DMA IP HW channel 7 */
    DMA_IP_HW_CH_8           =  8U,     /*!< DMA IP HW channel 8 */
    DMA_IP_HW_CH_9           =  9U,     /*!< DMA IP HW channel 9 */
    DMA_IP_HW_CH_10          = 10U,     /*!< DMA IP HW channel 10 */
    DMA_IP_HW_CH_11          = 11U,     /*!< DMA IP HW channel 11 */
    DMA_IP_HW_CH_12          = 12U,     /*!< DMA IP HW channel 12 */
    DMA_IP_HW_CH_13          = 13U,     /*!< DMA IP HW channel 13 */
    DMA_IP_HW_CH_14          = 14U,     /*!< DMA IP HW channel 14 */
    DMA_IP_HW_CH_15          = 15U,     /*!< DMA IP HW channel 15 */
    DMA_IP_HW_CH_16          = 16U,     /*!< DMA IP HW channel 16 */
    DMA_IP_HW_CH_17          = 17U,     /*!< DMA IP HW channel 17 */
    DMA_IP_HW_CH_18          = 18U,     /*!< DMA IP HW channel 18 */
    DMA_IP_HW_CH_19          = 19U,     /*!< DMA IP HW channel 19 */
    DMA_IP_HW_CH_20          = 20U,     /*!< DMA IP HW channel 20 */
    DMA_IP_HW_CH_21          = 21U,     /*!< DMA IP HW channel 21 */
    DMA_IP_HW_CH_22          = 22U,     /*!< DMA IP HW channel 22 */
    DMA_IP_HW_CH_23          = 23U,     /*!< DMA IP HW channel 23 */
    DMA_IP_HW_CH_24          = 24U,     /*!< DMA IP HW channel 24 */
    DMA_IP_HW_CH_25          = 25U,     /*!< DMA IP HW channel 25 */
    DMA_IP_HW_CH_26          = 26U,     /*!< DMA IP HW channel 26 */
    DMA_IP_HW_CH_27          = 27U,     /*!< DMA IP HW channel 27 */
    DMA_IP_HW_CH_28          = 28U,     /*!< DMA IP HW channel 28 */
    DMA_IP_HW_CH_29          = 29U,     /*!< DMA IP HW channel 29 */
    DMA_IP_HW_CH_30          = 30U,     /*!< DMA IP HW channel 30 */
    DMA_IP_HW_CH_31          = 31U,     /*!< DMA IP HW channel 31 */
} CddDma_HwChannelType;

#define CDDDMA_TRANSFER_CONFIG_COUNT                (2U)

/* Logic Channel 0 */
#define CddDmaConf_CddDmaConfig_I2C0_TX_DMA             DMA_IP_HW_CH_0
/* Logic Channel 1 */
#define CddDmaConf_CddDmaConfig_I2C0_RX_DMA             DMA_IP_HW_CH_1

#define CDDDMA_CONFIG_PB \
    extern const CddDma_ConfigType CddDma_Config;

#endif

