/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file CddDma_Cfg.h
 * @brief 
 * 
 */


#ifndef CDDDMA_CFG_H
#define CDDDMA_CFG_H

#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"
#include "CddDma_PBcfg.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CDDDMA_VENDOR_ID_CFG                      (180)
#define CDDDMA_AR_RELEASE_MAJOR_VERSION_CFG       (4)
#define CDDDMA_AR_RELEASE_MINOR_VERSION_CFG       (4)
#define CDDDMA_AR_RELEASE_REVISION_VERSION_CFG    (0)
#define CDDDMA_SW_MAJOR_VERSION_CFG               (1)
#define CDDDMA_SW_MINOR_VERSION_CFG               (3)
#define CDDDMA_SW_PATCH_VERSION_CFG               (2)

/*==================================================================================================
 *                          LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
==================================================================================================*/

/*!
 * @brief Structure for the DMA hardware request
 *
 * Defines the structure for the DMA hardware request collections. The user can configure the
 * hardware request into DMAMUX to trigger the DMA transfer accordingly. The index
 * of the hardware request varies according  to the to SoC.
 */
typedef enum {
    DMA_REQ_DISABLED         =   0U,     /*!< Disabled         dma request    0u */
    DMA_REQ_LINFlexD0_RX     =   2U,     /*!< LINFlexD0_RX     dma request    2u */
    DMA_REQ_LINFlexD0_TX     =   3U,     /*!< LINFlexD0_TX     dma request    3u */
    DMA_REQ_LINFlexD1_RX     =   4U,     /*!< LINFlexD1_RX     dma request    4u */
    DMA_REQ_LINFlexD1_TX     =   5U,     /*!< LINFlexD1_TX     dma request    5u */
    DMA_REQ_LINFlexD2_RX     =   6U,     /*!< LINFlexD2_RX     dma request    6u */
    DMA_REQ_LINFlexD2_TX     =   7U,     /*!< LINFlexD2_TX     dma request    7u */
    DMA_REQ_I2C1_RX          =   8U,     /*!< I2C1_RX          dma request    8u */
    DMA_REQ_I2C1_TX          =   9U,     /*!< I2C1_TX          dma request    9u */
    DMA_REQ_LINFlexD3_RX     =  10U,     /*!< LINFlexD3_RX     dma request   10u */
    DMA_REQ_LINFlexD3_TX     =  11U,     /*!< LINFlexD3_TX     dma request   11u */
    DMA_REQ_LINFlexD4_RX     =  12U,     /*!< LINFlexD4_RX     dma request   12u */
    DMA_REQ_LINFlexD4_TX     =  13U,     /*!< LINFlexD4_TX     dma request   13u */
    DMA_REQ_SPI0_RX          =  14U,     /*!< SPI0_RX          dma request   14u */
    DMA_REQ_SPI0_TX          =  15U,     /*!< SPI0_TX          dma request   15u */
    DMA_REQ_SPI1_RX          =  16U,     /*!< SPI1_RX          dma request   16u */
    DMA_REQ_SPI1_TX          =  17U,     /*!< SPI1_TX          dma request   17u */
    DMA_REQ_SPI2_RX          =  18U,     /*!< SPI2_RX          dma request   18u */
    DMA_REQ_SPI2_TX          =  19U,     /*!< SPI2_TX          dma request   19u */
    DMA_REQ_eTMR1_CH0        =  20U,     /*!< eTMR1_CH0        dma request   20u */
    DMA_REQ_eTMR1_CH1        =  21U,     /*!< eTMR1_CH1        dma request   21u */
    DMA_REQ_eTMR1_CH2        =  22U,     /*!< eTMR1_CH2        dma request   22u */
    DMA_REQ_eTMR1_CH3        =  23U,     /*!< eTMR1_CH3        dma request   23u */
    DMA_REQ_eTMR1_CH4        =  24U,     /*!< eTMR1_CH4        dma request   24u */
    DMA_REQ_eTMR1_CH5        =  25U,     /*!< eTMR1_CH5        dma request   25u */
    DMA_REQ_eTMR1_CH6        =  26U,     /*!< eTMR1_CH6        dma request   26u */
    DMA_REQ_eTMR1_CH7        =  27U,     /*!< eTMR1_CH7        dma request   27u */
    DMA_REQ_eTMR2_CH0        =  28U,     /*!< eTMR2_CH0        dma request   28u */
    DMA_REQ_eTMR2_CH1        =  29U,     /*!< eTMR2_CH1        dma request   29u */
    DMA_REQ_eTMR2_CH2        =  30U,     /*!< eTMR2_CH2        dma request   30u */
    DMA_REQ_eTMR2_CH3        =  31U,     /*!< eTMR2_CH3        dma request   31u */
    DMA_REQ_eTMR2_CH4        =  32U,     /*!< eTMR2_CH4        dma request   32u */
    DMA_REQ_eTMR2_CH5        =  33U,     /*!< eTMR2_CH5        dma request   33u */
    DMA_REQ_eTMR2_CH6        =  34U,     /*!< eTMR2_CH6        dma request   34u */
    DMA_REQ_eTMR2_CH7        =  35U,     /*!< eTMR2_CH7        dma request   35u */
    DMA_REQ_eTMR0            =  36U,     /*!< eTMR0            dma request   36u */
    DMA_REQ_eTMR3            =  37U,     /*!< eTMR3            dma request   37u */
    DMA_REQ_eTMR4            =  38U,     /*!< eTMR4            dma request   38u */
    DMA_REQ_eTMR5            =  39U,     /*!< eTMR5            dma request   39u */
    DMA_REQ_ADC0             =  42U,     /*!< ADC0             dma request   42u */
    DMA_REQ_ADC1             =  43U,     /*!< ADC1             dma request   43u */
    DMA_REQ_I2C0_RX          =  44U,     /*!< I2C0_RX          dma request   44u */
    DMA_REQ_I2C0_TX          =  45U,     /*!< I2C0_TX          dma request   45u */
    DMA_REQ_PTU0             =  46U,     /*!< PTU0             dma request   46u */
    DMA_REQ_PTU1             =  47U,     /*!< PTU1             dma request   47u */
    DMA_REQ_ACMP0            =  48U,     /*!< ACMP0            dma request   48u */
    DMA_REQ_GPIOA            =  49U,     /*!< GPIOA            dma request   49u */
    DMA_REQ_GPIOB            =  50U,     /*!< GPIOB            dma request   50u */
    DMA_REQ_GPIOC            =  51U,     /*!< GPIOC            dma request   51u */
    DMA_REQ_GPIOD            =  52U,     /*!< GPIOD            dma request   52u */
    DMA_REQ_GPIOE            =  53U,     /*!< GPIOE            dma request   53u */
    DMA_REQ_FLEXCAN0         =  54U,     /*!< FLEXCAN0         dma request   54u */
    DMA_REQ_FLEXCAN1         =  55U,     /*!< FLEXCAN1         dma request   55u */
    DMA_REQ_FLEXCAN2         =  56U,     /*!< FLEXCAN2         dma request   56u */
    DMA_REQ_FLEXCAN3         =  57U,     /*!< FLEXCAN3         dma request   57u */
    DMA_REQ_FLEXCAN4         =  58U,     /*!< FLEXCAN4         dma request   58u */
    DMA_REQ_lpTMR0           =  59U,     /*!< lpTMR0           dma request   59u */
    DMA_REQ_FLEXCAN5         =  60U,     /*!< FLEXCAN5         dma request   60u */
    DMA_REQ_SPI3_RX          =  64U,     /*!< SPI3_RX          dma request   64u */
    DMA_REQ_SPI3_TX          =  65U,     /*!< SPI3_TX          dma request   65u */
    DMA_REQ_SPI4_RX          =  66U,     /*!< SPI4_RX          dma request   66u */
    DMA_REQ_SPI4_TX          =  67U,     /*!< SPI4_TX          dma request   67u */
    DMA_REQ_SPI5_RX          =  68U,     /*!< SPI5_RX          dma request   68u */
    DMA_REQ_SPI5_TX          =  69U,     /*!< SPI5_TX          dma request   69u */
    DMA_REQ_I2C2_RX          =  70U,     /*!< I2C2_RX          dma request   70u */
    DMA_REQ_I2C2_TX          =  71U,     /*!< I2C2_TX          dma request   71u */
    DMA_REQ_LINFlexD5_TX     =  72U,     /*!< LINFlexD5_TX     dma request   72u */
    DMA_REQ_LINFlexD5_RX     =  73U,     /*!< LINFlexD5_RX     dma request   73u */
    DMA_REQ_HCU_IN           =  74U,     /*!< HCU_IN           dma request   74u */
    DMA_REQ_HCU_OUT          =  75U,     /*!< HCU_OUT          dma request   75u */
    DMA_REQ_LINFlexD6_TX     =  76U,     /*!< LINFlexD6_TX     dma request   76u */
    DMA_REQ_LINFlexD6_RX     =  77U,     /*!< LINFlexD6_RX     dma request   77u */
    DMA_REQ_LINFlexD7_TX     =  78U,     /*!< LINFlexD7_TX     dma request   78u */
    DMA_REQ_LINFlexD7_RX     =  79U,     /*!< LINFlexD7_RX     dma request   79u */
    DMA_REQ_LINFlexD8_TX     =  80U,     /*!< LINFlexD8_TX     dma request   80u */
    DMA_REQ_LINFlexD8_RX     =  81U,     /*!< LINFlexD8_RX     dma request   81u */
    DMA_REQ_LINFlexD9_TX     =  82U,     /*!< LINFlexD9_TX     dma request   82u */
    DMA_REQ_LINFlexD9_RX     =  83U,     /*!< LINFlexD9_RX     dma request   83u */
    DMA_REQ_I2C3_RX          =  84U,     /*!< I2C3_RX          dma request   84u */
    DMA_REQ_I2C3_TX          =  85U,     /*!< I2C3_TX          dma request   85u */
    DMA_REQ_SPI6_RX          =  86U,     /*!< SPI6_RX          dma request   86u */
    DMA_REQ_SPI6_TX          =  87U,     /*!< SPI6_TX          dma request   87u */
    DMA_REQ_SPI7_RX          =  88U,     /*!< SPI7_RX          dma request   88u */
    DMA_REQ_SPI7_TX          =  89U,     /*!< SPI7_TX          dma request   89u */
    DMA_REQ_I2C4_RX          =  90U,     /*!< I2C4_RX          dma request   90u */
    DMA_REQ_I2C4_TX          =  91U,     /*!< I2C4_TX          dma request   91u */
    DMA_REQ_ACMP1            =  94U,     /*!< ACMP1            dma request   94u */
    DMA_REQ_FLEXCAN6         =  96U,     /*!< FLEXCAN6         dma request   96u */
    DMA_REQ_FLEXCAN7         =  97U,     /*!< FLEXCAN7         dma request   97u */
    DMA_REQ_SENT0_FAST       = 102U,     /*!< SENT0_FAST       dma request  102u */
    DMA_REQ_SENT0_SLOW       = 103U,     /*!< SENT0_SLOW       dma request  103u */
    DMA_REQ_SENT1_FAST       = 104U,     /*!< SENT1_FAST       dma request  104u */
    DMA_REQ_SENT1_SLOW       = 105U,     /*!< SENT1_SLOW       dma request  105u */
    DMA_REQ_QSPI_RX          = 106U,     /*!< QSPI_RX          dma request  106u */
    DMA_REQ_QSPI_TX          = 107U,     /*!< QSPI_TX          dma request  107u */
    DMA_REQ_MWPM0            = 108U,     /*!< MWPM0            dma request  108u */
    DMA_REQ_MWPM1            = 109U,     /*!< MWPM1            dma request  109u */
    DMA_REQ_MWPM2            = 110U,     /*!< MWPM2            dma request  110u */
    DMA_REQ_EMAC_CH0         = 112U,     /*!< EMAC_CH0         dma request  112u */
    DMA_REQ_EMAC_CH1         = 113U,     /*!< EMAC_CH1         dma request  113u */
    DMA_REQ_EMAC_CH2         = 114U,     /*!< EMAC_CH2         dma request  114u */
    DMA_REQ_EMAC_CH3         = 115U,     /*!< EMAC_CH3         dma request  115u */
    DMA_REQ_SAI0_RX_CH0      = 116U,     /*!< SAI0_RX_CH0      dma request  116u */
    DMA_REQ_SAI0_RX_CH1      = 117U,     /*!< SAI0_RX_CH1      dma request  117u */
    DMA_REQ_SAI0_RX_CH2      = 118U,     /*!< SAI0_RX_CH2      dma request  118u */
    DMA_REQ_SAI0_RX_CH3      = 119U,     /*!< SAI0_RX_CH3      dma request  119u */
    DMA_REQ_SAI0_TX_CH0      = 120U,     /*!< SAI0_TX_CH0      dma request  120u */
    DMA_REQ_SAI0_TX_CH1      = 121U,     /*!< SAI0_TX_CH1      dma request  121u */
    DMA_REQ_SAI0_TX_CH2      = 122U,     /*!< SAI0_TX_CH2      dma request  122u */
    DMA_REQ_SAI0_TX_CH3      = 123U,     /*!< SAI0_TX_CH3      dma request  123u */
    DMA_REQ_SAI1_RX          = 124U,     /*!< SAI1_RX          dma request  124u */
    DMA_REQ_SAI1_TX          = 125U,     /*!< SAI1_TX          dma request  125u */
} CddDma_RequestSourceType;
/*==================================================================================================
*                                       DEFINITIONS AND MACROS
==================================================================================================*/

/* @brief Total enabled number of DMA channels. */
#define CDDDMA_CHANNEL_CONFIG_COUNT                (2U)
/* @brief Max number of DMA channels. */
#define DMA_MAX_CH_COUNT                           (32U)

/**
* @brief Define precompile support.
* @details Define precompile support if VARIANT-PRE-COMPILE or VARIANT-LINK-TIME is selected and number of variant <=1.
*/
#define CDDDMA_PRECOMPILE_SUPPORT                  (STD_OFF)

#define CDDDMA_DEV_ERROR_DETECT                    (STD_ON)

#define CDDDMA_VERSION_INFO_API                    (STD_OFF)

/**
* @brief Support for SchM: sync/atomic operations, global interrupt disable/enable.
*        If this parameter has been configured to 'STD_ON', the MCAL driver code supports sync/atomic operations for key resource protection.
*        If it is enabled, all the SchM codes in MCAL CddDma driver codes will work and support sync/atomic operation with CPU global interrupt enable/disable for key resource protection. 
*        Disable it can reduce code size, but may cause potential risks when access to some critical resource!
*/
#define CDDDMA_SCHM_SUPPORT                         (STD_ON) 


#ifdef CDDDMA_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if CDDDMA_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif

#endif

